/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2beta1;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.v2beta1.CreateSessionEntityTypeRequest;
import com.google.cloud.dialogflow.v2beta1.DeleteSessionEntityTypeRequest;
import com.google.cloud.dialogflow.v2beta1.GetSessionEntityTypeRequest;
import com.google.cloud.dialogflow.v2beta1.ListSessionEntityTypesRequest;
import com.google.cloud.dialogflow.v2beta1.ListSessionEntityTypesResponse;
import com.google.cloud.dialogflow.v2beta1.PagedResponseWrappers;
import com.google.cloud.dialogflow.v2beta1.SessionEntityType;
import com.google.cloud.dialogflow.v2beta1.SessionEntityTypeName;
import com.google.cloud.dialogflow.v2beta1.SessionEntityTypesSettings;
import com.google.cloud.dialogflow.v2beta1.SessionName;
import com.google.cloud.dialogflow.v2beta1.UpdateSessionEntityTypeRequest;
import com.google.cloud.dialogflow.v2beta1.stub.SessionEntityTypesStub;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class SessionEntityTypesClient
implements BackgroundResource {
    private final SessionEntityTypesSettings settings;
    private final SessionEntityTypesStub stub;

    public static final SessionEntityTypesClient create() throws IOException {
        return SessionEntityTypesClient.create(SessionEntityTypesSettings.newBuilder().build());
    }

    public static final SessionEntityTypesClient create(SessionEntityTypesSettings settings) throws IOException {
        return new SessionEntityTypesClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final SessionEntityTypesClient create(SessionEntityTypesStub stub) {
        return new SessionEntityTypesClient(stub);
    }

    protected SessionEntityTypesClient(SessionEntityTypesSettings settings) throws IOException {
        this.settings = settings;
        this.stub = settings.createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected SessionEntityTypesClient(SessionEntityTypesStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final SessionEntityTypesSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public SessionEntityTypesStub getStub() {
        return this.stub;
    }

    public final PagedResponseWrappers.ListSessionEntityTypesPagedResponse listSessionEntityTypes(SessionName parent) {
        ListSessionEntityTypesRequest request = ListSessionEntityTypesRequest.newBuilder().setParentWithSessionName(parent).build();
        return this.listSessionEntityTypes(request);
    }

    public final PagedResponseWrappers.ListSessionEntityTypesPagedResponse listSessionEntityTypes(ListSessionEntityTypesRequest request) {
        return (PagedResponseWrappers.ListSessionEntityTypesPagedResponse)((Object)this.listSessionEntityTypesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListSessionEntityTypesRequest, PagedResponseWrappers.ListSessionEntityTypesPagedResponse> listSessionEntityTypesPagedCallable() {
        return this.stub.listSessionEntityTypesPagedCallable();
    }

    public final UnaryCallable<ListSessionEntityTypesRequest, ListSessionEntityTypesResponse> listSessionEntityTypesCallable() {
        return this.stub.listSessionEntityTypesCallable();
    }

    public final SessionEntityType getSessionEntityType(SessionEntityTypeName name) {
        GetSessionEntityTypeRequest request = GetSessionEntityTypeRequest.newBuilder().setNameWithSessionEntityTypeName(name).build();
        return this.getSessionEntityType(request);
    }

    private final SessionEntityType getSessionEntityType(GetSessionEntityTypeRequest request) {
        return (SessionEntityType)this.getSessionEntityTypeCallable().call((Object)request);
    }

    public final UnaryCallable<GetSessionEntityTypeRequest, SessionEntityType> getSessionEntityTypeCallable() {
        return this.stub.getSessionEntityTypeCallable();
    }

    public final SessionEntityType createSessionEntityType(SessionName parent, SessionEntityType sessionEntityType) {
        CreateSessionEntityTypeRequest request = CreateSessionEntityTypeRequest.newBuilder().setParentWithSessionName(parent).setSessionEntityType(sessionEntityType).build();
        return this.createSessionEntityType(request);
    }

    public final SessionEntityType createSessionEntityType(CreateSessionEntityTypeRequest request) {
        return (SessionEntityType)this.createSessionEntityTypeCallable().call((Object)request);
    }

    public final UnaryCallable<CreateSessionEntityTypeRequest, SessionEntityType> createSessionEntityTypeCallable() {
        return this.stub.createSessionEntityTypeCallable();
    }

    public final SessionEntityType updateSessionEntityType(SessionEntityType sessionEntityType) {
        UpdateSessionEntityTypeRequest request = UpdateSessionEntityTypeRequest.newBuilder().setSessionEntityType(sessionEntityType).build();
        return this.updateSessionEntityType(request);
    }

    public final SessionEntityType updateSessionEntityType(UpdateSessionEntityTypeRequest request) {
        return (SessionEntityType)this.updateSessionEntityTypeCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateSessionEntityTypeRequest, SessionEntityType> updateSessionEntityTypeCallable() {
        return this.stub.updateSessionEntityTypeCallable();
    }

    public final void deleteSessionEntityType(SessionEntityTypeName name) {
        DeleteSessionEntityTypeRequest request = DeleteSessionEntityTypeRequest.newBuilder().setNameWithSessionEntityTypeName(name).build();
        this.deleteSessionEntityType(request);
    }

    private final void deleteSessionEntityType(DeleteSessionEntityTypeRequest request) {
        this.deleteSessionEntityTypeCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteSessionEntityTypeRequest, Empty> deleteSessionEntityTypeCallable() {
        return this.stub.deleteSessionEntityTypeCallable();
    }

    public final void close() throws Exception {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

