/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.cx.v3beta1.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.cx.v3beta1.CreateGeneratorRequest;
import com.google.cloud.dialogflow.cx.v3beta1.DeleteGeneratorRequest;
import com.google.cloud.dialogflow.cx.v3beta1.Generator;
import com.google.cloud.dialogflow.cx.v3beta1.GeneratorsClient;
import com.google.cloud.dialogflow.cx.v3beta1.GetGeneratorRequest;
import com.google.cloud.dialogflow.cx.v3beta1.ListGeneratorsRequest;
import com.google.cloud.dialogflow.cx.v3beta1.ListGeneratorsResponse;
import com.google.cloud.dialogflow.cx.v3beta1.UpdateGeneratorRequest;
import com.google.cloud.dialogflow.cx.v3beta1.stub.GeneratorsStub;
import com.google.cloud.dialogflow.cx.v3beta1.stub.GeneratorsStubSettings;
import com.google.cloud.dialogflow.cx.v3beta1.stub.GrpcGeneratorsCallableFactory;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcGeneratorsStub
extends GeneratorsStub {
    private static final MethodDescriptor<ListGeneratorsRequest, ListGeneratorsResponse> listGeneratorsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.cx.v3beta1.Generators/ListGenerators").setRequestMarshaller(ProtoUtils.marshaller((Message)ListGeneratorsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListGeneratorsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetGeneratorRequest, Generator> getGeneratorMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.cx.v3beta1.Generators/GetGenerator").setRequestMarshaller(ProtoUtils.marshaller((Message)GetGeneratorRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Generator.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<CreateGeneratorRequest, Generator> createGeneratorMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.cx.v3beta1.Generators/CreateGenerator").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateGeneratorRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Generator.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<UpdateGeneratorRequest, Generator> updateGeneratorMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.cx.v3beta1.Generators/UpdateGenerator").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateGeneratorRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Generator.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<DeleteGeneratorRequest, Empty> deleteGeneratorMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.cx.v3beta1.Generators/DeleteGenerator").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteGeneratorRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/ListLocations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListLocationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListLocationsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/GetLocation").setRequestMarshaller(ProtoUtils.marshaller((Message)GetLocationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Location.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final UnaryCallable<ListGeneratorsRequest, ListGeneratorsResponse> listGeneratorsCallable;
    private final UnaryCallable<ListGeneratorsRequest, GeneratorsClient.ListGeneratorsPagedResponse> listGeneratorsPagedCallable;
    private final UnaryCallable<GetGeneratorRequest, Generator> getGeneratorCallable;
    private final UnaryCallable<CreateGeneratorRequest, Generator> createGeneratorCallable;
    private final UnaryCallable<UpdateGeneratorRequest, Generator> updateGeneratorCallable;
    private final UnaryCallable<DeleteGeneratorRequest, Empty> deleteGeneratorCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, GeneratorsClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcGeneratorsStub create(GeneratorsStubSettings settings) throws IOException {
        return new GrpcGeneratorsStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcGeneratorsStub create(ClientContext clientContext) throws IOException {
        return new GrpcGeneratorsStub(GeneratorsStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcGeneratorsStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcGeneratorsStub(GeneratorsStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcGeneratorsStub(GeneratorsStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcGeneratorsCallableFactory());
    }

    protected GrpcGeneratorsStub(GeneratorsStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings listGeneratorsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listGeneratorsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getGeneratorTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getGeneratorMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings createGeneratorTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createGeneratorMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings updateGeneratorTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateGeneratorMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("generator.name", String.valueOf(request.getGenerator().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteGeneratorTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteGeneratorMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listLocationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getLocationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.listGeneratorsCallable = callableFactory.createUnaryCallable(listGeneratorsTransportSettings, settings.listGeneratorsSettings(), clientContext);
        this.listGeneratorsPagedCallable = callableFactory.createPagedCallable(listGeneratorsTransportSettings, settings.listGeneratorsSettings(), clientContext);
        this.getGeneratorCallable = callableFactory.createUnaryCallable(getGeneratorTransportSettings, settings.getGeneratorSettings(), clientContext);
        this.createGeneratorCallable = callableFactory.createUnaryCallable(createGeneratorTransportSettings, settings.createGeneratorSettings(), clientContext);
        this.updateGeneratorCallable = callableFactory.createUnaryCallable(updateGeneratorTransportSettings, settings.updateGeneratorSettings(), clientContext);
        this.deleteGeneratorCallable = callableFactory.createUnaryCallable(deleteGeneratorTransportSettings, settings.deleteGeneratorSettings(), clientContext);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ListGeneratorsRequest, ListGeneratorsResponse> listGeneratorsCallable() {
        return this.listGeneratorsCallable;
    }

    @Override
    public UnaryCallable<ListGeneratorsRequest, GeneratorsClient.ListGeneratorsPagedResponse> listGeneratorsPagedCallable() {
        return this.listGeneratorsPagedCallable;
    }

    @Override
    public UnaryCallable<GetGeneratorRequest, Generator> getGeneratorCallable() {
        return this.getGeneratorCallable;
    }

    @Override
    public UnaryCallable<CreateGeneratorRequest, Generator> createGeneratorCallable() {
        return this.createGeneratorCallable;
    }

    @Override
    public UnaryCallable<UpdateGeneratorRequest, Generator> updateGeneratorCallable() {
        return this.updateGeneratorCallable;
    }

    @Override
    public UnaryCallable<DeleteGeneratorRequest, Empty> deleteGeneratorCallable() {
        return this.deleteGeneratorCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, GeneratorsClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

