/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.cx.v3.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.cx.v3.CreateExperimentRequest;
import com.google.cloud.dialogflow.cx.v3.DeleteExperimentRequest;
import com.google.cloud.dialogflow.cx.v3.Experiment;
import com.google.cloud.dialogflow.cx.v3.ExperimentsClient;
import com.google.cloud.dialogflow.cx.v3.GetExperimentRequest;
import com.google.cloud.dialogflow.cx.v3.ListExperimentsRequest;
import com.google.cloud.dialogflow.cx.v3.ListExperimentsResponse;
import com.google.cloud.dialogflow.cx.v3.StartExperimentRequest;
import com.google.cloud.dialogflow.cx.v3.StopExperimentRequest;
import com.google.cloud.dialogflow.cx.v3.UpdateExperimentRequest;
import com.google.cloud.dialogflow.cx.v3.stub.ExperimentsStub;
import com.google.cloud.dialogflow.cx.v3.stub.GrpcExperimentsStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class ExperimentsStubSettings
extends StubSettings<ExperimentsStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/dialogflow").build();
    private final PagedCallSettings<ListExperimentsRequest, ListExperimentsResponse, ExperimentsClient.ListExperimentsPagedResponse> listExperimentsSettings;
    private final UnaryCallSettings<GetExperimentRequest, Experiment> getExperimentSettings;
    private final UnaryCallSettings<CreateExperimentRequest, Experiment> createExperimentSettings;
    private final UnaryCallSettings<UpdateExperimentRequest, Experiment> updateExperimentSettings;
    private final UnaryCallSettings<DeleteExperimentRequest, Empty> deleteExperimentSettings;
    private final UnaryCallSettings<StartExperimentRequest, Experiment> startExperimentSettings;
    private final UnaryCallSettings<StopExperimentRequest, Experiment> stopExperimentSettings;
    private static final PagedListDescriptor<ListExperimentsRequest, ListExperimentsResponse, Experiment> LIST_EXPERIMENTS_PAGE_STR_DESC = new PagedListDescriptor<ListExperimentsRequest, ListExperimentsResponse, Experiment>(){

        public String emptyToken() {
            return "";
        }

        public ListExperimentsRequest injectToken(ListExperimentsRequest payload, String token) {
            return ListExperimentsRequest.newBuilder((ListExperimentsRequest)payload).setPageToken(token).build();
        }

        public ListExperimentsRequest injectPageSize(ListExperimentsRequest payload, int pageSize) {
            return ListExperimentsRequest.newBuilder((ListExperimentsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListExperimentsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListExperimentsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Experiment> extractResources(ListExperimentsResponse payload) {
            return payload.getExperimentsList() == null ? ImmutableList.of() : payload.getExperimentsList();
        }
    };
    private static final PagedListResponseFactory<ListExperimentsRequest, ListExperimentsResponse, ExperimentsClient.ListExperimentsPagedResponse> LIST_EXPERIMENTS_PAGE_STR_FACT = new PagedListResponseFactory<ListExperimentsRequest, ListExperimentsResponse, ExperimentsClient.ListExperimentsPagedResponse>(){

        public ApiFuture<ExperimentsClient.ListExperimentsPagedResponse> getFuturePagedResponse(UnaryCallable<ListExperimentsRequest, ListExperimentsResponse> callable, ListExperimentsRequest request, ApiCallContext context, ApiFuture<ListExperimentsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_EXPERIMENTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ExperimentsClient.ListExperimentsPagedResponse.createAsync((PageContext<ListExperimentsRequest, ListExperimentsResponse, Experiment>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListExperimentsRequest, ListExperimentsResponse, ExperimentsClient.ListExperimentsPagedResponse> listExperimentsSettings() {
        return this.listExperimentsSettings;
    }

    public UnaryCallSettings<GetExperimentRequest, Experiment> getExperimentSettings() {
        return this.getExperimentSettings;
    }

    public UnaryCallSettings<CreateExperimentRequest, Experiment> createExperimentSettings() {
        return this.createExperimentSettings;
    }

    public UnaryCallSettings<UpdateExperimentRequest, Experiment> updateExperimentSettings() {
        return this.updateExperimentSettings;
    }

    public UnaryCallSettings<DeleteExperimentRequest, Empty> deleteExperimentSettings() {
        return this.deleteExperimentSettings;
    }

    public UnaryCallSettings<StartExperimentRequest, Experiment> startExperimentSettings() {
        return this.startExperimentSettings;
    }

    public UnaryCallSettings<StopExperimentRequest, Experiment> stopExperimentSettings() {
        return this.stopExperimentSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public ExperimentsStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcExperimentsStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "dialogflow.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "dialogflow.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ExperimentsStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ExperimentsStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ExperimentsStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listExperimentsSettings = settingsBuilder.listExperimentsSettings().build();
        this.getExperimentSettings = settingsBuilder.getExperimentSettings().build();
        this.createExperimentSettings = settingsBuilder.createExperimentSettings().build();
        this.updateExperimentSettings = settingsBuilder.updateExperimentSettings().build();
        this.deleteExperimentSettings = settingsBuilder.deleteExperimentSettings().build();
        this.startExperimentSettings = settingsBuilder.startExperimentSettings().build();
        this.stopExperimentSettings = settingsBuilder.stopExperimentSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ExperimentsStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListExperimentsRequest, ListExperimentsResponse, ExperimentsClient.ListExperimentsPagedResponse> listExperimentsSettings;
        private final UnaryCallSettings.Builder<GetExperimentRequest, Experiment> getExperimentSettings;
        private final UnaryCallSettings.Builder<CreateExperimentRequest, Experiment> createExperimentSettings;
        private final UnaryCallSettings.Builder<UpdateExperimentRequest, Experiment> updateExperimentSettings;
        private final UnaryCallSettings.Builder<DeleteExperimentRequest, Empty> deleteExperimentSettings;
        private final UnaryCallSettings.Builder<StartExperimentRequest, Experiment> startExperimentSettings;
        private final UnaryCallSettings.Builder<StopExperimentRequest, Experiment> stopExperimentSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listExperimentsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_EXPERIMENTS_PAGE_STR_FACT);
            this.getExperimentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createExperimentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateExperimentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteExperimentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.startExperimentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.stopExperimentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listExperimentsSettings, this.getExperimentSettings, this.createExperimentSettings, this.updateExperimentSettings, this.deleteExperimentSettings, this.startExperimentSettings, this.stopExperimentSettings);
            Builder.initDefaults(this);
        }

        protected Builder(ExperimentsStubSettings settings) {
            super((StubSettings)settings);
            this.listExperimentsSettings = settings.listExperimentsSettings.toBuilder();
            this.getExperimentSettings = settings.getExperimentSettings.toBuilder();
            this.createExperimentSettings = settings.createExperimentSettings.toBuilder();
            this.updateExperimentSettings = settings.updateExperimentSettings.toBuilder();
            this.deleteExperimentSettings = settings.deleteExperimentSettings.toBuilder();
            this.startExperimentSettings = settings.startExperimentSettings.toBuilder();
            this.stopExperimentSettings = settings.stopExperimentSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listExperimentsSettings, this.getExperimentSettings, this.createExperimentSettings, this.updateExperimentSettings, this.deleteExperimentSettings, this.startExperimentSettings, this.stopExperimentSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ExperimentsStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ExperimentsStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ExperimentsStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(ExperimentsStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(ExperimentsStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listExperimentsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getExperimentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createExperimentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateExperimentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteExperimentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.startExperimentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.stopExperimentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListExperimentsRequest, ListExperimentsResponse, ExperimentsClient.ListExperimentsPagedResponse> listExperimentsSettings() {
            return this.listExperimentsSettings;
        }

        public UnaryCallSettings.Builder<GetExperimentRequest, Experiment> getExperimentSettings() {
            return this.getExperimentSettings;
        }

        public UnaryCallSettings.Builder<CreateExperimentRequest, Experiment> createExperimentSettings() {
            return this.createExperimentSettings;
        }

        public UnaryCallSettings.Builder<UpdateExperimentRequest, Experiment> updateExperimentSettings() {
            return this.updateExperimentSettings;
        }

        public UnaryCallSettings.Builder<DeleteExperimentRequest, Empty> deleteExperimentSettings() {
            return this.deleteExperimentSettings;
        }

        public UnaryCallSettings.Builder<StartExperimentRequest, Experiment> startExperimentSettings() {
            return this.startExperimentSettings;
        }

        public UnaryCallSettings.Builder<StopExperimentRequest, Experiment> stopExperimentSettings() {
            return this.stopExperimentSettings;
        }

        public ExperimentsStubSettings build() throws IOException {
            return new ExperimentsStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

