/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.cx.v3beta1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.cx.v3beta1.AgentName;
import com.google.cloud.dialogflow.cx.v3beta1.Conversation;
import com.google.cloud.dialogflow.cx.v3beta1.ConversationHistorySettings;
import com.google.cloud.dialogflow.cx.v3beta1.ConversationName;
import com.google.cloud.dialogflow.cx.v3beta1.DeleteConversationRequest;
import com.google.cloud.dialogflow.cx.v3beta1.GetConversationRequest;
import com.google.cloud.dialogflow.cx.v3beta1.ListConversationsRequest;
import com.google.cloud.dialogflow.cx.v3beta1.ListConversationsResponse;
import com.google.cloud.dialogflow.cx.v3beta1.stub.ConversationHistoryStub;
import com.google.cloud.dialogflow.cx.v3beta1.stub.ConversationHistoryStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class ConversationHistoryClient
implements BackgroundResource {
    private final ConversationHistorySettings settings;
    private final ConversationHistoryStub stub;

    public static final ConversationHistoryClient create() throws IOException {
        return ConversationHistoryClient.create(ConversationHistorySettings.newBuilder().build());
    }

    public static final ConversationHistoryClient create(ConversationHistorySettings settings) throws IOException {
        return new ConversationHistoryClient(settings);
    }

    public static final ConversationHistoryClient create(ConversationHistoryStub stub) {
        return new ConversationHistoryClient(stub);
    }

    protected ConversationHistoryClient(ConversationHistorySettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ConversationHistoryStubSettings)settings.getStubSettings()).createStub();
    }

    protected ConversationHistoryClient(ConversationHistoryStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ConversationHistorySettings getSettings() {
        return this.settings;
    }

    public ConversationHistoryStub getStub() {
        return this.stub;
    }

    public final ListConversationsPagedResponse listConversations(AgentName parent) {
        ListConversationsRequest request = ListConversationsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listConversations(request);
    }

    public final ListConversationsPagedResponse listConversations(String parent) {
        ListConversationsRequest request = ListConversationsRequest.newBuilder().setParent(parent).build();
        return this.listConversations(request);
    }

    public final ListConversationsPagedResponse listConversations(ListConversationsRequest request) {
        return (ListConversationsPagedResponse)((Object)this.listConversationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListConversationsRequest, ListConversationsPagedResponse> listConversationsPagedCallable() {
        return this.stub.listConversationsPagedCallable();
    }

    public final UnaryCallable<ListConversationsRequest, ListConversationsResponse> listConversationsCallable() {
        return this.stub.listConversationsCallable();
    }

    public final Conversation getConversation(ConversationName name) {
        GetConversationRequest request = GetConversationRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getConversation(request);
    }

    public final Conversation getConversation(String name) {
        GetConversationRequest request = GetConversationRequest.newBuilder().setName(name).build();
        return this.getConversation(request);
    }

    public final Conversation getConversation(GetConversationRequest request) {
        return (Conversation)this.getConversationCallable().call((Object)request);
    }

    public final UnaryCallable<GetConversationRequest, Conversation> getConversationCallable() {
        return this.stub.getConversationCallable();
    }

    public final void deleteConversation(ConversationName name) {
        DeleteConversationRequest request = DeleteConversationRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteConversation(request);
    }

    public final void deleteConversation(String name) {
        DeleteConversationRequest request = DeleteConversationRequest.newBuilder().setName(name).build();
        this.deleteConversation(request);
    }

    public final void deleteConversation(DeleteConversationRequest request) {
        this.deleteConversationCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteConversationRequest, Empty> deleteConversationCallable() {
        return this.stub.deleteConversationCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListConversationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListConversationsRequest, ListConversationsResponse, Conversation, ListConversationsPage, ListConversationsFixedSizeCollection> {
        private ListConversationsFixedSizeCollection(List<ListConversationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListConversationsFixedSizeCollection createEmptyCollection() {
            return new ListConversationsFixedSizeCollection(null, 0);
        }

        protected ListConversationsFixedSizeCollection createCollection(List<ListConversationsPage> pages, int collectionSize) {
            return new ListConversationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListConversationsPage
    extends AbstractPage<ListConversationsRequest, ListConversationsResponse, Conversation, ListConversationsPage> {
        private ListConversationsPage(PageContext<ListConversationsRequest, ListConversationsResponse, Conversation> context, ListConversationsResponse response) {
            super(context, (Object)response);
        }

        private static ListConversationsPage createEmptyPage() {
            return new ListConversationsPage(null, null);
        }

        protected ListConversationsPage createPage(PageContext<ListConversationsRequest, ListConversationsResponse, Conversation> context, ListConversationsResponse response) {
            return new ListConversationsPage(context, response);
        }

        public ApiFuture<ListConversationsPage> createPageAsync(PageContext<ListConversationsRequest, ListConversationsResponse, Conversation> context, ApiFuture<ListConversationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListConversationsPagedResponse
    extends AbstractPagedListResponse<ListConversationsRequest, ListConversationsResponse, Conversation, ListConversationsPage, ListConversationsFixedSizeCollection> {
        public static ApiFuture<ListConversationsPagedResponse> createAsync(PageContext<ListConversationsRequest, ListConversationsResponse, Conversation> context, ApiFuture<ListConversationsResponse> futureResponse) {
            ApiFuture<ListConversationsPage> futurePage = ListConversationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListConversationsPagedResponse((ListConversationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListConversationsPagedResponse(ListConversationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListConversationsFixedSizeCollection.createEmptyCollection());
        }
    }
}

