/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.cx.v3beta1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.cx.v3beta1.CreateExampleRequest;
import com.google.cloud.dialogflow.cx.v3beta1.DeleteExampleRequest;
import com.google.cloud.dialogflow.cx.v3beta1.Example;
import com.google.cloud.dialogflow.cx.v3beta1.ExampleName;
import com.google.cloud.dialogflow.cx.v3beta1.ExamplesSettings;
import com.google.cloud.dialogflow.cx.v3beta1.GetExampleRequest;
import com.google.cloud.dialogflow.cx.v3beta1.ListExamplesRequest;
import com.google.cloud.dialogflow.cx.v3beta1.ListExamplesResponse;
import com.google.cloud.dialogflow.cx.v3beta1.PlaybookName;
import com.google.cloud.dialogflow.cx.v3beta1.UpdateExampleRequest;
import com.google.cloud.dialogflow.cx.v3beta1.stub.ExamplesStub;
import com.google.cloud.dialogflow.cx.v3beta1.stub.ExamplesStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class ExamplesClient
implements BackgroundResource {
    private final ExamplesSettings settings;
    private final ExamplesStub stub;

    public static final ExamplesClient create() throws IOException {
        return ExamplesClient.create(ExamplesSettings.newBuilder().build());
    }

    public static final ExamplesClient create(ExamplesSettings settings) throws IOException {
        return new ExamplesClient(settings);
    }

    public static final ExamplesClient create(ExamplesStub stub) {
        return new ExamplesClient(stub);
    }

    protected ExamplesClient(ExamplesSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ExamplesStubSettings)settings.getStubSettings()).createStub();
    }

    protected ExamplesClient(ExamplesStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ExamplesSettings getSettings() {
        return this.settings;
    }

    public ExamplesStub getStub() {
        return this.stub;
    }

    public final Example createExample(PlaybookName parent, Example example) {
        CreateExampleRequest request = CreateExampleRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setExample(example).build();
        return this.createExample(request);
    }

    public final Example createExample(String parent, Example example) {
        CreateExampleRequest request = CreateExampleRequest.newBuilder().setParent(parent).setExample(example).build();
        return this.createExample(request);
    }

    public final Example createExample(CreateExampleRequest request) {
        return (Example)this.createExampleCallable().call((Object)request);
    }

    public final UnaryCallable<CreateExampleRequest, Example> createExampleCallable() {
        return this.stub.createExampleCallable();
    }

    public final void deleteExample(ExampleName name) {
        DeleteExampleRequest request = DeleteExampleRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteExample(request);
    }

    public final void deleteExample(String name) {
        DeleteExampleRequest request = DeleteExampleRequest.newBuilder().setName(name).build();
        this.deleteExample(request);
    }

    public final void deleteExample(DeleteExampleRequest request) {
        this.deleteExampleCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteExampleRequest, Empty> deleteExampleCallable() {
        return this.stub.deleteExampleCallable();
    }

    public final ListExamplesPagedResponse listExamples(PlaybookName parent) {
        ListExamplesRequest request = ListExamplesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listExamples(request);
    }

    public final ListExamplesPagedResponse listExamples(String parent) {
        ListExamplesRequest request = ListExamplesRequest.newBuilder().setParent(parent).build();
        return this.listExamples(request);
    }

    public final ListExamplesPagedResponse listExamples(ListExamplesRequest request) {
        return (ListExamplesPagedResponse)((Object)this.listExamplesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListExamplesRequest, ListExamplesPagedResponse> listExamplesPagedCallable() {
        return this.stub.listExamplesPagedCallable();
    }

    public final UnaryCallable<ListExamplesRequest, ListExamplesResponse> listExamplesCallable() {
        return this.stub.listExamplesCallable();
    }

    public final Example getExample(ExampleName name) {
        GetExampleRequest request = GetExampleRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getExample(request);
    }

    public final Example getExample(String name) {
        GetExampleRequest request = GetExampleRequest.newBuilder().setName(name).build();
        return this.getExample(request);
    }

    public final Example getExample(GetExampleRequest request) {
        return (Example)this.getExampleCallable().call((Object)request);
    }

    public final UnaryCallable<GetExampleRequest, Example> getExampleCallable() {
        return this.stub.getExampleCallable();
    }

    public final Example updateExample(Example example, FieldMask updateMask) {
        UpdateExampleRequest request = UpdateExampleRequest.newBuilder().setExample(example).setUpdateMask(updateMask).build();
        return this.updateExample(request);
    }

    public final Example updateExample(UpdateExampleRequest request) {
        return (Example)this.updateExampleCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateExampleRequest, Example> updateExampleCallable() {
        return this.stub.updateExampleCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListExamplesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListExamplesRequest, ListExamplesResponse, Example, ListExamplesPage, ListExamplesFixedSizeCollection> {
        private ListExamplesFixedSizeCollection(List<ListExamplesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListExamplesFixedSizeCollection createEmptyCollection() {
            return new ListExamplesFixedSizeCollection(null, 0);
        }

        protected ListExamplesFixedSizeCollection createCollection(List<ListExamplesPage> pages, int collectionSize) {
            return new ListExamplesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListExamplesPage
    extends AbstractPage<ListExamplesRequest, ListExamplesResponse, Example, ListExamplesPage> {
        private ListExamplesPage(PageContext<ListExamplesRequest, ListExamplesResponse, Example> context, ListExamplesResponse response) {
            super(context, (Object)response);
        }

        private static ListExamplesPage createEmptyPage() {
            return new ListExamplesPage(null, null);
        }

        protected ListExamplesPage createPage(PageContext<ListExamplesRequest, ListExamplesResponse, Example> context, ListExamplesResponse response) {
            return new ListExamplesPage(context, response);
        }

        public ApiFuture<ListExamplesPage> createPageAsync(PageContext<ListExamplesRequest, ListExamplesResponse, Example> context, ApiFuture<ListExamplesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListExamplesPagedResponse
    extends AbstractPagedListResponse<ListExamplesRequest, ListExamplesResponse, Example, ListExamplesPage, ListExamplesFixedSizeCollection> {
        public static ApiFuture<ListExamplesPagedResponse> createAsync(PageContext<ListExamplesRequest, ListExamplesResponse, Example> context, ApiFuture<ListExamplesResponse> futureResponse) {
            ApiFuture<ListExamplesPage> futurePage = ListExamplesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListExamplesPagedResponse((ListExamplesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListExamplesPagedResponse(ListExamplesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListExamplesFixedSizeCollection.createEmptyCollection());
        }
    }
}

