/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.cx.v3;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.cx.v3.AgentName;
import com.google.cloud.dialogflow.cx.v3.CreateEntityTypeRequest;
import com.google.cloud.dialogflow.cx.v3.DeleteEntityTypeRequest;
import com.google.cloud.dialogflow.cx.v3.EntityType;
import com.google.cloud.dialogflow.cx.v3.EntityTypeName;
import com.google.cloud.dialogflow.cx.v3.EntityTypesSettings;
import com.google.cloud.dialogflow.cx.v3.GetEntityTypeRequest;
import com.google.cloud.dialogflow.cx.v3.ListEntityTypesRequest;
import com.google.cloud.dialogflow.cx.v3.ListEntityTypesResponse;
import com.google.cloud.dialogflow.cx.v3.UpdateEntityTypeRequest;
import com.google.cloud.dialogflow.cx.v3.stub.EntityTypesStub;
import com.google.cloud.dialogflow.cx.v3.stub.EntityTypesStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class EntityTypesClient
implements BackgroundResource {
    private final EntityTypesSettings settings;
    private final EntityTypesStub stub;

    public static final EntityTypesClient create() throws IOException {
        return EntityTypesClient.create(EntityTypesSettings.newBuilder().build());
    }

    public static final EntityTypesClient create(EntityTypesSettings settings) throws IOException {
        return new EntityTypesClient(settings);
    }

    public static final EntityTypesClient create(EntityTypesStub stub) {
        return new EntityTypesClient(stub);
    }

    protected EntityTypesClient(EntityTypesSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((EntityTypesStubSettings)settings.getStubSettings()).createStub();
    }

    protected EntityTypesClient(EntityTypesStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final EntityTypesSettings getSettings() {
        return this.settings;
    }

    public EntityTypesStub getStub() {
        return this.stub;
    }

    public final EntityType getEntityType(EntityTypeName name) {
        GetEntityTypeRequest request = GetEntityTypeRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getEntityType(request);
    }

    public final EntityType getEntityType(String name) {
        GetEntityTypeRequest request = GetEntityTypeRequest.newBuilder().setName(name).build();
        return this.getEntityType(request);
    }

    public final EntityType getEntityType(GetEntityTypeRequest request) {
        return (EntityType)this.getEntityTypeCallable().call((Object)request);
    }

    public final UnaryCallable<GetEntityTypeRequest, EntityType> getEntityTypeCallable() {
        return this.stub.getEntityTypeCallable();
    }

    public final EntityType createEntityType(AgentName parent, EntityType entityType) {
        CreateEntityTypeRequest request = CreateEntityTypeRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setEntityType(entityType).build();
        return this.createEntityType(request);
    }

    public final EntityType createEntityType(String parent, EntityType entityType) {
        CreateEntityTypeRequest request = CreateEntityTypeRequest.newBuilder().setParent(parent).setEntityType(entityType).build();
        return this.createEntityType(request);
    }

    public final EntityType createEntityType(CreateEntityTypeRequest request) {
        return (EntityType)this.createEntityTypeCallable().call((Object)request);
    }

    public final UnaryCallable<CreateEntityTypeRequest, EntityType> createEntityTypeCallable() {
        return this.stub.createEntityTypeCallable();
    }

    public final EntityType updateEntityType(EntityType entityType, FieldMask updateMask) {
        UpdateEntityTypeRequest request = UpdateEntityTypeRequest.newBuilder().setEntityType(entityType).setUpdateMask(updateMask).build();
        return this.updateEntityType(request);
    }

    public final EntityType updateEntityType(UpdateEntityTypeRequest request) {
        return (EntityType)this.updateEntityTypeCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateEntityTypeRequest, EntityType> updateEntityTypeCallable() {
        return this.stub.updateEntityTypeCallable();
    }

    public final void deleteEntityType(EntityTypeName name) {
        DeleteEntityTypeRequest request = DeleteEntityTypeRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteEntityType(request);
    }

    public final void deleteEntityType(String name) {
        DeleteEntityTypeRequest request = DeleteEntityTypeRequest.newBuilder().setName(name).build();
        this.deleteEntityType(request);
    }

    public final void deleteEntityType(DeleteEntityTypeRequest request) {
        this.deleteEntityTypeCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteEntityTypeRequest, Empty> deleteEntityTypeCallable() {
        return this.stub.deleteEntityTypeCallable();
    }

    public final ListEntityTypesPagedResponse listEntityTypes(AgentName parent) {
        ListEntityTypesRequest request = ListEntityTypesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listEntityTypes(request);
    }

    public final ListEntityTypesPagedResponse listEntityTypes(String parent) {
        ListEntityTypesRequest request = ListEntityTypesRequest.newBuilder().setParent(parent).build();
        return this.listEntityTypes(request);
    }

    public final ListEntityTypesPagedResponse listEntityTypes(ListEntityTypesRequest request) {
        return (ListEntityTypesPagedResponse)((Object)this.listEntityTypesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListEntityTypesRequest, ListEntityTypesPagedResponse> listEntityTypesPagedCallable() {
        return this.stub.listEntityTypesPagedCallable();
    }

    public final UnaryCallable<ListEntityTypesRequest, ListEntityTypesResponse> listEntityTypesCallable() {
        return this.stub.listEntityTypesCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListEntityTypesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListEntityTypesRequest, ListEntityTypesResponse, EntityType, ListEntityTypesPage, ListEntityTypesFixedSizeCollection> {
        private ListEntityTypesFixedSizeCollection(List<ListEntityTypesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListEntityTypesFixedSizeCollection createEmptyCollection() {
            return new ListEntityTypesFixedSizeCollection(null, 0);
        }

        protected ListEntityTypesFixedSizeCollection createCollection(List<ListEntityTypesPage> pages, int collectionSize) {
            return new ListEntityTypesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListEntityTypesPage
    extends AbstractPage<ListEntityTypesRequest, ListEntityTypesResponse, EntityType, ListEntityTypesPage> {
        private ListEntityTypesPage(PageContext<ListEntityTypesRequest, ListEntityTypesResponse, EntityType> context, ListEntityTypesResponse response) {
            super(context, (Object)response);
        }

        private static ListEntityTypesPage createEmptyPage() {
            return new ListEntityTypesPage(null, null);
        }

        protected ListEntityTypesPage createPage(PageContext<ListEntityTypesRequest, ListEntityTypesResponse, EntityType> context, ListEntityTypesResponse response) {
            return new ListEntityTypesPage(context, response);
        }

        public ApiFuture<ListEntityTypesPage> createPageAsync(PageContext<ListEntityTypesRequest, ListEntityTypesResponse, EntityType> context, ApiFuture<ListEntityTypesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListEntityTypesPagedResponse
    extends AbstractPagedListResponse<ListEntityTypesRequest, ListEntityTypesResponse, EntityType, ListEntityTypesPage, ListEntityTypesFixedSizeCollection> {
        public static ApiFuture<ListEntityTypesPagedResponse> createAsync(PageContext<ListEntityTypesRequest, ListEntityTypesResponse, EntityType> context, ApiFuture<ListEntityTypesResponse> futureResponse) {
            ApiFuture<ListEntityTypesPage> futurePage = ListEntityTypesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListEntityTypesPagedResponse((ListEntityTypesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListEntityTypesPagedResponse(ListEntityTypesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListEntityTypesFixedSizeCollection.createEmptyCollection());
        }
    }
}

