/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.cx.v3.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.cx.v3.CreateIntentRequest;
import com.google.cloud.dialogflow.cx.v3.DeleteIntentRequest;
import com.google.cloud.dialogflow.cx.v3.GetIntentRequest;
import com.google.cloud.dialogflow.cx.v3.Intent;
import com.google.cloud.dialogflow.cx.v3.IntentsClient;
import com.google.cloud.dialogflow.cx.v3.ListIntentsRequest;
import com.google.cloud.dialogflow.cx.v3.ListIntentsResponse;
import com.google.cloud.dialogflow.cx.v3.UpdateIntentRequest;
import com.google.cloud.dialogflow.cx.v3.stub.GrpcIntentsCallableFactory;
import com.google.cloud.dialogflow.cx.v3.stub.IntentsStub;
import com.google.cloud.dialogflow.cx.v3.stub.IntentsStubSettings;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
public class GrpcIntentsStub
extends IntentsStub {
    private static final MethodDescriptor<ListIntentsRequest, ListIntentsResponse> listIntentsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.cx.v3.Intents/ListIntents").setRequestMarshaller(ProtoUtils.marshaller((Message)ListIntentsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListIntentsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetIntentRequest, Intent> getIntentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.cx.v3.Intents/GetIntent").setRequestMarshaller(ProtoUtils.marshaller((Message)GetIntentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Intent.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateIntentRequest, Intent> createIntentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.cx.v3.Intents/CreateIntent").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateIntentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Intent.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateIntentRequest, Intent> updateIntentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.cx.v3.Intents/UpdateIntent").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateIntentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Intent.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteIntentRequest, Empty> deleteIntentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.cx.v3.Intents/DeleteIntent").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteIntentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private final BackgroundResource backgroundResources;
    private final UnaryCallable<ListIntentsRequest, ListIntentsResponse> listIntentsCallable;
    private final UnaryCallable<ListIntentsRequest, IntentsClient.ListIntentsPagedResponse> listIntentsPagedCallable;
    private final UnaryCallable<GetIntentRequest, Intent> getIntentCallable;
    private final UnaryCallable<CreateIntentRequest, Intent> createIntentCallable;
    private final UnaryCallable<UpdateIntentRequest, Intent> updateIntentCallable;
    private final UnaryCallable<DeleteIntentRequest, Empty> deleteIntentCallable;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcIntentsStub create(IntentsStubSettings settings) throws IOException {
        return new GrpcIntentsStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcIntentsStub create(ClientContext clientContext) throws IOException {
        return new GrpcIntentsStub(IntentsStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcIntentsStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcIntentsStub(IntentsStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcIntentsStub(IntentsStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcIntentsCallableFactory());
    }

    protected GrpcIntentsStub(IntentsStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        GrpcCallSettings listIntentsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listIntentsMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<ListIntentsRequest>(){

            public Map<String, String> extract(ListIntentsRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        GrpcCallSettings getIntentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getIntentMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<GetIntentRequest>(){

            public Map<String, String> extract(GetIntentRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings createIntentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createIntentMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<CreateIntentRequest>(){

            public Map<String, String> extract(CreateIntentRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        GrpcCallSettings updateIntentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateIntentMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<UpdateIntentRequest>(){

            public Map<String, String> extract(UpdateIntentRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"intent.name", (Object)String.valueOf(request.getIntent().getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings deleteIntentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteIntentMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<DeleteIntentRequest>(){

            public Map<String, String> extract(DeleteIntentRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        this.listIntentsCallable = callableFactory.createUnaryCallable(listIntentsTransportSettings, settings.listIntentsSettings(), clientContext);
        this.listIntentsPagedCallable = callableFactory.createPagedCallable(listIntentsTransportSettings, settings.listIntentsSettings(), clientContext);
        this.getIntentCallable = callableFactory.createUnaryCallable(getIntentTransportSettings, settings.getIntentSettings(), clientContext);
        this.createIntentCallable = callableFactory.createUnaryCallable(createIntentTransportSettings, settings.createIntentSettings(), clientContext);
        this.updateIntentCallable = callableFactory.createUnaryCallable(updateIntentTransportSettings, settings.updateIntentSettings(), clientContext);
        this.deleteIntentCallable = callableFactory.createUnaryCallable(deleteIntentTransportSettings, settings.deleteIntentSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @Override
    public UnaryCallable<ListIntentsRequest, IntentsClient.ListIntentsPagedResponse> listIntentsPagedCallable() {
        return this.listIntentsPagedCallable;
    }

    @Override
    public UnaryCallable<ListIntentsRequest, ListIntentsResponse> listIntentsCallable() {
        return this.listIntentsCallable;
    }

    @Override
    public UnaryCallable<GetIntentRequest, Intent> getIntentCallable() {
        return this.getIntentCallable;
    }

    @Override
    public UnaryCallable<CreateIntentRequest, Intent> createIntentCallable() {
        return this.createIntentCallable;
    }

    @Override
    public UnaryCallable<UpdateIntentRequest, Intent> updateIntentCallable() {
        return this.updateIntentCallable;
    }

    @Override
    public UnaryCallable<DeleteIntentRequest, Empty> deleteIntentCallable() {
        return this.deleteIntentCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

