/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.cx.v3;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.cx.v3.Agent;
import com.google.cloud.dialogflow.cx.v3.AgentName;
import com.google.cloud.dialogflow.cx.v3.AgentsSettings;
import com.google.cloud.dialogflow.cx.v3.CreateAgentRequest;
import com.google.cloud.dialogflow.cx.v3.DeleteAgentRequest;
import com.google.cloud.dialogflow.cx.v3.ExportAgentRequest;
import com.google.cloud.dialogflow.cx.v3.ExportAgentResponse;
import com.google.cloud.dialogflow.cx.v3.GetAgentRequest;
import com.google.cloud.dialogflow.cx.v3.ListAgentsRequest;
import com.google.cloud.dialogflow.cx.v3.ListAgentsResponse;
import com.google.cloud.dialogflow.cx.v3.LocationName;
import com.google.cloud.dialogflow.cx.v3.RestoreAgentRequest;
import com.google.cloud.dialogflow.cx.v3.UpdateAgentRequest;
import com.google.cloud.dialogflow.cx.v3.stub.AgentsStub;
import com.google.cloud.dialogflow.cx.v3.stub.AgentsStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Struct;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class AgentsClient
implements BackgroundResource {
    private final AgentsSettings settings;
    private final AgentsStub stub;
    private final OperationsClient operationsClient;

    public static final AgentsClient create() throws IOException {
        return AgentsClient.create(AgentsSettings.newBuilder().build());
    }

    public static final AgentsClient create(AgentsSettings settings) throws IOException {
        return new AgentsClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final AgentsClient create(AgentsStub stub) {
        return new AgentsClient(stub);
    }

    protected AgentsClient(AgentsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((AgentsStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected AgentsClient(AgentsStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final AgentsSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public AgentsStub getStub() {
        return this.stub;
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final ListAgentsPagedResponse listAgents(LocationName parent) {
        ListAgentsRequest request = ListAgentsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listAgents(request);
    }

    public final ListAgentsPagedResponse listAgents(String parent) {
        ListAgentsRequest request = ListAgentsRequest.newBuilder().setParent(parent).build();
        return this.listAgents(request);
    }

    public final ListAgentsPagedResponse listAgents(ListAgentsRequest request) {
        return (ListAgentsPagedResponse)((Object)this.listAgentsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListAgentsRequest, ListAgentsPagedResponse> listAgentsPagedCallable() {
        return this.stub.listAgentsPagedCallable();
    }

    public final UnaryCallable<ListAgentsRequest, ListAgentsResponse> listAgentsCallable() {
        return this.stub.listAgentsCallable();
    }

    public final Agent getAgent(AgentName name) {
        GetAgentRequest request = GetAgentRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getAgent(request);
    }

    public final Agent getAgent(String name) {
        GetAgentRequest request = GetAgentRequest.newBuilder().setName(name).build();
        return this.getAgent(request);
    }

    public final Agent getAgent(GetAgentRequest request) {
        return (Agent)this.getAgentCallable().call((Object)request);
    }

    public final UnaryCallable<GetAgentRequest, Agent> getAgentCallable() {
        return this.stub.getAgentCallable();
    }

    public final Agent createAgent(LocationName parent, Agent agent) {
        CreateAgentRequest request = CreateAgentRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setAgent(agent).build();
        return this.createAgent(request);
    }

    public final Agent createAgent(String parent, Agent agent) {
        CreateAgentRequest request = CreateAgentRequest.newBuilder().setParent(parent).setAgent(agent).build();
        return this.createAgent(request);
    }

    public final Agent createAgent(CreateAgentRequest request) {
        return (Agent)this.createAgentCallable().call((Object)request);
    }

    public final UnaryCallable<CreateAgentRequest, Agent> createAgentCallable() {
        return this.stub.createAgentCallable();
    }

    public final Agent updateAgent(Agent agent, FieldMask updateMask) {
        UpdateAgentRequest request = UpdateAgentRequest.newBuilder().setAgent(agent).setUpdateMask(updateMask).build();
        return this.updateAgent(request);
    }

    public final Agent updateAgent(UpdateAgentRequest request) {
        return (Agent)this.updateAgentCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateAgentRequest, Agent> updateAgentCallable() {
        return this.stub.updateAgentCallable();
    }

    public final void deleteAgent(AgentName name) {
        DeleteAgentRequest request = DeleteAgentRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteAgent(request);
    }

    public final void deleteAgent(String name) {
        DeleteAgentRequest request = DeleteAgentRequest.newBuilder().setName(name).build();
        this.deleteAgent(request);
    }

    public final void deleteAgent(DeleteAgentRequest request) {
        this.deleteAgentCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteAgentRequest, Empty> deleteAgentCallable() {
        return this.stub.deleteAgentCallable();
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<ExportAgentResponse, Struct> exportAgentAsync(ExportAgentRequest request) {
        return this.exportAgentOperationCallable().futureCall((Object)request);
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public final OperationCallable<ExportAgentRequest, ExportAgentResponse, Struct> exportAgentOperationCallable() {
        return this.stub.exportAgentOperationCallable();
    }

    public final UnaryCallable<ExportAgentRequest, Operation> exportAgentCallable() {
        return this.stub.exportAgentCallable();
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, Struct> restoreAgentAsync(RestoreAgentRequest request) {
        return this.restoreAgentOperationCallable().futureCall((Object)request);
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public final OperationCallable<RestoreAgentRequest, Empty, Struct> restoreAgentOperationCallable() {
        return this.stub.restoreAgentOperationCallable();
    }

    public final UnaryCallable<RestoreAgentRequest, Operation> restoreAgentCallable() {
        return this.stub.restoreAgentCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListAgentsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListAgentsRequest, ListAgentsResponse, Agent, ListAgentsPage, ListAgentsFixedSizeCollection> {
        private ListAgentsFixedSizeCollection(List<ListAgentsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListAgentsFixedSizeCollection createEmptyCollection() {
            return new ListAgentsFixedSizeCollection(null, 0);
        }

        protected ListAgentsFixedSizeCollection createCollection(List<ListAgentsPage> pages, int collectionSize) {
            return new ListAgentsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListAgentsPage
    extends AbstractPage<ListAgentsRequest, ListAgentsResponse, Agent, ListAgentsPage> {
        private ListAgentsPage(PageContext<ListAgentsRequest, ListAgentsResponse, Agent> context, ListAgentsResponse response) {
            super(context, (Object)response);
        }

        private static ListAgentsPage createEmptyPage() {
            return new ListAgentsPage(null, null);
        }

        protected ListAgentsPage createPage(PageContext<ListAgentsRequest, ListAgentsResponse, Agent> context, ListAgentsResponse response) {
            return new ListAgentsPage(context, response);
        }

        public ApiFuture<ListAgentsPage> createPageAsync(PageContext<ListAgentsRequest, ListAgentsResponse, Agent> context, ApiFuture<ListAgentsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListAgentsPagedResponse
    extends AbstractPagedListResponse<ListAgentsRequest, ListAgentsResponse, Agent, ListAgentsPage, ListAgentsFixedSizeCollection> {
        public static ApiFuture<ListAgentsPagedResponse> createAsync(PageContext<ListAgentsRequest, ListAgentsResponse, Agent> context, ApiFuture<ListAgentsResponse> futureResponse) {
            ApiFuture<ListAgentsPage> futurePage = ListAgentsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListAgentsPage, ListAgentsPagedResponse>(){

                public ListAgentsPagedResponse apply(ListAgentsPage input) {
                    return new ListAgentsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListAgentsPagedResponse(ListAgentsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListAgentsFixedSizeCollection.createEmptyCollection());
        }
    }
}

