/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.cx.v3beta1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.cx.v3beta1.AgentName;
import com.google.cloud.dialogflow.cx.v3beta1.CreateFlowRequest;
import com.google.cloud.dialogflow.cx.v3beta1.DeleteFlowRequest;
import com.google.cloud.dialogflow.cx.v3beta1.Flow;
import com.google.cloud.dialogflow.cx.v3beta1.FlowName;
import com.google.cloud.dialogflow.cx.v3beta1.FlowsSettings;
import com.google.cloud.dialogflow.cx.v3beta1.GetFlowRequest;
import com.google.cloud.dialogflow.cx.v3beta1.ListFlowsRequest;
import com.google.cloud.dialogflow.cx.v3beta1.ListFlowsResponse;
import com.google.cloud.dialogflow.cx.v3beta1.TrainFlowRequest;
import com.google.cloud.dialogflow.cx.v3beta1.UpdateFlowRequest;
import com.google.cloud.dialogflow.cx.v3beta1.stub.FlowsStub;
import com.google.cloud.dialogflow.cx.v3beta1.stub.FlowsStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Struct;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class FlowsClient
implements BackgroundResource {
    private final FlowsSettings settings;
    private final FlowsStub stub;
    private final OperationsClient operationsClient;

    public static final FlowsClient create() throws IOException {
        return FlowsClient.create(FlowsSettings.newBuilder().build());
    }

    public static final FlowsClient create(FlowsSettings settings) throws IOException {
        return new FlowsClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final FlowsClient create(FlowsStub stub) {
        return new FlowsClient(stub);
    }

    protected FlowsClient(FlowsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((FlowsStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected FlowsClient(FlowsStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final FlowsSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public FlowsStub getStub() {
        return this.stub;
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final Flow createFlow(AgentName parent, Flow flow) {
        CreateFlowRequest request = CreateFlowRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setFlow(flow).build();
        return this.createFlow(request);
    }

    public final Flow createFlow(String parent, Flow flow) {
        CreateFlowRequest request = CreateFlowRequest.newBuilder().setParent(parent).setFlow(flow).build();
        return this.createFlow(request);
    }

    public final Flow createFlow(CreateFlowRequest request) {
        return (Flow)this.createFlowCallable().call((Object)request);
    }

    public final UnaryCallable<CreateFlowRequest, Flow> createFlowCallable() {
        return this.stub.createFlowCallable();
    }

    public final void deleteFlow(FlowName name) {
        DeleteFlowRequest request = DeleteFlowRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteFlow(request);
    }

    public final void deleteFlow(String name) {
        DeleteFlowRequest request = DeleteFlowRequest.newBuilder().setName(name).build();
        this.deleteFlow(request);
    }

    public final void deleteFlow(DeleteFlowRequest request) {
        this.deleteFlowCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteFlowRequest, Empty> deleteFlowCallable() {
        return this.stub.deleteFlowCallable();
    }

    public final ListFlowsPagedResponse listFlows(AgentName parent) {
        ListFlowsRequest request = ListFlowsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listFlows(request);
    }

    public final ListFlowsPagedResponse listFlows(String parent) {
        ListFlowsRequest request = ListFlowsRequest.newBuilder().setParent(parent).build();
        return this.listFlows(request);
    }

    public final ListFlowsPagedResponse listFlows(ListFlowsRequest request) {
        return (ListFlowsPagedResponse)((Object)this.listFlowsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListFlowsRequest, ListFlowsPagedResponse> listFlowsPagedCallable() {
        return this.stub.listFlowsPagedCallable();
    }

    public final UnaryCallable<ListFlowsRequest, ListFlowsResponse> listFlowsCallable() {
        return this.stub.listFlowsCallable();
    }

    public final Flow getFlow(FlowName name) {
        GetFlowRequest request = GetFlowRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getFlow(request);
    }

    public final Flow getFlow(String name) {
        GetFlowRequest request = GetFlowRequest.newBuilder().setName(name).build();
        return this.getFlow(request);
    }

    public final Flow getFlow(GetFlowRequest request) {
        return (Flow)this.getFlowCallable().call((Object)request);
    }

    public final UnaryCallable<GetFlowRequest, Flow> getFlowCallable() {
        return this.stub.getFlowCallable();
    }

    public final Flow updateFlow(Flow flow, FieldMask updateMask) {
        UpdateFlowRequest request = UpdateFlowRequest.newBuilder().setFlow(flow).setUpdateMask(updateMask).build();
        return this.updateFlow(request);
    }

    public final Flow updateFlow(UpdateFlowRequest request) {
        return (Flow)this.updateFlowCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateFlowRequest, Flow> updateFlowCallable() {
        return this.stub.updateFlowCallable();
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, Struct> trainFlowAsync(FlowName name) {
        TrainFlowRequest request = TrainFlowRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.trainFlowAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, Struct> trainFlowAsync(String name) {
        TrainFlowRequest request = TrainFlowRequest.newBuilder().setName(name).build();
        return this.trainFlowAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, Struct> trainFlowAsync(TrainFlowRequest request) {
        return this.trainFlowOperationCallable().futureCall((Object)request);
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public final OperationCallable<TrainFlowRequest, Empty, Struct> trainFlowOperationCallable() {
        return this.stub.trainFlowOperationCallable();
    }

    public final UnaryCallable<TrainFlowRequest, Operation> trainFlowCallable() {
        return this.stub.trainFlowCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFlowsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListFlowsRequest, ListFlowsResponse, Flow, ListFlowsPage, ListFlowsFixedSizeCollection> {
        private ListFlowsFixedSizeCollection(List<ListFlowsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFlowsFixedSizeCollection createEmptyCollection() {
            return new ListFlowsFixedSizeCollection(null, 0);
        }

        protected ListFlowsFixedSizeCollection createCollection(List<ListFlowsPage> pages, int collectionSize) {
            return new ListFlowsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListFlowsPage
    extends AbstractPage<ListFlowsRequest, ListFlowsResponse, Flow, ListFlowsPage> {
        private ListFlowsPage(PageContext<ListFlowsRequest, ListFlowsResponse, Flow> context, ListFlowsResponse response) {
            super(context, (Object)response);
        }

        private static ListFlowsPage createEmptyPage() {
            return new ListFlowsPage(null, null);
        }

        protected ListFlowsPage createPage(PageContext<ListFlowsRequest, ListFlowsResponse, Flow> context, ListFlowsResponse response) {
            return new ListFlowsPage(context, response);
        }

        public ApiFuture<ListFlowsPage> createPageAsync(PageContext<ListFlowsRequest, ListFlowsResponse, Flow> context, ApiFuture<ListFlowsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListFlowsPagedResponse
    extends AbstractPagedListResponse<ListFlowsRequest, ListFlowsResponse, Flow, ListFlowsPage, ListFlowsFixedSizeCollection> {
        public static ApiFuture<ListFlowsPagedResponse> createAsync(PageContext<ListFlowsRequest, ListFlowsResponse, Flow> context, ApiFuture<ListFlowsResponse> futureResponse) {
            ApiFuture<ListFlowsPage> futurePage = ListFlowsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListFlowsPage, ListFlowsPagedResponse>(){

                public ListFlowsPagedResponse apply(ListFlowsPage input) {
                    return new ListFlowsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListFlowsPagedResponse(ListFlowsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFlowsFixedSizeCollection.createEmptyCollection());
        }
    }
}

