/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.cx.v3beta1.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.cx.v3beta1.CreateSecuritySettingsRequest;
import com.google.cloud.dialogflow.cx.v3beta1.DeleteSecuritySettingsRequest;
import com.google.cloud.dialogflow.cx.v3beta1.GetSecuritySettingsRequest;
import com.google.cloud.dialogflow.cx.v3beta1.ListSecuritySettingsRequest;
import com.google.cloud.dialogflow.cx.v3beta1.ListSecuritySettingsResponse;
import com.google.cloud.dialogflow.cx.v3beta1.SecuritySettings;
import com.google.cloud.dialogflow.cx.v3beta1.SecuritySettingsServiceClient;
import com.google.cloud.dialogflow.cx.v3beta1.UpdateSecuritySettingsRequest;
import com.google.cloud.dialogflow.cx.v3beta1.stub.GrpcSecuritySettingsServiceCallableFactory;
import com.google.cloud.dialogflow.cx.v3beta1.stub.SecuritySettingsServiceStub;
import com.google.cloud.dialogflow.cx.v3beta1.stub.SecuritySettingsServiceStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcSecuritySettingsServiceStub
extends SecuritySettingsServiceStub {
    private static final MethodDescriptor<CreateSecuritySettingsRequest, SecuritySettings> createSecuritySettingsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.cx.v3beta1.SecuritySettingsService/CreateSecuritySettings").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateSecuritySettingsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)SecuritySettings.getDefaultInstance())).build();
    private static final MethodDescriptor<GetSecuritySettingsRequest, SecuritySettings> getSecuritySettingsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.cx.v3beta1.SecuritySettingsService/GetSecuritySettings").setRequestMarshaller(ProtoUtils.marshaller((Message)GetSecuritySettingsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)SecuritySettings.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateSecuritySettingsRequest, SecuritySettings> updateSecuritySettingsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.cx.v3beta1.SecuritySettingsService/UpdateSecuritySettings").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateSecuritySettingsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)SecuritySettings.getDefaultInstance())).build();
    private static final MethodDescriptor<ListSecuritySettingsRequest, ListSecuritySettingsResponse> listSecuritySettingsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.cx.v3beta1.SecuritySettingsService/ListSecuritySettings").setRequestMarshaller(ProtoUtils.marshaller((Message)ListSecuritySettingsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListSecuritySettingsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteSecuritySettingsRequest, Empty> deleteSecuritySettingsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.cx.v3beta1.SecuritySettingsService/DeleteSecuritySettings").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteSecuritySettingsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/ListLocations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListLocationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListLocationsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/GetLocation").setRequestMarshaller(ProtoUtils.marshaller((Message)GetLocationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Location.getDefaultInstance())).build();
    private final UnaryCallable<CreateSecuritySettingsRequest, SecuritySettings> createSecuritySettingsCallable;
    private final UnaryCallable<GetSecuritySettingsRequest, SecuritySettings> getSecuritySettingsCallable;
    private final UnaryCallable<UpdateSecuritySettingsRequest, SecuritySettings> updateSecuritySettingsCallable;
    private final UnaryCallable<ListSecuritySettingsRequest, ListSecuritySettingsResponse> listSecuritySettingsCallable;
    private final UnaryCallable<ListSecuritySettingsRequest, SecuritySettingsServiceClient.ListSecuritySettingsPagedResponse> listSecuritySettingsPagedCallable;
    private final UnaryCallable<DeleteSecuritySettingsRequest, Empty> deleteSecuritySettingsCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, SecuritySettingsServiceClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcSecuritySettingsServiceStub create(SecuritySettingsServiceStubSettings settings) throws IOException {
        return new GrpcSecuritySettingsServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcSecuritySettingsServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcSecuritySettingsServiceStub(SecuritySettingsServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcSecuritySettingsServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcSecuritySettingsServiceStub(SecuritySettingsServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcSecuritySettingsServiceStub(SecuritySettingsServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcSecuritySettingsServiceCallableFactory());
    }

    protected GrpcSecuritySettingsServiceStub(SecuritySettingsServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createSecuritySettingsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createSecuritySettingsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings getSecuritySettingsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getSecuritySettingsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings updateSecuritySettingsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateSecuritySettingsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"security_settings.name", (Object)String.valueOf(request.getSecuritySettings().getName()));
            return params.build();
        }).build();
        GrpcCallSettings listSecuritySettingsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listSecuritySettingsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings deleteSecuritySettingsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteSecuritySettingsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings listLocationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings getLocationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        this.createSecuritySettingsCallable = callableFactory.createUnaryCallable(createSecuritySettingsTransportSettings, settings.createSecuritySettingsSettings(), clientContext);
        this.getSecuritySettingsCallable = callableFactory.createUnaryCallable(getSecuritySettingsTransportSettings, settings.getSecuritySettingsSettings(), clientContext);
        this.updateSecuritySettingsCallable = callableFactory.createUnaryCallable(updateSecuritySettingsTransportSettings, settings.updateSecuritySettingsSettings(), clientContext);
        this.listSecuritySettingsCallable = callableFactory.createUnaryCallable(listSecuritySettingsTransportSettings, settings.listSecuritySettingsSettings(), clientContext);
        this.listSecuritySettingsPagedCallable = callableFactory.createPagedCallable(listSecuritySettingsTransportSettings, settings.listSecuritySettingsSettings(), clientContext);
        this.deleteSecuritySettingsCallable = callableFactory.createUnaryCallable(deleteSecuritySettingsTransportSettings, settings.deleteSecuritySettingsSettings(), clientContext);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateSecuritySettingsRequest, SecuritySettings> createSecuritySettingsCallable() {
        return this.createSecuritySettingsCallable;
    }

    @Override
    public UnaryCallable<GetSecuritySettingsRequest, SecuritySettings> getSecuritySettingsCallable() {
        return this.getSecuritySettingsCallable;
    }

    @Override
    public UnaryCallable<UpdateSecuritySettingsRequest, SecuritySettings> updateSecuritySettingsCallable() {
        return this.updateSecuritySettingsCallable;
    }

    @Override
    public UnaryCallable<ListSecuritySettingsRequest, ListSecuritySettingsResponse> listSecuritySettingsCallable() {
        return this.listSecuritySettingsCallable;
    }

    @Override
    public UnaryCallable<ListSecuritySettingsRequest, SecuritySettingsServiceClient.ListSecuritySettingsPagedResponse> listSecuritySettingsPagedCallable() {
        return this.listSecuritySettingsPagedCallable;
    }

    @Override
    public UnaryCallable<DeleteSecuritySettingsRequest, Empty> deleteSecuritySettingsCallable() {
        return this.deleteSecuritySettingsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, SecuritySettingsServiceClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

