/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.cx.v3beta1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.cx.v3beta1.CreatePageRequest;
import com.google.cloud.dialogflow.cx.v3beta1.DeletePageRequest;
import com.google.cloud.dialogflow.cx.v3beta1.FlowName;
import com.google.cloud.dialogflow.cx.v3beta1.GetPageRequest;
import com.google.cloud.dialogflow.cx.v3beta1.ListPagesRequest;
import com.google.cloud.dialogflow.cx.v3beta1.ListPagesResponse;
import com.google.cloud.dialogflow.cx.v3beta1.Page;
import com.google.cloud.dialogflow.cx.v3beta1.PageName;
import com.google.cloud.dialogflow.cx.v3beta1.PagesSettings;
import com.google.cloud.dialogflow.cx.v3beta1.UpdatePageRequest;
import com.google.cloud.dialogflow.cx.v3beta1.stub.PagesStub;
import com.google.cloud.dialogflow.cx.v3beta1.stub.PagesStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class PagesClient
implements BackgroundResource {
    private final PagesSettings settings;
    private final PagesStub stub;

    public static final PagesClient create() throws IOException {
        return PagesClient.create(PagesSettings.newBuilder().build());
    }

    public static final PagesClient create(PagesSettings settings) throws IOException {
        return new PagesClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final PagesClient create(PagesStub stub) {
        return new PagesClient(stub);
    }

    protected PagesClient(PagesSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((PagesStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected PagesClient(PagesStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final PagesSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public PagesStub getStub() {
        return this.stub;
    }

    public final ListPagesPagedResponse listPages(FlowName parent) {
        ListPagesRequest request = ListPagesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listPages(request);
    }

    public final ListPagesPagedResponse listPages(String parent) {
        ListPagesRequest request = ListPagesRequest.newBuilder().setParent(parent).build();
        return this.listPages(request);
    }

    public final ListPagesPagedResponse listPages(ListPagesRequest request) {
        return (ListPagesPagedResponse)((Object)this.listPagesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListPagesRequest, ListPagesPagedResponse> listPagesPagedCallable() {
        return this.stub.listPagesPagedCallable();
    }

    public final UnaryCallable<ListPagesRequest, ListPagesResponse> listPagesCallable() {
        return this.stub.listPagesCallable();
    }

    public final Page getPage(PageName name) {
        GetPageRequest request = GetPageRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getPage(request);
    }

    public final Page getPage(String name) {
        GetPageRequest request = GetPageRequest.newBuilder().setName(name).build();
        return this.getPage(request);
    }

    public final Page getPage(GetPageRequest request) {
        return (Page)this.getPageCallable().call((Object)request);
    }

    public final UnaryCallable<GetPageRequest, Page> getPageCallable() {
        return this.stub.getPageCallable();
    }

    public final Page createPage(FlowName parent, Page page) {
        CreatePageRequest request = CreatePageRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setPage(page).build();
        return this.createPage(request);
    }

    public final Page createPage(String parent, Page page) {
        CreatePageRequest request = CreatePageRequest.newBuilder().setParent(parent).setPage(page).build();
        return this.createPage(request);
    }

    public final Page createPage(CreatePageRequest request) {
        return (Page)this.createPageCallable().call((Object)request);
    }

    public final UnaryCallable<CreatePageRequest, Page> createPageCallable() {
        return this.stub.createPageCallable();
    }

    public final Page updatePage(Page page, FieldMask updateMask) {
        UpdatePageRequest request = UpdatePageRequest.newBuilder().setPage(page).setUpdateMask(updateMask).build();
        return this.updatePage(request);
    }

    public final Page updatePage(UpdatePageRequest request) {
        return (Page)this.updatePageCallable().call((Object)request);
    }

    public final UnaryCallable<UpdatePageRequest, Page> updatePageCallable() {
        return this.stub.updatePageCallable();
    }

    public final void deletePage(PageName name) {
        DeletePageRequest request = DeletePageRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deletePage(request);
    }

    public final void deletePage(String name) {
        DeletePageRequest request = DeletePageRequest.newBuilder().setName(name).build();
        this.deletePage(request);
    }

    public final void deletePage(DeletePageRequest request) {
        this.deletePageCallable().call((Object)request);
    }

    public final UnaryCallable<DeletePageRequest, Empty> deletePageCallable() {
        return this.stub.deletePageCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListPagesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListPagesRequest, ListPagesResponse, Page, ListPagesPage, ListPagesFixedSizeCollection> {
        private ListPagesFixedSizeCollection(List<ListPagesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListPagesFixedSizeCollection createEmptyCollection() {
            return new ListPagesFixedSizeCollection(null, 0);
        }

        protected ListPagesFixedSizeCollection createCollection(List<ListPagesPage> pages, int collectionSize) {
            return new ListPagesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPagesPage
    extends AbstractPage<ListPagesRequest, ListPagesResponse, Page, ListPagesPage> {
        private ListPagesPage(PageContext<ListPagesRequest, ListPagesResponse, Page> context, ListPagesResponse response) {
            super(context, (Object)response);
        }

        private static ListPagesPage createEmptyPage() {
            return new ListPagesPage(null, null);
        }

        protected ListPagesPage createPage(PageContext<ListPagesRequest, ListPagesResponse, Page> context, ListPagesResponse response) {
            return new ListPagesPage(context, response);
        }

        public ApiFuture<ListPagesPage> createPageAsync(PageContext<ListPagesRequest, ListPagesResponse, Page> context, ApiFuture<ListPagesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagesPagedResponse
    extends AbstractPagedListResponse<ListPagesRequest, ListPagesResponse, Page, ListPagesPage, ListPagesFixedSizeCollection> {
        public static ApiFuture<ListPagesPagedResponse> createAsync(PageContext<ListPagesRequest, ListPagesResponse, Page> context, ApiFuture<ListPagesResponse> futureResponse) {
            ApiFuture<ListPagesPage> futurePage = ListPagesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPagesPagedResponse((ListPagesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPagesPagedResponse(ListPagesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListPagesFixedSizeCollection.createEmptyCollection());
        }
    }
}

