/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.developerconnect.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.developerconnect.v1.CreateInsightsConfigRequest;
import com.google.cloud.developerconnect.v1.DeleteInsightsConfigRequest;
import com.google.cloud.developerconnect.v1.GetInsightsConfigRequest;
import com.google.cloud.developerconnect.v1.InsightsConfig;
import com.google.cloud.developerconnect.v1.InsightsConfigName;
import com.google.cloud.developerconnect.v1.InsightsConfigServiceSettings;
import com.google.cloud.developerconnect.v1.ListInsightsConfigsRequest;
import com.google.cloud.developerconnect.v1.ListInsightsConfigsResponse;
import com.google.cloud.developerconnect.v1.LocationName;
import com.google.cloud.developerconnect.v1.OperationMetadata;
import com.google.cloud.developerconnect.v1.UpdateInsightsConfigRequest;
import com.google.cloud.developerconnect.v1.stub.InsightsConfigServiceStub;
import com.google.cloud.developerconnect.v1.stub.InsightsConfigServiceStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class InsightsConfigServiceClient
implements BackgroundResource {
    private final InsightsConfigServiceSettings settings;
    private final InsightsConfigServiceStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final InsightsConfigServiceClient create() throws IOException {
        return InsightsConfigServiceClient.create(InsightsConfigServiceSettings.newBuilder().build());
    }

    public static final InsightsConfigServiceClient create(InsightsConfigServiceSettings settings) throws IOException {
        return new InsightsConfigServiceClient(settings);
    }

    public static final InsightsConfigServiceClient create(InsightsConfigServiceStub stub) {
        return new InsightsConfigServiceClient(stub);
    }

    protected InsightsConfigServiceClient(InsightsConfigServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((InsightsConfigServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected InsightsConfigServiceClient(InsightsConfigServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final InsightsConfigServiceSettings getSettings() {
        return this.settings;
    }

    public InsightsConfigServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final ListInsightsConfigsPagedResponse listInsightsConfigs(LocationName parent) {
        ListInsightsConfigsRequest request = ListInsightsConfigsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listInsightsConfigs(request);
    }

    public final ListInsightsConfigsPagedResponse listInsightsConfigs(String parent) {
        ListInsightsConfigsRequest request = ListInsightsConfigsRequest.newBuilder().setParent(parent).build();
        return this.listInsightsConfigs(request);
    }

    public final ListInsightsConfigsPagedResponse listInsightsConfigs(ListInsightsConfigsRequest request) {
        return (ListInsightsConfigsPagedResponse)((Object)this.listInsightsConfigsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListInsightsConfigsRequest, ListInsightsConfigsPagedResponse> listInsightsConfigsPagedCallable() {
        return this.stub.listInsightsConfigsPagedCallable();
    }

    public final UnaryCallable<ListInsightsConfigsRequest, ListInsightsConfigsResponse> listInsightsConfigsCallable() {
        return this.stub.listInsightsConfigsCallable();
    }

    public final OperationFuture<InsightsConfig, OperationMetadata> createInsightsConfigAsync(LocationName parent, InsightsConfig insightsConfig, String insightsConfigId) {
        CreateInsightsConfigRequest request = CreateInsightsConfigRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setInsightsConfig(insightsConfig).setInsightsConfigId(insightsConfigId).build();
        return this.createInsightsConfigAsync(request);
    }

    public final OperationFuture<InsightsConfig, OperationMetadata> createInsightsConfigAsync(String parent, InsightsConfig insightsConfig, String insightsConfigId) {
        CreateInsightsConfigRequest request = CreateInsightsConfigRequest.newBuilder().setParent(parent).setInsightsConfig(insightsConfig).setInsightsConfigId(insightsConfigId).build();
        return this.createInsightsConfigAsync(request);
    }

    public final OperationFuture<InsightsConfig, OperationMetadata> createInsightsConfigAsync(CreateInsightsConfigRequest request) {
        return this.createInsightsConfigOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateInsightsConfigRequest, InsightsConfig, OperationMetadata> createInsightsConfigOperationCallable() {
        return this.stub.createInsightsConfigOperationCallable();
    }

    public final UnaryCallable<CreateInsightsConfigRequest, Operation> createInsightsConfigCallable() {
        return this.stub.createInsightsConfigCallable();
    }

    public final InsightsConfig getInsightsConfig(InsightsConfigName name) {
        GetInsightsConfigRequest request = GetInsightsConfigRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getInsightsConfig(request);
    }

    public final InsightsConfig getInsightsConfig(String name) {
        GetInsightsConfigRequest request = GetInsightsConfigRequest.newBuilder().setName(name).build();
        return this.getInsightsConfig(request);
    }

    public final InsightsConfig getInsightsConfig(GetInsightsConfigRequest request) {
        return (InsightsConfig)this.getInsightsConfigCallable().call((Object)request);
    }

    public final UnaryCallable<GetInsightsConfigRequest, InsightsConfig> getInsightsConfigCallable() {
        return this.stub.getInsightsConfigCallable();
    }

    public final OperationFuture<InsightsConfig, OperationMetadata> updateInsightsConfigAsync(UpdateInsightsConfigRequest request) {
        return this.updateInsightsConfigOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateInsightsConfigRequest, InsightsConfig, OperationMetadata> updateInsightsConfigOperationCallable() {
        return this.stub.updateInsightsConfigOperationCallable();
    }

    public final UnaryCallable<UpdateInsightsConfigRequest, Operation> updateInsightsConfigCallable() {
        return this.stub.updateInsightsConfigCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteInsightsConfigAsync(InsightsConfigName name) {
        DeleteInsightsConfigRequest request = DeleteInsightsConfigRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteInsightsConfigAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteInsightsConfigAsync(String name) {
        DeleteInsightsConfigRequest request = DeleteInsightsConfigRequest.newBuilder().setName(name).build();
        return this.deleteInsightsConfigAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteInsightsConfigAsync(DeleteInsightsConfigRequest request) {
        return this.deleteInsightsConfigOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteInsightsConfigRequest, Empty, OperationMetadata> deleteInsightsConfigOperationCallable() {
        return this.stub.deleteInsightsConfigOperationCallable();
    }

    public final UnaryCallable<DeleteInsightsConfigRequest, Operation> deleteInsightsConfigCallable() {
        return this.stub.deleteInsightsConfigCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListInsightsConfigsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListInsightsConfigsRequest, ListInsightsConfigsResponse, InsightsConfig, ListInsightsConfigsPage, ListInsightsConfigsFixedSizeCollection> {
        private ListInsightsConfigsFixedSizeCollection(List<ListInsightsConfigsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListInsightsConfigsFixedSizeCollection createEmptyCollection() {
            return new ListInsightsConfigsFixedSizeCollection(null, 0);
        }

        protected ListInsightsConfigsFixedSizeCollection createCollection(List<ListInsightsConfigsPage> pages, int collectionSize) {
            return new ListInsightsConfigsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListInsightsConfigsPage
    extends AbstractPage<ListInsightsConfigsRequest, ListInsightsConfigsResponse, InsightsConfig, ListInsightsConfigsPage> {
        private ListInsightsConfigsPage(PageContext<ListInsightsConfigsRequest, ListInsightsConfigsResponse, InsightsConfig> context, ListInsightsConfigsResponse response) {
            super(context, (Object)response);
        }

        private static ListInsightsConfigsPage createEmptyPage() {
            return new ListInsightsConfigsPage(null, null);
        }

        protected ListInsightsConfigsPage createPage(PageContext<ListInsightsConfigsRequest, ListInsightsConfigsResponse, InsightsConfig> context, ListInsightsConfigsResponse response) {
            return new ListInsightsConfigsPage(context, response);
        }

        public ApiFuture<ListInsightsConfigsPage> createPageAsync(PageContext<ListInsightsConfigsRequest, ListInsightsConfigsResponse, InsightsConfig> context, ApiFuture<ListInsightsConfigsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListInsightsConfigsPagedResponse
    extends AbstractPagedListResponse<ListInsightsConfigsRequest, ListInsightsConfigsResponse, InsightsConfig, ListInsightsConfigsPage, ListInsightsConfigsFixedSizeCollection> {
        public static ApiFuture<ListInsightsConfigsPagedResponse> createAsync(PageContext<ListInsightsConfigsRequest, ListInsightsConfigsResponse, InsightsConfig> context, ApiFuture<ListInsightsConfigsResponse> futureResponse) {
            ApiFuture<ListInsightsConfigsPage> futurePage = ListInsightsConfigsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListInsightsConfigsPagedResponse((ListInsightsConfigsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListInsightsConfigsPagedResponse(ListInsightsConfigsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListInsightsConfigsFixedSizeCollection.createEmptyCollection());
        }
    }
}

