/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataproc.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dataproc.v1.Cluster;
import com.google.cloud.dataproc.v1.ClusterControllerClient;
import com.google.cloud.dataproc.v1.ClusterOperationMetadata;
import com.google.cloud.dataproc.v1.CreateClusterRequest;
import com.google.cloud.dataproc.v1.DeleteClusterRequest;
import com.google.cloud.dataproc.v1.DiagnoseClusterRequest;
import com.google.cloud.dataproc.v1.DiagnoseClusterResults;
import com.google.cloud.dataproc.v1.GetClusterRequest;
import com.google.cloud.dataproc.v1.ListClustersRequest;
import com.google.cloud.dataproc.v1.ListClustersResponse;
import com.google.cloud.dataproc.v1.UpdateClusterRequest;
import com.google.cloud.dataproc.v1.stub.ClusterControllerStub;
import com.google.cloud.dataproc.v1.stub.GrpcClusterControllerStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class ClusterControllerStubSettings
extends StubSettings<ClusterControllerStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateClusterRequest, Operation> createClusterSettings;
    private final OperationCallSettings<CreateClusterRequest, Cluster, ClusterOperationMetadata> createClusterOperationSettings;
    private final UnaryCallSettings<UpdateClusterRequest, Operation> updateClusterSettings;
    private final OperationCallSettings<UpdateClusterRequest, Cluster, ClusterOperationMetadata> updateClusterOperationSettings;
    private final UnaryCallSettings<DeleteClusterRequest, Operation> deleteClusterSettings;
    private final OperationCallSettings<DeleteClusterRequest, Empty, ClusterOperationMetadata> deleteClusterOperationSettings;
    private final UnaryCallSettings<GetClusterRequest, Cluster> getClusterSettings;
    private final PagedCallSettings<ListClustersRequest, ListClustersResponse, ClusterControllerClient.ListClustersPagedResponse> listClustersSettings;
    private final UnaryCallSettings<DiagnoseClusterRequest, Operation> diagnoseClusterSettings;
    private final OperationCallSettings<DiagnoseClusterRequest, Empty, DiagnoseClusterResults> diagnoseClusterOperationSettings;
    private static final PagedListDescriptor<ListClustersRequest, ListClustersResponse, Cluster> LIST_CLUSTERS_PAGE_STR_DESC = new PagedListDescriptor<ListClustersRequest, ListClustersResponse, Cluster>(){

        public String emptyToken() {
            return "";
        }

        public ListClustersRequest injectToken(ListClustersRequest payload, String token) {
            return ListClustersRequest.newBuilder((ListClustersRequest)payload).setPageToken(token).build();
        }

        public ListClustersRequest injectPageSize(ListClustersRequest payload, int pageSize) {
            return ListClustersRequest.newBuilder((ListClustersRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListClustersRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListClustersResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Cluster> extractResources(ListClustersResponse payload) {
            return payload.getClustersList() != null ? payload.getClustersList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<ListClustersRequest, ListClustersResponse, ClusterControllerClient.ListClustersPagedResponse> LIST_CLUSTERS_PAGE_STR_FACT = new PagedListResponseFactory<ListClustersRequest, ListClustersResponse, ClusterControllerClient.ListClustersPagedResponse>(){

        public ApiFuture<ClusterControllerClient.ListClustersPagedResponse> getFuturePagedResponse(UnaryCallable<ListClustersRequest, ListClustersResponse> callable, ListClustersRequest request, ApiCallContext context, ApiFuture<ListClustersResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_CLUSTERS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ClusterControllerClient.ListClustersPagedResponse.createAsync((PageContext<ListClustersRequest, ListClustersResponse, Cluster>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateClusterRequest, Operation> createClusterSettings() {
        return this.createClusterSettings;
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public OperationCallSettings<CreateClusterRequest, Cluster, ClusterOperationMetadata> createClusterOperationSettings() {
        return this.createClusterOperationSettings;
    }

    public UnaryCallSettings<UpdateClusterRequest, Operation> updateClusterSettings() {
        return this.updateClusterSettings;
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public OperationCallSettings<UpdateClusterRequest, Cluster, ClusterOperationMetadata> updateClusterOperationSettings() {
        return this.updateClusterOperationSettings;
    }

    public UnaryCallSettings<DeleteClusterRequest, Operation> deleteClusterSettings() {
        return this.deleteClusterSettings;
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public OperationCallSettings<DeleteClusterRequest, Empty, ClusterOperationMetadata> deleteClusterOperationSettings() {
        return this.deleteClusterOperationSettings;
    }

    public UnaryCallSettings<GetClusterRequest, Cluster> getClusterSettings() {
        return this.getClusterSettings;
    }

    public PagedCallSettings<ListClustersRequest, ListClustersResponse, ClusterControllerClient.ListClustersPagedResponse> listClustersSettings() {
        return this.listClustersSettings;
    }

    public UnaryCallSettings<DiagnoseClusterRequest, Operation> diagnoseClusterSettings() {
        return this.diagnoseClusterSettings;
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public OperationCallSettings<DiagnoseClusterRequest, Empty, DiagnoseClusterResults> diagnoseClusterOperationSettings() {
        return this.diagnoseClusterOperationSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public ClusterControllerStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcClusterControllerStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "dataproc.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ClusterControllerStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ClusterControllerStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ClusterControllerStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createClusterSettings = settingsBuilder.createClusterSettings().build();
        this.createClusterOperationSettings = settingsBuilder.createClusterOperationSettings().build();
        this.updateClusterSettings = settingsBuilder.updateClusterSettings().build();
        this.updateClusterOperationSettings = settingsBuilder.updateClusterOperationSettings().build();
        this.deleteClusterSettings = settingsBuilder.deleteClusterSettings().build();
        this.deleteClusterOperationSettings = settingsBuilder.deleteClusterOperationSettings().build();
        this.getClusterSettings = settingsBuilder.getClusterSettings().build();
        this.listClustersSettings = settingsBuilder.listClustersSettings().build();
        this.diagnoseClusterSettings = settingsBuilder.diagnoseClusterSettings().build();
        this.diagnoseClusterOperationSettings = settingsBuilder.diagnoseClusterOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ClusterControllerStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateClusterRequest, Operation> createClusterSettings;
        private final OperationCallSettings.Builder<CreateClusterRequest, Cluster, ClusterOperationMetadata> createClusterOperationSettings;
        private final UnaryCallSettings.Builder<UpdateClusterRequest, Operation> updateClusterSettings;
        private final OperationCallSettings.Builder<UpdateClusterRequest, Cluster, ClusterOperationMetadata> updateClusterOperationSettings;
        private final UnaryCallSettings.Builder<DeleteClusterRequest, Operation> deleteClusterSettings;
        private final OperationCallSettings.Builder<DeleteClusterRequest, Empty, ClusterOperationMetadata> deleteClusterOperationSettings;
        private final UnaryCallSettings.Builder<GetClusterRequest, Cluster> getClusterSettings;
        private final PagedCallSettings.Builder<ListClustersRequest, ListClustersResponse, ClusterControllerClient.ListClustersPagedResponse> listClustersSettings;
        private final UnaryCallSettings.Builder<DiagnoseClusterRequest, Operation> diagnoseClusterSettings;
        private final OperationCallSettings.Builder<DiagnoseClusterRequest, Empty, DiagnoseClusterResults> diagnoseClusterOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createClusterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createClusterOperationSettings = OperationCallSettings.newBuilder();
            this.updateClusterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateClusterOperationSettings = OperationCallSettings.newBuilder();
            this.deleteClusterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteClusterOperationSettings = OperationCallSettings.newBuilder();
            this.getClusterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listClustersSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_CLUSTERS_PAGE_STR_FACT);
            this.diagnoseClusterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.diagnoseClusterOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createClusterSettings, this.updateClusterSettings, this.deleteClusterSettings, this.getClusterSettings, this.listClustersSettings, this.diagnoseClusterSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ClusterControllerStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ClusterControllerStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ClusterControllerStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(ClusterControllerStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createClusterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.updateClusterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.deleteClusterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getClusterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listClustersSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.diagnoseClusterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.createClusterOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Cluster.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(ClusterOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(2.0).setMaxRetryDelay(Duration.ofMillis((long)10000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)900000L)).build()));
            builder.updateClusterOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Cluster.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(ClusterOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(2.0).setMaxRetryDelay(Duration.ofMillis((long)10000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)900000L)).build()));
            builder.deleteClusterOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(ClusterOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(2.0).setMaxRetryDelay(Duration.ofMillis((long)10000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)900000L)).build()));
            builder.diagnoseClusterOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(DiagnoseClusterResults.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(2.0).setMaxRetryDelay(Duration.ofMillis((long)10000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)30000L)).build()));
            return builder;
        }

        protected Builder(ClusterControllerStubSettings settings) {
            super((StubSettings)settings);
            this.createClusterSettings = settings.createClusterSettings.toBuilder();
            this.createClusterOperationSettings = settings.createClusterOperationSettings.toBuilder();
            this.updateClusterSettings = settings.updateClusterSettings.toBuilder();
            this.updateClusterOperationSettings = settings.updateClusterOperationSettings.toBuilder();
            this.deleteClusterSettings = settings.deleteClusterSettings.toBuilder();
            this.deleteClusterOperationSettings = settings.deleteClusterOperationSettings.toBuilder();
            this.getClusterSettings = settings.getClusterSettings.toBuilder();
            this.listClustersSettings = settings.listClustersSettings.toBuilder();
            this.diagnoseClusterSettings = settings.diagnoseClusterSettings.toBuilder();
            this.diagnoseClusterOperationSettings = settings.diagnoseClusterOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createClusterSettings, this.updateClusterSettings, this.deleteClusterSettings, this.getClusterSettings, this.listClustersSettings, this.diagnoseClusterSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateClusterRequest, Operation> createClusterSettings() {
            return this.createClusterSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateClusterRequest, Cluster, ClusterOperationMetadata> createClusterOperationSettings() {
            return this.createClusterOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateClusterRequest, Operation> updateClusterSettings() {
            return this.updateClusterSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpdateClusterRequest, Cluster, ClusterOperationMetadata> updateClusterOperationSettings() {
            return this.updateClusterOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteClusterRequest, Operation> deleteClusterSettings() {
            return this.deleteClusterSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteClusterRequest, Empty, ClusterOperationMetadata> deleteClusterOperationSettings() {
            return this.deleteClusterOperationSettings;
        }

        public UnaryCallSettings.Builder<GetClusterRequest, Cluster> getClusterSettings() {
            return this.getClusterSettings;
        }

        public PagedCallSettings.Builder<ListClustersRequest, ListClustersResponse, ClusterControllerClient.ListClustersPagedResponse> listClustersSettings() {
            return this.listClustersSettings;
        }

        public UnaryCallSettings.Builder<DiagnoseClusterRequest, Operation> diagnoseClusterSettings() {
            return this.diagnoseClusterSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DiagnoseClusterRequest, Empty, DiagnoseClusterResults> diagnoseClusterOperationSettings() {
            return this.diagnoseClusterOperationSettings;
        }

        public ClusterControllerStubSettings build() throws IOException {
            return new ClusterControllerStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.INTERNAL, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)10000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)10000L)).setTotalTimeout(Duration.ofMillis((long)300000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

