/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.metastore.v1beta.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.metastore.v1beta.CreateFederationRequest;
import com.google.cloud.metastore.v1beta.DataprocMetastoreFederationClient;
import com.google.cloud.metastore.v1beta.DeleteFederationRequest;
import com.google.cloud.metastore.v1beta.Federation;
import com.google.cloud.metastore.v1beta.GetFederationRequest;
import com.google.cloud.metastore.v1beta.ListFederationsRequest;
import com.google.cloud.metastore.v1beta.ListFederationsResponse;
import com.google.cloud.metastore.v1beta.OperationMetadata;
import com.google.cloud.metastore.v1beta.UpdateFederationRequest;
import com.google.cloud.metastore.v1beta.stub.DataprocMetastoreFederationStub;
import com.google.cloud.metastore.v1beta.stub.DataprocMetastoreFederationStubSettings;
import com.google.cloud.metastore.v1beta.stub.GrpcDataprocMetastoreFederationCallableFactory;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcDataprocMetastoreFederationStub
extends DataprocMetastoreFederationStub {
    private static final MethodDescriptor<ListFederationsRequest, ListFederationsResponse> listFederationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.metastore.v1beta.DataprocMetastoreFederation/ListFederations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListFederationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListFederationsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetFederationRequest, Federation> getFederationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.metastore.v1beta.DataprocMetastoreFederation/GetFederation").setRequestMarshaller(ProtoUtils.marshaller((Message)GetFederationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Federation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<CreateFederationRequest, Operation> createFederationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.metastore.v1beta.DataprocMetastoreFederation/CreateFederation").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateFederationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<UpdateFederationRequest, Operation> updateFederationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.metastore.v1beta.DataprocMetastoreFederation/UpdateFederation").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateFederationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<DeleteFederationRequest, Operation> deleteFederationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.metastore.v1beta.DataprocMetastoreFederation/DeleteFederation").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteFederationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/ListLocations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListLocationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListLocationsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/GetLocation").setRequestMarshaller(ProtoUtils.marshaller((Message)GetLocationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Location.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<SetIamPolicyRequest, Policy> setIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/SetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)SetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetIamPolicyRequest, Policy> getIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/GetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)GetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/TestIamPermissions").setRequestMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final UnaryCallable<ListFederationsRequest, ListFederationsResponse> listFederationsCallable;
    private final UnaryCallable<ListFederationsRequest, DataprocMetastoreFederationClient.ListFederationsPagedResponse> listFederationsPagedCallable;
    private final UnaryCallable<GetFederationRequest, Federation> getFederationCallable;
    private final UnaryCallable<CreateFederationRequest, Operation> createFederationCallable;
    private final OperationCallable<CreateFederationRequest, Federation, OperationMetadata> createFederationOperationCallable;
    private final UnaryCallable<UpdateFederationRequest, Operation> updateFederationCallable;
    private final OperationCallable<UpdateFederationRequest, Federation, OperationMetadata> updateFederationOperationCallable;
    private final UnaryCallable<DeleteFederationRequest, Operation> deleteFederationCallable;
    private final OperationCallable<DeleteFederationRequest, Empty, OperationMetadata> deleteFederationOperationCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, DataprocMetastoreFederationClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable;
    private final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable;
    private final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcDataprocMetastoreFederationStub create(DataprocMetastoreFederationStubSettings settings) throws IOException {
        return new GrpcDataprocMetastoreFederationStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcDataprocMetastoreFederationStub create(ClientContext clientContext) throws IOException {
        return new GrpcDataprocMetastoreFederationStub(DataprocMetastoreFederationStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcDataprocMetastoreFederationStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcDataprocMetastoreFederationStub(DataprocMetastoreFederationStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcDataprocMetastoreFederationStub(DataprocMetastoreFederationStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcDataprocMetastoreFederationCallableFactory());
    }

    protected GrpcDataprocMetastoreFederationStub(DataprocMetastoreFederationStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings listFederationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listFederationsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getFederationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getFederationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings createFederationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createFederationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings updateFederationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateFederationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("federation.name", String.valueOf(request.getFederation().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteFederationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteFederationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listLocationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getLocationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings setIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(setIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        GrpcCallSettings getIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        GrpcCallSettings testIamPermissionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(testIamPermissionsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        this.listFederationsCallable = callableFactory.createUnaryCallable(listFederationsTransportSettings, settings.listFederationsSettings(), clientContext);
        this.listFederationsPagedCallable = callableFactory.createPagedCallable(listFederationsTransportSettings, settings.listFederationsSettings(), clientContext);
        this.getFederationCallable = callableFactory.createUnaryCallable(getFederationTransportSettings, settings.getFederationSettings(), clientContext);
        this.createFederationCallable = callableFactory.createUnaryCallable(createFederationTransportSettings, settings.createFederationSettings(), clientContext);
        this.createFederationOperationCallable = callableFactory.createOperationCallable(createFederationTransportSettings, settings.createFederationOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.updateFederationCallable = callableFactory.createUnaryCallable(updateFederationTransportSettings, settings.updateFederationSettings(), clientContext);
        this.updateFederationOperationCallable = callableFactory.createOperationCallable(updateFederationTransportSettings, settings.updateFederationOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.deleteFederationCallable = callableFactory.createUnaryCallable(deleteFederationTransportSettings, settings.deleteFederationSettings(), clientContext);
        this.deleteFederationOperationCallable = callableFactory.createOperationCallable(deleteFederationTransportSettings, settings.deleteFederationOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.setIamPolicyCallable = callableFactory.createUnaryCallable(setIamPolicyTransportSettings, settings.setIamPolicySettings(), clientContext);
        this.getIamPolicyCallable = callableFactory.createUnaryCallable(getIamPolicyTransportSettings, settings.getIamPolicySettings(), clientContext);
        this.testIamPermissionsCallable = callableFactory.createUnaryCallable(testIamPermissionsTransportSettings, settings.testIamPermissionsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ListFederationsRequest, ListFederationsResponse> listFederationsCallable() {
        return this.listFederationsCallable;
    }

    @Override
    public UnaryCallable<ListFederationsRequest, DataprocMetastoreFederationClient.ListFederationsPagedResponse> listFederationsPagedCallable() {
        return this.listFederationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetFederationRequest, Federation> getFederationCallable() {
        return this.getFederationCallable;
    }

    @Override
    public UnaryCallable<CreateFederationRequest, Operation> createFederationCallable() {
        return this.createFederationCallable;
    }

    @Override
    public OperationCallable<CreateFederationRequest, Federation, OperationMetadata> createFederationOperationCallable() {
        return this.createFederationOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateFederationRequest, Operation> updateFederationCallable() {
        return this.updateFederationCallable;
    }

    @Override
    public OperationCallable<UpdateFederationRequest, Federation, OperationMetadata> updateFederationOperationCallable() {
        return this.updateFederationOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteFederationRequest, Operation> deleteFederationCallable() {
        return this.deleteFederationCallable;
    }

    @Override
    public OperationCallable<DeleteFederationRequest, Empty, OperationMetadata> deleteFederationOperationCallable() {
        return this.deleteFederationOperationCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, DataprocMetastoreFederationClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.setIamPolicyCallable;
    }

    @Override
    public UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.getIamPolicyCallable;
    }

    @Override
    public UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.testIamPermissionsCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

