/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.metastore.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.httpjson.longrunning.stub.HttpJsonOperationsStub;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.metastore.v1.Backup;
import com.google.cloud.metastore.v1.CreateBackupRequest;
import com.google.cloud.metastore.v1.CreateMetadataImportRequest;
import com.google.cloud.metastore.v1.CreateServiceRequest;
import com.google.cloud.metastore.v1.DataprocMetastoreClient;
import com.google.cloud.metastore.v1.DeleteBackupRequest;
import com.google.cloud.metastore.v1.DeleteServiceRequest;
import com.google.cloud.metastore.v1.ExportMetadataRequest;
import com.google.cloud.metastore.v1.GetBackupRequest;
import com.google.cloud.metastore.v1.GetMetadataImportRequest;
import com.google.cloud.metastore.v1.GetServiceRequest;
import com.google.cloud.metastore.v1.ListBackupsRequest;
import com.google.cloud.metastore.v1.ListBackupsResponse;
import com.google.cloud.metastore.v1.ListMetadataImportsRequest;
import com.google.cloud.metastore.v1.ListMetadataImportsResponse;
import com.google.cloud.metastore.v1.ListServicesRequest;
import com.google.cloud.metastore.v1.ListServicesResponse;
import com.google.cloud.metastore.v1.MetadataExport;
import com.google.cloud.metastore.v1.MetadataImport;
import com.google.cloud.metastore.v1.OperationMetadata;
import com.google.cloud.metastore.v1.Restore;
import com.google.cloud.metastore.v1.RestoreServiceRequest;
import com.google.cloud.metastore.v1.Service;
import com.google.cloud.metastore.v1.UpdateMetadataImportRequest;
import com.google.cloud.metastore.v1.UpdateServiceRequest;
import com.google.cloud.metastore.v1.stub.DataprocMetastoreStub;
import com.google.cloud.metastore.v1.stub.DataprocMetastoreStubSettings;
import com.google.cloud.metastore.v1.stub.HttpJsonDataprocMetastoreCallableFactory;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonDataprocMetastoreStub
extends DataprocMetastoreStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(Empty.getDescriptor()).add(MetadataImport.getDescriptor()).add(OperationMetadata.getDescriptor()).add(Service.getDescriptor()).add(MetadataExport.getDescriptor()).add(Backup.getDescriptor()).add(Restore.getDescriptor()).build();
    private static final ApiMethodDescriptor<ListServicesRequest, ListServicesResponse> listServicesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.metastore.v1.DataprocMetastore/ListServices").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/services", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListServicesResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetServiceRequest, Service> getServiceMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.metastore.v1.DataprocMetastore/GetService").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/services/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Service.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateServiceRequest, Operation> createServiceMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.metastore.v1.DataprocMetastore/CreateService").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/services", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        serializer.putQueryParam(fields, "serviceId", (Object)request.getServiceId());
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("service", (Message)request.getService(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<UpdateServiceRequest, Operation> updateServiceMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.metastore.v1.DataprocMetastore/UpdateService").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{service.name=projects/*/locations/*/services/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "service.name", (Object)request.getService().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("service", (Message)request.getService(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<DeleteServiceRequest, Operation> deleteServiceMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.metastore.v1.DataprocMetastore/DeleteService").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/services/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<ListMetadataImportsRequest, ListMetadataImportsResponse> listMetadataImportsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.metastore.v1.DataprocMetastore/ListMetadataImports").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*/services/*}/metadataImports", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListMetadataImportsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetMetadataImportRequest, MetadataImport> getMetadataImportMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.metastore.v1.DataprocMetastore/GetMetadataImport").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/services/*/metadataImports/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)MetadataImport.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateMetadataImportRequest, Operation> createMetadataImportMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.metastore.v1.DataprocMetastore/CreateMetadataImport").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*/services/*}/metadataImports", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "metadataImportId", (Object)request.getMetadataImportId());
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("metadataImport", (Message)request.getMetadataImport(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<UpdateMetadataImportRequest, Operation> updateMetadataImportMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.metastore.v1.DataprocMetastore/UpdateMetadataImport").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{metadataImport.name=projects/*/locations/*/services/*/metadataImports/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "metadataImport.name", (Object)request.getMetadataImport().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("metadataImport", (Message)request.getMetadataImport(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<ExportMetadataRequest, Operation> exportMetadataMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.metastore.v1.DataprocMetastore/ExportMetadata").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{service=projects/*/locations/*/services/*}:exportMetadata", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "service", (Object)request.getService());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearService().build(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<RestoreServiceRequest, Operation> restoreServiceMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.metastore.v1.DataprocMetastore/RestoreService").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{service=projects/*/locations/*/services/*}:restore", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "service", (Object)request.getService());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearService().build(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<ListBackupsRequest, ListBackupsResponse> listBackupsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.metastore.v1.DataprocMetastore/ListBackups").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*/services/*}/backups", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListBackupsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetBackupRequest, Backup> getBackupMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.metastore.v1.DataprocMetastore/GetBackup").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/services/*/backups/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Backup.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateBackupRequest, Operation> createBackupMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.metastore.v1.DataprocMetastore/CreateBackup").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*/services/*}/backups", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "backupId", (Object)request.getBackupId());
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("backup", (Message)request.getBackup(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<DeleteBackupRequest, Operation> deleteBackupMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.metastore.v1.DataprocMetastore/DeleteBackup").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/services/*/backups/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private final UnaryCallable<ListServicesRequest, ListServicesResponse> listServicesCallable;
    private final UnaryCallable<ListServicesRequest, DataprocMetastoreClient.ListServicesPagedResponse> listServicesPagedCallable;
    private final UnaryCallable<GetServiceRequest, Service> getServiceCallable;
    private final UnaryCallable<CreateServiceRequest, Operation> createServiceCallable;
    private final OperationCallable<CreateServiceRequest, Service, OperationMetadata> createServiceOperationCallable;
    private final UnaryCallable<UpdateServiceRequest, Operation> updateServiceCallable;
    private final OperationCallable<UpdateServiceRequest, Service, OperationMetadata> updateServiceOperationCallable;
    private final UnaryCallable<DeleteServiceRequest, Operation> deleteServiceCallable;
    private final OperationCallable<DeleteServiceRequest, Empty, OperationMetadata> deleteServiceOperationCallable;
    private final UnaryCallable<ListMetadataImportsRequest, ListMetadataImportsResponse> listMetadataImportsCallable;
    private final UnaryCallable<ListMetadataImportsRequest, DataprocMetastoreClient.ListMetadataImportsPagedResponse> listMetadataImportsPagedCallable;
    private final UnaryCallable<GetMetadataImportRequest, MetadataImport> getMetadataImportCallable;
    private final UnaryCallable<CreateMetadataImportRequest, Operation> createMetadataImportCallable;
    private final OperationCallable<CreateMetadataImportRequest, MetadataImport, OperationMetadata> createMetadataImportOperationCallable;
    private final UnaryCallable<UpdateMetadataImportRequest, Operation> updateMetadataImportCallable;
    private final OperationCallable<UpdateMetadataImportRequest, MetadataImport, OperationMetadata> updateMetadataImportOperationCallable;
    private final UnaryCallable<ExportMetadataRequest, Operation> exportMetadataCallable;
    private final OperationCallable<ExportMetadataRequest, MetadataExport, OperationMetadata> exportMetadataOperationCallable;
    private final UnaryCallable<RestoreServiceRequest, Operation> restoreServiceCallable;
    private final OperationCallable<RestoreServiceRequest, Restore, OperationMetadata> restoreServiceOperationCallable;
    private final UnaryCallable<ListBackupsRequest, ListBackupsResponse> listBackupsCallable;
    private final UnaryCallable<ListBackupsRequest, DataprocMetastoreClient.ListBackupsPagedResponse> listBackupsPagedCallable;
    private final UnaryCallable<GetBackupRequest, Backup> getBackupCallable;
    private final UnaryCallable<CreateBackupRequest, Operation> createBackupCallable;
    private final OperationCallable<CreateBackupRequest, Backup, OperationMetadata> createBackupOperationCallable;
    private final UnaryCallable<DeleteBackupRequest, Operation> deleteBackupCallable;
    private final OperationCallable<DeleteBackupRequest, Empty, OperationMetadata> deleteBackupOperationCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonDataprocMetastoreStub create(DataprocMetastoreStubSettings settings) throws IOException {
        return new HttpJsonDataprocMetastoreStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonDataprocMetastoreStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonDataprocMetastoreStub(DataprocMetastoreStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonDataprocMetastoreStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonDataprocMetastoreStub(DataprocMetastoreStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonDataprocMetastoreStub(DataprocMetastoreStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonDataprocMetastoreCallableFactory());
    }

    protected HttpJsonDataprocMetastoreStub(DataprocMetastoreStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonOperationsStub.create((ClientContext)clientContext, (HttpJsonStubCallableFactory)callableFactory, (TypeRegistry)typeRegistry);
        HttpJsonCallSettings listServicesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listServicesMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getServiceTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getServiceMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings createServiceTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createServiceMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings updateServiceTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateServiceMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings deleteServiceTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteServiceMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings listMetadataImportsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listMetadataImportsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getMetadataImportTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getMetadataImportMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings createMetadataImportTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createMetadataImportMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings updateMetadataImportTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateMetadataImportMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings exportMetadataTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(exportMetadataMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings restoreServiceTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(restoreServiceMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings listBackupsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listBackupsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getBackupTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getBackupMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings createBackupTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createBackupMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings deleteBackupTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteBackupMethodDescriptor).setTypeRegistry(typeRegistry).build();
        this.listServicesCallable = callableFactory.createUnaryCallable(listServicesTransportSettings, settings.listServicesSettings(), clientContext);
        this.listServicesPagedCallable = callableFactory.createPagedCallable(listServicesTransportSettings, settings.listServicesSettings(), clientContext);
        this.getServiceCallable = callableFactory.createUnaryCallable(getServiceTransportSettings, settings.getServiceSettings(), clientContext);
        this.createServiceCallable = callableFactory.createUnaryCallable(createServiceTransportSettings, settings.createServiceSettings(), clientContext);
        this.createServiceOperationCallable = callableFactory.createOperationCallable(createServiceTransportSettings, settings.createServiceOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.updateServiceCallable = callableFactory.createUnaryCallable(updateServiceTransportSettings, settings.updateServiceSettings(), clientContext);
        this.updateServiceOperationCallable = callableFactory.createOperationCallable(updateServiceTransportSettings, settings.updateServiceOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.deleteServiceCallable = callableFactory.createUnaryCallable(deleteServiceTransportSettings, settings.deleteServiceSettings(), clientContext);
        this.deleteServiceOperationCallable = callableFactory.createOperationCallable(deleteServiceTransportSettings, settings.deleteServiceOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.listMetadataImportsCallable = callableFactory.createUnaryCallable(listMetadataImportsTransportSettings, settings.listMetadataImportsSettings(), clientContext);
        this.listMetadataImportsPagedCallable = callableFactory.createPagedCallable(listMetadataImportsTransportSettings, settings.listMetadataImportsSettings(), clientContext);
        this.getMetadataImportCallable = callableFactory.createUnaryCallable(getMetadataImportTransportSettings, settings.getMetadataImportSettings(), clientContext);
        this.createMetadataImportCallable = callableFactory.createUnaryCallable(createMetadataImportTransportSettings, settings.createMetadataImportSettings(), clientContext);
        this.createMetadataImportOperationCallable = callableFactory.createOperationCallable(createMetadataImportTransportSettings, settings.createMetadataImportOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.updateMetadataImportCallable = callableFactory.createUnaryCallable(updateMetadataImportTransportSettings, settings.updateMetadataImportSettings(), clientContext);
        this.updateMetadataImportOperationCallable = callableFactory.createOperationCallable(updateMetadataImportTransportSettings, settings.updateMetadataImportOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.exportMetadataCallable = callableFactory.createUnaryCallable(exportMetadataTransportSettings, settings.exportMetadataSettings(), clientContext);
        this.exportMetadataOperationCallable = callableFactory.createOperationCallable(exportMetadataTransportSettings, settings.exportMetadataOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.restoreServiceCallable = callableFactory.createUnaryCallable(restoreServiceTransportSettings, settings.restoreServiceSettings(), clientContext);
        this.restoreServiceOperationCallable = callableFactory.createOperationCallable(restoreServiceTransportSettings, settings.restoreServiceOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.listBackupsCallable = callableFactory.createUnaryCallable(listBackupsTransportSettings, settings.listBackupsSettings(), clientContext);
        this.listBackupsPagedCallable = callableFactory.createPagedCallable(listBackupsTransportSettings, settings.listBackupsSettings(), clientContext);
        this.getBackupCallable = callableFactory.createUnaryCallable(getBackupTransportSettings, settings.getBackupSettings(), clientContext);
        this.createBackupCallable = callableFactory.createUnaryCallable(createBackupTransportSettings, settings.createBackupSettings(), clientContext);
        this.createBackupOperationCallable = callableFactory.createOperationCallable(createBackupTransportSettings, settings.createBackupOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.deleteBackupCallable = callableFactory.createUnaryCallable(deleteBackupTransportSettings, settings.deleteBackupSettings(), clientContext);
        this.deleteBackupOperationCallable = callableFactory.createOperationCallable(deleteBackupTransportSettings, settings.deleteBackupOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(listServicesMethodDescriptor);
        methodDescriptors.add(getServiceMethodDescriptor);
        methodDescriptors.add(createServiceMethodDescriptor);
        methodDescriptors.add(updateServiceMethodDescriptor);
        methodDescriptors.add(deleteServiceMethodDescriptor);
        methodDescriptors.add(listMetadataImportsMethodDescriptor);
        methodDescriptors.add(getMetadataImportMethodDescriptor);
        methodDescriptors.add(createMetadataImportMethodDescriptor);
        methodDescriptors.add(updateMetadataImportMethodDescriptor);
        methodDescriptors.add(exportMetadataMethodDescriptor);
        methodDescriptors.add(restoreServiceMethodDescriptor);
        methodDescriptors.add(listBackupsMethodDescriptor);
        methodDescriptors.add(getBackupMethodDescriptor);
        methodDescriptors.add(createBackupMethodDescriptor);
        methodDescriptors.add(deleteBackupMethodDescriptor);
        return methodDescriptors;
    }

    public HttpJsonOperationsStub getHttpJsonOperationsStub() {
        return this.httpJsonOperationsStub;
    }

    @Override
    public UnaryCallable<ListServicesRequest, ListServicesResponse> listServicesCallable() {
        return this.listServicesCallable;
    }

    @Override
    public UnaryCallable<ListServicesRequest, DataprocMetastoreClient.ListServicesPagedResponse> listServicesPagedCallable() {
        return this.listServicesPagedCallable;
    }

    @Override
    public UnaryCallable<GetServiceRequest, Service> getServiceCallable() {
        return this.getServiceCallable;
    }

    @Override
    public UnaryCallable<CreateServiceRequest, Operation> createServiceCallable() {
        return this.createServiceCallable;
    }

    @Override
    public OperationCallable<CreateServiceRequest, Service, OperationMetadata> createServiceOperationCallable() {
        return this.createServiceOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateServiceRequest, Operation> updateServiceCallable() {
        return this.updateServiceCallable;
    }

    @Override
    public OperationCallable<UpdateServiceRequest, Service, OperationMetadata> updateServiceOperationCallable() {
        return this.updateServiceOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteServiceRequest, Operation> deleteServiceCallable() {
        return this.deleteServiceCallable;
    }

    @Override
    public OperationCallable<DeleteServiceRequest, Empty, OperationMetadata> deleteServiceOperationCallable() {
        return this.deleteServiceOperationCallable;
    }

    @Override
    public UnaryCallable<ListMetadataImportsRequest, ListMetadataImportsResponse> listMetadataImportsCallable() {
        return this.listMetadataImportsCallable;
    }

    @Override
    public UnaryCallable<ListMetadataImportsRequest, DataprocMetastoreClient.ListMetadataImportsPagedResponse> listMetadataImportsPagedCallable() {
        return this.listMetadataImportsPagedCallable;
    }

    @Override
    public UnaryCallable<GetMetadataImportRequest, MetadataImport> getMetadataImportCallable() {
        return this.getMetadataImportCallable;
    }

    @Override
    public UnaryCallable<CreateMetadataImportRequest, Operation> createMetadataImportCallable() {
        return this.createMetadataImportCallable;
    }

    @Override
    public OperationCallable<CreateMetadataImportRequest, MetadataImport, OperationMetadata> createMetadataImportOperationCallable() {
        return this.createMetadataImportOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateMetadataImportRequest, Operation> updateMetadataImportCallable() {
        return this.updateMetadataImportCallable;
    }

    @Override
    public OperationCallable<UpdateMetadataImportRequest, MetadataImport, OperationMetadata> updateMetadataImportOperationCallable() {
        return this.updateMetadataImportOperationCallable;
    }

    @Override
    public UnaryCallable<ExportMetadataRequest, Operation> exportMetadataCallable() {
        return this.exportMetadataCallable;
    }

    @Override
    public OperationCallable<ExportMetadataRequest, MetadataExport, OperationMetadata> exportMetadataOperationCallable() {
        return this.exportMetadataOperationCallable;
    }

    @Override
    public UnaryCallable<RestoreServiceRequest, Operation> restoreServiceCallable() {
        return this.restoreServiceCallable;
    }

    @Override
    public OperationCallable<RestoreServiceRequest, Restore, OperationMetadata> restoreServiceOperationCallable() {
        return this.restoreServiceOperationCallable;
    }

    @Override
    public UnaryCallable<ListBackupsRequest, ListBackupsResponse> listBackupsCallable() {
        return this.listBackupsCallable;
    }

    @Override
    public UnaryCallable<ListBackupsRequest, DataprocMetastoreClient.ListBackupsPagedResponse> listBackupsPagedCallable() {
        return this.listBackupsPagedCallable;
    }

    @Override
    public UnaryCallable<GetBackupRequest, Backup> getBackupCallable() {
        return this.getBackupCallable;
    }

    @Override
    public UnaryCallable<CreateBackupRequest, Operation> createBackupCallable() {
        return this.createBackupCallable;
    }

    @Override
    public OperationCallable<CreateBackupRequest, Backup, OperationMetadata> createBackupOperationCallable() {
        return this.createBackupOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteBackupRequest, Operation> deleteBackupCallable() {
        return this.deleteBackupCallable;
    }

    @Override
    public OperationCallable<DeleteBackupRequest, Empty, OperationMetadata> deleteBackupOperationCallable() {
        return this.deleteBackupOperationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

