/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataplex.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dataplex.v1.CmekServiceSettings;
import com.google.cloud.dataplex.v1.CreateEncryptionConfigRequest;
import com.google.cloud.dataplex.v1.DeleteEncryptionConfigRequest;
import com.google.cloud.dataplex.v1.EncryptionConfig;
import com.google.cloud.dataplex.v1.EncryptionConfigName;
import com.google.cloud.dataplex.v1.GetEncryptionConfigRequest;
import com.google.cloud.dataplex.v1.ListEncryptionConfigsRequest;
import com.google.cloud.dataplex.v1.ListEncryptionConfigsResponse;
import com.google.cloud.dataplex.v1.OperationMetadata;
import com.google.cloud.dataplex.v1.OrganizationLocationName;
import com.google.cloud.dataplex.v1.UpdateEncryptionConfigRequest;
import com.google.cloud.dataplex.v1.stub.CmekServiceStub;
import com.google.cloud.dataplex.v1.stub.CmekServiceStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class CmekServiceClient
implements BackgroundResource {
    private final CmekServiceSettings settings;
    private final CmekServiceStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final CmekServiceClient create() throws IOException {
        return CmekServiceClient.create(CmekServiceSettings.newBuilder().build());
    }

    public static final CmekServiceClient create(CmekServiceSettings settings) throws IOException {
        return new CmekServiceClient(settings);
    }

    public static final CmekServiceClient create(CmekServiceStub stub) {
        return new CmekServiceClient(stub);
    }

    protected CmekServiceClient(CmekServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((CmekServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected CmekServiceClient(CmekServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final CmekServiceSettings getSettings() {
        return this.settings;
    }

    public CmekServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final OperationFuture<EncryptionConfig, OperationMetadata> createEncryptionConfigAsync(OrganizationLocationName parent, EncryptionConfig encryptionConfig, String encryptionConfigId) {
        CreateEncryptionConfigRequest request = CreateEncryptionConfigRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setEncryptionConfig(encryptionConfig).setEncryptionConfigId(encryptionConfigId).build();
        return this.createEncryptionConfigAsync(request);
    }

    public final OperationFuture<EncryptionConfig, OperationMetadata> createEncryptionConfigAsync(String parent, EncryptionConfig encryptionConfig, String encryptionConfigId) {
        CreateEncryptionConfigRequest request = CreateEncryptionConfigRequest.newBuilder().setParent(parent).setEncryptionConfig(encryptionConfig).setEncryptionConfigId(encryptionConfigId).build();
        return this.createEncryptionConfigAsync(request);
    }

    public final OperationFuture<EncryptionConfig, OperationMetadata> createEncryptionConfigAsync(CreateEncryptionConfigRequest request) {
        return this.createEncryptionConfigOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateEncryptionConfigRequest, EncryptionConfig, OperationMetadata> createEncryptionConfigOperationCallable() {
        return this.stub.createEncryptionConfigOperationCallable();
    }

    public final UnaryCallable<CreateEncryptionConfigRequest, Operation> createEncryptionConfigCallable() {
        return this.stub.createEncryptionConfigCallable();
    }

    public final OperationFuture<EncryptionConfig, OperationMetadata> updateEncryptionConfigAsync(EncryptionConfig encryptionConfig, FieldMask updateMask) {
        UpdateEncryptionConfigRequest request = UpdateEncryptionConfigRequest.newBuilder().setEncryptionConfig(encryptionConfig).setUpdateMask(updateMask).build();
        return this.updateEncryptionConfigAsync(request);
    }

    public final OperationFuture<EncryptionConfig, OperationMetadata> updateEncryptionConfigAsync(UpdateEncryptionConfigRequest request) {
        return this.updateEncryptionConfigOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateEncryptionConfigRequest, EncryptionConfig, OperationMetadata> updateEncryptionConfigOperationCallable() {
        return this.stub.updateEncryptionConfigOperationCallable();
    }

    public final UnaryCallable<UpdateEncryptionConfigRequest, Operation> updateEncryptionConfigCallable() {
        return this.stub.updateEncryptionConfigCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteEncryptionConfigAsync(EncryptionConfigName name) {
        DeleteEncryptionConfigRequest request = DeleteEncryptionConfigRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteEncryptionConfigAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteEncryptionConfigAsync(String name) {
        DeleteEncryptionConfigRequest request = DeleteEncryptionConfigRequest.newBuilder().setName(name).build();
        return this.deleteEncryptionConfigAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteEncryptionConfigAsync(DeleteEncryptionConfigRequest request) {
        return this.deleteEncryptionConfigOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteEncryptionConfigRequest, Empty, OperationMetadata> deleteEncryptionConfigOperationCallable() {
        return this.stub.deleteEncryptionConfigOperationCallable();
    }

    public final UnaryCallable<DeleteEncryptionConfigRequest, Operation> deleteEncryptionConfigCallable() {
        return this.stub.deleteEncryptionConfigCallable();
    }

    public final ListEncryptionConfigsPagedResponse listEncryptionConfigs(OrganizationLocationName parent) {
        ListEncryptionConfigsRequest request = ListEncryptionConfigsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listEncryptionConfigs(request);
    }

    public final ListEncryptionConfigsPagedResponse listEncryptionConfigs(String parent) {
        ListEncryptionConfigsRequest request = ListEncryptionConfigsRequest.newBuilder().setParent(parent).build();
        return this.listEncryptionConfigs(request);
    }

    public final ListEncryptionConfigsPagedResponse listEncryptionConfigs(ListEncryptionConfigsRequest request) {
        return (ListEncryptionConfigsPagedResponse)((Object)this.listEncryptionConfigsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListEncryptionConfigsRequest, ListEncryptionConfigsPagedResponse> listEncryptionConfigsPagedCallable() {
        return this.stub.listEncryptionConfigsPagedCallable();
    }

    public final UnaryCallable<ListEncryptionConfigsRequest, ListEncryptionConfigsResponse> listEncryptionConfigsCallable() {
        return this.stub.listEncryptionConfigsCallable();
    }

    public final EncryptionConfig getEncryptionConfig(EncryptionConfigName name) {
        GetEncryptionConfigRequest request = GetEncryptionConfigRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getEncryptionConfig(request);
    }

    public final EncryptionConfig getEncryptionConfig(String name) {
        GetEncryptionConfigRequest request = GetEncryptionConfigRequest.newBuilder().setName(name).build();
        return this.getEncryptionConfig(request);
    }

    public final EncryptionConfig getEncryptionConfig(GetEncryptionConfigRequest request) {
        return (EncryptionConfig)this.getEncryptionConfigCallable().call((Object)request);
    }

    public final UnaryCallable<GetEncryptionConfigRequest, EncryptionConfig> getEncryptionConfigCallable() {
        return this.stub.getEncryptionConfigCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListEncryptionConfigsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListEncryptionConfigsRequest, ListEncryptionConfigsResponse, EncryptionConfig, ListEncryptionConfigsPage, ListEncryptionConfigsFixedSizeCollection> {
        private ListEncryptionConfigsFixedSizeCollection(List<ListEncryptionConfigsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListEncryptionConfigsFixedSizeCollection createEmptyCollection() {
            return new ListEncryptionConfigsFixedSizeCollection(null, 0);
        }

        protected ListEncryptionConfigsFixedSizeCollection createCollection(List<ListEncryptionConfigsPage> pages, int collectionSize) {
            return new ListEncryptionConfigsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListEncryptionConfigsPage
    extends AbstractPage<ListEncryptionConfigsRequest, ListEncryptionConfigsResponse, EncryptionConfig, ListEncryptionConfigsPage> {
        private ListEncryptionConfigsPage(PageContext<ListEncryptionConfigsRequest, ListEncryptionConfigsResponse, EncryptionConfig> context, ListEncryptionConfigsResponse response) {
            super(context, (Object)response);
        }

        private static ListEncryptionConfigsPage createEmptyPage() {
            return new ListEncryptionConfigsPage(null, null);
        }

        protected ListEncryptionConfigsPage createPage(PageContext<ListEncryptionConfigsRequest, ListEncryptionConfigsResponse, EncryptionConfig> context, ListEncryptionConfigsResponse response) {
            return new ListEncryptionConfigsPage(context, response);
        }

        public ApiFuture<ListEncryptionConfigsPage> createPageAsync(PageContext<ListEncryptionConfigsRequest, ListEncryptionConfigsResponse, EncryptionConfig> context, ApiFuture<ListEncryptionConfigsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListEncryptionConfigsPagedResponse
    extends AbstractPagedListResponse<ListEncryptionConfigsRequest, ListEncryptionConfigsResponse, EncryptionConfig, ListEncryptionConfigsPage, ListEncryptionConfigsFixedSizeCollection> {
        public static ApiFuture<ListEncryptionConfigsPagedResponse> createAsync(PageContext<ListEncryptionConfigsRequest, ListEncryptionConfigsResponse, EncryptionConfig> context, ApiFuture<ListEncryptionConfigsResponse> futureResponse) {
            ApiFuture<ListEncryptionConfigsPage> futurePage = ListEncryptionConfigsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListEncryptionConfigsPagedResponse((ListEncryptionConfigsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListEncryptionConfigsPagedResponse(ListEncryptionConfigsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListEncryptionConfigsFixedSizeCollection.createEmptyCollection());
        }
    }
}

