/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataplex.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dataplex.v1.CreateDataScanRequest;
import com.google.cloud.dataplex.v1.DataScan;
import com.google.cloud.dataplex.v1.DataScanJob;
import com.google.cloud.dataplex.v1.DataScanServiceClient;
import com.google.cloud.dataplex.v1.DeleteDataScanRequest;
import com.google.cloud.dataplex.v1.GenerateDataQualityRulesRequest;
import com.google.cloud.dataplex.v1.GenerateDataQualityRulesResponse;
import com.google.cloud.dataplex.v1.GetDataScanJobRequest;
import com.google.cloud.dataplex.v1.GetDataScanRequest;
import com.google.cloud.dataplex.v1.ListDataScanJobsRequest;
import com.google.cloud.dataplex.v1.ListDataScanJobsResponse;
import com.google.cloud.dataplex.v1.ListDataScansRequest;
import com.google.cloud.dataplex.v1.ListDataScansResponse;
import com.google.cloud.dataplex.v1.OperationMetadata;
import com.google.cloud.dataplex.v1.RunDataScanRequest;
import com.google.cloud.dataplex.v1.RunDataScanResponse;
import com.google.cloud.dataplex.v1.UpdateDataScanRequest;
import com.google.cloud.dataplex.v1.stub.DataScanServiceStub;
import com.google.cloud.dataplex.v1.stub.GrpcDataScanServiceStub;
import com.google.cloud.dataplex.v1.stub.HttpJsonDataScanServiceStub;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class DataScanServiceStubSettings
extends StubSettings<DataScanServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateDataScanRequest, Operation> createDataScanSettings;
    private final OperationCallSettings<CreateDataScanRequest, DataScan, OperationMetadata> createDataScanOperationSettings;
    private final UnaryCallSettings<UpdateDataScanRequest, Operation> updateDataScanSettings;
    private final OperationCallSettings<UpdateDataScanRequest, DataScan, OperationMetadata> updateDataScanOperationSettings;
    private final UnaryCallSettings<DeleteDataScanRequest, Operation> deleteDataScanSettings;
    private final OperationCallSettings<DeleteDataScanRequest, Empty, OperationMetadata> deleteDataScanOperationSettings;
    private final UnaryCallSettings<GetDataScanRequest, DataScan> getDataScanSettings;
    private final PagedCallSettings<ListDataScansRequest, ListDataScansResponse, DataScanServiceClient.ListDataScansPagedResponse> listDataScansSettings;
    private final UnaryCallSettings<RunDataScanRequest, RunDataScanResponse> runDataScanSettings;
    private final UnaryCallSettings<GetDataScanJobRequest, DataScanJob> getDataScanJobSettings;
    private final PagedCallSettings<ListDataScanJobsRequest, ListDataScanJobsResponse, DataScanServiceClient.ListDataScanJobsPagedResponse> listDataScanJobsSettings;
    private final UnaryCallSettings<GenerateDataQualityRulesRequest, GenerateDataQualityRulesResponse> generateDataQualityRulesSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, DataScanServiceClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private static final PagedListDescriptor<ListDataScansRequest, ListDataScansResponse, DataScan> LIST_DATA_SCANS_PAGE_STR_DESC = new PagedListDescriptor<ListDataScansRequest, ListDataScansResponse, DataScan>(){

        public String emptyToken() {
            return "";
        }

        public ListDataScansRequest injectToken(ListDataScansRequest payload, String token) {
            return ListDataScansRequest.newBuilder((ListDataScansRequest)payload).setPageToken(token).build();
        }

        public ListDataScansRequest injectPageSize(ListDataScansRequest payload, int pageSize) {
            return ListDataScansRequest.newBuilder((ListDataScansRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListDataScansRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListDataScansResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<DataScan> extractResources(ListDataScansResponse payload) {
            return payload.getDataScansList() == null ? ImmutableList.of() : payload.getDataScansList();
        }
    };
    private static final PagedListDescriptor<ListDataScanJobsRequest, ListDataScanJobsResponse, DataScanJob> LIST_DATA_SCAN_JOBS_PAGE_STR_DESC = new PagedListDescriptor<ListDataScanJobsRequest, ListDataScanJobsResponse, DataScanJob>(){

        public String emptyToken() {
            return "";
        }

        public ListDataScanJobsRequest injectToken(ListDataScanJobsRequest payload, String token) {
            return ListDataScanJobsRequest.newBuilder((ListDataScanJobsRequest)payload).setPageToken(token).build();
        }

        public ListDataScanJobsRequest injectPageSize(ListDataScanJobsRequest payload, int pageSize) {
            return ListDataScanJobsRequest.newBuilder((ListDataScanJobsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListDataScanJobsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListDataScanJobsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<DataScanJob> extractResources(ListDataScanJobsResponse payload) {
            return payload.getDataScanJobsList() == null ? ImmutableList.of() : payload.getDataScanJobsList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList() == null ? ImmutableList.of() : payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListDataScansRequest, ListDataScansResponse, DataScanServiceClient.ListDataScansPagedResponse> LIST_DATA_SCANS_PAGE_STR_FACT = new PagedListResponseFactory<ListDataScansRequest, ListDataScansResponse, DataScanServiceClient.ListDataScansPagedResponse>(){

        public ApiFuture<DataScanServiceClient.ListDataScansPagedResponse> getFuturePagedResponse(UnaryCallable<ListDataScansRequest, ListDataScansResponse> callable, ListDataScansRequest request, ApiCallContext context, ApiFuture<ListDataScansResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_DATA_SCANS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DataScanServiceClient.ListDataScansPagedResponse.createAsync((PageContext<ListDataScansRequest, ListDataScansResponse, DataScan>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListDataScanJobsRequest, ListDataScanJobsResponse, DataScanServiceClient.ListDataScanJobsPagedResponse> LIST_DATA_SCAN_JOBS_PAGE_STR_FACT = new PagedListResponseFactory<ListDataScanJobsRequest, ListDataScanJobsResponse, DataScanServiceClient.ListDataScanJobsPagedResponse>(){

        public ApiFuture<DataScanServiceClient.ListDataScanJobsPagedResponse> getFuturePagedResponse(UnaryCallable<ListDataScanJobsRequest, ListDataScanJobsResponse> callable, ListDataScanJobsRequest request, ApiCallContext context, ApiFuture<ListDataScanJobsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_DATA_SCAN_JOBS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DataScanServiceClient.ListDataScanJobsPagedResponse.createAsync((PageContext<ListDataScanJobsRequest, ListDataScanJobsResponse, DataScanJob>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, DataScanServiceClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, DataScanServiceClient.ListLocationsPagedResponse>(){

        public ApiFuture<DataScanServiceClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DataScanServiceClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateDataScanRequest, Operation> createDataScanSettings() {
        return this.createDataScanSettings;
    }

    public OperationCallSettings<CreateDataScanRequest, DataScan, OperationMetadata> createDataScanOperationSettings() {
        return this.createDataScanOperationSettings;
    }

    public UnaryCallSettings<UpdateDataScanRequest, Operation> updateDataScanSettings() {
        return this.updateDataScanSettings;
    }

    public OperationCallSettings<UpdateDataScanRequest, DataScan, OperationMetadata> updateDataScanOperationSettings() {
        return this.updateDataScanOperationSettings;
    }

    public UnaryCallSettings<DeleteDataScanRequest, Operation> deleteDataScanSettings() {
        return this.deleteDataScanSettings;
    }

    public OperationCallSettings<DeleteDataScanRequest, Empty, OperationMetadata> deleteDataScanOperationSettings() {
        return this.deleteDataScanOperationSettings;
    }

    public UnaryCallSettings<GetDataScanRequest, DataScan> getDataScanSettings() {
        return this.getDataScanSettings;
    }

    public PagedCallSettings<ListDataScansRequest, ListDataScansResponse, DataScanServiceClient.ListDataScansPagedResponse> listDataScansSettings() {
        return this.listDataScansSettings;
    }

    public UnaryCallSettings<RunDataScanRequest, RunDataScanResponse> runDataScanSettings() {
        return this.runDataScanSettings;
    }

    public UnaryCallSettings<GetDataScanJobRequest, DataScanJob> getDataScanJobSettings() {
        return this.getDataScanJobSettings;
    }

    public PagedCallSettings<ListDataScanJobsRequest, ListDataScanJobsResponse, DataScanServiceClient.ListDataScanJobsPagedResponse> listDataScanJobsSettings() {
        return this.listDataScanJobsSettings;
    }

    public UnaryCallSettings<GenerateDataQualityRulesRequest, GenerateDataQualityRulesResponse> generateDataQualityRulesSettings() {
        return this.generateDataQualityRulesSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, DataScanServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public DataScanServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcDataScanServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonDataScanServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "dataplex";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "dataplex.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "dataplex.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return DataScanServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(DataScanServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(DataScanServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return DataScanServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected DataScanServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createDataScanSettings = settingsBuilder.createDataScanSettings().build();
        this.createDataScanOperationSettings = settingsBuilder.createDataScanOperationSettings().build();
        this.updateDataScanSettings = settingsBuilder.updateDataScanSettings().build();
        this.updateDataScanOperationSettings = settingsBuilder.updateDataScanOperationSettings().build();
        this.deleteDataScanSettings = settingsBuilder.deleteDataScanSettings().build();
        this.deleteDataScanOperationSettings = settingsBuilder.deleteDataScanOperationSettings().build();
        this.getDataScanSettings = settingsBuilder.getDataScanSettings().build();
        this.listDataScansSettings = settingsBuilder.listDataScansSettings().build();
        this.runDataScanSettings = settingsBuilder.runDataScanSettings().build();
        this.getDataScanJobSettings = settingsBuilder.getDataScanJobSettings().build();
        this.listDataScanJobsSettings = settingsBuilder.listDataScanJobsSettings().build();
        this.generateDataQualityRulesSettings = settingsBuilder.generateDataQualityRulesSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<DataScanServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateDataScanRequest, Operation> createDataScanSettings;
        private final OperationCallSettings.Builder<CreateDataScanRequest, DataScan, OperationMetadata> createDataScanOperationSettings;
        private final UnaryCallSettings.Builder<UpdateDataScanRequest, Operation> updateDataScanSettings;
        private final OperationCallSettings.Builder<UpdateDataScanRequest, DataScan, OperationMetadata> updateDataScanOperationSettings;
        private final UnaryCallSettings.Builder<DeleteDataScanRequest, Operation> deleteDataScanSettings;
        private final OperationCallSettings.Builder<DeleteDataScanRequest, Empty, OperationMetadata> deleteDataScanOperationSettings;
        private final UnaryCallSettings.Builder<GetDataScanRequest, DataScan> getDataScanSettings;
        private final PagedCallSettings.Builder<ListDataScansRequest, ListDataScansResponse, DataScanServiceClient.ListDataScansPagedResponse> listDataScansSettings;
        private final UnaryCallSettings.Builder<RunDataScanRequest, RunDataScanResponse> runDataScanSettings;
        private final UnaryCallSettings.Builder<GetDataScanJobRequest, DataScanJob> getDataScanJobSettings;
        private final PagedCallSettings.Builder<ListDataScanJobsRequest, ListDataScanJobsResponse, DataScanServiceClient.ListDataScanJobsPagedResponse> listDataScanJobsSettings;
        private final UnaryCallSettings.Builder<GenerateDataQualityRulesRequest, GenerateDataQualityRulesResponse> generateDataQualityRulesSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, DataScanServiceClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createDataScanSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createDataScanOperationSettings = OperationCallSettings.newBuilder();
            this.updateDataScanSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateDataScanOperationSettings = OperationCallSettings.newBuilder();
            this.deleteDataScanSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteDataScanOperationSettings = OperationCallSettings.newBuilder();
            this.getDataScanSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listDataScansSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_DATA_SCANS_PAGE_STR_FACT);
            this.runDataScanSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getDataScanJobSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listDataScanJobsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_DATA_SCAN_JOBS_PAGE_STR_FACT);
            this.generateDataQualityRulesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createDataScanSettings, this.updateDataScanSettings, this.deleteDataScanSettings, this.getDataScanSettings, this.listDataScansSettings, this.runDataScanSettings, this.getDataScanJobSettings, this.listDataScanJobsSettings, this.generateDataQualityRulesSettings, this.listLocationsSettings, this.getLocationSettings);
            Builder.initDefaults(this);
        }

        protected Builder(DataScanServiceStubSettings settings) {
            super((StubSettings)settings);
            this.createDataScanSettings = settings.createDataScanSettings.toBuilder();
            this.createDataScanOperationSettings = settings.createDataScanOperationSettings.toBuilder();
            this.updateDataScanSettings = settings.updateDataScanSettings.toBuilder();
            this.updateDataScanOperationSettings = settings.updateDataScanOperationSettings.toBuilder();
            this.deleteDataScanSettings = settings.deleteDataScanSettings.toBuilder();
            this.deleteDataScanOperationSettings = settings.deleteDataScanOperationSettings.toBuilder();
            this.getDataScanSettings = settings.getDataScanSettings.toBuilder();
            this.listDataScansSettings = settings.listDataScansSettings.toBuilder();
            this.runDataScanSettings = settings.runDataScanSettings.toBuilder();
            this.getDataScanJobSettings = settings.getDataScanJobSettings.toBuilder();
            this.listDataScanJobsSettings = settings.listDataScanJobsSettings.toBuilder();
            this.generateDataQualityRulesSettings = settings.generateDataQualityRulesSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createDataScanSettings, this.updateDataScanSettings, this.deleteDataScanSettings, this.getDataScanSettings, this.listDataScansSettings, this.runDataScanSettings, this.getDataScanJobSettings, this.listDataScanJobsSettings, this.generateDataQualityRulesSettings, this.listLocationsSettings, this.getLocationSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(DataScanServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)DataScanServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)DataScanServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(DataScanServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)DataScanServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)DataScanServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)DataScanServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(DataScanServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createDataScanSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateDataScanSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteDataScanSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getDataScanSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listDataScansSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.runDataScanSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getDataScanJobSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listDataScanJobsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.generateDataQualityRulesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createDataScanOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(DataScan.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateDataScanOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(DataScan.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteDataScanOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateDataScanRequest, Operation> createDataScanSettings() {
            return this.createDataScanSettings;
        }

        public OperationCallSettings.Builder<CreateDataScanRequest, DataScan, OperationMetadata> createDataScanOperationSettings() {
            return this.createDataScanOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateDataScanRequest, Operation> updateDataScanSettings() {
            return this.updateDataScanSettings;
        }

        public OperationCallSettings.Builder<UpdateDataScanRequest, DataScan, OperationMetadata> updateDataScanOperationSettings() {
            return this.updateDataScanOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteDataScanRequest, Operation> deleteDataScanSettings() {
            return this.deleteDataScanSettings;
        }

        public OperationCallSettings.Builder<DeleteDataScanRequest, Empty, OperationMetadata> deleteDataScanOperationSettings() {
            return this.deleteDataScanOperationSettings;
        }

        public UnaryCallSettings.Builder<GetDataScanRequest, DataScan> getDataScanSettings() {
            return this.getDataScanSettings;
        }

        public PagedCallSettings.Builder<ListDataScansRequest, ListDataScansResponse, DataScanServiceClient.ListDataScansPagedResponse> listDataScansSettings() {
            return this.listDataScansSettings;
        }

        public UnaryCallSettings.Builder<RunDataScanRequest, RunDataScanResponse> runDataScanSettings() {
            return this.runDataScanSettings;
        }

        public UnaryCallSettings.Builder<GetDataScanJobRequest, DataScanJob> getDataScanJobSettings() {
            return this.getDataScanJobSettings;
        }

        public PagedCallSettings.Builder<ListDataScanJobsRequest, ListDataScanJobsResponse, DataScanServiceClient.ListDataScanJobsPagedResponse> listDataScanJobsSettings() {
            return this.listDataScanJobsSettings;
        }

        public UnaryCallSettings.Builder<GenerateDataQualityRulesRequest, GenerateDataQualityRulesResponse> generateDataQualityRulesSettings() {
            return this.generateDataQualityRulesSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, DataScanServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public DataScanServiceStubSettings build() throws IOException {
            return new DataScanServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

