/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataplex.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dataplex.v1.CreateEntityRequest;
import com.google.cloud.dataplex.v1.CreatePartitionRequest;
import com.google.cloud.dataplex.v1.DeleteEntityRequest;
import com.google.cloud.dataplex.v1.DeletePartitionRequest;
import com.google.cloud.dataplex.v1.Entity;
import com.google.cloud.dataplex.v1.EntityName;
import com.google.cloud.dataplex.v1.GetEntityRequest;
import com.google.cloud.dataplex.v1.GetPartitionRequest;
import com.google.cloud.dataplex.v1.ListEntitiesRequest;
import com.google.cloud.dataplex.v1.ListEntitiesResponse;
import com.google.cloud.dataplex.v1.ListPartitionsRequest;
import com.google.cloud.dataplex.v1.ListPartitionsResponse;
import com.google.cloud.dataplex.v1.MetadataServiceSettings;
import com.google.cloud.dataplex.v1.Partition;
import com.google.cloud.dataplex.v1.PartitionName;
import com.google.cloud.dataplex.v1.UpdateEntityRequest;
import com.google.cloud.dataplex.v1.ZoneName;
import com.google.cloud.dataplex.v1.stub.MetadataServiceStub;
import com.google.cloud.dataplex.v1.stub.MetadataServiceStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class MetadataServiceClient
implements BackgroundResource {
    private final MetadataServiceSettings settings;
    private final MetadataServiceStub stub;

    public static final MetadataServiceClient create() throws IOException {
        return MetadataServiceClient.create(MetadataServiceSettings.newBuilder().build());
    }

    public static final MetadataServiceClient create(MetadataServiceSettings settings) throws IOException {
        return new MetadataServiceClient(settings);
    }

    public static final MetadataServiceClient create(MetadataServiceStub stub) {
        return new MetadataServiceClient(stub);
    }

    protected MetadataServiceClient(MetadataServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((MetadataServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected MetadataServiceClient(MetadataServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final MetadataServiceSettings getSettings() {
        return this.settings;
    }

    public MetadataServiceStub getStub() {
        return this.stub;
    }

    public final Entity createEntity(ZoneName parent, Entity entity) {
        CreateEntityRequest request = CreateEntityRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setEntity(entity).build();
        return this.createEntity(request);
    }

    public final Entity createEntity(String parent, Entity entity) {
        CreateEntityRequest request = CreateEntityRequest.newBuilder().setParent(parent).setEntity(entity).build();
        return this.createEntity(request);
    }

    public final Entity createEntity(CreateEntityRequest request) {
        return (Entity)this.createEntityCallable().call((Object)request);
    }

    public final UnaryCallable<CreateEntityRequest, Entity> createEntityCallable() {
        return this.stub.createEntityCallable();
    }

    public final Entity updateEntity(UpdateEntityRequest request) {
        return (Entity)this.updateEntityCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateEntityRequest, Entity> updateEntityCallable() {
        return this.stub.updateEntityCallable();
    }

    public final void deleteEntity(EntityName name) {
        DeleteEntityRequest request = DeleteEntityRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteEntity(request);
    }

    public final void deleteEntity(String name) {
        DeleteEntityRequest request = DeleteEntityRequest.newBuilder().setName(name).build();
        this.deleteEntity(request);
    }

    public final void deleteEntity(DeleteEntityRequest request) {
        this.deleteEntityCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteEntityRequest, Empty> deleteEntityCallable() {
        return this.stub.deleteEntityCallable();
    }

    public final Entity getEntity(EntityName name) {
        GetEntityRequest request = GetEntityRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getEntity(request);
    }

    public final Entity getEntity(String name) {
        GetEntityRequest request = GetEntityRequest.newBuilder().setName(name).build();
        return this.getEntity(request);
    }

    public final Entity getEntity(GetEntityRequest request) {
        return (Entity)this.getEntityCallable().call((Object)request);
    }

    public final UnaryCallable<GetEntityRequest, Entity> getEntityCallable() {
        return this.stub.getEntityCallable();
    }

    public final ListEntitiesPagedResponse listEntities(ZoneName parent) {
        ListEntitiesRequest request = ListEntitiesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listEntities(request);
    }

    public final ListEntitiesPagedResponse listEntities(String parent) {
        ListEntitiesRequest request = ListEntitiesRequest.newBuilder().setParent(parent).build();
        return this.listEntities(request);
    }

    public final ListEntitiesPagedResponse listEntities(ListEntitiesRequest request) {
        return (ListEntitiesPagedResponse)((Object)this.listEntitiesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListEntitiesRequest, ListEntitiesPagedResponse> listEntitiesPagedCallable() {
        return this.stub.listEntitiesPagedCallable();
    }

    public final UnaryCallable<ListEntitiesRequest, ListEntitiesResponse> listEntitiesCallable() {
        return this.stub.listEntitiesCallable();
    }

    public final Partition createPartition(EntityName parent, Partition partition) {
        CreatePartitionRequest request = CreatePartitionRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setPartition(partition).build();
        return this.createPartition(request);
    }

    public final Partition createPartition(String parent, Partition partition) {
        CreatePartitionRequest request = CreatePartitionRequest.newBuilder().setParent(parent).setPartition(partition).build();
        return this.createPartition(request);
    }

    public final Partition createPartition(CreatePartitionRequest request) {
        return (Partition)this.createPartitionCallable().call((Object)request);
    }

    public final UnaryCallable<CreatePartitionRequest, Partition> createPartitionCallable() {
        return this.stub.createPartitionCallable();
    }

    public final void deletePartition(PartitionName name) {
        DeletePartitionRequest request = DeletePartitionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deletePartition(request);
    }

    public final void deletePartition(String name) {
        DeletePartitionRequest request = DeletePartitionRequest.newBuilder().setName(name).build();
        this.deletePartition(request);
    }

    public final void deletePartition(DeletePartitionRequest request) {
        this.deletePartitionCallable().call((Object)request);
    }

    public final UnaryCallable<DeletePartitionRequest, Empty> deletePartitionCallable() {
        return this.stub.deletePartitionCallable();
    }

    public final Partition getPartition(PartitionName name) {
        GetPartitionRequest request = GetPartitionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getPartition(request);
    }

    public final Partition getPartition(String name) {
        GetPartitionRequest request = GetPartitionRequest.newBuilder().setName(name).build();
        return this.getPartition(request);
    }

    public final Partition getPartition(GetPartitionRequest request) {
        return (Partition)this.getPartitionCallable().call((Object)request);
    }

    public final UnaryCallable<GetPartitionRequest, Partition> getPartitionCallable() {
        return this.stub.getPartitionCallable();
    }

    public final ListPartitionsPagedResponse listPartitions(EntityName parent) {
        ListPartitionsRequest request = ListPartitionsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listPartitions(request);
    }

    public final ListPartitionsPagedResponse listPartitions(String parent) {
        ListPartitionsRequest request = ListPartitionsRequest.newBuilder().setParent(parent).build();
        return this.listPartitions(request);
    }

    public final ListPartitionsPagedResponse listPartitions(ListPartitionsRequest request) {
        return (ListPartitionsPagedResponse)((Object)this.listPartitionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListPartitionsRequest, ListPartitionsPagedResponse> listPartitionsPagedCallable() {
        return this.stub.listPartitionsPagedCallable();
    }

    public final UnaryCallable<ListPartitionsRequest, ListPartitionsResponse> listPartitionsCallable() {
        return this.stub.listPartitionsCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListPartitionsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListPartitionsRequest, ListPartitionsResponse, Partition, ListPartitionsPage, ListPartitionsFixedSizeCollection> {
        private ListPartitionsFixedSizeCollection(List<ListPartitionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListPartitionsFixedSizeCollection createEmptyCollection() {
            return new ListPartitionsFixedSizeCollection(null, 0);
        }

        protected ListPartitionsFixedSizeCollection createCollection(List<ListPartitionsPage> pages, int collectionSize) {
            return new ListPartitionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPartitionsPage
    extends AbstractPage<ListPartitionsRequest, ListPartitionsResponse, Partition, ListPartitionsPage> {
        private ListPartitionsPage(PageContext<ListPartitionsRequest, ListPartitionsResponse, Partition> context, ListPartitionsResponse response) {
            super(context, (Object)response);
        }

        private static ListPartitionsPage createEmptyPage() {
            return new ListPartitionsPage(null, null);
        }

        protected ListPartitionsPage createPage(PageContext<ListPartitionsRequest, ListPartitionsResponse, Partition> context, ListPartitionsResponse response) {
            return new ListPartitionsPage(context, response);
        }

        public ApiFuture<ListPartitionsPage> createPageAsync(PageContext<ListPartitionsRequest, ListPartitionsResponse, Partition> context, ApiFuture<ListPartitionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPartitionsPagedResponse
    extends AbstractPagedListResponse<ListPartitionsRequest, ListPartitionsResponse, Partition, ListPartitionsPage, ListPartitionsFixedSizeCollection> {
        public static ApiFuture<ListPartitionsPagedResponse> createAsync(PageContext<ListPartitionsRequest, ListPartitionsResponse, Partition> context, ApiFuture<ListPartitionsResponse> futureResponse) {
            ApiFuture<ListPartitionsPage> futurePage = ListPartitionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPartitionsPagedResponse((ListPartitionsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPartitionsPagedResponse(ListPartitionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListPartitionsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListEntitiesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListEntitiesRequest, ListEntitiesResponse, Entity, ListEntitiesPage, ListEntitiesFixedSizeCollection> {
        private ListEntitiesFixedSizeCollection(List<ListEntitiesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListEntitiesFixedSizeCollection createEmptyCollection() {
            return new ListEntitiesFixedSizeCollection(null, 0);
        }

        protected ListEntitiesFixedSizeCollection createCollection(List<ListEntitiesPage> pages, int collectionSize) {
            return new ListEntitiesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListEntitiesPage
    extends AbstractPage<ListEntitiesRequest, ListEntitiesResponse, Entity, ListEntitiesPage> {
        private ListEntitiesPage(PageContext<ListEntitiesRequest, ListEntitiesResponse, Entity> context, ListEntitiesResponse response) {
            super(context, (Object)response);
        }

        private static ListEntitiesPage createEmptyPage() {
            return new ListEntitiesPage(null, null);
        }

        protected ListEntitiesPage createPage(PageContext<ListEntitiesRequest, ListEntitiesResponse, Entity> context, ListEntitiesResponse response) {
            return new ListEntitiesPage(context, response);
        }

        public ApiFuture<ListEntitiesPage> createPageAsync(PageContext<ListEntitiesRequest, ListEntitiesResponse, Entity> context, ApiFuture<ListEntitiesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListEntitiesPagedResponse
    extends AbstractPagedListResponse<ListEntitiesRequest, ListEntitiesResponse, Entity, ListEntitiesPage, ListEntitiesFixedSizeCollection> {
        public static ApiFuture<ListEntitiesPagedResponse> createAsync(PageContext<ListEntitiesRequest, ListEntitiesResponse, Entity> context, ApiFuture<ListEntitiesResponse> futureResponse) {
            ApiFuture<ListEntitiesPage> futurePage = ListEntitiesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListEntitiesPagedResponse((ListEntitiesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListEntitiesPagedResponse(ListEntitiesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListEntitiesFixedSizeCollection.createEmptyCollection());
        }
    }
}

