/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataplex.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dataplex.v1.CreateDataScanRequest;
import com.google.cloud.dataplex.v1.DataScan;
import com.google.cloud.dataplex.v1.DataScanJob;
import com.google.cloud.dataplex.v1.DataScanJobName;
import com.google.cloud.dataplex.v1.DataScanName;
import com.google.cloud.dataplex.v1.DataScanServiceSettings;
import com.google.cloud.dataplex.v1.DeleteDataScanRequest;
import com.google.cloud.dataplex.v1.GetDataScanJobRequest;
import com.google.cloud.dataplex.v1.GetDataScanRequest;
import com.google.cloud.dataplex.v1.ListDataScanJobsRequest;
import com.google.cloud.dataplex.v1.ListDataScanJobsResponse;
import com.google.cloud.dataplex.v1.ListDataScansRequest;
import com.google.cloud.dataplex.v1.ListDataScansResponse;
import com.google.cloud.dataplex.v1.LocationName;
import com.google.cloud.dataplex.v1.OperationMetadata;
import com.google.cloud.dataplex.v1.RunDataScanRequest;
import com.google.cloud.dataplex.v1.RunDataScanResponse;
import com.google.cloud.dataplex.v1.UpdateDataScanRequest;
import com.google.cloud.dataplex.v1.stub.DataScanServiceStub;
import com.google.cloud.dataplex.v1.stub.DataScanServiceStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class DataScanServiceClient
implements BackgroundResource {
    private final DataScanServiceSettings settings;
    private final DataScanServiceStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final DataScanServiceClient create() throws IOException {
        return DataScanServiceClient.create(DataScanServiceSettings.newBuilder().build());
    }

    public static final DataScanServiceClient create(DataScanServiceSettings settings) throws IOException {
        return new DataScanServiceClient(settings);
    }

    public static final DataScanServiceClient create(DataScanServiceStub stub) {
        return new DataScanServiceClient(stub);
    }

    protected DataScanServiceClient(DataScanServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((DataScanServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected DataScanServiceClient(DataScanServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final DataScanServiceSettings getSettings() {
        return this.settings;
    }

    public DataScanServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final OperationFuture<DataScan, OperationMetadata> createDataScanAsync(LocationName parent, DataScan dataScan, String dataScanId) {
        CreateDataScanRequest request = CreateDataScanRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setDataScan(dataScan).setDataScanId(dataScanId).build();
        return this.createDataScanAsync(request);
    }

    public final OperationFuture<DataScan, OperationMetadata> createDataScanAsync(String parent, DataScan dataScan, String dataScanId) {
        CreateDataScanRequest request = CreateDataScanRequest.newBuilder().setParent(parent).setDataScan(dataScan).setDataScanId(dataScanId).build();
        return this.createDataScanAsync(request);
    }

    public final OperationFuture<DataScan, OperationMetadata> createDataScanAsync(CreateDataScanRequest request) {
        return this.createDataScanOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateDataScanRequest, DataScan, OperationMetadata> createDataScanOperationCallable() {
        return this.stub.createDataScanOperationCallable();
    }

    public final UnaryCallable<CreateDataScanRequest, Operation> createDataScanCallable() {
        return this.stub.createDataScanCallable();
    }

    public final OperationFuture<DataScan, OperationMetadata> updateDataScanAsync(DataScan dataScan, FieldMask updateMask) {
        UpdateDataScanRequest request = UpdateDataScanRequest.newBuilder().setDataScan(dataScan).setUpdateMask(updateMask).build();
        return this.updateDataScanAsync(request);
    }

    public final OperationFuture<DataScan, OperationMetadata> updateDataScanAsync(UpdateDataScanRequest request) {
        return this.updateDataScanOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateDataScanRequest, DataScan, OperationMetadata> updateDataScanOperationCallable() {
        return this.stub.updateDataScanOperationCallable();
    }

    public final UnaryCallable<UpdateDataScanRequest, Operation> updateDataScanCallable() {
        return this.stub.updateDataScanCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteDataScanAsync(DataScanName name) {
        DeleteDataScanRequest request = DeleteDataScanRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteDataScanAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteDataScanAsync(String name) {
        DeleteDataScanRequest request = DeleteDataScanRequest.newBuilder().setName(name).build();
        return this.deleteDataScanAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteDataScanAsync(DeleteDataScanRequest request) {
        return this.deleteDataScanOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteDataScanRequest, Empty, OperationMetadata> deleteDataScanOperationCallable() {
        return this.stub.deleteDataScanOperationCallable();
    }

    public final UnaryCallable<DeleteDataScanRequest, Operation> deleteDataScanCallable() {
        return this.stub.deleteDataScanCallable();
    }

    public final DataScan getDataScan(DataScanName name) {
        GetDataScanRequest request = GetDataScanRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getDataScan(request);
    }

    public final DataScan getDataScan(String name) {
        GetDataScanRequest request = GetDataScanRequest.newBuilder().setName(name).build();
        return this.getDataScan(request);
    }

    public final DataScan getDataScan(GetDataScanRequest request) {
        return (DataScan)this.getDataScanCallable().call((Object)request);
    }

    public final UnaryCallable<GetDataScanRequest, DataScan> getDataScanCallable() {
        return this.stub.getDataScanCallable();
    }

    public final ListDataScansPagedResponse listDataScans(LocationName parent) {
        ListDataScansRequest request = ListDataScansRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listDataScans(request);
    }

    public final ListDataScansPagedResponse listDataScans(String parent) {
        ListDataScansRequest request = ListDataScansRequest.newBuilder().setParent(parent).build();
        return this.listDataScans(request);
    }

    public final ListDataScansPagedResponse listDataScans(ListDataScansRequest request) {
        return (ListDataScansPagedResponse)((Object)this.listDataScansPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListDataScansRequest, ListDataScansPagedResponse> listDataScansPagedCallable() {
        return this.stub.listDataScansPagedCallable();
    }

    public final UnaryCallable<ListDataScansRequest, ListDataScansResponse> listDataScansCallable() {
        return this.stub.listDataScansCallable();
    }

    public final RunDataScanResponse runDataScan(DataScanName name) {
        RunDataScanRequest request = RunDataScanRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.runDataScan(request);
    }

    public final RunDataScanResponse runDataScan(String name) {
        RunDataScanRequest request = RunDataScanRequest.newBuilder().setName(name).build();
        return this.runDataScan(request);
    }

    public final RunDataScanResponse runDataScan(RunDataScanRequest request) {
        return (RunDataScanResponse)this.runDataScanCallable().call((Object)request);
    }

    public final UnaryCallable<RunDataScanRequest, RunDataScanResponse> runDataScanCallable() {
        return this.stub.runDataScanCallable();
    }

    public final DataScanJob getDataScanJob(DataScanJobName name) {
        GetDataScanJobRequest request = GetDataScanJobRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getDataScanJob(request);
    }

    public final DataScanJob getDataScanJob(String name) {
        GetDataScanJobRequest request = GetDataScanJobRequest.newBuilder().setName(name).build();
        return this.getDataScanJob(request);
    }

    public final DataScanJob getDataScanJob(GetDataScanJobRequest request) {
        return (DataScanJob)this.getDataScanJobCallable().call((Object)request);
    }

    public final UnaryCallable<GetDataScanJobRequest, DataScanJob> getDataScanJobCallable() {
        return this.stub.getDataScanJobCallable();
    }

    public final ListDataScanJobsPagedResponse listDataScanJobs(DataScanName parent) {
        ListDataScanJobsRequest request = ListDataScanJobsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listDataScanJobs(request);
    }

    public final ListDataScanJobsPagedResponse listDataScanJobs(String parent) {
        ListDataScanJobsRequest request = ListDataScanJobsRequest.newBuilder().setParent(parent).build();
        return this.listDataScanJobs(request);
    }

    public final ListDataScanJobsPagedResponse listDataScanJobs(ListDataScanJobsRequest request) {
        return (ListDataScanJobsPagedResponse)((Object)this.listDataScanJobsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListDataScanJobsRequest, ListDataScanJobsPagedResponse> listDataScanJobsPagedCallable() {
        return this.stub.listDataScanJobsPagedCallable();
    }

    public final UnaryCallable<ListDataScanJobsRequest, ListDataScanJobsResponse> listDataScanJobsCallable() {
        return this.stub.listDataScanJobsCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListDataScanJobsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListDataScanJobsRequest, ListDataScanJobsResponse, DataScanJob, ListDataScanJobsPage, ListDataScanJobsFixedSizeCollection> {
        private ListDataScanJobsFixedSizeCollection(List<ListDataScanJobsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListDataScanJobsFixedSizeCollection createEmptyCollection() {
            return new ListDataScanJobsFixedSizeCollection(null, 0);
        }

        protected ListDataScanJobsFixedSizeCollection createCollection(List<ListDataScanJobsPage> pages, int collectionSize) {
            return new ListDataScanJobsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListDataScanJobsPage
    extends AbstractPage<ListDataScanJobsRequest, ListDataScanJobsResponse, DataScanJob, ListDataScanJobsPage> {
        private ListDataScanJobsPage(PageContext<ListDataScanJobsRequest, ListDataScanJobsResponse, DataScanJob> context, ListDataScanJobsResponse response) {
            super(context, (Object)response);
        }

        private static ListDataScanJobsPage createEmptyPage() {
            return new ListDataScanJobsPage(null, null);
        }

        protected ListDataScanJobsPage createPage(PageContext<ListDataScanJobsRequest, ListDataScanJobsResponse, DataScanJob> context, ListDataScanJobsResponse response) {
            return new ListDataScanJobsPage(context, response);
        }

        public ApiFuture<ListDataScanJobsPage> createPageAsync(PageContext<ListDataScanJobsRequest, ListDataScanJobsResponse, DataScanJob> context, ApiFuture<ListDataScanJobsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListDataScanJobsPagedResponse
    extends AbstractPagedListResponse<ListDataScanJobsRequest, ListDataScanJobsResponse, DataScanJob, ListDataScanJobsPage, ListDataScanJobsFixedSizeCollection> {
        public static ApiFuture<ListDataScanJobsPagedResponse> createAsync(PageContext<ListDataScanJobsRequest, ListDataScanJobsResponse, DataScanJob> context, ApiFuture<ListDataScanJobsResponse> futureResponse) {
            ApiFuture<ListDataScanJobsPage> futurePage = ListDataScanJobsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListDataScanJobsPagedResponse((ListDataScanJobsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListDataScanJobsPagedResponse(ListDataScanJobsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListDataScanJobsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListDataScansFixedSizeCollection
    extends AbstractFixedSizeCollection<ListDataScansRequest, ListDataScansResponse, DataScan, ListDataScansPage, ListDataScansFixedSizeCollection> {
        private ListDataScansFixedSizeCollection(List<ListDataScansPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListDataScansFixedSizeCollection createEmptyCollection() {
            return new ListDataScansFixedSizeCollection(null, 0);
        }

        protected ListDataScansFixedSizeCollection createCollection(List<ListDataScansPage> pages, int collectionSize) {
            return new ListDataScansFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListDataScansPage
    extends AbstractPage<ListDataScansRequest, ListDataScansResponse, DataScan, ListDataScansPage> {
        private ListDataScansPage(PageContext<ListDataScansRequest, ListDataScansResponse, DataScan> context, ListDataScansResponse response) {
            super(context, (Object)response);
        }

        private static ListDataScansPage createEmptyPage() {
            return new ListDataScansPage(null, null);
        }

        protected ListDataScansPage createPage(PageContext<ListDataScansRequest, ListDataScansResponse, DataScan> context, ListDataScansResponse response) {
            return new ListDataScansPage(context, response);
        }

        public ApiFuture<ListDataScansPage> createPageAsync(PageContext<ListDataScansRequest, ListDataScansResponse, DataScan> context, ApiFuture<ListDataScansResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListDataScansPagedResponse
    extends AbstractPagedListResponse<ListDataScansRequest, ListDataScansResponse, DataScan, ListDataScansPage, ListDataScansFixedSizeCollection> {
        public static ApiFuture<ListDataScansPagedResponse> createAsync(PageContext<ListDataScansRequest, ListDataScansResponse, DataScan> context, ApiFuture<ListDataScansResponse> futureResponse) {
            ApiFuture<ListDataScansPage> futurePage = ListDataScansPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListDataScansPagedResponse((ListDataScansPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListDataScansPagedResponse(ListDataScansPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListDataScansFixedSizeCollection.createEmptyCollection());
        }
    }
}

