/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datacatalog.lineage.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.datacatalog.lineage.v1.BatchSearchLinkProcessesRequest;
import com.google.cloud.datacatalog.lineage.v1.BatchSearchLinkProcessesResponse;
import com.google.cloud.datacatalog.lineage.v1.CreateLineageEventRequest;
import com.google.cloud.datacatalog.lineage.v1.CreateProcessRequest;
import com.google.cloud.datacatalog.lineage.v1.CreateRunRequest;
import com.google.cloud.datacatalog.lineage.v1.DeleteLineageEventRequest;
import com.google.cloud.datacatalog.lineage.v1.DeleteProcessRequest;
import com.google.cloud.datacatalog.lineage.v1.DeleteRunRequest;
import com.google.cloud.datacatalog.lineage.v1.GetLineageEventRequest;
import com.google.cloud.datacatalog.lineage.v1.GetProcessRequest;
import com.google.cloud.datacatalog.lineage.v1.GetRunRequest;
import com.google.cloud.datacatalog.lineage.v1.LineageClient;
import com.google.cloud.datacatalog.lineage.v1.LineageEvent;
import com.google.cloud.datacatalog.lineage.v1.Link;
import com.google.cloud.datacatalog.lineage.v1.ListLineageEventsRequest;
import com.google.cloud.datacatalog.lineage.v1.ListLineageEventsResponse;
import com.google.cloud.datacatalog.lineage.v1.ListProcessesRequest;
import com.google.cloud.datacatalog.lineage.v1.ListProcessesResponse;
import com.google.cloud.datacatalog.lineage.v1.ListRunsRequest;
import com.google.cloud.datacatalog.lineage.v1.ListRunsResponse;
import com.google.cloud.datacatalog.lineage.v1.OperationMetadata;
import com.google.cloud.datacatalog.lineage.v1.Process;
import com.google.cloud.datacatalog.lineage.v1.ProcessLinks;
import com.google.cloud.datacatalog.lineage.v1.ProcessOpenLineageRunEventRequest;
import com.google.cloud.datacatalog.lineage.v1.ProcessOpenLineageRunEventResponse;
import com.google.cloud.datacatalog.lineage.v1.Run;
import com.google.cloud.datacatalog.lineage.v1.SearchLinksRequest;
import com.google.cloud.datacatalog.lineage.v1.SearchLinksResponse;
import com.google.cloud.datacatalog.lineage.v1.UpdateProcessRequest;
import com.google.cloud.datacatalog.lineage.v1.UpdateRunRequest;
import com.google.cloud.datacatalog.lineage.v1.stub.GrpcLineageStub;
import com.google.cloud.datacatalog.lineage.v1.stub.HttpJsonLineageStub;
import com.google.cloud.datacatalog.lineage.v1.stub.LineageStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class LineageStubSettings
extends StubSettings<LineageStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<ProcessOpenLineageRunEventRequest, ProcessOpenLineageRunEventResponse> processOpenLineageRunEventSettings;
    private final UnaryCallSettings<CreateProcessRequest, Process> createProcessSettings;
    private final UnaryCallSettings<UpdateProcessRequest, Process> updateProcessSettings;
    private final UnaryCallSettings<GetProcessRequest, Process> getProcessSettings;
    private final PagedCallSettings<ListProcessesRequest, ListProcessesResponse, LineageClient.ListProcessesPagedResponse> listProcessesSettings;
    private final UnaryCallSettings<DeleteProcessRequest, Operation> deleteProcessSettings;
    private final OperationCallSettings<DeleteProcessRequest, Empty, OperationMetadata> deleteProcessOperationSettings;
    private final UnaryCallSettings<CreateRunRequest, Run> createRunSettings;
    private final UnaryCallSettings<UpdateRunRequest, Run> updateRunSettings;
    private final UnaryCallSettings<GetRunRequest, Run> getRunSettings;
    private final PagedCallSettings<ListRunsRequest, ListRunsResponse, LineageClient.ListRunsPagedResponse> listRunsSettings;
    private final UnaryCallSettings<DeleteRunRequest, Operation> deleteRunSettings;
    private final OperationCallSettings<DeleteRunRequest, Empty, OperationMetadata> deleteRunOperationSettings;
    private final UnaryCallSettings<CreateLineageEventRequest, LineageEvent> createLineageEventSettings;
    private final UnaryCallSettings<GetLineageEventRequest, LineageEvent> getLineageEventSettings;
    private final PagedCallSettings<ListLineageEventsRequest, ListLineageEventsResponse, LineageClient.ListLineageEventsPagedResponse> listLineageEventsSettings;
    private final UnaryCallSettings<DeleteLineageEventRequest, Empty> deleteLineageEventSettings;
    private final PagedCallSettings<SearchLinksRequest, SearchLinksResponse, LineageClient.SearchLinksPagedResponse> searchLinksSettings;
    private final PagedCallSettings<BatchSearchLinkProcessesRequest, BatchSearchLinkProcessesResponse, LineageClient.BatchSearchLinkProcessesPagedResponse> batchSearchLinkProcessesSettings;
    private static final PagedListDescriptor<ListProcessesRequest, ListProcessesResponse, Process> LIST_PROCESSES_PAGE_STR_DESC = new PagedListDescriptor<ListProcessesRequest, ListProcessesResponse, Process>(){

        public String emptyToken() {
            return "";
        }

        public ListProcessesRequest injectToken(ListProcessesRequest payload, String token) {
            return ListProcessesRequest.newBuilder((ListProcessesRequest)payload).setPageToken(token).build();
        }

        public ListProcessesRequest injectPageSize(ListProcessesRequest payload, int pageSize) {
            return ListProcessesRequest.newBuilder((ListProcessesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListProcessesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListProcessesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Process> extractResources(ListProcessesResponse payload) {
            return payload.getProcessesList() == null ? ImmutableList.of() : payload.getProcessesList();
        }
    };
    private static final PagedListDescriptor<ListRunsRequest, ListRunsResponse, Run> LIST_RUNS_PAGE_STR_DESC = new PagedListDescriptor<ListRunsRequest, ListRunsResponse, Run>(){

        public String emptyToken() {
            return "";
        }

        public ListRunsRequest injectToken(ListRunsRequest payload, String token) {
            return ListRunsRequest.newBuilder((ListRunsRequest)payload).setPageToken(token).build();
        }

        public ListRunsRequest injectPageSize(ListRunsRequest payload, int pageSize) {
            return ListRunsRequest.newBuilder((ListRunsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListRunsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListRunsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Run> extractResources(ListRunsResponse payload) {
            return payload.getRunsList() == null ? ImmutableList.of() : payload.getRunsList();
        }
    };
    private static final PagedListDescriptor<ListLineageEventsRequest, ListLineageEventsResponse, LineageEvent> LIST_LINEAGE_EVENTS_PAGE_STR_DESC = new PagedListDescriptor<ListLineageEventsRequest, ListLineageEventsResponse, LineageEvent>(){

        public String emptyToken() {
            return "";
        }

        public ListLineageEventsRequest injectToken(ListLineageEventsRequest payload, String token) {
            return ListLineageEventsRequest.newBuilder((ListLineageEventsRequest)payload).setPageToken(token).build();
        }

        public ListLineageEventsRequest injectPageSize(ListLineageEventsRequest payload, int pageSize) {
            return ListLineageEventsRequest.newBuilder((ListLineageEventsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLineageEventsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLineageEventsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<LineageEvent> extractResources(ListLineageEventsResponse payload) {
            return payload.getLineageEventsList() == null ? ImmutableList.of() : payload.getLineageEventsList();
        }
    };
    private static final PagedListDescriptor<SearchLinksRequest, SearchLinksResponse, Link> SEARCH_LINKS_PAGE_STR_DESC = new PagedListDescriptor<SearchLinksRequest, SearchLinksResponse, Link>(){

        public String emptyToken() {
            return "";
        }

        public SearchLinksRequest injectToken(SearchLinksRequest payload, String token) {
            return SearchLinksRequest.newBuilder((SearchLinksRequest)payload).setPageToken(token).build();
        }

        public SearchLinksRequest injectPageSize(SearchLinksRequest payload, int pageSize) {
            return SearchLinksRequest.newBuilder((SearchLinksRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(SearchLinksRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(SearchLinksResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Link> extractResources(SearchLinksResponse payload) {
            return payload.getLinksList() == null ? ImmutableList.of() : payload.getLinksList();
        }
    };
    private static final PagedListDescriptor<BatchSearchLinkProcessesRequest, BatchSearchLinkProcessesResponse, ProcessLinks> BATCH_SEARCH_LINK_PROCESSES_PAGE_STR_DESC = new PagedListDescriptor<BatchSearchLinkProcessesRequest, BatchSearchLinkProcessesResponse, ProcessLinks>(){

        public String emptyToken() {
            return "";
        }

        public BatchSearchLinkProcessesRequest injectToken(BatchSearchLinkProcessesRequest payload, String token) {
            return BatchSearchLinkProcessesRequest.newBuilder((BatchSearchLinkProcessesRequest)payload).setPageToken(token).build();
        }

        public BatchSearchLinkProcessesRequest injectPageSize(BatchSearchLinkProcessesRequest payload, int pageSize) {
            return BatchSearchLinkProcessesRequest.newBuilder((BatchSearchLinkProcessesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(BatchSearchLinkProcessesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(BatchSearchLinkProcessesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<ProcessLinks> extractResources(BatchSearchLinkProcessesResponse payload) {
            return payload.getProcessLinksList() == null ? ImmutableList.of() : payload.getProcessLinksList();
        }
    };
    private static final PagedListResponseFactory<ListProcessesRequest, ListProcessesResponse, LineageClient.ListProcessesPagedResponse> LIST_PROCESSES_PAGE_STR_FACT = new PagedListResponseFactory<ListProcessesRequest, ListProcessesResponse, LineageClient.ListProcessesPagedResponse>(){

        public ApiFuture<LineageClient.ListProcessesPagedResponse> getFuturePagedResponse(UnaryCallable<ListProcessesRequest, ListProcessesResponse> callable, ListProcessesRequest request, ApiCallContext context, ApiFuture<ListProcessesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PROCESSES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return LineageClient.ListProcessesPagedResponse.createAsync((PageContext<ListProcessesRequest, ListProcessesResponse, Process>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListRunsRequest, ListRunsResponse, LineageClient.ListRunsPagedResponse> LIST_RUNS_PAGE_STR_FACT = new PagedListResponseFactory<ListRunsRequest, ListRunsResponse, LineageClient.ListRunsPagedResponse>(){

        public ApiFuture<LineageClient.ListRunsPagedResponse> getFuturePagedResponse(UnaryCallable<ListRunsRequest, ListRunsResponse> callable, ListRunsRequest request, ApiCallContext context, ApiFuture<ListRunsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_RUNS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return LineageClient.ListRunsPagedResponse.createAsync((PageContext<ListRunsRequest, ListRunsResponse, Run>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLineageEventsRequest, ListLineageEventsResponse, LineageClient.ListLineageEventsPagedResponse> LIST_LINEAGE_EVENTS_PAGE_STR_FACT = new PagedListResponseFactory<ListLineageEventsRequest, ListLineageEventsResponse, LineageClient.ListLineageEventsPagedResponse>(){

        public ApiFuture<LineageClient.ListLineageEventsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLineageEventsRequest, ListLineageEventsResponse> callable, ListLineageEventsRequest request, ApiCallContext context, ApiFuture<ListLineageEventsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LINEAGE_EVENTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return LineageClient.ListLineageEventsPagedResponse.createAsync((PageContext<ListLineageEventsRequest, ListLineageEventsResponse, LineageEvent>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<SearchLinksRequest, SearchLinksResponse, LineageClient.SearchLinksPagedResponse> SEARCH_LINKS_PAGE_STR_FACT = new PagedListResponseFactory<SearchLinksRequest, SearchLinksResponse, LineageClient.SearchLinksPagedResponse>(){

        public ApiFuture<LineageClient.SearchLinksPagedResponse> getFuturePagedResponse(UnaryCallable<SearchLinksRequest, SearchLinksResponse> callable, SearchLinksRequest request, ApiCallContext context, ApiFuture<SearchLinksResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)SEARCH_LINKS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return LineageClient.SearchLinksPagedResponse.createAsync((PageContext<SearchLinksRequest, SearchLinksResponse, Link>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<BatchSearchLinkProcessesRequest, BatchSearchLinkProcessesResponse, LineageClient.BatchSearchLinkProcessesPagedResponse> BATCH_SEARCH_LINK_PROCESSES_PAGE_STR_FACT = new PagedListResponseFactory<BatchSearchLinkProcessesRequest, BatchSearchLinkProcessesResponse, LineageClient.BatchSearchLinkProcessesPagedResponse>(){

        public ApiFuture<LineageClient.BatchSearchLinkProcessesPagedResponse> getFuturePagedResponse(UnaryCallable<BatchSearchLinkProcessesRequest, BatchSearchLinkProcessesResponse> callable, BatchSearchLinkProcessesRequest request, ApiCallContext context, ApiFuture<BatchSearchLinkProcessesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)BATCH_SEARCH_LINK_PROCESSES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return LineageClient.BatchSearchLinkProcessesPagedResponse.createAsync((PageContext<BatchSearchLinkProcessesRequest, BatchSearchLinkProcessesResponse, ProcessLinks>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<ProcessOpenLineageRunEventRequest, ProcessOpenLineageRunEventResponse> processOpenLineageRunEventSettings() {
        return this.processOpenLineageRunEventSettings;
    }

    public UnaryCallSettings<CreateProcessRequest, Process> createProcessSettings() {
        return this.createProcessSettings;
    }

    public UnaryCallSettings<UpdateProcessRequest, Process> updateProcessSettings() {
        return this.updateProcessSettings;
    }

    public UnaryCallSettings<GetProcessRequest, Process> getProcessSettings() {
        return this.getProcessSettings;
    }

    public PagedCallSettings<ListProcessesRequest, ListProcessesResponse, LineageClient.ListProcessesPagedResponse> listProcessesSettings() {
        return this.listProcessesSettings;
    }

    public UnaryCallSettings<DeleteProcessRequest, Operation> deleteProcessSettings() {
        return this.deleteProcessSettings;
    }

    public OperationCallSettings<DeleteProcessRequest, Empty, OperationMetadata> deleteProcessOperationSettings() {
        return this.deleteProcessOperationSettings;
    }

    public UnaryCallSettings<CreateRunRequest, Run> createRunSettings() {
        return this.createRunSettings;
    }

    public UnaryCallSettings<UpdateRunRequest, Run> updateRunSettings() {
        return this.updateRunSettings;
    }

    public UnaryCallSettings<GetRunRequest, Run> getRunSettings() {
        return this.getRunSettings;
    }

    public PagedCallSettings<ListRunsRequest, ListRunsResponse, LineageClient.ListRunsPagedResponse> listRunsSettings() {
        return this.listRunsSettings;
    }

    public UnaryCallSettings<DeleteRunRequest, Operation> deleteRunSettings() {
        return this.deleteRunSettings;
    }

    public OperationCallSettings<DeleteRunRequest, Empty, OperationMetadata> deleteRunOperationSettings() {
        return this.deleteRunOperationSettings;
    }

    public UnaryCallSettings<CreateLineageEventRequest, LineageEvent> createLineageEventSettings() {
        return this.createLineageEventSettings;
    }

    public UnaryCallSettings<GetLineageEventRequest, LineageEvent> getLineageEventSettings() {
        return this.getLineageEventSettings;
    }

    public PagedCallSettings<ListLineageEventsRequest, ListLineageEventsResponse, LineageClient.ListLineageEventsPagedResponse> listLineageEventsSettings() {
        return this.listLineageEventsSettings;
    }

    public UnaryCallSettings<DeleteLineageEventRequest, Empty> deleteLineageEventSettings() {
        return this.deleteLineageEventSettings;
    }

    public PagedCallSettings<SearchLinksRequest, SearchLinksResponse, LineageClient.SearchLinksPagedResponse> searchLinksSettings() {
        return this.searchLinksSettings;
    }

    public PagedCallSettings<BatchSearchLinkProcessesRequest, BatchSearchLinkProcessesResponse, LineageClient.BatchSearchLinkProcessesPagedResponse> batchSearchLinkProcessesSettings() {
        return this.batchSearchLinkProcessesSettings;
    }

    public LineageStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcLineageStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonLineageStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "datalineage.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "datalineage.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return LineageStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(LineageStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(LineageStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return LineageStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected LineageStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.processOpenLineageRunEventSettings = settingsBuilder.processOpenLineageRunEventSettings().build();
        this.createProcessSettings = settingsBuilder.createProcessSettings().build();
        this.updateProcessSettings = settingsBuilder.updateProcessSettings().build();
        this.getProcessSettings = settingsBuilder.getProcessSettings().build();
        this.listProcessesSettings = settingsBuilder.listProcessesSettings().build();
        this.deleteProcessSettings = settingsBuilder.deleteProcessSettings().build();
        this.deleteProcessOperationSettings = settingsBuilder.deleteProcessOperationSettings().build();
        this.createRunSettings = settingsBuilder.createRunSettings().build();
        this.updateRunSettings = settingsBuilder.updateRunSettings().build();
        this.getRunSettings = settingsBuilder.getRunSettings().build();
        this.listRunsSettings = settingsBuilder.listRunsSettings().build();
        this.deleteRunSettings = settingsBuilder.deleteRunSettings().build();
        this.deleteRunOperationSettings = settingsBuilder.deleteRunOperationSettings().build();
        this.createLineageEventSettings = settingsBuilder.createLineageEventSettings().build();
        this.getLineageEventSettings = settingsBuilder.getLineageEventSettings().build();
        this.listLineageEventsSettings = settingsBuilder.listLineageEventsSettings().build();
        this.deleteLineageEventSettings = settingsBuilder.deleteLineageEventSettings().build();
        this.searchLinksSettings = settingsBuilder.searchLinksSettings().build();
        this.batchSearchLinkProcessesSettings = settingsBuilder.batchSearchLinkProcessesSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<LineageStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<ProcessOpenLineageRunEventRequest, ProcessOpenLineageRunEventResponse> processOpenLineageRunEventSettings;
        private final UnaryCallSettings.Builder<CreateProcessRequest, Process> createProcessSettings;
        private final UnaryCallSettings.Builder<UpdateProcessRequest, Process> updateProcessSettings;
        private final UnaryCallSettings.Builder<GetProcessRequest, Process> getProcessSettings;
        private final PagedCallSettings.Builder<ListProcessesRequest, ListProcessesResponse, LineageClient.ListProcessesPagedResponse> listProcessesSettings;
        private final UnaryCallSettings.Builder<DeleteProcessRequest, Operation> deleteProcessSettings;
        private final OperationCallSettings.Builder<DeleteProcessRequest, Empty, OperationMetadata> deleteProcessOperationSettings;
        private final UnaryCallSettings.Builder<CreateRunRequest, Run> createRunSettings;
        private final UnaryCallSettings.Builder<UpdateRunRequest, Run> updateRunSettings;
        private final UnaryCallSettings.Builder<GetRunRequest, Run> getRunSettings;
        private final PagedCallSettings.Builder<ListRunsRequest, ListRunsResponse, LineageClient.ListRunsPagedResponse> listRunsSettings;
        private final UnaryCallSettings.Builder<DeleteRunRequest, Operation> deleteRunSettings;
        private final OperationCallSettings.Builder<DeleteRunRequest, Empty, OperationMetadata> deleteRunOperationSettings;
        private final UnaryCallSettings.Builder<CreateLineageEventRequest, LineageEvent> createLineageEventSettings;
        private final UnaryCallSettings.Builder<GetLineageEventRequest, LineageEvent> getLineageEventSettings;
        private final PagedCallSettings.Builder<ListLineageEventsRequest, ListLineageEventsResponse, LineageClient.ListLineageEventsPagedResponse> listLineageEventsSettings;
        private final UnaryCallSettings.Builder<DeleteLineageEventRequest, Empty> deleteLineageEventSettings;
        private final PagedCallSettings.Builder<SearchLinksRequest, SearchLinksResponse, LineageClient.SearchLinksPagedResponse> searchLinksSettings;
        private final PagedCallSettings.Builder<BatchSearchLinkProcessesRequest, BatchSearchLinkProcessesResponse, LineageClient.BatchSearchLinkProcessesPagedResponse> batchSearchLinkProcessesSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.processOpenLineageRunEventSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createProcessSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateProcessSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getProcessSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listProcessesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PROCESSES_PAGE_STR_FACT);
            this.deleteProcessSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteProcessOperationSettings = OperationCallSettings.newBuilder();
            this.createRunSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateRunSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getRunSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listRunsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_RUNS_PAGE_STR_FACT);
            this.deleteRunSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteRunOperationSettings = OperationCallSettings.newBuilder();
            this.createLineageEventSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getLineageEventSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listLineageEventsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LINEAGE_EVENTS_PAGE_STR_FACT);
            this.deleteLineageEventSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.searchLinksSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)SEARCH_LINKS_PAGE_STR_FACT);
            this.batchSearchLinkProcessesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)BATCH_SEARCH_LINK_PROCESSES_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.processOpenLineageRunEventSettings, this.createProcessSettings, this.updateProcessSettings, this.getProcessSettings, this.listProcessesSettings, this.deleteProcessSettings, this.createRunSettings, this.updateRunSettings, this.getRunSettings, this.listRunsSettings, this.deleteRunSettings, this.createLineageEventSettings, (Object[])new UnaryCallSettings.Builder[]{this.getLineageEventSettings, this.listLineageEventsSettings, this.deleteLineageEventSettings, this.searchLinksSettings, this.batchSearchLinkProcessesSettings});
            Builder.initDefaults(this);
        }

        protected Builder(LineageStubSettings settings) {
            super((StubSettings)settings);
            this.processOpenLineageRunEventSettings = settings.processOpenLineageRunEventSettings.toBuilder();
            this.createProcessSettings = settings.createProcessSettings.toBuilder();
            this.updateProcessSettings = settings.updateProcessSettings.toBuilder();
            this.getProcessSettings = settings.getProcessSettings.toBuilder();
            this.listProcessesSettings = settings.listProcessesSettings.toBuilder();
            this.deleteProcessSettings = settings.deleteProcessSettings.toBuilder();
            this.deleteProcessOperationSettings = settings.deleteProcessOperationSettings.toBuilder();
            this.createRunSettings = settings.createRunSettings.toBuilder();
            this.updateRunSettings = settings.updateRunSettings.toBuilder();
            this.getRunSettings = settings.getRunSettings.toBuilder();
            this.listRunsSettings = settings.listRunsSettings.toBuilder();
            this.deleteRunSettings = settings.deleteRunSettings.toBuilder();
            this.deleteRunOperationSettings = settings.deleteRunOperationSettings.toBuilder();
            this.createLineageEventSettings = settings.createLineageEventSettings.toBuilder();
            this.getLineageEventSettings = settings.getLineageEventSettings.toBuilder();
            this.listLineageEventsSettings = settings.listLineageEventsSettings.toBuilder();
            this.deleteLineageEventSettings = settings.deleteLineageEventSettings.toBuilder();
            this.searchLinksSettings = settings.searchLinksSettings.toBuilder();
            this.batchSearchLinkProcessesSettings = settings.batchSearchLinkProcessesSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.processOpenLineageRunEventSettings, this.createProcessSettings, this.updateProcessSettings, this.getProcessSettings, this.listProcessesSettings, this.deleteProcessSettings, this.createRunSettings, this.updateRunSettings, this.getRunSettings, this.listRunsSettings, this.deleteRunSettings, this.createLineageEventSettings, (Object[])new UnaryCallSettings.Builder[]{this.getLineageEventSettings, this.listLineageEventsSettings, this.deleteLineageEventSettings, this.searchLinksSettings, this.batchSearchLinkProcessesSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(LineageStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)LineageStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)LineageStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(LineageStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(LineageStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)LineageStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)LineageStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)LineageStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(LineageStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(LineageStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.processOpenLineageRunEventSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createProcessSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateProcessSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getProcessSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listProcessesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteProcessSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createRunSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateRunSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getRunSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listRunsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteRunSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createLineageEventSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getLineageEventSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listLineageEventsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteLineageEventSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.searchLinksSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.batchSearchLinkProcessesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteProcessOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteRunOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<ProcessOpenLineageRunEventRequest, ProcessOpenLineageRunEventResponse> processOpenLineageRunEventSettings() {
            return this.processOpenLineageRunEventSettings;
        }

        public UnaryCallSettings.Builder<CreateProcessRequest, Process> createProcessSettings() {
            return this.createProcessSettings;
        }

        public UnaryCallSettings.Builder<UpdateProcessRequest, Process> updateProcessSettings() {
            return this.updateProcessSettings;
        }

        public UnaryCallSettings.Builder<GetProcessRequest, Process> getProcessSettings() {
            return this.getProcessSettings;
        }

        public PagedCallSettings.Builder<ListProcessesRequest, ListProcessesResponse, LineageClient.ListProcessesPagedResponse> listProcessesSettings() {
            return this.listProcessesSettings;
        }

        public UnaryCallSettings.Builder<DeleteProcessRequest, Operation> deleteProcessSettings() {
            return this.deleteProcessSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteProcessRequest, Empty, OperationMetadata> deleteProcessOperationSettings() {
            return this.deleteProcessOperationSettings;
        }

        public UnaryCallSettings.Builder<CreateRunRequest, Run> createRunSettings() {
            return this.createRunSettings;
        }

        public UnaryCallSettings.Builder<UpdateRunRequest, Run> updateRunSettings() {
            return this.updateRunSettings;
        }

        public UnaryCallSettings.Builder<GetRunRequest, Run> getRunSettings() {
            return this.getRunSettings;
        }

        public PagedCallSettings.Builder<ListRunsRequest, ListRunsResponse, LineageClient.ListRunsPagedResponse> listRunsSettings() {
            return this.listRunsSettings;
        }

        public UnaryCallSettings.Builder<DeleteRunRequest, Operation> deleteRunSettings() {
            return this.deleteRunSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteRunRequest, Empty, OperationMetadata> deleteRunOperationSettings() {
            return this.deleteRunOperationSettings;
        }

        public UnaryCallSettings.Builder<CreateLineageEventRequest, LineageEvent> createLineageEventSettings() {
            return this.createLineageEventSettings;
        }

        public UnaryCallSettings.Builder<GetLineageEventRequest, LineageEvent> getLineageEventSettings() {
            return this.getLineageEventSettings;
        }

        public PagedCallSettings.Builder<ListLineageEventsRequest, ListLineageEventsResponse, LineageClient.ListLineageEventsPagedResponse> listLineageEventsSettings() {
            return this.listLineageEventsSettings;
        }

        public UnaryCallSettings.Builder<DeleteLineageEventRequest, Empty> deleteLineageEventSettings() {
            return this.deleteLineageEventSettings;
        }

        public PagedCallSettings.Builder<SearchLinksRequest, SearchLinksResponse, LineageClient.SearchLinksPagedResponse> searchLinksSettings() {
            return this.searchLinksSettings;
        }

        public PagedCallSettings.Builder<BatchSearchLinkProcessesRequest, BatchSearchLinkProcessesResponse, LineageClient.BatchSearchLinkProcessesPagedResponse> batchSearchLinkProcessesSettings() {
            return this.batchSearchLinkProcessesSettings;
        }

        public LineageStubSettings build() throws IOException {
            return new LineageStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

