/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datalabeling.v1beta1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.pathtemplate.PathTemplate;
import com.google.cloud.datalabeling.v1beta1.AnnotatedDataset;
import com.google.cloud.datalabeling.v1beta1.AnnotationSpecSet;
import com.google.cloud.datalabeling.v1beta1.CreateAnnotationSpecSetRequest;
import com.google.cloud.datalabeling.v1beta1.CreateDatasetRequest;
import com.google.cloud.datalabeling.v1beta1.CreateEvaluationJobRequest;
import com.google.cloud.datalabeling.v1beta1.CreateInstructionMetadata;
import com.google.cloud.datalabeling.v1beta1.CreateInstructionRequest;
import com.google.cloud.datalabeling.v1beta1.DataItem;
import com.google.cloud.datalabeling.v1beta1.DataLabelingServiceSettings;
import com.google.cloud.datalabeling.v1beta1.Dataset;
import com.google.cloud.datalabeling.v1beta1.DeleteAnnotatedDatasetRequest;
import com.google.cloud.datalabeling.v1beta1.DeleteAnnotationSpecSetRequest;
import com.google.cloud.datalabeling.v1beta1.DeleteDatasetRequest;
import com.google.cloud.datalabeling.v1beta1.DeleteEvaluationJobRequest;
import com.google.cloud.datalabeling.v1beta1.DeleteInstructionRequest;
import com.google.cloud.datalabeling.v1beta1.Evaluation;
import com.google.cloud.datalabeling.v1beta1.EvaluationJob;
import com.google.cloud.datalabeling.v1beta1.Example;
import com.google.cloud.datalabeling.v1beta1.ExportDataOperationMetadata;
import com.google.cloud.datalabeling.v1beta1.ExportDataOperationResponse;
import com.google.cloud.datalabeling.v1beta1.ExportDataRequest;
import com.google.cloud.datalabeling.v1beta1.GetAnnotatedDatasetRequest;
import com.google.cloud.datalabeling.v1beta1.GetAnnotationSpecSetRequest;
import com.google.cloud.datalabeling.v1beta1.GetDataItemRequest;
import com.google.cloud.datalabeling.v1beta1.GetDatasetRequest;
import com.google.cloud.datalabeling.v1beta1.GetEvaluationJobRequest;
import com.google.cloud.datalabeling.v1beta1.GetEvaluationRequest;
import com.google.cloud.datalabeling.v1beta1.GetExampleRequest;
import com.google.cloud.datalabeling.v1beta1.GetInstructionRequest;
import com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig;
import com.google.cloud.datalabeling.v1beta1.ImportDataOperationMetadata;
import com.google.cloud.datalabeling.v1beta1.ImportDataOperationResponse;
import com.google.cloud.datalabeling.v1beta1.ImportDataRequest;
import com.google.cloud.datalabeling.v1beta1.InputConfig;
import com.google.cloud.datalabeling.v1beta1.Instruction;
import com.google.cloud.datalabeling.v1beta1.LabelImageRequest;
import com.google.cloud.datalabeling.v1beta1.LabelOperationMetadata;
import com.google.cloud.datalabeling.v1beta1.LabelTextRequest;
import com.google.cloud.datalabeling.v1beta1.LabelVideoRequest;
import com.google.cloud.datalabeling.v1beta1.ListAnnotatedDatasetsRequest;
import com.google.cloud.datalabeling.v1beta1.ListAnnotatedDatasetsResponse;
import com.google.cloud.datalabeling.v1beta1.ListAnnotationSpecSetsRequest;
import com.google.cloud.datalabeling.v1beta1.ListAnnotationSpecSetsResponse;
import com.google.cloud.datalabeling.v1beta1.ListDataItemsRequest;
import com.google.cloud.datalabeling.v1beta1.ListDataItemsResponse;
import com.google.cloud.datalabeling.v1beta1.ListDatasetsRequest;
import com.google.cloud.datalabeling.v1beta1.ListDatasetsResponse;
import com.google.cloud.datalabeling.v1beta1.ListEvaluationJobsRequest;
import com.google.cloud.datalabeling.v1beta1.ListEvaluationJobsResponse;
import com.google.cloud.datalabeling.v1beta1.ListExamplesRequest;
import com.google.cloud.datalabeling.v1beta1.ListExamplesResponse;
import com.google.cloud.datalabeling.v1beta1.ListInstructionsRequest;
import com.google.cloud.datalabeling.v1beta1.ListInstructionsResponse;
import com.google.cloud.datalabeling.v1beta1.OutputConfig;
import com.google.cloud.datalabeling.v1beta1.PauseEvaluationJobRequest;
import com.google.cloud.datalabeling.v1beta1.ResumeEvaluationJobRequest;
import com.google.cloud.datalabeling.v1beta1.SearchEvaluationsRequest;
import com.google.cloud.datalabeling.v1beta1.SearchEvaluationsResponse;
import com.google.cloud.datalabeling.v1beta1.SearchExampleComparisonsRequest;
import com.google.cloud.datalabeling.v1beta1.SearchExampleComparisonsResponse;
import com.google.cloud.datalabeling.v1beta1.UpdateEvaluationJobRequest;
import com.google.cloud.datalabeling.v1beta1.stub.DataLabelingServiceStub;
import com.google.cloud.datalabeling.v1beta1.stub.DataLabelingServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class DataLabelingServiceClient
implements BackgroundResource {
    private final DataLabelingServiceSettings settings;
    private final DataLabelingServiceStub stub;
    private final OperationsClient operationsClient;
    private static final PathTemplate ANNOTATED_DATASET_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/datasets/{dataset}/annotatedDatasets/{annotated_dataset}");
    private static final PathTemplate ANNOTATION_SPEC_SET_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/annotationSpecSets/{annotation_spec_set}");
    private static final PathTemplate DATA_ITEM_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/datasets/{dataset}/dataItems/{data_item}");
    private static final PathTemplate DATASET_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/datasets/{dataset}");
    private static final PathTemplate EVALUATION_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/datasets/{dataset}/evaluations/{evaluation}");
    private static final PathTemplate EVALUATION_JOB_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/evaluationJobs/{evaluation_job}");
    private static final PathTemplate EXAMPLE_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/datasets/{dataset}/annotatedDatasets/{annotated_dataset}/examples/{example}");
    private static final PathTemplate INSTRUCTION_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/instructions/{instruction}");
    private static final PathTemplate PROJECT_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}");

    @Deprecated
    public static final String formatAnnotatedDatasetName(String project, String dataset, String annotatedDataset) {
        return ANNOTATED_DATASET_PATH_TEMPLATE.instantiate(new String[]{"project", project, "dataset", dataset, "annotated_dataset", annotatedDataset});
    }

    @Deprecated
    public static final String formatAnnotationSpecSetName(String project, String annotationSpecSet) {
        return ANNOTATION_SPEC_SET_PATH_TEMPLATE.instantiate(new String[]{"project", project, "annotation_spec_set", annotationSpecSet});
    }

    @Deprecated
    public static final String formatDataItemName(String project, String dataset, String dataItem) {
        return DATA_ITEM_PATH_TEMPLATE.instantiate(new String[]{"project", project, "dataset", dataset, "data_item", dataItem});
    }

    @Deprecated
    public static final String formatDatasetName(String project, String dataset) {
        return DATASET_PATH_TEMPLATE.instantiate(new String[]{"project", project, "dataset", dataset});
    }

    @Deprecated
    public static final String formatEvaluationName(String project, String dataset, String evaluation) {
        return EVALUATION_PATH_TEMPLATE.instantiate(new String[]{"project", project, "dataset", dataset, "evaluation", evaluation});
    }

    @Deprecated
    public static final String formatEvaluationJobName(String project, String evaluationJob) {
        return EVALUATION_JOB_PATH_TEMPLATE.instantiate(new String[]{"project", project, "evaluation_job", evaluationJob});
    }

    @Deprecated
    public static final String formatExampleName(String project, String dataset, String annotatedDataset, String example) {
        return EXAMPLE_PATH_TEMPLATE.instantiate(new String[]{"project", project, "dataset", dataset, "annotated_dataset", annotatedDataset, "example", example});
    }

    @Deprecated
    public static final String formatInstructionName(String project, String instruction) {
        return INSTRUCTION_PATH_TEMPLATE.instantiate(new String[]{"project", project, "instruction", instruction});
    }

    @Deprecated
    public static final String formatProjectName(String project) {
        return PROJECT_PATH_TEMPLATE.instantiate(new String[]{"project", project});
    }

    @Deprecated
    public static final String parseProjectFromAnnotatedDatasetName(String annotatedDatasetName) {
        return ANNOTATED_DATASET_PATH_TEMPLATE.parse(annotatedDatasetName).get((Object)"project");
    }

    @Deprecated
    public static final String parseDatasetFromAnnotatedDatasetName(String annotatedDatasetName) {
        return ANNOTATED_DATASET_PATH_TEMPLATE.parse(annotatedDatasetName).get((Object)"dataset");
    }

    @Deprecated
    public static final String parseAnnotatedDatasetFromAnnotatedDatasetName(String annotatedDatasetName) {
        return ANNOTATED_DATASET_PATH_TEMPLATE.parse(annotatedDatasetName).get((Object)"annotated_dataset");
    }

    @Deprecated
    public static final String parseProjectFromAnnotationSpecSetName(String annotationSpecSetName) {
        return ANNOTATION_SPEC_SET_PATH_TEMPLATE.parse(annotationSpecSetName).get((Object)"project");
    }

    @Deprecated
    public static final String parseAnnotationSpecSetFromAnnotationSpecSetName(String annotationSpecSetName) {
        return ANNOTATION_SPEC_SET_PATH_TEMPLATE.parse(annotationSpecSetName).get((Object)"annotation_spec_set");
    }

    @Deprecated
    public static final String parseProjectFromDataItemName(String dataItemName) {
        return DATA_ITEM_PATH_TEMPLATE.parse(dataItemName).get((Object)"project");
    }

    @Deprecated
    public static final String parseDatasetFromDataItemName(String dataItemName) {
        return DATA_ITEM_PATH_TEMPLATE.parse(dataItemName).get((Object)"dataset");
    }

    @Deprecated
    public static final String parseDataItemFromDataItemName(String dataItemName) {
        return DATA_ITEM_PATH_TEMPLATE.parse(dataItemName).get((Object)"data_item");
    }

    @Deprecated
    public static final String parseProjectFromDatasetName(String datasetName) {
        return DATASET_PATH_TEMPLATE.parse(datasetName).get((Object)"project");
    }

    @Deprecated
    public static final String parseDatasetFromDatasetName(String datasetName) {
        return DATASET_PATH_TEMPLATE.parse(datasetName).get((Object)"dataset");
    }

    @Deprecated
    public static final String parseProjectFromEvaluationName(String evaluationName) {
        return EVALUATION_PATH_TEMPLATE.parse(evaluationName).get((Object)"project");
    }

    @Deprecated
    public static final String parseDatasetFromEvaluationName(String evaluationName) {
        return EVALUATION_PATH_TEMPLATE.parse(evaluationName).get((Object)"dataset");
    }

    @Deprecated
    public static final String parseEvaluationFromEvaluationName(String evaluationName) {
        return EVALUATION_PATH_TEMPLATE.parse(evaluationName).get((Object)"evaluation");
    }

    @Deprecated
    public static final String parseProjectFromEvaluationJobName(String evaluationJobName) {
        return EVALUATION_JOB_PATH_TEMPLATE.parse(evaluationJobName).get((Object)"project");
    }

    @Deprecated
    public static final String parseEvaluationJobFromEvaluationJobName(String evaluationJobName) {
        return EVALUATION_JOB_PATH_TEMPLATE.parse(evaluationJobName).get((Object)"evaluation_job");
    }

    @Deprecated
    public static final String parseProjectFromExampleName(String exampleName) {
        return EXAMPLE_PATH_TEMPLATE.parse(exampleName).get((Object)"project");
    }

    @Deprecated
    public static final String parseDatasetFromExampleName(String exampleName) {
        return EXAMPLE_PATH_TEMPLATE.parse(exampleName).get((Object)"dataset");
    }

    @Deprecated
    public static final String parseAnnotatedDatasetFromExampleName(String exampleName) {
        return EXAMPLE_PATH_TEMPLATE.parse(exampleName).get((Object)"annotated_dataset");
    }

    @Deprecated
    public static final String parseExampleFromExampleName(String exampleName) {
        return EXAMPLE_PATH_TEMPLATE.parse(exampleName).get((Object)"example");
    }

    @Deprecated
    public static final String parseProjectFromInstructionName(String instructionName) {
        return INSTRUCTION_PATH_TEMPLATE.parse(instructionName).get((Object)"project");
    }

    @Deprecated
    public static final String parseInstructionFromInstructionName(String instructionName) {
        return INSTRUCTION_PATH_TEMPLATE.parse(instructionName).get((Object)"instruction");
    }

    @Deprecated
    public static final String parseProjectFromProjectName(String projectName) {
        return PROJECT_PATH_TEMPLATE.parse(projectName).get((Object)"project");
    }

    public static final DataLabelingServiceClient create() throws IOException {
        return DataLabelingServiceClient.create(DataLabelingServiceSettings.newBuilder().build());
    }

    public static final DataLabelingServiceClient create(DataLabelingServiceSettings settings) throws IOException {
        return new DataLabelingServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final DataLabelingServiceClient create(DataLabelingServiceStub stub) {
        return new DataLabelingServiceClient(stub);
    }

    protected DataLabelingServiceClient(DataLabelingServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((DataLabelingServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected DataLabelingServiceClient(DataLabelingServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final DataLabelingServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public DataLabelingServiceStub getStub() {
        return this.stub;
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final Dataset createDataset(String parent, Dataset dataset) {
        PROJECT_PATH_TEMPLATE.validate(parent, "createDataset");
        CreateDatasetRequest request = CreateDatasetRequest.newBuilder().setParent(parent).setDataset(dataset).build();
        return this.createDataset(request);
    }

    public final Dataset createDataset(CreateDatasetRequest request) {
        return (Dataset)this.createDatasetCallable().call((Object)request);
    }

    public final UnaryCallable<CreateDatasetRequest, Dataset> createDatasetCallable() {
        return this.stub.createDatasetCallable();
    }

    public final Dataset getDataset(String name) {
        DATASET_PATH_TEMPLATE.validate(name, "getDataset");
        GetDatasetRequest request = GetDatasetRequest.newBuilder().setName(name).build();
        return this.getDataset(request);
    }

    public final Dataset getDataset(GetDatasetRequest request) {
        return (Dataset)this.getDatasetCallable().call((Object)request);
    }

    public final UnaryCallable<GetDatasetRequest, Dataset> getDatasetCallable() {
        return this.stub.getDatasetCallable();
    }

    public final ListDatasetsPagedResponse listDatasets(String parent, String filter) {
        PROJECT_PATH_TEMPLATE.validate(parent, "listDatasets");
        ListDatasetsRequest request = ListDatasetsRequest.newBuilder().setParent(parent).setFilter(filter).build();
        return this.listDatasets(request);
    }

    public final ListDatasetsPagedResponse listDatasets(ListDatasetsRequest request) {
        return (ListDatasetsPagedResponse)((Object)this.listDatasetsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListDatasetsRequest, ListDatasetsPagedResponse> listDatasetsPagedCallable() {
        return this.stub.listDatasetsPagedCallable();
    }

    public final UnaryCallable<ListDatasetsRequest, ListDatasetsResponse> listDatasetsCallable() {
        return this.stub.listDatasetsCallable();
    }

    public final void deleteDataset(String name) {
        DATASET_PATH_TEMPLATE.validate(name, "deleteDataset");
        DeleteDatasetRequest request = DeleteDatasetRequest.newBuilder().setName(name).build();
        this.deleteDataset(request);
    }

    public final void deleteDataset(DeleteDatasetRequest request) {
        this.deleteDatasetCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteDatasetRequest, Empty> deleteDatasetCallable() {
        return this.stub.deleteDatasetCallable();
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<ImportDataOperationResponse, ImportDataOperationMetadata> importDataAsync(String name, InputConfig inputConfig) {
        DATASET_PATH_TEMPLATE.validate(name, "importData");
        ImportDataRequest request = ImportDataRequest.newBuilder().setName(name).setInputConfig(inputConfig).build();
        return this.importDataAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<ImportDataOperationResponse, ImportDataOperationMetadata> importDataAsync(ImportDataRequest request) {
        return this.importDataOperationCallable().futureCall((Object)request);
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public final OperationCallable<ImportDataRequest, ImportDataOperationResponse, ImportDataOperationMetadata> importDataOperationCallable() {
        return this.stub.importDataOperationCallable();
    }

    public final UnaryCallable<ImportDataRequest, Operation> importDataCallable() {
        return this.stub.importDataCallable();
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<ExportDataOperationResponse, ExportDataOperationMetadata> exportDataAsync(String name, String annotatedDataset, String filter, OutputConfig outputConfig) {
        DATASET_PATH_TEMPLATE.validate(name, "exportData");
        ExportDataRequest request = ExportDataRequest.newBuilder().setName(name).setAnnotatedDataset(annotatedDataset).setFilter(filter).setOutputConfig(outputConfig).build();
        return this.exportDataAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<ExportDataOperationResponse, ExportDataOperationMetadata> exportDataAsync(ExportDataRequest request) {
        return this.exportDataOperationCallable().futureCall((Object)request);
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public final OperationCallable<ExportDataRequest, ExportDataOperationResponse, ExportDataOperationMetadata> exportDataOperationCallable() {
        return this.stub.exportDataOperationCallable();
    }

    public final UnaryCallable<ExportDataRequest, Operation> exportDataCallable() {
        return this.stub.exportDataCallable();
    }

    public final DataItem getDataItem(String name) {
        DATA_ITEM_PATH_TEMPLATE.validate(name, "getDataItem");
        GetDataItemRequest request = GetDataItemRequest.newBuilder().setName(name).build();
        return this.getDataItem(request);
    }

    public final DataItem getDataItem(GetDataItemRequest request) {
        return (DataItem)this.getDataItemCallable().call((Object)request);
    }

    public final UnaryCallable<GetDataItemRequest, DataItem> getDataItemCallable() {
        return this.stub.getDataItemCallable();
    }

    public final ListDataItemsPagedResponse listDataItems(String parent, String filter) {
        DATASET_PATH_TEMPLATE.validate(parent, "listDataItems");
        ListDataItemsRequest request = ListDataItemsRequest.newBuilder().setParent(parent).setFilter(filter).build();
        return this.listDataItems(request);
    }

    public final ListDataItemsPagedResponse listDataItems(ListDataItemsRequest request) {
        return (ListDataItemsPagedResponse)((Object)this.listDataItemsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListDataItemsRequest, ListDataItemsPagedResponse> listDataItemsPagedCallable() {
        return this.stub.listDataItemsPagedCallable();
    }

    public final UnaryCallable<ListDataItemsRequest, ListDataItemsResponse> listDataItemsCallable() {
        return this.stub.listDataItemsCallable();
    }

    public final AnnotatedDataset getAnnotatedDataset(String name) {
        ANNOTATED_DATASET_PATH_TEMPLATE.validate(name, "getAnnotatedDataset");
        GetAnnotatedDatasetRequest request = GetAnnotatedDatasetRequest.newBuilder().setName(name).build();
        return this.getAnnotatedDataset(request);
    }

    public final AnnotatedDataset getAnnotatedDataset(GetAnnotatedDatasetRequest request) {
        return (AnnotatedDataset)this.getAnnotatedDatasetCallable().call((Object)request);
    }

    public final UnaryCallable<GetAnnotatedDatasetRequest, AnnotatedDataset> getAnnotatedDatasetCallable() {
        return this.stub.getAnnotatedDatasetCallable();
    }

    public final ListAnnotatedDatasetsPagedResponse listAnnotatedDatasets(String parent, String filter) {
        DATASET_PATH_TEMPLATE.validate(parent, "listAnnotatedDatasets");
        ListAnnotatedDatasetsRequest request = ListAnnotatedDatasetsRequest.newBuilder().setParent(parent).setFilter(filter).build();
        return this.listAnnotatedDatasets(request);
    }

    public final ListAnnotatedDatasetsPagedResponse listAnnotatedDatasets(ListAnnotatedDatasetsRequest request) {
        return (ListAnnotatedDatasetsPagedResponse)((Object)this.listAnnotatedDatasetsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListAnnotatedDatasetsRequest, ListAnnotatedDatasetsPagedResponse> listAnnotatedDatasetsPagedCallable() {
        return this.stub.listAnnotatedDatasetsPagedCallable();
    }

    public final UnaryCallable<ListAnnotatedDatasetsRequest, ListAnnotatedDatasetsResponse> listAnnotatedDatasetsCallable() {
        return this.stub.listAnnotatedDatasetsCallable();
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<AnnotatedDataset, LabelOperationMetadata> labelImageAsync(String parent, HumanAnnotationConfig basicConfig, LabelImageRequest.Feature feature) {
        DATASET_PATH_TEMPLATE.validate(parent, "labelImage");
        LabelImageRequest request = LabelImageRequest.newBuilder().setParent(parent).setBasicConfig(basicConfig).setFeature(feature).build();
        return this.labelImageAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<AnnotatedDataset, LabelOperationMetadata> labelImageAsync(LabelImageRequest request) {
        return this.labelImageOperationCallable().futureCall((Object)request);
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public final OperationCallable<LabelImageRequest, AnnotatedDataset, LabelOperationMetadata> labelImageOperationCallable() {
        return this.stub.labelImageOperationCallable();
    }

    public final UnaryCallable<LabelImageRequest, Operation> labelImageCallable() {
        return this.stub.labelImageCallable();
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<AnnotatedDataset, LabelOperationMetadata> labelVideoAsync(String parent, HumanAnnotationConfig basicConfig, LabelVideoRequest.Feature feature) {
        DATASET_PATH_TEMPLATE.validate(parent, "labelVideo");
        LabelVideoRequest request = LabelVideoRequest.newBuilder().setParent(parent).setBasicConfig(basicConfig).setFeature(feature).build();
        return this.labelVideoAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<AnnotatedDataset, LabelOperationMetadata> labelVideoAsync(LabelVideoRequest request) {
        return this.labelVideoOperationCallable().futureCall((Object)request);
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public final OperationCallable<LabelVideoRequest, AnnotatedDataset, LabelOperationMetadata> labelVideoOperationCallable() {
        return this.stub.labelVideoOperationCallable();
    }

    public final UnaryCallable<LabelVideoRequest, Operation> labelVideoCallable() {
        return this.stub.labelVideoCallable();
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<AnnotatedDataset, LabelOperationMetadata> labelTextAsync(String parent, HumanAnnotationConfig basicConfig, LabelTextRequest.Feature feature) {
        DATASET_PATH_TEMPLATE.validate(parent, "labelText");
        LabelTextRequest request = LabelTextRequest.newBuilder().setParent(parent).setBasicConfig(basicConfig).setFeature(feature).build();
        return this.labelTextAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<AnnotatedDataset, LabelOperationMetadata> labelTextAsync(LabelTextRequest request) {
        return this.labelTextOperationCallable().futureCall((Object)request);
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public final OperationCallable<LabelTextRequest, AnnotatedDataset, LabelOperationMetadata> labelTextOperationCallable() {
        return this.stub.labelTextOperationCallable();
    }

    public final UnaryCallable<LabelTextRequest, Operation> labelTextCallable() {
        return this.stub.labelTextCallable();
    }

    public final Example getExample(String name, String filter) {
        EXAMPLE_PATH_TEMPLATE.validate(name, "getExample");
        GetExampleRequest request = GetExampleRequest.newBuilder().setName(name).setFilter(filter).build();
        return this.getExample(request);
    }

    public final Example getExample(GetExampleRequest request) {
        return (Example)this.getExampleCallable().call((Object)request);
    }

    public final UnaryCallable<GetExampleRequest, Example> getExampleCallable() {
        return this.stub.getExampleCallable();
    }

    public final ListExamplesPagedResponse listExamples(String parent, String filter) {
        ANNOTATED_DATASET_PATH_TEMPLATE.validate(parent, "listExamples");
        ListExamplesRequest request = ListExamplesRequest.newBuilder().setParent(parent).setFilter(filter).build();
        return this.listExamples(request);
    }

    public final ListExamplesPagedResponse listExamples(ListExamplesRequest request) {
        return (ListExamplesPagedResponse)((Object)this.listExamplesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListExamplesRequest, ListExamplesPagedResponse> listExamplesPagedCallable() {
        return this.stub.listExamplesPagedCallable();
    }

    public final UnaryCallable<ListExamplesRequest, ListExamplesResponse> listExamplesCallable() {
        return this.stub.listExamplesCallable();
    }

    public final AnnotationSpecSet createAnnotationSpecSet(String parent, AnnotationSpecSet annotationSpecSet) {
        PROJECT_PATH_TEMPLATE.validate(parent, "createAnnotationSpecSet");
        CreateAnnotationSpecSetRequest request = CreateAnnotationSpecSetRequest.newBuilder().setParent(parent).setAnnotationSpecSet(annotationSpecSet).build();
        return this.createAnnotationSpecSet(request);
    }

    public final AnnotationSpecSet createAnnotationSpecSet(CreateAnnotationSpecSetRequest request) {
        return (AnnotationSpecSet)this.createAnnotationSpecSetCallable().call((Object)request);
    }

    public final UnaryCallable<CreateAnnotationSpecSetRequest, AnnotationSpecSet> createAnnotationSpecSetCallable() {
        return this.stub.createAnnotationSpecSetCallable();
    }

    public final AnnotationSpecSet getAnnotationSpecSet(String name) {
        ANNOTATION_SPEC_SET_PATH_TEMPLATE.validate(name, "getAnnotationSpecSet");
        GetAnnotationSpecSetRequest request = GetAnnotationSpecSetRequest.newBuilder().setName(name).build();
        return this.getAnnotationSpecSet(request);
    }

    public final AnnotationSpecSet getAnnotationSpecSet(GetAnnotationSpecSetRequest request) {
        return (AnnotationSpecSet)this.getAnnotationSpecSetCallable().call((Object)request);
    }

    public final UnaryCallable<GetAnnotationSpecSetRequest, AnnotationSpecSet> getAnnotationSpecSetCallable() {
        return this.stub.getAnnotationSpecSetCallable();
    }

    public final ListAnnotationSpecSetsPagedResponse listAnnotationSpecSets(String parent, String filter) {
        PROJECT_PATH_TEMPLATE.validate(parent, "listAnnotationSpecSets");
        ListAnnotationSpecSetsRequest request = ListAnnotationSpecSetsRequest.newBuilder().setParent(parent).setFilter(filter).build();
        return this.listAnnotationSpecSets(request);
    }

    public final ListAnnotationSpecSetsPagedResponse listAnnotationSpecSets(ListAnnotationSpecSetsRequest request) {
        return (ListAnnotationSpecSetsPagedResponse)((Object)this.listAnnotationSpecSetsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListAnnotationSpecSetsRequest, ListAnnotationSpecSetsPagedResponse> listAnnotationSpecSetsPagedCallable() {
        return this.stub.listAnnotationSpecSetsPagedCallable();
    }

    public final UnaryCallable<ListAnnotationSpecSetsRequest, ListAnnotationSpecSetsResponse> listAnnotationSpecSetsCallable() {
        return this.stub.listAnnotationSpecSetsCallable();
    }

    public final void deleteAnnotationSpecSet(String name) {
        ANNOTATION_SPEC_SET_PATH_TEMPLATE.validate(name, "deleteAnnotationSpecSet");
        DeleteAnnotationSpecSetRequest request = DeleteAnnotationSpecSetRequest.newBuilder().setName(name).build();
        this.deleteAnnotationSpecSet(request);
    }

    public final void deleteAnnotationSpecSet(DeleteAnnotationSpecSetRequest request) {
        this.deleteAnnotationSpecSetCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteAnnotationSpecSetRequest, Empty> deleteAnnotationSpecSetCallable() {
        return this.stub.deleteAnnotationSpecSetCallable();
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Instruction, CreateInstructionMetadata> createInstructionAsync(String parent, Instruction instruction) {
        PROJECT_PATH_TEMPLATE.validate(parent, "createInstruction");
        CreateInstructionRequest request = CreateInstructionRequest.newBuilder().setParent(parent).setInstruction(instruction).build();
        return this.createInstructionAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Instruction, CreateInstructionMetadata> createInstructionAsync(CreateInstructionRequest request) {
        return this.createInstructionOperationCallable().futureCall((Object)request);
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public final OperationCallable<CreateInstructionRequest, Instruction, CreateInstructionMetadata> createInstructionOperationCallable() {
        return this.stub.createInstructionOperationCallable();
    }

    public final UnaryCallable<CreateInstructionRequest, Operation> createInstructionCallable() {
        return this.stub.createInstructionCallable();
    }

    public final Instruction getInstruction(String name) {
        INSTRUCTION_PATH_TEMPLATE.validate(name, "getInstruction");
        GetInstructionRequest request = GetInstructionRequest.newBuilder().setName(name).build();
        return this.getInstruction(request);
    }

    public final Instruction getInstruction(GetInstructionRequest request) {
        return (Instruction)this.getInstructionCallable().call((Object)request);
    }

    public final UnaryCallable<GetInstructionRequest, Instruction> getInstructionCallable() {
        return this.stub.getInstructionCallable();
    }

    public final ListInstructionsPagedResponse listInstructions(String parent, String filter) {
        PROJECT_PATH_TEMPLATE.validate(parent, "listInstructions");
        ListInstructionsRequest request = ListInstructionsRequest.newBuilder().setParent(parent).setFilter(filter).build();
        return this.listInstructions(request);
    }

    public final ListInstructionsPagedResponse listInstructions(ListInstructionsRequest request) {
        return (ListInstructionsPagedResponse)((Object)this.listInstructionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListInstructionsRequest, ListInstructionsPagedResponse> listInstructionsPagedCallable() {
        return this.stub.listInstructionsPagedCallable();
    }

    public final UnaryCallable<ListInstructionsRequest, ListInstructionsResponse> listInstructionsCallable() {
        return this.stub.listInstructionsCallable();
    }

    public final void deleteInstruction(String name) {
        INSTRUCTION_PATH_TEMPLATE.validate(name, "deleteInstruction");
        DeleteInstructionRequest request = DeleteInstructionRequest.newBuilder().setName(name).build();
        this.deleteInstruction(request);
    }

    public final void deleteInstruction(DeleteInstructionRequest request) {
        this.deleteInstructionCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteInstructionRequest, Empty> deleteInstructionCallable() {
        return this.stub.deleteInstructionCallable();
    }

    public final Evaluation getEvaluation(String name) {
        EVALUATION_PATH_TEMPLATE.validate(name, "getEvaluation");
        GetEvaluationRequest request = GetEvaluationRequest.newBuilder().setName(name).build();
        return this.getEvaluation(request);
    }

    public final Evaluation getEvaluation(GetEvaluationRequest request) {
        return (Evaluation)this.getEvaluationCallable().call((Object)request);
    }

    public final UnaryCallable<GetEvaluationRequest, Evaluation> getEvaluationCallable() {
        return this.stub.getEvaluationCallable();
    }

    public final SearchEvaluationsPagedResponse searchEvaluations(String parent, String filter) {
        PROJECT_PATH_TEMPLATE.validate(parent, "searchEvaluations");
        SearchEvaluationsRequest request = SearchEvaluationsRequest.newBuilder().setParent(parent).setFilter(filter).build();
        return this.searchEvaluations(request);
    }

    public final SearchEvaluationsPagedResponse searchEvaluations(SearchEvaluationsRequest request) {
        return (SearchEvaluationsPagedResponse)((Object)this.searchEvaluationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<SearchEvaluationsRequest, SearchEvaluationsPagedResponse> searchEvaluationsPagedCallable() {
        return this.stub.searchEvaluationsPagedCallable();
    }

    public final UnaryCallable<SearchEvaluationsRequest, SearchEvaluationsResponse> searchEvaluationsCallable() {
        return this.stub.searchEvaluationsCallable();
    }

    public final SearchExampleComparisonsPagedResponse searchExampleComparisons(String parent) {
        EVALUATION_PATH_TEMPLATE.validate(parent, "searchExampleComparisons");
        SearchExampleComparisonsRequest request = SearchExampleComparisonsRequest.newBuilder().setParent(parent).build();
        return this.searchExampleComparisons(request);
    }

    public final SearchExampleComparisonsPagedResponse searchExampleComparisons(SearchExampleComparisonsRequest request) {
        return (SearchExampleComparisonsPagedResponse)((Object)this.searchExampleComparisonsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<SearchExampleComparisonsRequest, SearchExampleComparisonsPagedResponse> searchExampleComparisonsPagedCallable() {
        return this.stub.searchExampleComparisonsPagedCallable();
    }

    public final UnaryCallable<SearchExampleComparisonsRequest, SearchExampleComparisonsResponse> searchExampleComparisonsCallable() {
        return this.stub.searchExampleComparisonsCallable();
    }

    public final EvaluationJob createEvaluationJob(String parent, EvaluationJob job) {
        PROJECT_PATH_TEMPLATE.validate(parent, "createEvaluationJob");
        CreateEvaluationJobRequest request = CreateEvaluationJobRequest.newBuilder().setParent(parent).setJob(job).build();
        return this.createEvaluationJob(request);
    }

    public final EvaluationJob createEvaluationJob(CreateEvaluationJobRequest request) {
        return (EvaluationJob)this.createEvaluationJobCallable().call((Object)request);
    }

    public final UnaryCallable<CreateEvaluationJobRequest, EvaluationJob> createEvaluationJobCallable() {
        return this.stub.createEvaluationJobCallable();
    }

    public final EvaluationJob updateEvaluationJob(EvaluationJob evaluationJob, FieldMask updateMask) {
        UpdateEvaluationJobRequest request = UpdateEvaluationJobRequest.newBuilder().setEvaluationJob(evaluationJob).setUpdateMask(updateMask).build();
        return this.updateEvaluationJob(request);
    }

    public final EvaluationJob updateEvaluationJob(UpdateEvaluationJobRequest request) {
        return (EvaluationJob)this.updateEvaluationJobCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateEvaluationJobRequest, EvaluationJob> updateEvaluationJobCallable() {
        return this.stub.updateEvaluationJobCallable();
    }

    public final EvaluationJob getEvaluationJob(String name) {
        EVALUATION_JOB_PATH_TEMPLATE.validate(name, "getEvaluationJob");
        GetEvaluationJobRequest request = GetEvaluationJobRequest.newBuilder().setName(name).build();
        return this.getEvaluationJob(request);
    }

    public final EvaluationJob getEvaluationJob(GetEvaluationJobRequest request) {
        return (EvaluationJob)this.getEvaluationJobCallable().call((Object)request);
    }

    public final UnaryCallable<GetEvaluationJobRequest, EvaluationJob> getEvaluationJobCallable() {
        return this.stub.getEvaluationJobCallable();
    }

    public final void pauseEvaluationJob(String name) {
        EVALUATION_JOB_PATH_TEMPLATE.validate(name, "pauseEvaluationJob");
        PauseEvaluationJobRequest request = PauseEvaluationJobRequest.newBuilder().setName(name).build();
        this.pauseEvaluationJob(request);
    }

    public final void pauseEvaluationJob(PauseEvaluationJobRequest request) {
        this.pauseEvaluationJobCallable().call((Object)request);
    }

    public final UnaryCallable<PauseEvaluationJobRequest, Empty> pauseEvaluationJobCallable() {
        return this.stub.pauseEvaluationJobCallable();
    }

    public final void resumeEvaluationJob(String name) {
        EVALUATION_JOB_PATH_TEMPLATE.validate(name, "resumeEvaluationJob");
        ResumeEvaluationJobRequest request = ResumeEvaluationJobRequest.newBuilder().setName(name).build();
        this.resumeEvaluationJob(request);
    }

    public final void resumeEvaluationJob(ResumeEvaluationJobRequest request) {
        this.resumeEvaluationJobCallable().call((Object)request);
    }

    public final UnaryCallable<ResumeEvaluationJobRequest, Empty> resumeEvaluationJobCallable() {
        return this.stub.resumeEvaluationJobCallable();
    }

    public final void deleteEvaluationJob(String name) {
        EVALUATION_JOB_PATH_TEMPLATE.validate(name, "deleteEvaluationJob");
        DeleteEvaluationJobRequest request = DeleteEvaluationJobRequest.newBuilder().setName(name).build();
        this.deleteEvaluationJob(request);
    }

    public final void deleteEvaluationJob(DeleteEvaluationJobRequest request) {
        this.deleteEvaluationJobCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteEvaluationJobRequest, Empty> deleteEvaluationJobCallable() {
        return this.stub.deleteEvaluationJobCallable();
    }

    public final ListEvaluationJobsPagedResponse listEvaluationJobs(String parent, String filter) {
        PROJECT_PATH_TEMPLATE.validate(parent, "listEvaluationJobs");
        ListEvaluationJobsRequest request = ListEvaluationJobsRequest.newBuilder().setParent(parent).setFilter(filter).build();
        return this.listEvaluationJobs(request);
    }

    public final ListEvaluationJobsPagedResponse listEvaluationJobs(ListEvaluationJobsRequest request) {
        return (ListEvaluationJobsPagedResponse)((Object)this.listEvaluationJobsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListEvaluationJobsRequest, ListEvaluationJobsPagedResponse> listEvaluationJobsPagedCallable() {
        return this.stub.listEvaluationJobsPagedCallable();
    }

    public final UnaryCallable<ListEvaluationJobsRequest, ListEvaluationJobsResponse> listEvaluationJobsCallable() {
        return this.stub.listEvaluationJobsCallable();
    }

    public final void deleteAnnotatedDataset(DeleteAnnotatedDatasetRequest request) {
        this.deleteAnnotatedDatasetCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteAnnotatedDatasetRequest, Empty> deleteAnnotatedDatasetCallable() {
        return this.stub.deleteAnnotatedDatasetCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListEvaluationJobsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListEvaluationJobsRequest, ListEvaluationJobsResponse, EvaluationJob, ListEvaluationJobsPage, ListEvaluationJobsFixedSizeCollection> {
        private ListEvaluationJobsFixedSizeCollection(List<ListEvaluationJobsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListEvaluationJobsFixedSizeCollection createEmptyCollection() {
            return new ListEvaluationJobsFixedSizeCollection(null, 0);
        }

        protected ListEvaluationJobsFixedSizeCollection createCollection(List<ListEvaluationJobsPage> pages, int collectionSize) {
            return new ListEvaluationJobsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListEvaluationJobsPage
    extends AbstractPage<ListEvaluationJobsRequest, ListEvaluationJobsResponse, EvaluationJob, ListEvaluationJobsPage> {
        private ListEvaluationJobsPage(PageContext<ListEvaluationJobsRequest, ListEvaluationJobsResponse, EvaluationJob> context, ListEvaluationJobsResponse response) {
            super(context, (Object)response);
        }

        private static ListEvaluationJobsPage createEmptyPage() {
            return new ListEvaluationJobsPage(null, null);
        }

        protected ListEvaluationJobsPage createPage(PageContext<ListEvaluationJobsRequest, ListEvaluationJobsResponse, EvaluationJob> context, ListEvaluationJobsResponse response) {
            return new ListEvaluationJobsPage(context, response);
        }

        public ApiFuture<ListEvaluationJobsPage> createPageAsync(PageContext<ListEvaluationJobsRequest, ListEvaluationJobsResponse, EvaluationJob> context, ApiFuture<ListEvaluationJobsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListEvaluationJobsPagedResponse
    extends AbstractPagedListResponse<ListEvaluationJobsRequest, ListEvaluationJobsResponse, EvaluationJob, ListEvaluationJobsPage, ListEvaluationJobsFixedSizeCollection> {
        public static ApiFuture<ListEvaluationJobsPagedResponse> createAsync(PageContext<ListEvaluationJobsRequest, ListEvaluationJobsResponse, EvaluationJob> context, ApiFuture<ListEvaluationJobsResponse> futureResponse) {
            ApiFuture<ListEvaluationJobsPage> futurePage = ListEvaluationJobsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListEvaluationJobsPage, ListEvaluationJobsPagedResponse>(){

                public ListEvaluationJobsPagedResponse apply(ListEvaluationJobsPage input) {
                    return new ListEvaluationJobsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListEvaluationJobsPagedResponse(ListEvaluationJobsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListEvaluationJobsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class SearchExampleComparisonsFixedSizeCollection
    extends AbstractFixedSizeCollection<SearchExampleComparisonsRequest, SearchExampleComparisonsResponse, SearchExampleComparisonsResponse.ExampleComparison, SearchExampleComparisonsPage, SearchExampleComparisonsFixedSizeCollection> {
        private SearchExampleComparisonsFixedSizeCollection(List<SearchExampleComparisonsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static SearchExampleComparisonsFixedSizeCollection createEmptyCollection() {
            return new SearchExampleComparisonsFixedSizeCollection(null, 0);
        }

        protected SearchExampleComparisonsFixedSizeCollection createCollection(List<SearchExampleComparisonsPage> pages, int collectionSize) {
            return new SearchExampleComparisonsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class SearchExampleComparisonsPage
    extends AbstractPage<SearchExampleComparisonsRequest, SearchExampleComparisonsResponse, SearchExampleComparisonsResponse.ExampleComparison, SearchExampleComparisonsPage> {
        private SearchExampleComparisonsPage(PageContext<SearchExampleComparisonsRequest, SearchExampleComparisonsResponse, SearchExampleComparisonsResponse.ExampleComparison> context, SearchExampleComparisonsResponse response) {
            super(context, (Object)response);
        }

        private static SearchExampleComparisonsPage createEmptyPage() {
            return new SearchExampleComparisonsPage(null, null);
        }

        protected SearchExampleComparisonsPage createPage(PageContext<SearchExampleComparisonsRequest, SearchExampleComparisonsResponse, SearchExampleComparisonsResponse.ExampleComparison> context, SearchExampleComparisonsResponse response) {
            return new SearchExampleComparisonsPage(context, response);
        }

        public ApiFuture<SearchExampleComparisonsPage> createPageAsync(PageContext<SearchExampleComparisonsRequest, SearchExampleComparisonsResponse, SearchExampleComparisonsResponse.ExampleComparison> context, ApiFuture<SearchExampleComparisonsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class SearchExampleComparisonsPagedResponse
    extends AbstractPagedListResponse<SearchExampleComparisonsRequest, SearchExampleComparisonsResponse, SearchExampleComparisonsResponse.ExampleComparison, SearchExampleComparisonsPage, SearchExampleComparisonsFixedSizeCollection> {
        public static ApiFuture<SearchExampleComparisonsPagedResponse> createAsync(PageContext<SearchExampleComparisonsRequest, SearchExampleComparisonsResponse, SearchExampleComparisonsResponse.ExampleComparison> context, ApiFuture<SearchExampleComparisonsResponse> futureResponse) {
            ApiFuture<SearchExampleComparisonsPage> futurePage = SearchExampleComparisonsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<SearchExampleComparisonsPage, SearchExampleComparisonsPagedResponse>(){

                public SearchExampleComparisonsPagedResponse apply(SearchExampleComparisonsPage input) {
                    return new SearchExampleComparisonsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private SearchExampleComparisonsPagedResponse(SearchExampleComparisonsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)SearchExampleComparisonsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class SearchEvaluationsFixedSizeCollection
    extends AbstractFixedSizeCollection<SearchEvaluationsRequest, SearchEvaluationsResponse, Evaluation, SearchEvaluationsPage, SearchEvaluationsFixedSizeCollection> {
        private SearchEvaluationsFixedSizeCollection(List<SearchEvaluationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static SearchEvaluationsFixedSizeCollection createEmptyCollection() {
            return new SearchEvaluationsFixedSizeCollection(null, 0);
        }

        protected SearchEvaluationsFixedSizeCollection createCollection(List<SearchEvaluationsPage> pages, int collectionSize) {
            return new SearchEvaluationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class SearchEvaluationsPage
    extends AbstractPage<SearchEvaluationsRequest, SearchEvaluationsResponse, Evaluation, SearchEvaluationsPage> {
        private SearchEvaluationsPage(PageContext<SearchEvaluationsRequest, SearchEvaluationsResponse, Evaluation> context, SearchEvaluationsResponse response) {
            super(context, (Object)response);
        }

        private static SearchEvaluationsPage createEmptyPage() {
            return new SearchEvaluationsPage(null, null);
        }

        protected SearchEvaluationsPage createPage(PageContext<SearchEvaluationsRequest, SearchEvaluationsResponse, Evaluation> context, SearchEvaluationsResponse response) {
            return new SearchEvaluationsPage(context, response);
        }

        public ApiFuture<SearchEvaluationsPage> createPageAsync(PageContext<SearchEvaluationsRequest, SearchEvaluationsResponse, Evaluation> context, ApiFuture<SearchEvaluationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class SearchEvaluationsPagedResponse
    extends AbstractPagedListResponse<SearchEvaluationsRequest, SearchEvaluationsResponse, Evaluation, SearchEvaluationsPage, SearchEvaluationsFixedSizeCollection> {
        public static ApiFuture<SearchEvaluationsPagedResponse> createAsync(PageContext<SearchEvaluationsRequest, SearchEvaluationsResponse, Evaluation> context, ApiFuture<SearchEvaluationsResponse> futureResponse) {
            ApiFuture<SearchEvaluationsPage> futurePage = SearchEvaluationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<SearchEvaluationsPage, SearchEvaluationsPagedResponse>(){

                public SearchEvaluationsPagedResponse apply(SearchEvaluationsPage input) {
                    return new SearchEvaluationsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private SearchEvaluationsPagedResponse(SearchEvaluationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)SearchEvaluationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListInstructionsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListInstructionsRequest, ListInstructionsResponse, Instruction, ListInstructionsPage, ListInstructionsFixedSizeCollection> {
        private ListInstructionsFixedSizeCollection(List<ListInstructionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListInstructionsFixedSizeCollection createEmptyCollection() {
            return new ListInstructionsFixedSizeCollection(null, 0);
        }

        protected ListInstructionsFixedSizeCollection createCollection(List<ListInstructionsPage> pages, int collectionSize) {
            return new ListInstructionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListInstructionsPage
    extends AbstractPage<ListInstructionsRequest, ListInstructionsResponse, Instruction, ListInstructionsPage> {
        private ListInstructionsPage(PageContext<ListInstructionsRequest, ListInstructionsResponse, Instruction> context, ListInstructionsResponse response) {
            super(context, (Object)response);
        }

        private static ListInstructionsPage createEmptyPage() {
            return new ListInstructionsPage(null, null);
        }

        protected ListInstructionsPage createPage(PageContext<ListInstructionsRequest, ListInstructionsResponse, Instruction> context, ListInstructionsResponse response) {
            return new ListInstructionsPage(context, response);
        }

        public ApiFuture<ListInstructionsPage> createPageAsync(PageContext<ListInstructionsRequest, ListInstructionsResponse, Instruction> context, ApiFuture<ListInstructionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListInstructionsPagedResponse
    extends AbstractPagedListResponse<ListInstructionsRequest, ListInstructionsResponse, Instruction, ListInstructionsPage, ListInstructionsFixedSizeCollection> {
        public static ApiFuture<ListInstructionsPagedResponse> createAsync(PageContext<ListInstructionsRequest, ListInstructionsResponse, Instruction> context, ApiFuture<ListInstructionsResponse> futureResponse) {
            ApiFuture<ListInstructionsPage> futurePage = ListInstructionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListInstructionsPage, ListInstructionsPagedResponse>(){

                public ListInstructionsPagedResponse apply(ListInstructionsPage input) {
                    return new ListInstructionsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListInstructionsPagedResponse(ListInstructionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListInstructionsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListAnnotationSpecSetsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListAnnotationSpecSetsRequest, ListAnnotationSpecSetsResponse, AnnotationSpecSet, ListAnnotationSpecSetsPage, ListAnnotationSpecSetsFixedSizeCollection> {
        private ListAnnotationSpecSetsFixedSizeCollection(List<ListAnnotationSpecSetsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListAnnotationSpecSetsFixedSizeCollection createEmptyCollection() {
            return new ListAnnotationSpecSetsFixedSizeCollection(null, 0);
        }

        protected ListAnnotationSpecSetsFixedSizeCollection createCollection(List<ListAnnotationSpecSetsPage> pages, int collectionSize) {
            return new ListAnnotationSpecSetsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListAnnotationSpecSetsPage
    extends AbstractPage<ListAnnotationSpecSetsRequest, ListAnnotationSpecSetsResponse, AnnotationSpecSet, ListAnnotationSpecSetsPage> {
        private ListAnnotationSpecSetsPage(PageContext<ListAnnotationSpecSetsRequest, ListAnnotationSpecSetsResponse, AnnotationSpecSet> context, ListAnnotationSpecSetsResponse response) {
            super(context, (Object)response);
        }

        private static ListAnnotationSpecSetsPage createEmptyPage() {
            return new ListAnnotationSpecSetsPage(null, null);
        }

        protected ListAnnotationSpecSetsPage createPage(PageContext<ListAnnotationSpecSetsRequest, ListAnnotationSpecSetsResponse, AnnotationSpecSet> context, ListAnnotationSpecSetsResponse response) {
            return new ListAnnotationSpecSetsPage(context, response);
        }

        public ApiFuture<ListAnnotationSpecSetsPage> createPageAsync(PageContext<ListAnnotationSpecSetsRequest, ListAnnotationSpecSetsResponse, AnnotationSpecSet> context, ApiFuture<ListAnnotationSpecSetsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListAnnotationSpecSetsPagedResponse
    extends AbstractPagedListResponse<ListAnnotationSpecSetsRequest, ListAnnotationSpecSetsResponse, AnnotationSpecSet, ListAnnotationSpecSetsPage, ListAnnotationSpecSetsFixedSizeCollection> {
        public static ApiFuture<ListAnnotationSpecSetsPagedResponse> createAsync(PageContext<ListAnnotationSpecSetsRequest, ListAnnotationSpecSetsResponse, AnnotationSpecSet> context, ApiFuture<ListAnnotationSpecSetsResponse> futureResponse) {
            ApiFuture<ListAnnotationSpecSetsPage> futurePage = ListAnnotationSpecSetsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListAnnotationSpecSetsPage, ListAnnotationSpecSetsPagedResponse>(){

                public ListAnnotationSpecSetsPagedResponse apply(ListAnnotationSpecSetsPage input) {
                    return new ListAnnotationSpecSetsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListAnnotationSpecSetsPagedResponse(ListAnnotationSpecSetsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListAnnotationSpecSetsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListExamplesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListExamplesRequest, ListExamplesResponse, Example, ListExamplesPage, ListExamplesFixedSizeCollection> {
        private ListExamplesFixedSizeCollection(List<ListExamplesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListExamplesFixedSizeCollection createEmptyCollection() {
            return new ListExamplesFixedSizeCollection(null, 0);
        }

        protected ListExamplesFixedSizeCollection createCollection(List<ListExamplesPage> pages, int collectionSize) {
            return new ListExamplesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListExamplesPage
    extends AbstractPage<ListExamplesRequest, ListExamplesResponse, Example, ListExamplesPage> {
        private ListExamplesPage(PageContext<ListExamplesRequest, ListExamplesResponse, Example> context, ListExamplesResponse response) {
            super(context, (Object)response);
        }

        private static ListExamplesPage createEmptyPage() {
            return new ListExamplesPage(null, null);
        }

        protected ListExamplesPage createPage(PageContext<ListExamplesRequest, ListExamplesResponse, Example> context, ListExamplesResponse response) {
            return new ListExamplesPage(context, response);
        }

        public ApiFuture<ListExamplesPage> createPageAsync(PageContext<ListExamplesRequest, ListExamplesResponse, Example> context, ApiFuture<ListExamplesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListExamplesPagedResponse
    extends AbstractPagedListResponse<ListExamplesRequest, ListExamplesResponse, Example, ListExamplesPage, ListExamplesFixedSizeCollection> {
        public static ApiFuture<ListExamplesPagedResponse> createAsync(PageContext<ListExamplesRequest, ListExamplesResponse, Example> context, ApiFuture<ListExamplesResponse> futureResponse) {
            ApiFuture<ListExamplesPage> futurePage = ListExamplesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListExamplesPage, ListExamplesPagedResponse>(){

                public ListExamplesPagedResponse apply(ListExamplesPage input) {
                    return new ListExamplesPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListExamplesPagedResponse(ListExamplesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListExamplesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListAnnotatedDatasetsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListAnnotatedDatasetsRequest, ListAnnotatedDatasetsResponse, AnnotatedDataset, ListAnnotatedDatasetsPage, ListAnnotatedDatasetsFixedSizeCollection> {
        private ListAnnotatedDatasetsFixedSizeCollection(List<ListAnnotatedDatasetsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListAnnotatedDatasetsFixedSizeCollection createEmptyCollection() {
            return new ListAnnotatedDatasetsFixedSizeCollection(null, 0);
        }

        protected ListAnnotatedDatasetsFixedSizeCollection createCollection(List<ListAnnotatedDatasetsPage> pages, int collectionSize) {
            return new ListAnnotatedDatasetsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListAnnotatedDatasetsPage
    extends AbstractPage<ListAnnotatedDatasetsRequest, ListAnnotatedDatasetsResponse, AnnotatedDataset, ListAnnotatedDatasetsPage> {
        private ListAnnotatedDatasetsPage(PageContext<ListAnnotatedDatasetsRequest, ListAnnotatedDatasetsResponse, AnnotatedDataset> context, ListAnnotatedDatasetsResponse response) {
            super(context, (Object)response);
        }

        private static ListAnnotatedDatasetsPage createEmptyPage() {
            return new ListAnnotatedDatasetsPage(null, null);
        }

        protected ListAnnotatedDatasetsPage createPage(PageContext<ListAnnotatedDatasetsRequest, ListAnnotatedDatasetsResponse, AnnotatedDataset> context, ListAnnotatedDatasetsResponse response) {
            return new ListAnnotatedDatasetsPage(context, response);
        }

        public ApiFuture<ListAnnotatedDatasetsPage> createPageAsync(PageContext<ListAnnotatedDatasetsRequest, ListAnnotatedDatasetsResponse, AnnotatedDataset> context, ApiFuture<ListAnnotatedDatasetsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListAnnotatedDatasetsPagedResponse
    extends AbstractPagedListResponse<ListAnnotatedDatasetsRequest, ListAnnotatedDatasetsResponse, AnnotatedDataset, ListAnnotatedDatasetsPage, ListAnnotatedDatasetsFixedSizeCollection> {
        public static ApiFuture<ListAnnotatedDatasetsPagedResponse> createAsync(PageContext<ListAnnotatedDatasetsRequest, ListAnnotatedDatasetsResponse, AnnotatedDataset> context, ApiFuture<ListAnnotatedDatasetsResponse> futureResponse) {
            ApiFuture<ListAnnotatedDatasetsPage> futurePage = ListAnnotatedDatasetsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListAnnotatedDatasetsPage, ListAnnotatedDatasetsPagedResponse>(){

                public ListAnnotatedDatasetsPagedResponse apply(ListAnnotatedDatasetsPage input) {
                    return new ListAnnotatedDatasetsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListAnnotatedDatasetsPagedResponse(ListAnnotatedDatasetsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListAnnotatedDatasetsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListDataItemsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListDataItemsRequest, ListDataItemsResponse, DataItem, ListDataItemsPage, ListDataItemsFixedSizeCollection> {
        private ListDataItemsFixedSizeCollection(List<ListDataItemsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListDataItemsFixedSizeCollection createEmptyCollection() {
            return new ListDataItemsFixedSizeCollection(null, 0);
        }

        protected ListDataItemsFixedSizeCollection createCollection(List<ListDataItemsPage> pages, int collectionSize) {
            return new ListDataItemsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListDataItemsPage
    extends AbstractPage<ListDataItemsRequest, ListDataItemsResponse, DataItem, ListDataItemsPage> {
        private ListDataItemsPage(PageContext<ListDataItemsRequest, ListDataItemsResponse, DataItem> context, ListDataItemsResponse response) {
            super(context, (Object)response);
        }

        private static ListDataItemsPage createEmptyPage() {
            return new ListDataItemsPage(null, null);
        }

        protected ListDataItemsPage createPage(PageContext<ListDataItemsRequest, ListDataItemsResponse, DataItem> context, ListDataItemsResponse response) {
            return new ListDataItemsPage(context, response);
        }

        public ApiFuture<ListDataItemsPage> createPageAsync(PageContext<ListDataItemsRequest, ListDataItemsResponse, DataItem> context, ApiFuture<ListDataItemsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListDataItemsPagedResponse
    extends AbstractPagedListResponse<ListDataItemsRequest, ListDataItemsResponse, DataItem, ListDataItemsPage, ListDataItemsFixedSizeCollection> {
        public static ApiFuture<ListDataItemsPagedResponse> createAsync(PageContext<ListDataItemsRequest, ListDataItemsResponse, DataItem> context, ApiFuture<ListDataItemsResponse> futureResponse) {
            ApiFuture<ListDataItemsPage> futurePage = ListDataItemsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListDataItemsPage, ListDataItemsPagedResponse>(){

                public ListDataItemsPagedResponse apply(ListDataItemsPage input) {
                    return new ListDataItemsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListDataItemsPagedResponse(ListDataItemsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListDataItemsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListDatasetsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListDatasetsRequest, ListDatasetsResponse, Dataset, ListDatasetsPage, ListDatasetsFixedSizeCollection> {
        private ListDatasetsFixedSizeCollection(List<ListDatasetsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListDatasetsFixedSizeCollection createEmptyCollection() {
            return new ListDatasetsFixedSizeCollection(null, 0);
        }

        protected ListDatasetsFixedSizeCollection createCollection(List<ListDatasetsPage> pages, int collectionSize) {
            return new ListDatasetsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListDatasetsPage
    extends AbstractPage<ListDatasetsRequest, ListDatasetsResponse, Dataset, ListDatasetsPage> {
        private ListDatasetsPage(PageContext<ListDatasetsRequest, ListDatasetsResponse, Dataset> context, ListDatasetsResponse response) {
            super(context, (Object)response);
        }

        private static ListDatasetsPage createEmptyPage() {
            return new ListDatasetsPage(null, null);
        }

        protected ListDatasetsPage createPage(PageContext<ListDatasetsRequest, ListDatasetsResponse, Dataset> context, ListDatasetsResponse response) {
            return new ListDatasetsPage(context, response);
        }

        public ApiFuture<ListDatasetsPage> createPageAsync(PageContext<ListDatasetsRequest, ListDatasetsResponse, Dataset> context, ApiFuture<ListDatasetsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListDatasetsPagedResponse
    extends AbstractPagedListResponse<ListDatasetsRequest, ListDatasetsResponse, Dataset, ListDatasetsPage, ListDatasetsFixedSizeCollection> {
        public static ApiFuture<ListDatasetsPagedResponse> createAsync(PageContext<ListDatasetsRequest, ListDatasetsResponse, Dataset> context, ApiFuture<ListDatasetsResponse> futureResponse) {
            ApiFuture<ListDatasetsPage> futurePage = ListDatasetsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListDatasetsPage, ListDatasetsPagedResponse>(){

                public ListDatasetsPagedResponse apply(ListDatasetsPage input) {
                    return new ListDatasetsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListDatasetsPagedResponse(ListDatasetsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListDatasetsFixedSizeCollection.createEmptyCollection());
        }
    }
}

