/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datacatalog.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.datacatalog.v1.CreatePolicyTagRequest;
import com.google.cloud.datacatalog.v1.CreateTaxonomyRequest;
import com.google.cloud.datacatalog.v1.DeletePolicyTagRequest;
import com.google.cloud.datacatalog.v1.DeleteTaxonomyRequest;
import com.google.cloud.datacatalog.v1.GetPolicyTagRequest;
import com.google.cloud.datacatalog.v1.GetTaxonomyRequest;
import com.google.cloud.datacatalog.v1.ListPolicyTagsRequest;
import com.google.cloud.datacatalog.v1.ListPolicyTagsResponse;
import com.google.cloud.datacatalog.v1.ListTaxonomiesRequest;
import com.google.cloud.datacatalog.v1.ListTaxonomiesResponse;
import com.google.cloud.datacatalog.v1.PolicyTag;
import com.google.cloud.datacatalog.v1.PolicyTagManagerClient;
import com.google.cloud.datacatalog.v1.Taxonomy;
import com.google.cloud.datacatalog.v1.UpdatePolicyTagRequest;
import com.google.cloud.datacatalog.v1.UpdateTaxonomyRequest;
import com.google.cloud.datacatalog.v1.stub.GrpcPolicyTagManagerStub;
import com.google.cloud.datacatalog.v1.stub.HttpJsonPolicyTagManagerStub;
import com.google.cloud.datacatalog.v1.stub.PolicyTagManagerStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class PolicyTagManagerStubSettings
extends StubSettings<PolicyTagManagerStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateTaxonomyRequest, Taxonomy> createTaxonomySettings;
    private final UnaryCallSettings<DeleteTaxonomyRequest, Empty> deleteTaxonomySettings;
    private final UnaryCallSettings<UpdateTaxonomyRequest, Taxonomy> updateTaxonomySettings;
    private final PagedCallSettings<ListTaxonomiesRequest, ListTaxonomiesResponse, PolicyTagManagerClient.ListTaxonomiesPagedResponse> listTaxonomiesSettings;
    private final UnaryCallSettings<GetTaxonomyRequest, Taxonomy> getTaxonomySettings;
    private final UnaryCallSettings<CreatePolicyTagRequest, PolicyTag> createPolicyTagSettings;
    private final UnaryCallSettings<DeletePolicyTagRequest, Empty> deletePolicyTagSettings;
    private final UnaryCallSettings<UpdatePolicyTagRequest, PolicyTag> updatePolicyTagSettings;
    private final PagedCallSettings<ListPolicyTagsRequest, ListPolicyTagsResponse, PolicyTagManagerClient.ListPolicyTagsPagedResponse> listPolicyTagsSettings;
    private final UnaryCallSettings<GetPolicyTagRequest, PolicyTag> getPolicyTagSettings;
    private final UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
    private static final PagedListDescriptor<ListTaxonomiesRequest, ListTaxonomiesResponse, Taxonomy> LIST_TAXONOMIES_PAGE_STR_DESC = new PagedListDescriptor<ListTaxonomiesRequest, ListTaxonomiesResponse, Taxonomy>(){

        public String emptyToken() {
            return "";
        }

        public ListTaxonomiesRequest injectToken(ListTaxonomiesRequest payload, String token) {
            return ListTaxonomiesRequest.newBuilder((ListTaxonomiesRequest)payload).setPageToken(token).build();
        }

        public ListTaxonomiesRequest injectPageSize(ListTaxonomiesRequest payload, int pageSize) {
            return ListTaxonomiesRequest.newBuilder((ListTaxonomiesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListTaxonomiesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListTaxonomiesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Taxonomy> extractResources(ListTaxonomiesResponse payload) {
            return payload.getTaxonomiesList() == null ? ImmutableList.of() : payload.getTaxonomiesList();
        }
    };
    private static final PagedListDescriptor<ListPolicyTagsRequest, ListPolicyTagsResponse, PolicyTag> LIST_POLICY_TAGS_PAGE_STR_DESC = new PagedListDescriptor<ListPolicyTagsRequest, ListPolicyTagsResponse, PolicyTag>(){

        public String emptyToken() {
            return "";
        }

        public ListPolicyTagsRequest injectToken(ListPolicyTagsRequest payload, String token) {
            return ListPolicyTagsRequest.newBuilder((ListPolicyTagsRequest)payload).setPageToken(token).build();
        }

        public ListPolicyTagsRequest injectPageSize(ListPolicyTagsRequest payload, int pageSize) {
            return ListPolicyTagsRequest.newBuilder((ListPolicyTagsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListPolicyTagsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListPolicyTagsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<PolicyTag> extractResources(ListPolicyTagsResponse payload) {
            return payload.getPolicyTagsList() == null ? ImmutableList.of() : payload.getPolicyTagsList();
        }
    };
    private static final PagedListResponseFactory<ListTaxonomiesRequest, ListTaxonomiesResponse, PolicyTagManagerClient.ListTaxonomiesPagedResponse> LIST_TAXONOMIES_PAGE_STR_FACT = new PagedListResponseFactory<ListTaxonomiesRequest, ListTaxonomiesResponse, PolicyTagManagerClient.ListTaxonomiesPagedResponse>(){

        public ApiFuture<PolicyTagManagerClient.ListTaxonomiesPagedResponse> getFuturePagedResponse(UnaryCallable<ListTaxonomiesRequest, ListTaxonomiesResponse> callable, ListTaxonomiesRequest request, ApiCallContext context, ApiFuture<ListTaxonomiesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_TAXONOMIES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return PolicyTagManagerClient.ListTaxonomiesPagedResponse.createAsync((PageContext<ListTaxonomiesRequest, ListTaxonomiesResponse, Taxonomy>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListPolicyTagsRequest, ListPolicyTagsResponse, PolicyTagManagerClient.ListPolicyTagsPagedResponse> LIST_POLICY_TAGS_PAGE_STR_FACT = new PagedListResponseFactory<ListPolicyTagsRequest, ListPolicyTagsResponse, PolicyTagManagerClient.ListPolicyTagsPagedResponse>(){

        public ApiFuture<PolicyTagManagerClient.ListPolicyTagsPagedResponse> getFuturePagedResponse(UnaryCallable<ListPolicyTagsRequest, ListPolicyTagsResponse> callable, ListPolicyTagsRequest request, ApiCallContext context, ApiFuture<ListPolicyTagsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_POLICY_TAGS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return PolicyTagManagerClient.ListPolicyTagsPagedResponse.createAsync((PageContext<ListPolicyTagsRequest, ListPolicyTagsResponse, PolicyTag>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateTaxonomyRequest, Taxonomy> createTaxonomySettings() {
        return this.createTaxonomySettings;
    }

    public UnaryCallSettings<DeleteTaxonomyRequest, Empty> deleteTaxonomySettings() {
        return this.deleteTaxonomySettings;
    }

    public UnaryCallSettings<UpdateTaxonomyRequest, Taxonomy> updateTaxonomySettings() {
        return this.updateTaxonomySettings;
    }

    public PagedCallSettings<ListTaxonomiesRequest, ListTaxonomiesResponse, PolicyTagManagerClient.ListTaxonomiesPagedResponse> listTaxonomiesSettings() {
        return this.listTaxonomiesSettings;
    }

    public UnaryCallSettings<GetTaxonomyRequest, Taxonomy> getTaxonomySettings() {
        return this.getTaxonomySettings;
    }

    public UnaryCallSettings<CreatePolicyTagRequest, PolicyTag> createPolicyTagSettings() {
        return this.createPolicyTagSettings;
    }

    public UnaryCallSettings<DeletePolicyTagRequest, Empty> deletePolicyTagSettings() {
        return this.deletePolicyTagSettings;
    }

    public UnaryCallSettings<UpdatePolicyTagRequest, PolicyTag> updatePolicyTagSettings() {
        return this.updatePolicyTagSettings;
    }

    public PagedCallSettings<ListPolicyTagsRequest, ListPolicyTagsResponse, PolicyTagManagerClient.ListPolicyTagsPagedResponse> listPolicyTagsSettings() {
        return this.listPolicyTagsSettings;
    }

    public UnaryCallSettings<GetPolicyTagRequest, PolicyTag> getPolicyTagSettings() {
        return this.getPolicyTagSettings;
    }

    public UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public PolicyTagManagerStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcPolicyTagManagerStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonPolicyTagManagerStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "datacatalog";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "datacatalog.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "datacatalog.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return PolicyTagManagerStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(PolicyTagManagerStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(PolicyTagManagerStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return PolicyTagManagerStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected PolicyTagManagerStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createTaxonomySettings = settingsBuilder.createTaxonomySettings().build();
        this.deleteTaxonomySettings = settingsBuilder.deleteTaxonomySettings().build();
        this.updateTaxonomySettings = settingsBuilder.updateTaxonomySettings().build();
        this.listTaxonomiesSettings = settingsBuilder.listTaxonomiesSettings().build();
        this.getTaxonomySettings = settingsBuilder.getTaxonomySettings().build();
        this.createPolicyTagSettings = settingsBuilder.createPolicyTagSettings().build();
        this.deletePolicyTagSettings = settingsBuilder.deletePolicyTagSettings().build();
        this.updatePolicyTagSettings = settingsBuilder.updatePolicyTagSettings().build();
        this.listPolicyTagsSettings = settingsBuilder.listPolicyTagsSettings().build();
        this.getPolicyTagSettings = settingsBuilder.getPolicyTagSettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<PolicyTagManagerStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateTaxonomyRequest, Taxonomy> createTaxonomySettings;
        private final UnaryCallSettings.Builder<DeleteTaxonomyRequest, Empty> deleteTaxonomySettings;
        private final UnaryCallSettings.Builder<UpdateTaxonomyRequest, Taxonomy> updateTaxonomySettings;
        private final PagedCallSettings.Builder<ListTaxonomiesRequest, ListTaxonomiesResponse, PolicyTagManagerClient.ListTaxonomiesPagedResponse> listTaxonomiesSettings;
        private final UnaryCallSettings.Builder<GetTaxonomyRequest, Taxonomy> getTaxonomySettings;
        private final UnaryCallSettings.Builder<CreatePolicyTagRequest, PolicyTag> createPolicyTagSettings;
        private final UnaryCallSettings.Builder<DeletePolicyTagRequest, Empty> deletePolicyTagSettings;
        private final UnaryCallSettings.Builder<UpdatePolicyTagRequest, PolicyTag> updatePolicyTagSettings;
        private final PagedCallSettings.Builder<ListPolicyTagsRequest, ListPolicyTagsResponse, PolicyTagManagerClient.ListPolicyTagsPagedResponse> listPolicyTagsSettings;
        private final UnaryCallSettings.Builder<GetPolicyTagRequest, PolicyTag> getPolicyTagSettings;
        private final UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createTaxonomySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteTaxonomySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateTaxonomySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listTaxonomiesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_TAXONOMIES_PAGE_STR_FACT);
            this.getTaxonomySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createPolicyTagSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deletePolicyTagSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updatePolicyTagSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listPolicyTagsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_POLICY_TAGS_PAGE_STR_FACT);
            this.getPolicyTagSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createTaxonomySettings, this.deleteTaxonomySettings, this.updateTaxonomySettings, this.listTaxonomiesSettings, this.getTaxonomySettings, this.createPolicyTagSettings, this.deletePolicyTagSettings, this.updatePolicyTagSettings, this.listPolicyTagsSettings, this.getPolicyTagSettings, this.getIamPolicySettings, this.setIamPolicySettings, (Object[])new UnaryCallSettings.Builder[]{this.testIamPermissionsSettings});
            Builder.initDefaults(this);
        }

        protected Builder(PolicyTagManagerStubSettings settings) {
            super((StubSettings)settings);
            this.createTaxonomySettings = settings.createTaxonomySettings.toBuilder();
            this.deleteTaxonomySettings = settings.deleteTaxonomySettings.toBuilder();
            this.updateTaxonomySettings = settings.updateTaxonomySettings.toBuilder();
            this.listTaxonomiesSettings = settings.listTaxonomiesSettings.toBuilder();
            this.getTaxonomySettings = settings.getTaxonomySettings.toBuilder();
            this.createPolicyTagSettings = settings.createPolicyTagSettings.toBuilder();
            this.deletePolicyTagSettings = settings.deletePolicyTagSettings.toBuilder();
            this.updatePolicyTagSettings = settings.updatePolicyTagSettings.toBuilder();
            this.listPolicyTagsSettings = settings.listPolicyTagsSettings.toBuilder();
            this.getPolicyTagSettings = settings.getPolicyTagSettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createTaxonomySettings, this.deleteTaxonomySettings, this.updateTaxonomySettings, this.listTaxonomiesSettings, this.getTaxonomySettings, this.createPolicyTagSettings, this.deletePolicyTagSettings, this.updatePolicyTagSettings, this.listPolicyTagsSettings, this.getPolicyTagSettings, this.getIamPolicySettings, this.setIamPolicySettings, (Object[])new UnaryCallSettings.Builder[]{this.testIamPermissionsSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(PolicyTagManagerStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)PolicyTagManagerStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)PolicyTagManagerStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(PolicyTagManagerStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)PolicyTagManagerStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)PolicyTagManagerStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)PolicyTagManagerStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(PolicyTagManagerStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createTaxonomySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteTaxonomySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateTaxonomySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listTaxonomiesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getTaxonomySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.createPolicyTagSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deletePolicyTagSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updatePolicyTagSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listPolicyTagsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getPolicyTagSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateTaxonomyRequest, Taxonomy> createTaxonomySettings() {
            return this.createTaxonomySettings;
        }

        public UnaryCallSettings.Builder<DeleteTaxonomyRequest, Empty> deleteTaxonomySettings() {
            return this.deleteTaxonomySettings;
        }

        public UnaryCallSettings.Builder<UpdateTaxonomyRequest, Taxonomy> updateTaxonomySettings() {
            return this.updateTaxonomySettings;
        }

        public PagedCallSettings.Builder<ListTaxonomiesRequest, ListTaxonomiesResponse, PolicyTagManagerClient.ListTaxonomiesPagedResponse> listTaxonomiesSettings() {
            return this.listTaxonomiesSettings;
        }

        public UnaryCallSettings.Builder<GetTaxonomyRequest, Taxonomy> getTaxonomySettings() {
            return this.getTaxonomySettings;
        }

        public UnaryCallSettings.Builder<CreatePolicyTagRequest, PolicyTag> createPolicyTagSettings() {
            return this.createPolicyTagSettings;
        }

        public UnaryCallSettings.Builder<DeletePolicyTagRequest, Empty> deletePolicyTagSettings() {
            return this.deletePolicyTagSettings;
        }

        public UnaryCallSettings.Builder<UpdatePolicyTagRequest, PolicyTag> updatePolicyTagSettings() {
            return this.updatePolicyTagSettings;
        }

        public PagedCallSettings.Builder<ListPolicyTagsRequest, ListPolicyTagsResponse, PolicyTagManagerClient.ListPolicyTagsPagedResponse> listPolicyTagsSettings() {
            return this.listPolicyTagsSettings;
        }

        public UnaryCallSettings.Builder<GetPolicyTagRequest, PolicyTag> getPolicyTagSettings() {
            return this.getPolicyTagSettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public PolicyTagManagerStubSettings build() throws IOException {
            return new PolicyTagManagerStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

