/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datacatalog.v1beta1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.datacatalog.v1beta1.CreateEntryGroupRequest;
import com.google.cloud.datacatalog.v1beta1.CreateEntryRequest;
import com.google.cloud.datacatalog.v1beta1.CreateTagRequest;
import com.google.cloud.datacatalog.v1beta1.CreateTagTemplateFieldRequest;
import com.google.cloud.datacatalog.v1beta1.CreateTagTemplateRequest;
import com.google.cloud.datacatalog.v1beta1.DataCatalogClient;
import com.google.cloud.datacatalog.v1beta1.DeleteEntryGroupRequest;
import com.google.cloud.datacatalog.v1beta1.DeleteEntryRequest;
import com.google.cloud.datacatalog.v1beta1.DeleteTagRequest;
import com.google.cloud.datacatalog.v1beta1.DeleteTagTemplateFieldRequest;
import com.google.cloud.datacatalog.v1beta1.DeleteTagTemplateRequest;
import com.google.cloud.datacatalog.v1beta1.Entry;
import com.google.cloud.datacatalog.v1beta1.EntryGroup;
import com.google.cloud.datacatalog.v1beta1.GetEntryGroupRequest;
import com.google.cloud.datacatalog.v1beta1.GetEntryRequest;
import com.google.cloud.datacatalog.v1beta1.GetTagTemplateRequest;
import com.google.cloud.datacatalog.v1beta1.ListEntriesRequest;
import com.google.cloud.datacatalog.v1beta1.ListEntriesResponse;
import com.google.cloud.datacatalog.v1beta1.ListEntryGroupsRequest;
import com.google.cloud.datacatalog.v1beta1.ListEntryGroupsResponse;
import com.google.cloud.datacatalog.v1beta1.ListTagsRequest;
import com.google.cloud.datacatalog.v1beta1.ListTagsResponse;
import com.google.cloud.datacatalog.v1beta1.LookupEntryRequest;
import com.google.cloud.datacatalog.v1beta1.RenameTagTemplateFieldRequest;
import com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest;
import com.google.cloud.datacatalog.v1beta1.SearchCatalogResponse;
import com.google.cloud.datacatalog.v1beta1.SearchCatalogResult;
import com.google.cloud.datacatalog.v1beta1.Tag;
import com.google.cloud.datacatalog.v1beta1.TagTemplate;
import com.google.cloud.datacatalog.v1beta1.TagTemplateField;
import com.google.cloud.datacatalog.v1beta1.UpdateEntryGroupRequest;
import com.google.cloud.datacatalog.v1beta1.UpdateEntryRequest;
import com.google.cloud.datacatalog.v1beta1.UpdateTagRequest;
import com.google.cloud.datacatalog.v1beta1.UpdateTagTemplateFieldRequest;
import com.google.cloud.datacatalog.v1beta1.UpdateTagTemplateRequest;
import com.google.cloud.datacatalog.v1beta1.stub.DataCatalogStub;
import com.google.cloud.datacatalog.v1beta1.stub.GrpcDataCatalogStub;
import com.google.cloud.datacatalog.v1beta1.stub.HttpJsonDataCatalogStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class DataCatalogStubSettings
extends StubSettings<DataCatalogStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<SearchCatalogRequest, SearchCatalogResponse, DataCatalogClient.SearchCatalogPagedResponse> searchCatalogSettings;
    private final UnaryCallSettings<CreateEntryGroupRequest, EntryGroup> createEntryGroupSettings;
    private final UnaryCallSettings<UpdateEntryGroupRequest, EntryGroup> updateEntryGroupSettings;
    private final UnaryCallSettings<GetEntryGroupRequest, EntryGroup> getEntryGroupSettings;
    private final UnaryCallSettings<DeleteEntryGroupRequest, Empty> deleteEntryGroupSettings;
    private final PagedCallSettings<ListEntryGroupsRequest, ListEntryGroupsResponse, DataCatalogClient.ListEntryGroupsPagedResponse> listEntryGroupsSettings;
    private final UnaryCallSettings<CreateEntryRequest, Entry> createEntrySettings;
    private final UnaryCallSettings<UpdateEntryRequest, Entry> updateEntrySettings;
    private final UnaryCallSettings<DeleteEntryRequest, Empty> deleteEntrySettings;
    private final UnaryCallSettings<GetEntryRequest, Entry> getEntrySettings;
    private final UnaryCallSettings<LookupEntryRequest, Entry> lookupEntrySettings;
    private final PagedCallSettings<ListEntriesRequest, ListEntriesResponse, DataCatalogClient.ListEntriesPagedResponse> listEntriesSettings;
    private final UnaryCallSettings<CreateTagTemplateRequest, TagTemplate> createTagTemplateSettings;
    private final UnaryCallSettings<GetTagTemplateRequest, TagTemplate> getTagTemplateSettings;
    private final UnaryCallSettings<UpdateTagTemplateRequest, TagTemplate> updateTagTemplateSettings;
    private final UnaryCallSettings<DeleteTagTemplateRequest, Empty> deleteTagTemplateSettings;
    private final UnaryCallSettings<CreateTagTemplateFieldRequest, TagTemplateField> createTagTemplateFieldSettings;
    private final UnaryCallSettings<UpdateTagTemplateFieldRequest, TagTemplateField> updateTagTemplateFieldSettings;
    private final UnaryCallSettings<RenameTagTemplateFieldRequest, TagTemplateField> renameTagTemplateFieldSettings;
    private final UnaryCallSettings<DeleteTagTemplateFieldRequest, Empty> deleteTagTemplateFieldSettings;
    private final UnaryCallSettings<CreateTagRequest, Tag> createTagSettings;
    private final UnaryCallSettings<UpdateTagRequest, Tag> updateTagSettings;
    private final UnaryCallSettings<DeleteTagRequest, Empty> deleteTagSettings;
    private final PagedCallSettings<ListTagsRequest, ListTagsResponse, DataCatalogClient.ListTagsPagedResponse> listTagsSettings;
    private final UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
    private static final PagedListDescriptor<SearchCatalogRequest, SearchCatalogResponse, SearchCatalogResult> SEARCH_CATALOG_PAGE_STR_DESC = new PagedListDescriptor<SearchCatalogRequest, SearchCatalogResponse, SearchCatalogResult>(){

        public String emptyToken() {
            return "";
        }

        public SearchCatalogRequest injectToken(SearchCatalogRequest payload, String token) {
            return SearchCatalogRequest.newBuilder((SearchCatalogRequest)payload).setPageToken(token).build();
        }

        public SearchCatalogRequest injectPageSize(SearchCatalogRequest payload, int pageSize) {
            return SearchCatalogRequest.newBuilder((SearchCatalogRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(SearchCatalogRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(SearchCatalogResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<SearchCatalogResult> extractResources(SearchCatalogResponse payload) {
            return payload.getResultsList() == null ? ImmutableList.of() : payload.getResultsList();
        }
    };
    private static final PagedListDescriptor<ListEntryGroupsRequest, ListEntryGroupsResponse, EntryGroup> LIST_ENTRY_GROUPS_PAGE_STR_DESC = new PagedListDescriptor<ListEntryGroupsRequest, ListEntryGroupsResponse, EntryGroup>(){

        public String emptyToken() {
            return "";
        }

        public ListEntryGroupsRequest injectToken(ListEntryGroupsRequest payload, String token) {
            return ListEntryGroupsRequest.newBuilder((ListEntryGroupsRequest)payload).setPageToken(token).build();
        }

        public ListEntryGroupsRequest injectPageSize(ListEntryGroupsRequest payload, int pageSize) {
            return ListEntryGroupsRequest.newBuilder((ListEntryGroupsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListEntryGroupsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListEntryGroupsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<EntryGroup> extractResources(ListEntryGroupsResponse payload) {
            return payload.getEntryGroupsList() == null ? ImmutableList.of() : payload.getEntryGroupsList();
        }
    };
    private static final PagedListDescriptor<ListEntriesRequest, ListEntriesResponse, Entry> LIST_ENTRIES_PAGE_STR_DESC = new PagedListDescriptor<ListEntriesRequest, ListEntriesResponse, Entry>(){

        public String emptyToken() {
            return "";
        }

        public ListEntriesRequest injectToken(ListEntriesRequest payload, String token) {
            return ListEntriesRequest.newBuilder((ListEntriesRequest)payload).setPageToken(token).build();
        }

        public ListEntriesRequest injectPageSize(ListEntriesRequest payload, int pageSize) {
            return ListEntriesRequest.newBuilder((ListEntriesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListEntriesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListEntriesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Entry> extractResources(ListEntriesResponse payload) {
            return payload.getEntriesList() == null ? ImmutableList.of() : payload.getEntriesList();
        }
    };
    private static final PagedListDescriptor<ListTagsRequest, ListTagsResponse, Tag> LIST_TAGS_PAGE_STR_DESC = new PagedListDescriptor<ListTagsRequest, ListTagsResponse, Tag>(){

        public String emptyToken() {
            return "";
        }

        public ListTagsRequest injectToken(ListTagsRequest payload, String token) {
            return ListTagsRequest.newBuilder((ListTagsRequest)payload).setPageToken(token).build();
        }

        public ListTagsRequest injectPageSize(ListTagsRequest payload, int pageSize) {
            return ListTagsRequest.newBuilder((ListTagsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListTagsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListTagsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Tag> extractResources(ListTagsResponse payload) {
            return payload.getTagsList() == null ? ImmutableList.of() : payload.getTagsList();
        }
    };
    private static final PagedListResponseFactory<SearchCatalogRequest, SearchCatalogResponse, DataCatalogClient.SearchCatalogPagedResponse> SEARCH_CATALOG_PAGE_STR_FACT = new PagedListResponseFactory<SearchCatalogRequest, SearchCatalogResponse, DataCatalogClient.SearchCatalogPagedResponse>(){

        public ApiFuture<DataCatalogClient.SearchCatalogPagedResponse> getFuturePagedResponse(UnaryCallable<SearchCatalogRequest, SearchCatalogResponse> callable, SearchCatalogRequest request, ApiCallContext context, ApiFuture<SearchCatalogResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)SEARCH_CATALOG_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DataCatalogClient.SearchCatalogPagedResponse.createAsync((PageContext<SearchCatalogRequest, SearchCatalogResponse, SearchCatalogResult>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListEntryGroupsRequest, ListEntryGroupsResponse, DataCatalogClient.ListEntryGroupsPagedResponse> LIST_ENTRY_GROUPS_PAGE_STR_FACT = new PagedListResponseFactory<ListEntryGroupsRequest, ListEntryGroupsResponse, DataCatalogClient.ListEntryGroupsPagedResponse>(){

        public ApiFuture<DataCatalogClient.ListEntryGroupsPagedResponse> getFuturePagedResponse(UnaryCallable<ListEntryGroupsRequest, ListEntryGroupsResponse> callable, ListEntryGroupsRequest request, ApiCallContext context, ApiFuture<ListEntryGroupsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ENTRY_GROUPS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DataCatalogClient.ListEntryGroupsPagedResponse.createAsync((PageContext<ListEntryGroupsRequest, ListEntryGroupsResponse, EntryGroup>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListEntriesRequest, ListEntriesResponse, DataCatalogClient.ListEntriesPagedResponse> LIST_ENTRIES_PAGE_STR_FACT = new PagedListResponseFactory<ListEntriesRequest, ListEntriesResponse, DataCatalogClient.ListEntriesPagedResponse>(){

        public ApiFuture<DataCatalogClient.ListEntriesPagedResponse> getFuturePagedResponse(UnaryCallable<ListEntriesRequest, ListEntriesResponse> callable, ListEntriesRequest request, ApiCallContext context, ApiFuture<ListEntriesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ENTRIES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DataCatalogClient.ListEntriesPagedResponse.createAsync((PageContext<ListEntriesRequest, ListEntriesResponse, Entry>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListTagsRequest, ListTagsResponse, DataCatalogClient.ListTagsPagedResponse> LIST_TAGS_PAGE_STR_FACT = new PagedListResponseFactory<ListTagsRequest, ListTagsResponse, DataCatalogClient.ListTagsPagedResponse>(){

        public ApiFuture<DataCatalogClient.ListTagsPagedResponse> getFuturePagedResponse(UnaryCallable<ListTagsRequest, ListTagsResponse> callable, ListTagsRequest request, ApiCallContext context, ApiFuture<ListTagsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_TAGS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DataCatalogClient.ListTagsPagedResponse.createAsync((PageContext<ListTagsRequest, ListTagsResponse, Tag>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<SearchCatalogRequest, SearchCatalogResponse, DataCatalogClient.SearchCatalogPagedResponse> searchCatalogSettings() {
        return this.searchCatalogSettings;
    }

    public UnaryCallSettings<CreateEntryGroupRequest, EntryGroup> createEntryGroupSettings() {
        return this.createEntryGroupSettings;
    }

    public UnaryCallSettings<UpdateEntryGroupRequest, EntryGroup> updateEntryGroupSettings() {
        return this.updateEntryGroupSettings;
    }

    public UnaryCallSettings<GetEntryGroupRequest, EntryGroup> getEntryGroupSettings() {
        return this.getEntryGroupSettings;
    }

    public UnaryCallSettings<DeleteEntryGroupRequest, Empty> deleteEntryGroupSettings() {
        return this.deleteEntryGroupSettings;
    }

    public PagedCallSettings<ListEntryGroupsRequest, ListEntryGroupsResponse, DataCatalogClient.ListEntryGroupsPagedResponse> listEntryGroupsSettings() {
        return this.listEntryGroupsSettings;
    }

    public UnaryCallSettings<CreateEntryRequest, Entry> createEntrySettings() {
        return this.createEntrySettings;
    }

    public UnaryCallSettings<UpdateEntryRequest, Entry> updateEntrySettings() {
        return this.updateEntrySettings;
    }

    public UnaryCallSettings<DeleteEntryRequest, Empty> deleteEntrySettings() {
        return this.deleteEntrySettings;
    }

    public UnaryCallSettings<GetEntryRequest, Entry> getEntrySettings() {
        return this.getEntrySettings;
    }

    public UnaryCallSettings<LookupEntryRequest, Entry> lookupEntrySettings() {
        return this.lookupEntrySettings;
    }

    public PagedCallSettings<ListEntriesRequest, ListEntriesResponse, DataCatalogClient.ListEntriesPagedResponse> listEntriesSettings() {
        return this.listEntriesSettings;
    }

    public UnaryCallSettings<CreateTagTemplateRequest, TagTemplate> createTagTemplateSettings() {
        return this.createTagTemplateSettings;
    }

    public UnaryCallSettings<GetTagTemplateRequest, TagTemplate> getTagTemplateSettings() {
        return this.getTagTemplateSettings;
    }

    public UnaryCallSettings<UpdateTagTemplateRequest, TagTemplate> updateTagTemplateSettings() {
        return this.updateTagTemplateSettings;
    }

    public UnaryCallSettings<DeleteTagTemplateRequest, Empty> deleteTagTemplateSettings() {
        return this.deleteTagTemplateSettings;
    }

    public UnaryCallSettings<CreateTagTemplateFieldRequest, TagTemplateField> createTagTemplateFieldSettings() {
        return this.createTagTemplateFieldSettings;
    }

    public UnaryCallSettings<UpdateTagTemplateFieldRequest, TagTemplateField> updateTagTemplateFieldSettings() {
        return this.updateTagTemplateFieldSettings;
    }

    public UnaryCallSettings<RenameTagTemplateFieldRequest, TagTemplateField> renameTagTemplateFieldSettings() {
        return this.renameTagTemplateFieldSettings;
    }

    public UnaryCallSettings<DeleteTagTemplateFieldRequest, Empty> deleteTagTemplateFieldSettings() {
        return this.deleteTagTemplateFieldSettings;
    }

    public UnaryCallSettings<CreateTagRequest, Tag> createTagSettings() {
        return this.createTagSettings;
    }

    public UnaryCallSettings<UpdateTagRequest, Tag> updateTagSettings() {
        return this.updateTagSettings;
    }

    public UnaryCallSettings<DeleteTagRequest, Empty> deleteTagSettings() {
        return this.deleteTagSettings;
    }

    public PagedCallSettings<ListTagsRequest, ListTagsResponse, DataCatalogClient.ListTagsPagedResponse> listTagsSettings() {
        return this.listTagsSettings;
    }

    public UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public DataCatalogStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcDataCatalogStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonDataCatalogStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "datacatalog.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "datacatalog.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return DataCatalogStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(DataCatalogStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(DataCatalogStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return DataCatalogStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected DataCatalogStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.searchCatalogSettings = settingsBuilder.searchCatalogSettings().build();
        this.createEntryGroupSettings = settingsBuilder.createEntryGroupSettings().build();
        this.updateEntryGroupSettings = settingsBuilder.updateEntryGroupSettings().build();
        this.getEntryGroupSettings = settingsBuilder.getEntryGroupSettings().build();
        this.deleteEntryGroupSettings = settingsBuilder.deleteEntryGroupSettings().build();
        this.listEntryGroupsSettings = settingsBuilder.listEntryGroupsSettings().build();
        this.createEntrySettings = settingsBuilder.createEntrySettings().build();
        this.updateEntrySettings = settingsBuilder.updateEntrySettings().build();
        this.deleteEntrySettings = settingsBuilder.deleteEntrySettings().build();
        this.getEntrySettings = settingsBuilder.getEntrySettings().build();
        this.lookupEntrySettings = settingsBuilder.lookupEntrySettings().build();
        this.listEntriesSettings = settingsBuilder.listEntriesSettings().build();
        this.createTagTemplateSettings = settingsBuilder.createTagTemplateSettings().build();
        this.getTagTemplateSettings = settingsBuilder.getTagTemplateSettings().build();
        this.updateTagTemplateSettings = settingsBuilder.updateTagTemplateSettings().build();
        this.deleteTagTemplateSettings = settingsBuilder.deleteTagTemplateSettings().build();
        this.createTagTemplateFieldSettings = settingsBuilder.createTagTemplateFieldSettings().build();
        this.updateTagTemplateFieldSettings = settingsBuilder.updateTagTemplateFieldSettings().build();
        this.renameTagTemplateFieldSettings = settingsBuilder.renameTagTemplateFieldSettings().build();
        this.deleteTagTemplateFieldSettings = settingsBuilder.deleteTagTemplateFieldSettings().build();
        this.createTagSettings = settingsBuilder.createTagSettings().build();
        this.updateTagSettings = settingsBuilder.updateTagSettings().build();
        this.deleteTagSettings = settingsBuilder.deleteTagSettings().build();
        this.listTagsSettings = settingsBuilder.listTagsSettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<DataCatalogStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<SearchCatalogRequest, SearchCatalogResponse, DataCatalogClient.SearchCatalogPagedResponse> searchCatalogSettings;
        private final UnaryCallSettings.Builder<CreateEntryGroupRequest, EntryGroup> createEntryGroupSettings;
        private final UnaryCallSettings.Builder<UpdateEntryGroupRequest, EntryGroup> updateEntryGroupSettings;
        private final UnaryCallSettings.Builder<GetEntryGroupRequest, EntryGroup> getEntryGroupSettings;
        private final UnaryCallSettings.Builder<DeleteEntryGroupRequest, Empty> deleteEntryGroupSettings;
        private final PagedCallSettings.Builder<ListEntryGroupsRequest, ListEntryGroupsResponse, DataCatalogClient.ListEntryGroupsPagedResponse> listEntryGroupsSettings;
        private final UnaryCallSettings.Builder<CreateEntryRequest, Entry> createEntrySettings;
        private final UnaryCallSettings.Builder<UpdateEntryRequest, Entry> updateEntrySettings;
        private final UnaryCallSettings.Builder<DeleteEntryRequest, Empty> deleteEntrySettings;
        private final UnaryCallSettings.Builder<GetEntryRequest, Entry> getEntrySettings;
        private final UnaryCallSettings.Builder<LookupEntryRequest, Entry> lookupEntrySettings;
        private final PagedCallSettings.Builder<ListEntriesRequest, ListEntriesResponse, DataCatalogClient.ListEntriesPagedResponse> listEntriesSettings;
        private final UnaryCallSettings.Builder<CreateTagTemplateRequest, TagTemplate> createTagTemplateSettings;
        private final UnaryCallSettings.Builder<GetTagTemplateRequest, TagTemplate> getTagTemplateSettings;
        private final UnaryCallSettings.Builder<UpdateTagTemplateRequest, TagTemplate> updateTagTemplateSettings;
        private final UnaryCallSettings.Builder<DeleteTagTemplateRequest, Empty> deleteTagTemplateSettings;
        private final UnaryCallSettings.Builder<CreateTagTemplateFieldRequest, TagTemplateField> createTagTemplateFieldSettings;
        private final UnaryCallSettings.Builder<UpdateTagTemplateFieldRequest, TagTemplateField> updateTagTemplateFieldSettings;
        private final UnaryCallSettings.Builder<RenameTagTemplateFieldRequest, TagTemplateField> renameTagTemplateFieldSettings;
        private final UnaryCallSettings.Builder<DeleteTagTemplateFieldRequest, Empty> deleteTagTemplateFieldSettings;
        private final UnaryCallSettings.Builder<CreateTagRequest, Tag> createTagSettings;
        private final UnaryCallSettings.Builder<UpdateTagRequest, Tag> updateTagSettings;
        private final UnaryCallSettings.Builder<DeleteTagRequest, Empty> deleteTagSettings;
        private final PagedCallSettings.Builder<ListTagsRequest, ListTagsResponse, DataCatalogClient.ListTagsPagedResponse> listTagsSettings;
        private final UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.searchCatalogSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)SEARCH_CATALOG_PAGE_STR_FACT);
            this.createEntryGroupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateEntryGroupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getEntryGroupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteEntryGroupSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listEntryGroupsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ENTRY_GROUPS_PAGE_STR_FACT);
            this.createEntrySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateEntrySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteEntrySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getEntrySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.lookupEntrySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listEntriesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ENTRIES_PAGE_STR_FACT);
            this.createTagTemplateSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getTagTemplateSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateTagTemplateSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteTagTemplateSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createTagTemplateFieldSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateTagTemplateFieldSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.renameTagTemplateFieldSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteTagTemplateFieldSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createTagSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateTagSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteTagSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listTagsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_TAGS_PAGE_STR_FACT);
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.searchCatalogSettings, this.createEntryGroupSettings, this.updateEntryGroupSettings, this.getEntryGroupSettings, this.deleteEntryGroupSettings, this.listEntryGroupsSettings, this.createEntrySettings, this.updateEntrySettings, this.deleteEntrySettings, this.getEntrySettings, this.lookupEntrySettings, this.listEntriesSettings, (Object[])new UnaryCallSettings.Builder[]{this.createTagTemplateSettings, this.getTagTemplateSettings, this.updateTagTemplateSettings, this.deleteTagTemplateSettings, this.createTagTemplateFieldSettings, this.updateTagTemplateFieldSettings, this.renameTagTemplateFieldSettings, this.deleteTagTemplateFieldSettings, this.createTagSettings, this.updateTagSettings, this.deleteTagSettings, this.listTagsSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings});
            Builder.initDefaults(this);
        }

        protected Builder(DataCatalogStubSettings settings) {
            super((StubSettings)settings);
            this.searchCatalogSettings = settings.searchCatalogSettings.toBuilder();
            this.createEntryGroupSettings = settings.createEntryGroupSettings.toBuilder();
            this.updateEntryGroupSettings = settings.updateEntryGroupSettings.toBuilder();
            this.getEntryGroupSettings = settings.getEntryGroupSettings.toBuilder();
            this.deleteEntryGroupSettings = settings.deleteEntryGroupSettings.toBuilder();
            this.listEntryGroupsSettings = settings.listEntryGroupsSettings.toBuilder();
            this.createEntrySettings = settings.createEntrySettings.toBuilder();
            this.updateEntrySettings = settings.updateEntrySettings.toBuilder();
            this.deleteEntrySettings = settings.deleteEntrySettings.toBuilder();
            this.getEntrySettings = settings.getEntrySettings.toBuilder();
            this.lookupEntrySettings = settings.lookupEntrySettings.toBuilder();
            this.listEntriesSettings = settings.listEntriesSettings.toBuilder();
            this.createTagTemplateSettings = settings.createTagTemplateSettings.toBuilder();
            this.getTagTemplateSettings = settings.getTagTemplateSettings.toBuilder();
            this.updateTagTemplateSettings = settings.updateTagTemplateSettings.toBuilder();
            this.deleteTagTemplateSettings = settings.deleteTagTemplateSettings.toBuilder();
            this.createTagTemplateFieldSettings = settings.createTagTemplateFieldSettings.toBuilder();
            this.updateTagTemplateFieldSettings = settings.updateTagTemplateFieldSettings.toBuilder();
            this.renameTagTemplateFieldSettings = settings.renameTagTemplateFieldSettings.toBuilder();
            this.deleteTagTemplateFieldSettings = settings.deleteTagTemplateFieldSettings.toBuilder();
            this.createTagSettings = settings.createTagSettings.toBuilder();
            this.updateTagSettings = settings.updateTagSettings.toBuilder();
            this.deleteTagSettings = settings.deleteTagSettings.toBuilder();
            this.listTagsSettings = settings.listTagsSettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.searchCatalogSettings, this.createEntryGroupSettings, this.updateEntryGroupSettings, this.getEntryGroupSettings, this.deleteEntryGroupSettings, this.listEntryGroupsSettings, this.createEntrySettings, this.updateEntrySettings, this.deleteEntrySettings, this.getEntrySettings, this.lookupEntrySettings, this.listEntriesSettings, (Object[])new UnaryCallSettings.Builder[]{this.createTagTemplateSettings, this.getTagTemplateSettings, this.updateTagTemplateSettings, this.deleteTagTemplateSettings, this.createTagTemplateFieldSettings, this.updateTagTemplateFieldSettings, this.renameTagTemplateFieldSettings, this.deleteTagTemplateFieldSettings, this.createTagSettings, this.updateTagSettings, this.deleteTagSettings, this.listTagsSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(DataCatalogStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)DataCatalogStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)DataCatalogStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(DataCatalogStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(DataCatalogStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)DataCatalogStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)DataCatalogStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)DataCatalogStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(DataCatalogStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(DataCatalogStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.searchCatalogSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.createEntryGroupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.updateEntryGroupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getEntryGroupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.deleteEntryGroupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.listEntryGroupsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.createEntrySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.updateEntrySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.deleteEntrySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.getEntrySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.lookupEntrySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.listEntriesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.createTagTemplateSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getTagTemplateSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.updateTagTemplateSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.deleteTagTemplateSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.createTagTemplateFieldSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.updateTagTemplateFieldSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.renameTagTemplateFieldSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.deleteTagTemplateFieldSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.createTagSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.updateTagSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.deleteTagSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.listTagsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<SearchCatalogRequest, SearchCatalogResponse, DataCatalogClient.SearchCatalogPagedResponse> searchCatalogSettings() {
            return this.searchCatalogSettings;
        }

        public UnaryCallSettings.Builder<CreateEntryGroupRequest, EntryGroup> createEntryGroupSettings() {
            return this.createEntryGroupSettings;
        }

        public UnaryCallSettings.Builder<UpdateEntryGroupRequest, EntryGroup> updateEntryGroupSettings() {
            return this.updateEntryGroupSettings;
        }

        public UnaryCallSettings.Builder<GetEntryGroupRequest, EntryGroup> getEntryGroupSettings() {
            return this.getEntryGroupSettings;
        }

        public UnaryCallSettings.Builder<DeleteEntryGroupRequest, Empty> deleteEntryGroupSettings() {
            return this.deleteEntryGroupSettings;
        }

        public PagedCallSettings.Builder<ListEntryGroupsRequest, ListEntryGroupsResponse, DataCatalogClient.ListEntryGroupsPagedResponse> listEntryGroupsSettings() {
            return this.listEntryGroupsSettings;
        }

        public UnaryCallSettings.Builder<CreateEntryRequest, Entry> createEntrySettings() {
            return this.createEntrySettings;
        }

        public UnaryCallSettings.Builder<UpdateEntryRequest, Entry> updateEntrySettings() {
            return this.updateEntrySettings;
        }

        public UnaryCallSettings.Builder<DeleteEntryRequest, Empty> deleteEntrySettings() {
            return this.deleteEntrySettings;
        }

        public UnaryCallSettings.Builder<GetEntryRequest, Entry> getEntrySettings() {
            return this.getEntrySettings;
        }

        public UnaryCallSettings.Builder<LookupEntryRequest, Entry> lookupEntrySettings() {
            return this.lookupEntrySettings;
        }

        public PagedCallSettings.Builder<ListEntriesRequest, ListEntriesResponse, DataCatalogClient.ListEntriesPagedResponse> listEntriesSettings() {
            return this.listEntriesSettings;
        }

        public UnaryCallSettings.Builder<CreateTagTemplateRequest, TagTemplate> createTagTemplateSettings() {
            return this.createTagTemplateSettings;
        }

        public UnaryCallSettings.Builder<GetTagTemplateRequest, TagTemplate> getTagTemplateSettings() {
            return this.getTagTemplateSettings;
        }

        public UnaryCallSettings.Builder<UpdateTagTemplateRequest, TagTemplate> updateTagTemplateSettings() {
            return this.updateTagTemplateSettings;
        }

        public UnaryCallSettings.Builder<DeleteTagTemplateRequest, Empty> deleteTagTemplateSettings() {
            return this.deleteTagTemplateSettings;
        }

        public UnaryCallSettings.Builder<CreateTagTemplateFieldRequest, TagTemplateField> createTagTemplateFieldSettings() {
            return this.createTagTemplateFieldSettings;
        }

        public UnaryCallSettings.Builder<UpdateTagTemplateFieldRequest, TagTemplateField> updateTagTemplateFieldSettings() {
            return this.updateTagTemplateFieldSettings;
        }

        public UnaryCallSettings.Builder<RenameTagTemplateFieldRequest, TagTemplateField> renameTagTemplateFieldSettings() {
            return this.renameTagTemplateFieldSettings;
        }

        public UnaryCallSettings.Builder<DeleteTagTemplateFieldRequest, Empty> deleteTagTemplateFieldSettings() {
            return this.deleteTagTemplateFieldSettings;
        }

        public UnaryCallSettings.Builder<CreateTagRequest, Tag> createTagSettings() {
            return this.createTagSettings;
        }

        public UnaryCallSettings.Builder<UpdateTagRequest, Tag> updateTagSettings() {
            return this.updateTagSettings;
        }

        public UnaryCallSettings.Builder<DeleteTagRequest, Empty> deleteTagSettings() {
            return this.deleteTagSettings;
        }

        public PagedCallSettings.Builder<ListTagsRequest, ListTagsResponse, DataCatalogClient.ListTagsPagedResponse> listTagsSettings() {
            return this.listTagsSettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public DataCatalogStubSettings build() throws IOException {
            return new DataCatalogStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_1_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

