/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datafusion.v1beta1.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.datafusion.v1beta1.AddDnsPeeringRequest;
import com.google.cloud.datafusion.v1beta1.AddDnsPeeringResponse;
import com.google.cloud.datafusion.v1beta1.CreateInstanceRequest;
import com.google.cloud.datafusion.v1beta1.DataFusionClient;
import com.google.cloud.datafusion.v1beta1.DeleteInstanceRequest;
import com.google.cloud.datafusion.v1beta1.GetInstanceRequest;
import com.google.cloud.datafusion.v1beta1.Instance;
import com.google.cloud.datafusion.v1beta1.ListAvailableVersionsRequest;
import com.google.cloud.datafusion.v1beta1.ListAvailableVersionsResponse;
import com.google.cloud.datafusion.v1beta1.ListDnsPeeringsRequest;
import com.google.cloud.datafusion.v1beta1.ListDnsPeeringsResponse;
import com.google.cloud.datafusion.v1beta1.ListInstancesRequest;
import com.google.cloud.datafusion.v1beta1.ListInstancesResponse;
import com.google.cloud.datafusion.v1beta1.ListNamespacesRequest;
import com.google.cloud.datafusion.v1beta1.ListNamespacesResponse;
import com.google.cloud.datafusion.v1beta1.OperationMetadata;
import com.google.cloud.datafusion.v1beta1.RemoveDnsPeeringRequest;
import com.google.cloud.datafusion.v1beta1.RemoveDnsPeeringResponse;
import com.google.cloud.datafusion.v1beta1.RemoveIamPolicyRequest;
import com.google.cloud.datafusion.v1beta1.RemoveIamPolicyResponse;
import com.google.cloud.datafusion.v1beta1.RestartInstanceRequest;
import com.google.cloud.datafusion.v1beta1.UpdateInstanceRequest;
import com.google.cloud.datafusion.v1beta1.UpgradeInstanceRequest;
import com.google.cloud.datafusion.v1beta1.stub.DataFusionStub;
import com.google.cloud.datafusion.v1beta1.stub.DataFusionStubSettings;
import com.google.cloud.datafusion.v1beta1.stub.GrpcDataFusionCallableFactory;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcDataFusionStub
extends DataFusionStub {
    private static final MethodDescriptor<ListAvailableVersionsRequest, ListAvailableVersionsResponse> listAvailableVersionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.datafusion.v1beta1.DataFusion/ListAvailableVersions").setRequestMarshaller(ProtoUtils.marshaller((Message)ListAvailableVersionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListAvailableVersionsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<ListInstancesRequest, ListInstancesResponse> listInstancesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.datafusion.v1beta1.DataFusion/ListInstances").setRequestMarshaller(ProtoUtils.marshaller((Message)ListInstancesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListInstancesResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetInstanceRequest, Instance> getInstanceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.datafusion.v1beta1.DataFusion/GetInstance").setRequestMarshaller(ProtoUtils.marshaller((Message)GetInstanceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Instance.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateInstanceRequest, Operation> createInstanceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.datafusion.v1beta1.DataFusion/CreateInstance").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateInstanceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteInstanceRequest, Operation> deleteInstanceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.datafusion.v1beta1.DataFusion/DeleteInstance").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteInstanceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateInstanceRequest, Operation> updateInstanceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.datafusion.v1beta1.DataFusion/UpdateInstance").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateInstanceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<RestartInstanceRequest, Operation> restartInstanceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.datafusion.v1beta1.DataFusion/RestartInstance").setRequestMarshaller(ProtoUtils.marshaller((Message)RestartInstanceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<UpgradeInstanceRequest, Operation> upgradeInstanceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.datafusion.v1beta1.DataFusion/UpgradeInstance").setRequestMarshaller(ProtoUtils.marshaller((Message)UpgradeInstanceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<RemoveIamPolicyRequest, RemoveIamPolicyResponse> removeIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.datafusion.v1beta1.DataFusion/RemoveIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)RemoveIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)RemoveIamPolicyResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<ListNamespacesRequest, ListNamespacesResponse> listNamespacesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.datafusion.v1beta1.DataFusion/ListNamespaces").setRequestMarshaller(ProtoUtils.marshaller((Message)ListNamespacesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListNamespacesResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<AddDnsPeeringRequest, AddDnsPeeringResponse> addDnsPeeringMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.datafusion.v1beta1.DataFusion/AddDnsPeering").setRequestMarshaller(ProtoUtils.marshaller((Message)AddDnsPeeringRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)AddDnsPeeringResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<RemoveDnsPeeringRequest, RemoveDnsPeeringResponse> removeDnsPeeringMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.datafusion.v1beta1.DataFusion/RemoveDnsPeering").setRequestMarshaller(ProtoUtils.marshaller((Message)RemoveDnsPeeringRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)RemoveDnsPeeringResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<ListDnsPeeringsRequest, ListDnsPeeringsResponse> listDnsPeeringsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.datafusion.v1beta1.DataFusion/ListDnsPeerings").setRequestMarshaller(ProtoUtils.marshaller((Message)ListDnsPeeringsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListDnsPeeringsResponse.getDefaultInstance())).build();
    private final UnaryCallable<ListAvailableVersionsRequest, ListAvailableVersionsResponse> listAvailableVersionsCallable;
    private final UnaryCallable<ListAvailableVersionsRequest, DataFusionClient.ListAvailableVersionsPagedResponse> listAvailableVersionsPagedCallable;
    private final UnaryCallable<ListInstancesRequest, ListInstancesResponse> listInstancesCallable;
    private final UnaryCallable<ListInstancesRequest, DataFusionClient.ListInstancesPagedResponse> listInstancesPagedCallable;
    private final UnaryCallable<GetInstanceRequest, Instance> getInstanceCallable;
    private final UnaryCallable<CreateInstanceRequest, Operation> createInstanceCallable;
    private final OperationCallable<CreateInstanceRequest, Instance, OperationMetadata> createInstanceOperationCallable;
    private final UnaryCallable<DeleteInstanceRequest, Operation> deleteInstanceCallable;
    private final OperationCallable<DeleteInstanceRequest, Empty, OperationMetadata> deleteInstanceOperationCallable;
    private final UnaryCallable<UpdateInstanceRequest, Operation> updateInstanceCallable;
    private final OperationCallable<UpdateInstanceRequest, Instance, OperationMetadata> updateInstanceOperationCallable;
    private final UnaryCallable<RestartInstanceRequest, Operation> restartInstanceCallable;
    private final OperationCallable<RestartInstanceRequest, Instance, OperationMetadata> restartInstanceOperationCallable;
    private final UnaryCallable<UpgradeInstanceRequest, Operation> upgradeInstanceCallable;
    private final OperationCallable<UpgradeInstanceRequest, Instance, OperationMetadata> upgradeInstanceOperationCallable;
    private final UnaryCallable<RemoveIamPolicyRequest, RemoveIamPolicyResponse> removeIamPolicyCallable;
    private final UnaryCallable<ListNamespacesRequest, ListNamespacesResponse> listNamespacesCallable;
    private final UnaryCallable<ListNamespacesRequest, DataFusionClient.ListNamespacesPagedResponse> listNamespacesPagedCallable;
    private final UnaryCallable<AddDnsPeeringRequest, AddDnsPeeringResponse> addDnsPeeringCallable;
    private final UnaryCallable<RemoveDnsPeeringRequest, RemoveDnsPeeringResponse> removeDnsPeeringCallable;
    private final UnaryCallable<ListDnsPeeringsRequest, ListDnsPeeringsResponse> listDnsPeeringsCallable;
    private final UnaryCallable<ListDnsPeeringsRequest, DataFusionClient.ListDnsPeeringsPagedResponse> listDnsPeeringsPagedCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcDataFusionStub create(DataFusionStubSettings settings) throws IOException {
        return new GrpcDataFusionStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcDataFusionStub create(ClientContext clientContext) throws IOException {
        return new GrpcDataFusionStub(DataFusionStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcDataFusionStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcDataFusionStub(DataFusionStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcDataFusionStub(DataFusionStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcDataFusionCallableFactory());
    }

    protected GrpcDataFusionStub(DataFusionStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings listAvailableVersionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listAvailableVersionsMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<ListAvailableVersionsRequest>(){

            public Map<String, String> extract(ListAvailableVersionsRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        GrpcCallSettings listInstancesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listInstancesMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<ListInstancesRequest>(){

            public Map<String, String> extract(ListInstancesRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        GrpcCallSettings getInstanceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getInstanceMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<GetInstanceRequest>(){

            public Map<String, String> extract(GetInstanceRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings createInstanceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createInstanceMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<CreateInstanceRequest>(){

            public Map<String, String> extract(CreateInstanceRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        GrpcCallSettings deleteInstanceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteInstanceMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<DeleteInstanceRequest>(){

            public Map<String, String> extract(DeleteInstanceRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings updateInstanceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateInstanceMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<UpdateInstanceRequest>(){

            public Map<String, String> extract(UpdateInstanceRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"instance.name", (Object)String.valueOf(request.getInstance().getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings restartInstanceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(restartInstanceMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<RestartInstanceRequest>(){

            public Map<String, String> extract(RestartInstanceRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings upgradeInstanceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(upgradeInstanceMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<UpgradeInstanceRequest>(){

            public Map<String, String> extract(UpgradeInstanceRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings removeIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(removeIamPolicyMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<RemoveIamPolicyRequest>(){

            public Map<String, String> extract(RemoveIamPolicyRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"resource", (Object)String.valueOf(request.getResource()));
                return params.build();
            }
        }).build();
        GrpcCallSettings listNamespacesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listNamespacesMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<ListNamespacesRequest>(){

            public Map<String, String> extract(ListNamespacesRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        GrpcCallSettings addDnsPeeringTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(addDnsPeeringMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<AddDnsPeeringRequest>(){

            public Map<String, String> extract(AddDnsPeeringRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        GrpcCallSettings removeDnsPeeringTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(removeDnsPeeringMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<RemoveDnsPeeringRequest>(){

            public Map<String, String> extract(RemoveDnsPeeringRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        GrpcCallSettings listDnsPeeringsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listDnsPeeringsMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<ListDnsPeeringsRequest>(){

            public Map<String, String> extract(ListDnsPeeringsRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        this.listAvailableVersionsCallable = callableFactory.createUnaryCallable(listAvailableVersionsTransportSettings, settings.listAvailableVersionsSettings(), clientContext);
        this.listAvailableVersionsPagedCallable = callableFactory.createPagedCallable(listAvailableVersionsTransportSettings, settings.listAvailableVersionsSettings(), clientContext);
        this.listInstancesCallable = callableFactory.createUnaryCallable(listInstancesTransportSettings, settings.listInstancesSettings(), clientContext);
        this.listInstancesPagedCallable = callableFactory.createPagedCallable(listInstancesTransportSettings, settings.listInstancesSettings(), clientContext);
        this.getInstanceCallable = callableFactory.createUnaryCallable(getInstanceTransportSettings, settings.getInstanceSettings(), clientContext);
        this.createInstanceCallable = callableFactory.createUnaryCallable(createInstanceTransportSettings, settings.createInstanceSettings(), clientContext);
        this.createInstanceOperationCallable = callableFactory.createOperationCallable(createInstanceTransportSettings, settings.createInstanceOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.deleteInstanceCallable = callableFactory.createUnaryCallable(deleteInstanceTransportSettings, settings.deleteInstanceSettings(), clientContext);
        this.deleteInstanceOperationCallable = callableFactory.createOperationCallable(deleteInstanceTransportSettings, settings.deleteInstanceOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.updateInstanceCallable = callableFactory.createUnaryCallable(updateInstanceTransportSettings, settings.updateInstanceSettings(), clientContext);
        this.updateInstanceOperationCallable = callableFactory.createOperationCallable(updateInstanceTransportSettings, settings.updateInstanceOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.restartInstanceCallable = callableFactory.createUnaryCallable(restartInstanceTransportSettings, settings.restartInstanceSettings(), clientContext);
        this.restartInstanceOperationCallable = callableFactory.createOperationCallable(restartInstanceTransportSettings, settings.restartInstanceOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.upgradeInstanceCallable = callableFactory.createUnaryCallable(upgradeInstanceTransportSettings, settings.upgradeInstanceSettings(), clientContext);
        this.upgradeInstanceOperationCallable = callableFactory.createOperationCallable(upgradeInstanceTransportSettings, settings.upgradeInstanceOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.removeIamPolicyCallable = callableFactory.createUnaryCallable(removeIamPolicyTransportSettings, settings.removeIamPolicySettings(), clientContext);
        this.listNamespacesCallable = callableFactory.createUnaryCallable(listNamespacesTransportSettings, settings.listNamespacesSettings(), clientContext);
        this.listNamespacesPagedCallable = callableFactory.createPagedCallable(listNamespacesTransportSettings, settings.listNamespacesSettings(), clientContext);
        this.addDnsPeeringCallable = callableFactory.createUnaryCallable(addDnsPeeringTransportSettings, settings.addDnsPeeringSettings(), clientContext);
        this.removeDnsPeeringCallable = callableFactory.createUnaryCallable(removeDnsPeeringTransportSettings, settings.removeDnsPeeringSettings(), clientContext);
        this.listDnsPeeringsCallable = callableFactory.createUnaryCallable(listDnsPeeringsTransportSettings, settings.listDnsPeeringsSettings(), clientContext);
        this.listDnsPeeringsPagedCallable = callableFactory.createPagedCallable(listDnsPeeringsTransportSettings, settings.listDnsPeeringsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ListAvailableVersionsRequest, ListAvailableVersionsResponse> listAvailableVersionsCallable() {
        return this.listAvailableVersionsCallable;
    }

    @Override
    public UnaryCallable<ListAvailableVersionsRequest, DataFusionClient.ListAvailableVersionsPagedResponse> listAvailableVersionsPagedCallable() {
        return this.listAvailableVersionsPagedCallable;
    }

    @Override
    public UnaryCallable<ListInstancesRequest, ListInstancesResponse> listInstancesCallable() {
        return this.listInstancesCallable;
    }

    @Override
    public UnaryCallable<ListInstancesRequest, DataFusionClient.ListInstancesPagedResponse> listInstancesPagedCallable() {
        return this.listInstancesPagedCallable;
    }

    @Override
    public UnaryCallable<GetInstanceRequest, Instance> getInstanceCallable() {
        return this.getInstanceCallable;
    }

    @Override
    public UnaryCallable<CreateInstanceRequest, Operation> createInstanceCallable() {
        return this.createInstanceCallable;
    }

    @Override
    public OperationCallable<CreateInstanceRequest, Instance, OperationMetadata> createInstanceOperationCallable() {
        return this.createInstanceOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteInstanceRequest, Operation> deleteInstanceCallable() {
        return this.deleteInstanceCallable;
    }

    @Override
    public OperationCallable<DeleteInstanceRequest, Empty, OperationMetadata> deleteInstanceOperationCallable() {
        return this.deleteInstanceOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateInstanceRequest, Operation> updateInstanceCallable() {
        return this.updateInstanceCallable;
    }

    @Override
    public OperationCallable<UpdateInstanceRequest, Instance, OperationMetadata> updateInstanceOperationCallable() {
        return this.updateInstanceOperationCallable;
    }

    @Override
    public UnaryCallable<RestartInstanceRequest, Operation> restartInstanceCallable() {
        return this.restartInstanceCallable;
    }

    @Override
    public OperationCallable<RestartInstanceRequest, Instance, OperationMetadata> restartInstanceOperationCallable() {
        return this.restartInstanceOperationCallable;
    }

    @Override
    public UnaryCallable<UpgradeInstanceRequest, Operation> upgradeInstanceCallable() {
        return this.upgradeInstanceCallable;
    }

    @Override
    public OperationCallable<UpgradeInstanceRequest, Instance, OperationMetadata> upgradeInstanceOperationCallable() {
        return this.upgradeInstanceOperationCallable;
    }

    @Override
    public UnaryCallable<RemoveIamPolicyRequest, RemoveIamPolicyResponse> removeIamPolicyCallable() {
        return this.removeIamPolicyCallable;
    }

    @Override
    public UnaryCallable<ListNamespacesRequest, ListNamespacesResponse> listNamespacesCallable() {
        return this.listNamespacesCallable;
    }

    @Override
    public UnaryCallable<ListNamespacesRequest, DataFusionClient.ListNamespacesPagedResponse> listNamespacesPagedCallable() {
        return this.listNamespacesPagedCallable;
    }

    @Override
    public UnaryCallable<AddDnsPeeringRequest, AddDnsPeeringResponse> addDnsPeeringCallable() {
        return this.addDnsPeeringCallable;
    }

    @Override
    public UnaryCallable<RemoveDnsPeeringRequest, RemoveDnsPeeringResponse> removeDnsPeeringCallable() {
        return this.removeDnsPeeringCallable;
    }

    @Override
    public UnaryCallable<ListDnsPeeringsRequest, ListDnsPeeringsResponse> listDnsPeeringsCallable() {
        return this.listDnsPeeringsCallable;
    }

    @Override
    public UnaryCallable<ListDnsPeeringsRequest, DataFusionClient.ListDnsPeeringsPagedResponse> listDnsPeeringsPagedCallable() {
        return this.listDnsPeeringsPagedCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

