/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud;

import com.google.api.client.extensions.appengine.http.UrlFetchTransport;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.auth.Credentials;
import com.google.auth.http.HttpCredentialsAdapter;
import com.google.auth.http.HttpTransportFactory;
import com.google.cloud.NoCredentials;
import com.google.cloud.ServiceOptions;
import com.google.cloud.TransportOptions;
import com.google.common.base.MoreObjects;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Objects;

public class HttpTransportOptions
implements TransportOptions {
    private static final long serialVersionUID = 7890117765045419810L;
    private final int connectTimeout;
    private final int readTimeout;
    private final String httpTransportFactoryClassName;
    private transient HttpTransportFactory httpTransportFactory;

    protected HttpTransportOptions(Builder builder) {
        this.httpTransportFactory = (HttpTransportFactory)MoreObjects.firstNonNull((Object)builder.httpTransportFactory, (Object)ServiceOptions.getFromServiceLoader(HttpTransportFactory.class, DefaultHttpTransportFactory.INSTANCE));
        this.httpTransportFactoryClassName = this.httpTransportFactory.getClass().getName();
        this.connectTimeout = builder.connectTimeout;
        this.readTimeout = builder.readTimeout;
    }

    public HttpTransportFactory getHttpTransportFactory() {
        return this.httpTransportFactory;
    }

    public HttpRequestInitializer getHttpRequestInitializer(ServiceOptions<?, ?> serviceOptions) {
        Credentials scopedCredentials = serviceOptions.getScopedCredentials();
        HttpCredentialsAdapter delegate = scopedCredentials != null && scopedCredentials != NoCredentials.getInstance() ? new HttpCredentialsAdapter(scopedCredentials) : null;
        return new HttpRequestInitializer((HttpRequestInitializer)delegate, serviceOptions){
            final /* synthetic */ HttpRequestInitializer val$delegate;
            final /* synthetic */ ServiceOptions val$serviceOptions;
            {
                this.val$delegate = httpRequestInitializer;
                this.val$serviceOptions = serviceOptions;
            }

            public void initialize(HttpRequest httpRequest) throws IOException {
                if (this.val$delegate != null) {
                    this.val$delegate.initialize(httpRequest);
                }
                if (HttpTransportOptions.this.connectTimeout >= 0) {
                    httpRequest.setConnectTimeout(HttpTransportOptions.this.connectTimeout);
                }
                if (HttpTransportOptions.this.readTimeout >= 0) {
                    httpRequest.setReadTimeout(HttpTransportOptions.this.readTimeout);
                }
                HttpHeaders headers = httpRequest.getHeaders();
                headers.set("x-goog-api-client", (Object)HttpTransportOptions.this.getXGoogApiClientHeader(this.val$serviceOptions));
            }
        };
    }

    String getXGoogApiClientHeader(ServiceOptions<?, ?> serviceOptions) {
        return String.format("gl-java/%s %s/%s", HttpTransportOptions.getJavaVersion(), ServiceOptions.getGoogApiClientLibName(), serviceOptions.getLibraryVersion());
    }

    private static String getJavaVersion() {
        String javaVersion = Runtime.class.getPackage().getImplementationVersion();
        return javaVersion != null ? javaVersion : "";
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public int hashCode() {
        return Objects.hash(this.httpTransportFactoryClassName, this.connectTimeout, this.readTimeout);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HttpTransportOptions other = (HttpTransportOptions)obj;
        return Objects.equals(this.httpTransportFactoryClassName, other.httpTransportFactoryClassName) && Objects.equals(this.connectTimeout, other.connectTimeout) && Objects.equals(this.readTimeout, other.readTimeout);
    }

    private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
        this.httpTransportFactory = (HttpTransportFactory)ServiceOptions.newInstance(this.httpTransportFactoryClassName);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private HttpTransportFactory httpTransportFactory;
        private int connectTimeout = -1;
        private int readTimeout = -1;

        private Builder() {
        }

        private Builder(HttpTransportOptions options) {
            this.httpTransportFactory = options.httpTransportFactory;
            this.connectTimeout = options.connectTimeout;
            this.readTimeout = options.readTimeout;
        }

        public HttpTransportOptions build() {
            return new HttpTransportOptions(this);
        }

        public Builder setHttpTransportFactory(HttpTransportFactory httpTransportFactory) {
            this.httpTransportFactory = httpTransportFactory;
            return this;
        }

        public Builder setConnectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder setReadTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }
    }

    public static class DefaultHttpTransportFactory
    implements HttpTransportFactory {
        private static final HttpTransportFactory INSTANCE = new DefaultHttpTransportFactory();

        public HttpTransport create() {
            if (System.getProperty("com.google.appengine.runtime.version") != null && System.getenv("GAE_SERVICE") == null) {
                try {
                    return new UrlFetchTransport();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return new NetHttpTransport();
        }
    }
}

