/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud;

import com.google.api.client.googleapis.json.GoogleJsonError;
import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.client.http.HttpResponseException;
import com.google.api.gax.grpc.ApiException;
import com.google.cloud.RetryHelper;
import com.google.common.base.MoreObjects;
import java.io.IOException;
import java.io.Serializable;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;

public class BaseServiceException
extends RuntimeException {
    private static final long serialVersionUID = 759921776378760835L;
    public static final int UNKNOWN_CODE = 0;
    private final int code;
    private final boolean retryable;
    private final String reason;
    private final boolean idempotent;
    private final String location;
    private final String debugInfo;

    public BaseServiceException(IOException exception, boolean idempotent) {
        super(BaseServiceException.message(exception), exception);
        int code = 0;
        String reason = null;
        String location = null;
        String debugInfo = null;
        Boolean retryable = null;
        if (exception instanceof HttpResponseException) {
            if (exception instanceof GoogleJsonResponseException) {
                GoogleJsonError jsonError = ((GoogleJsonResponseException)exception).getDetails();
                if (jsonError != null) {
                    Error error = new Error(jsonError.getCode(), BaseServiceException.reason(jsonError));
                    code = error.code;
                    reason = error.reason;
                    retryable = this.isRetryable(idempotent, error);
                    if (reason != null) {
                        GoogleJsonError.ErrorInfo errorInfo = (GoogleJsonError.ErrorInfo)jsonError.getErrors().get(0);
                        location = errorInfo.getLocation();
                        debugInfo = (String)errorInfo.get((Object)"debugInfo");
                    }
                } else {
                    code = ((GoogleJsonResponseException)exception).getStatusCode();
                }
            } else {
                code = ((HttpResponseException)exception).getStatusCode();
                retryable = this.isRetryable(idempotent, new Error(code, null));
            }
        }
        this.retryable = (Boolean)MoreObjects.firstNonNull(retryable, (Object)this.isRetryable(idempotent, exception));
        this.code = code;
        this.reason = reason;
        this.idempotent = idempotent;
        this.location = location;
        this.debugInfo = debugInfo;
    }

    public BaseServiceException(GoogleJsonError googleJsonError, boolean idempotent) {
        super(googleJsonError.getMessage());
        Error error = new Error(googleJsonError.getCode(), BaseServiceException.reason(googleJsonError));
        this.code = error.code;
        this.reason = error.reason;
        this.retryable = this.isRetryable(idempotent, error);
        if (this.reason != null) {
            GoogleJsonError.ErrorInfo errorInfo = (GoogleJsonError.ErrorInfo)googleJsonError.getErrors().get(0);
            this.location = errorInfo.getLocation();
            this.debugInfo = (String)errorInfo.get((Object)"debugInfo");
        } else {
            this.location = null;
            this.debugInfo = null;
        }
        this.idempotent = idempotent;
    }

    public BaseServiceException(int code, String message, String reason, boolean idempotent) {
        this(code, message, reason, idempotent, null);
    }

    public BaseServiceException(int code, String message, String reason, boolean idempotent, Throwable cause) {
        super(message, cause);
        this.code = code;
        this.reason = reason;
        this.idempotent = idempotent;
        this.retryable = this.isRetryable(idempotent, new Error(code, reason));
        this.location = null;
        this.debugInfo = null;
    }

    public BaseServiceException(ApiException apiException, boolean idempotent) {
        super(apiException.getMessage(), (Throwable)apiException);
        this.code = apiException.getStatusCode().value();
        this.reason = apiException.getStatusCode().name();
        this.idempotent = idempotent;
        this.retryable = apiException.isRetryable();
        this.location = null;
        this.debugInfo = null;
    }

    @Deprecated
    protected Set<Error> retryableErrors() {
        return this.getRetryableErrors();
    }

    protected Set<Error> getRetryableErrors() {
        return Collections.emptySet();
    }

    protected boolean isRetryable(boolean idempotent, Error error) {
        return error.isRetryable(idempotent, this.getRetryableErrors());
    }

    protected boolean isRetryable(boolean idempotent, IOException exception) {
        boolean exceptionIsRetryable = exception instanceof SocketTimeoutException || exception instanceof SocketException || "insufficient data written".equals(exception.getMessage());
        return idempotent && exceptionIsRetryable;
    }

    @Deprecated
    public int code() {
        return this.getCode();
    }

    public int getCode() {
        return this.code;
    }

    @Deprecated
    public String reason() {
        return this.getReason();
    }

    public String getReason() {
        return this.reason;
    }

    @Deprecated
    public boolean retryable() {
        return this.isRetryable();
    }

    public boolean isRetryable() {
        return this.retryable;
    }

    @Deprecated
    public boolean idempotent() {
        return this.isIdempotent();
    }

    public boolean isIdempotent() {
        return this.idempotent;
    }

    @Deprecated
    public String location() {
        return this.getLocation();
    }

    public String getLocation() {
        return this.location;
    }

    @Deprecated
    protected String debugInfo() {
        return this.getDebugInfo();
    }

    protected String getDebugInfo() {
        return this.debugInfo;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BaseServiceException)) {
            return false;
        }
        BaseServiceException other = (BaseServiceException)obj;
        return Objects.equals(this.getCause(), other.getCause()) && Objects.equals(this.getMessage(), other.getMessage()) && this.code == other.code && this.retryable == other.retryable && Objects.equals(this.reason, other.reason) && this.idempotent == other.idempotent && Objects.equals(this.location, other.location) && Objects.equals(this.debugInfo, other.debugInfo);
    }

    public int hashCode() {
        return Objects.hash(this.getCause(), this.getMessage(), this.code, this.retryable, this.reason, this.idempotent, this.location, this.debugInfo);
    }

    private static String reason(GoogleJsonError error) {
        if (error.getErrors() != null && !error.getErrors().isEmpty()) {
            return ((GoogleJsonError.ErrorInfo)error.getErrors().get(0)).getReason();
        }
        return null;
    }

    private static String message(IOException exception) {
        GoogleJsonError details;
        if (exception instanceof GoogleJsonResponseException && (details = ((GoogleJsonResponseException)exception).getDetails()) != null) {
            return details.getMessage();
        }
        return exception.getMessage();
    }

    protected static void translateAndPropagateIfPossible(RetryHelper.RetryHelperException ex) {
        if (ex.getCause() instanceof BaseServiceException) {
            throw (BaseServiceException)ex.getCause();
        }
        if (ex instanceof RetryHelper.RetryInterruptedException) {
            RetryHelper.RetryInterruptedException.propagate();
        }
    }

    protected static final class Error
    implements Serializable {
        private static final long serialVersionUID = -4019600198652965721L;
        private final Integer code;
        private final String reason;
        private final boolean rejected;

        public Error(Integer code, String reason) {
            this(code, reason, false);
        }

        public Error(Integer code, String reason, boolean rejected) {
            this.code = code;
            this.reason = reason;
            this.rejected = rejected;
        }

        @Deprecated
        public Integer code() {
            return this.getCode();
        }

        public Integer getCode() {
            return this.code;
        }

        @Deprecated
        public boolean rejected() {
            return this.isRejected();
        }

        public boolean isRejected() {
            return this.rejected;
        }

        @Deprecated
        public String reason() {
            return this.getReason();
        }

        public String getReason() {
            return this.reason;
        }

        boolean isRetryable(boolean idempotent, Set<Error> retryableErrors) {
            for (Error retryableError : retryableErrors) {
                if (retryableError.getCode() != null && !retryableError.getCode().equals(this.getCode()) || retryableError.getReason() != null && !retryableError.getReason().equals(this.getReason())) continue;
                return idempotent || retryableError.isRejected();
            }
            return false;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("code", (Object)this.code).add("reason", (Object)this.reason).toString();
        }

        public int hashCode() {
            return Objects.hash(this.code, this.reason);
        }
    }
}

