/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud;

import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Objects;

public final class Identity
implements Serializable {
    private static final long serialVersionUID = -8181841964597657446L;
    private final Type type;
    private final String value;

    private Identity(Type type, String value) {
        this.type = type;
        this.value = value;
    }

    public Type type() {
        return this.type;
    }

    public String value() {
        return this.value;
    }

    public static Identity allUsers() {
        return new Identity(Type.ALL_USERS, null);
    }

    public static Identity allAuthenticatedUsers() {
        return new Identity(Type.ALL_AUTHENTICATED_USERS, null);
    }

    public static Identity user(String email) {
        return new Identity(Type.USER, (String)Preconditions.checkNotNull((Object)email));
    }

    public static Identity serviceAccount(String email) {
        return new Identity(Type.SERVICE_ACCOUNT, (String)Preconditions.checkNotNull((Object)email));
    }

    public static Identity group(String email) {
        return new Identity(Type.GROUP, (String)Preconditions.checkNotNull((Object)email));
    }

    public static Identity domain(String domain) {
        return new Identity(Type.DOMAIN, (String)Preconditions.checkNotNull((Object)domain));
    }

    public String toString() {
        return this.strValue();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.value, this.type});
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Identity)) {
            return false;
        }
        Identity other = (Identity)obj;
        return Objects.equals(this.value, other.value()) && Objects.equals((Object)this.type, (Object)other.type());
    }

    public String strValue() {
        switch (this.type) {
            case ALL_USERS: {
                return "allUsers";
            }
            case ALL_AUTHENTICATED_USERS: {
                return "allAuthenticatedUsers";
            }
            case USER: {
                return "user:" + this.value;
            }
            case SERVICE_ACCOUNT: {
                return "serviceAccount:" + this.value;
            }
            case GROUP: {
                return "group:" + this.value;
            }
            case DOMAIN: {
                return "domain:" + this.value;
            }
        }
        throw new IllegalStateException("Unexpected identity type: " + (Object)((Object)this.type));
    }

    public static Identity valueOf(String identityStr) {
        String[] info = identityStr.split(":");
        Type type = Type.valueOf(CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, info[0]));
        switch (type) {
            case ALL_USERS: {
                return Identity.allUsers();
            }
            case ALL_AUTHENTICATED_USERS: {
                return Identity.allAuthenticatedUsers();
            }
            case USER: {
                return Identity.user(info[1]);
            }
            case SERVICE_ACCOUNT: {
                return Identity.serviceAccount(info[1]);
            }
            case GROUP: {
                return Identity.group(info[1]);
            }
            case DOMAIN: {
                return Identity.domain(info[1]);
            }
        }
        throw new IllegalStateException("Unexpected identity type " + (Object)((Object)type));
    }

    public static enum Type {
        ALL_USERS,
        ALL_AUTHENTICATED_USERS,
        USER,
        SERVICE_ACCOUNT,
        GROUP,
        DOMAIN;

    }
}

