/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud;

import com.google.api.gax.core.ApiFuture;
import com.google.api.gax.core.ApiFutures;
import com.google.cloud.AsyncPage;
import com.google.cloud.Page;
import com.google.cloud.PageImpl;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.Serializable;
import java.util.concurrent.ExecutionException;

public class AsyncPageImpl<T>
extends PageImpl<T>
implements AsyncPage<T> {
    private static final long serialVersionUID = -6009473188630364906L;
    private final NextPageFetcher<T> asyncPageFetcher;

    public AsyncPageImpl(NextPageFetcher<T> asyncPageFetcher, String cursor, Iterable<T> results) {
        super(new SyncNextPageFetcher(asyncPageFetcher), cursor, results);
        this.asyncPageFetcher = asyncPageFetcher;
    }

    @Override
    public ApiFuture<AsyncPage<T>> getNextPageAsync() {
        if (this.getNextPageCursor() == null || this.asyncPageFetcher == null) {
            return ApiFutures.immediateFuture(null);
        }
        return this.asyncPageFetcher.getNextPage();
    }

    private static class SyncNextPageFetcher<T>
    implements PageImpl.NextPageFetcher<T> {
        private static final long serialVersionUID = -4124568632363525351L;
        private final NextPageFetcher<T> asyncPageFetcher;

        private SyncNextPageFetcher(NextPageFetcher<T> asyncPageFetcher) {
            this.asyncPageFetcher = asyncPageFetcher;
        }

        @Override
        public Page<T> getNextPage() {
            try {
                return this.asyncPageFetcher != null ? (AsyncPage)Uninterruptibles.getUninterruptibly(this.asyncPageFetcher.getNextPage()) : null;
            }
            catch (ExecutionException ex) {
                throw Throwables.propagate((Throwable)ex.getCause());
            }
        }
    }

    public static interface NextPageFetcher<T>
    extends Serializable {
        public ApiFuture<AsyncPage<T>> getNextPage();
    }
}

