/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.grpc;

import com.google.api.client.http.HttpResponseException;
import com.google.api.gax.grpc.ApiException;
import com.google.cloud.BaseServiceException;
import com.google.common.base.MoreObjects;
import java.io.IOException;
import java.util.Collections;

public class BaseGrpcServiceException
extends BaseServiceException {
    private static final long serialVersionUID = -2685197215731335549L;

    public BaseGrpcServiceException(String message, Throwable cause, int code, boolean retryable) {
        super(BaseServiceException.ExceptionData.newBuilder().setMessage(message).setCause(cause).setCode(code).setRetryable(retryable).build());
    }

    public BaseGrpcServiceException(IOException exception, boolean idempotent) {
        super(BaseGrpcServiceException.makeExceptionData(exception, idempotent));
    }

    private static BaseServiceException.ExceptionData makeExceptionData(IOException exception, boolean idempotent) {
        int code = 0;
        Boolean retryable = null;
        if (exception instanceof HttpResponseException) {
            code = ((HttpResponseException)exception).getStatusCode();
            retryable = BaseServiceException.isRetryable((Integer)code, null, (boolean)idempotent, Collections.emptySet());
        }
        return BaseServiceException.ExceptionData.newBuilder().setMessage(exception.getMessage()).setCause((Throwable)exception).setRetryable(((Boolean)MoreObjects.firstNonNull((Object)retryable, (Object)BaseServiceException.isRetryable((boolean)idempotent, (IOException)exception))).booleanValue()).setCode(code).setReason(null).setLocation(null).setDebugInfo(null).build();
    }

    public BaseGrpcServiceException(ApiException apiException) {
        super(BaseServiceException.ExceptionData.newBuilder().setMessage(apiException.getMessage()).setCause((Throwable)apiException).setRetryable(apiException.isRetryable()).setCode(apiException.getStatusCode().value()).setReason(apiException.getStatusCode().name()).setLocation(null).setDebugInfo(null).build());
    }
}

