/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.contentwarehouse.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.contentwarehouse.v1.CreateSynonymSetRequest;
import com.google.cloud.contentwarehouse.v1.DeleteSynonymSetRequest;
import com.google.cloud.contentwarehouse.v1.GetSynonymSetRequest;
import com.google.cloud.contentwarehouse.v1.ListSynonymSetsRequest;
import com.google.cloud.contentwarehouse.v1.ListSynonymSetsResponse;
import com.google.cloud.contentwarehouse.v1.LocationName;
import com.google.cloud.contentwarehouse.v1.SynonymSet;
import com.google.cloud.contentwarehouse.v1.SynonymSetName;
import com.google.cloud.contentwarehouse.v1.SynonymSetServiceSettings;
import com.google.cloud.contentwarehouse.v1.UpdateSynonymSetRequest;
import com.google.cloud.contentwarehouse.v1.stub.SynonymSetServiceStub;
import com.google.cloud.contentwarehouse.v1.stub.SynonymSetServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class SynonymSetServiceClient
implements BackgroundResource {
    private final SynonymSetServiceSettings settings;
    private final SynonymSetServiceStub stub;

    public static final SynonymSetServiceClient create() throws IOException {
        return SynonymSetServiceClient.create(SynonymSetServiceSettings.newBuilder().build());
    }

    public static final SynonymSetServiceClient create(SynonymSetServiceSettings settings) throws IOException {
        return new SynonymSetServiceClient(settings);
    }

    public static final SynonymSetServiceClient create(SynonymSetServiceStub stub) {
        return new SynonymSetServiceClient(stub);
    }

    protected SynonymSetServiceClient(SynonymSetServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((SynonymSetServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected SynonymSetServiceClient(SynonymSetServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final SynonymSetServiceSettings getSettings() {
        return this.settings;
    }

    public SynonymSetServiceStub getStub() {
        return this.stub;
    }

    public final SynonymSet createSynonymSet(LocationName parent, SynonymSet synonymSet) {
        CreateSynonymSetRequest request = CreateSynonymSetRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setSynonymSet(synonymSet).build();
        return this.createSynonymSet(request);
    }

    public final SynonymSet createSynonymSet(String parent, SynonymSet synonymSet) {
        CreateSynonymSetRequest request = CreateSynonymSetRequest.newBuilder().setParent(parent).setSynonymSet(synonymSet).build();
        return this.createSynonymSet(request);
    }

    public final SynonymSet createSynonymSet(CreateSynonymSetRequest request) {
        return (SynonymSet)this.createSynonymSetCallable().call((Object)request);
    }

    public final UnaryCallable<CreateSynonymSetRequest, SynonymSet> createSynonymSetCallable() {
        return this.stub.createSynonymSetCallable();
    }

    public final SynonymSet getSynonymSet(SynonymSetName name) {
        GetSynonymSetRequest request = GetSynonymSetRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getSynonymSet(request);
    }

    public final SynonymSet getSynonymSet(String name) {
        GetSynonymSetRequest request = GetSynonymSetRequest.newBuilder().setName(name).build();
        return this.getSynonymSet(request);
    }

    public final SynonymSet getSynonymSet(GetSynonymSetRequest request) {
        return (SynonymSet)this.getSynonymSetCallable().call((Object)request);
    }

    public final UnaryCallable<GetSynonymSetRequest, SynonymSet> getSynonymSetCallable() {
        return this.stub.getSynonymSetCallable();
    }

    public final SynonymSet updateSynonymSet(SynonymSetName name, SynonymSet synonymSet) {
        UpdateSynonymSetRequest request = UpdateSynonymSetRequest.newBuilder().setName(name == null ? null : name.toString()).setSynonymSet(synonymSet).build();
        return this.updateSynonymSet(request);
    }

    public final SynonymSet updateSynonymSet(String name, SynonymSet synonymSet) {
        UpdateSynonymSetRequest request = UpdateSynonymSetRequest.newBuilder().setName(name).setSynonymSet(synonymSet).build();
        return this.updateSynonymSet(request);
    }

    public final SynonymSet updateSynonymSet(UpdateSynonymSetRequest request) {
        return (SynonymSet)this.updateSynonymSetCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateSynonymSetRequest, SynonymSet> updateSynonymSetCallable() {
        return this.stub.updateSynonymSetCallable();
    }

    public final void deleteSynonymSet(SynonymSetName name) {
        DeleteSynonymSetRequest request = DeleteSynonymSetRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteSynonymSet(request);
    }

    public final void deleteSynonymSet(String name) {
        DeleteSynonymSetRequest request = DeleteSynonymSetRequest.newBuilder().setName(name).build();
        this.deleteSynonymSet(request);
    }

    public final void deleteSynonymSet(DeleteSynonymSetRequest request) {
        this.deleteSynonymSetCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteSynonymSetRequest, Empty> deleteSynonymSetCallable() {
        return this.stub.deleteSynonymSetCallable();
    }

    public final ListSynonymSetsPagedResponse listSynonymSets(LocationName parent) {
        ListSynonymSetsRequest request = ListSynonymSetsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listSynonymSets(request);
    }

    public final ListSynonymSetsPagedResponse listSynonymSets(String parent) {
        ListSynonymSetsRequest request = ListSynonymSetsRequest.newBuilder().setParent(parent).build();
        return this.listSynonymSets(request);
    }

    public final ListSynonymSetsPagedResponse listSynonymSets(ListSynonymSetsRequest request) {
        return (ListSynonymSetsPagedResponse)((Object)this.listSynonymSetsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListSynonymSetsRequest, ListSynonymSetsPagedResponse> listSynonymSetsPagedCallable() {
        return this.stub.listSynonymSetsPagedCallable();
    }

    public final UnaryCallable<ListSynonymSetsRequest, ListSynonymSetsResponse> listSynonymSetsCallable() {
        return this.stub.listSynonymSetsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListSynonymSetsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListSynonymSetsRequest, ListSynonymSetsResponse, SynonymSet, ListSynonymSetsPage, ListSynonymSetsFixedSizeCollection> {
        private ListSynonymSetsFixedSizeCollection(List<ListSynonymSetsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListSynonymSetsFixedSizeCollection createEmptyCollection() {
            return new ListSynonymSetsFixedSizeCollection(null, 0);
        }

        protected ListSynonymSetsFixedSizeCollection createCollection(List<ListSynonymSetsPage> pages, int collectionSize) {
            return new ListSynonymSetsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListSynonymSetsPage
    extends AbstractPage<ListSynonymSetsRequest, ListSynonymSetsResponse, SynonymSet, ListSynonymSetsPage> {
        private ListSynonymSetsPage(PageContext<ListSynonymSetsRequest, ListSynonymSetsResponse, SynonymSet> context, ListSynonymSetsResponse response) {
            super(context, (Object)response);
        }

        private static ListSynonymSetsPage createEmptyPage() {
            return new ListSynonymSetsPage(null, null);
        }

        protected ListSynonymSetsPage createPage(PageContext<ListSynonymSetsRequest, ListSynonymSetsResponse, SynonymSet> context, ListSynonymSetsResponse response) {
            return new ListSynonymSetsPage(context, response);
        }

        public ApiFuture<ListSynonymSetsPage> createPageAsync(PageContext<ListSynonymSetsRequest, ListSynonymSetsResponse, SynonymSet> context, ApiFuture<ListSynonymSetsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListSynonymSetsPagedResponse
    extends AbstractPagedListResponse<ListSynonymSetsRequest, ListSynonymSetsResponse, SynonymSet, ListSynonymSetsPage, ListSynonymSetsFixedSizeCollection> {
        public static ApiFuture<ListSynonymSetsPagedResponse> createAsync(PageContext<ListSynonymSetsRequest, ListSynonymSetsResponse, SynonymSet> context, ApiFuture<ListSynonymSetsResponse> futureResponse) {
            ApiFuture<ListSynonymSetsPage> futurePage = ListSynonymSetsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListSynonymSetsPagedResponse((ListSynonymSetsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListSynonymSetsPagedResponse(ListSynonymSetsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListSynonymSetsFixedSizeCollection.createEmptyCollection());
        }
    }
}

