/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.contentwarehouse.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.contentwarehouse.v1.CreateRuleSetRequest;
import com.google.cloud.contentwarehouse.v1.DeleteRuleSetRequest;
import com.google.cloud.contentwarehouse.v1.GetRuleSetRequest;
import com.google.cloud.contentwarehouse.v1.ListRuleSetsRequest;
import com.google.cloud.contentwarehouse.v1.ListRuleSetsResponse;
import com.google.cloud.contentwarehouse.v1.RuleSet;
import com.google.cloud.contentwarehouse.v1.RuleSetServiceClient;
import com.google.cloud.contentwarehouse.v1.UpdateRuleSetRequest;
import com.google.cloud.contentwarehouse.v1.stub.GrpcRuleSetServiceStub;
import com.google.cloud.contentwarehouse.v1.stub.HttpJsonRuleSetServiceStub;
import com.google.cloud.contentwarehouse.v1.stub.RuleSetServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class RuleSetServiceStubSettings
extends StubSettings<RuleSetServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateRuleSetRequest, RuleSet> createRuleSetSettings;
    private final UnaryCallSettings<GetRuleSetRequest, RuleSet> getRuleSetSettings;
    private final UnaryCallSettings<UpdateRuleSetRequest, RuleSet> updateRuleSetSettings;
    private final UnaryCallSettings<DeleteRuleSetRequest, Empty> deleteRuleSetSettings;
    private final PagedCallSettings<ListRuleSetsRequest, ListRuleSetsResponse, RuleSetServiceClient.ListRuleSetsPagedResponse> listRuleSetsSettings;
    private static final PagedListDescriptor<ListRuleSetsRequest, ListRuleSetsResponse, RuleSet> LIST_RULE_SETS_PAGE_STR_DESC = new PagedListDescriptor<ListRuleSetsRequest, ListRuleSetsResponse, RuleSet>(){

        public String emptyToken() {
            return "";
        }

        public ListRuleSetsRequest injectToken(ListRuleSetsRequest payload, String token) {
            return ListRuleSetsRequest.newBuilder((ListRuleSetsRequest)payload).setPageToken(token).build();
        }

        public ListRuleSetsRequest injectPageSize(ListRuleSetsRequest payload, int pageSize) {
            return ListRuleSetsRequest.newBuilder((ListRuleSetsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListRuleSetsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListRuleSetsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<RuleSet> extractResources(ListRuleSetsResponse payload) {
            return payload.getRuleSetsList() == null ? ImmutableList.of() : payload.getRuleSetsList();
        }
    };
    private static final PagedListResponseFactory<ListRuleSetsRequest, ListRuleSetsResponse, RuleSetServiceClient.ListRuleSetsPagedResponse> LIST_RULE_SETS_PAGE_STR_FACT = new PagedListResponseFactory<ListRuleSetsRequest, ListRuleSetsResponse, RuleSetServiceClient.ListRuleSetsPagedResponse>(){

        public ApiFuture<RuleSetServiceClient.ListRuleSetsPagedResponse> getFuturePagedResponse(UnaryCallable<ListRuleSetsRequest, ListRuleSetsResponse> callable, ListRuleSetsRequest request, ApiCallContext context, ApiFuture<ListRuleSetsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_RULE_SETS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return RuleSetServiceClient.ListRuleSetsPagedResponse.createAsync((PageContext<ListRuleSetsRequest, ListRuleSetsResponse, RuleSet>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateRuleSetRequest, RuleSet> createRuleSetSettings() {
        return this.createRuleSetSettings;
    }

    public UnaryCallSettings<GetRuleSetRequest, RuleSet> getRuleSetSettings() {
        return this.getRuleSetSettings;
    }

    public UnaryCallSettings<UpdateRuleSetRequest, RuleSet> updateRuleSetSettings() {
        return this.updateRuleSetSettings;
    }

    public UnaryCallSettings<DeleteRuleSetRequest, Empty> deleteRuleSetSettings() {
        return this.deleteRuleSetSettings;
    }

    public PagedCallSettings<ListRuleSetsRequest, ListRuleSetsResponse, RuleSetServiceClient.ListRuleSetsPagedResponse> listRuleSetsSettings() {
        return this.listRuleSetsSettings;
    }

    public RuleSetServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcRuleSetServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonRuleSetServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "contentwarehouse";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "contentwarehouse.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "contentwarehouse.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return RuleSetServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(RuleSetServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(RuleSetServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return RuleSetServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected RuleSetServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createRuleSetSettings = settingsBuilder.createRuleSetSettings().build();
        this.getRuleSetSettings = settingsBuilder.getRuleSetSettings().build();
        this.updateRuleSetSettings = settingsBuilder.updateRuleSetSettings().build();
        this.deleteRuleSetSettings = settingsBuilder.deleteRuleSetSettings().build();
        this.listRuleSetsSettings = settingsBuilder.listRuleSetsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<RuleSetServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateRuleSetRequest, RuleSet> createRuleSetSettings;
        private final UnaryCallSettings.Builder<GetRuleSetRequest, RuleSet> getRuleSetSettings;
        private final UnaryCallSettings.Builder<UpdateRuleSetRequest, RuleSet> updateRuleSetSettings;
        private final UnaryCallSettings.Builder<DeleteRuleSetRequest, Empty> deleteRuleSetSettings;
        private final PagedCallSettings.Builder<ListRuleSetsRequest, ListRuleSetsResponse, RuleSetServiceClient.ListRuleSetsPagedResponse> listRuleSetsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createRuleSetSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getRuleSetSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateRuleSetSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteRuleSetSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listRuleSetsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_RULE_SETS_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createRuleSetSettings, this.getRuleSetSettings, this.updateRuleSetSettings, this.deleteRuleSetSettings, this.listRuleSetsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(RuleSetServiceStubSettings settings) {
            super((StubSettings)settings);
            this.createRuleSetSettings = settings.createRuleSetSettings.toBuilder();
            this.getRuleSetSettings = settings.getRuleSetSettings.toBuilder();
            this.updateRuleSetSettings = settings.updateRuleSetSettings.toBuilder();
            this.deleteRuleSetSettings = settings.deleteRuleSetSettings.toBuilder();
            this.listRuleSetsSettings = settings.listRuleSetsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createRuleSetSettings, this.getRuleSetSettings, this.updateRuleSetSettings, this.deleteRuleSetSettings, this.listRuleSetsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(RuleSetServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)RuleSetServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)RuleSetServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(RuleSetServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)RuleSetServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)RuleSetServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)RuleSetServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(RuleSetServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createRuleSetSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getRuleSetSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateRuleSetSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteRuleSetSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listRuleSetsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateRuleSetRequest, RuleSet> createRuleSetSettings() {
            return this.createRuleSetSettings;
        }

        public UnaryCallSettings.Builder<GetRuleSetRequest, RuleSet> getRuleSetSettings() {
            return this.getRuleSetSettings;
        }

        public UnaryCallSettings.Builder<UpdateRuleSetRequest, RuleSet> updateRuleSetSettings() {
            return this.updateRuleSetSettings;
        }

        public UnaryCallSettings.Builder<DeleteRuleSetRequest, Empty> deleteRuleSetSettings() {
            return this.deleteRuleSetSettings;
        }

        public PagedCallSettings.Builder<ListRuleSetsRequest, ListRuleSetsResponse, RuleSetServiceClient.ListRuleSetsPagedResponse> listRuleSetsSettings() {
            return this.listRuleSetsSettings;
        }

        public RuleSetServiceStubSettings build() throws IOException {
            return new RuleSetServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)10000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

