/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.devtools.containeranalysis.v1beta1;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.resourcenames.ResourceName;
import com.google.cloud.devtools.containeranalysis.v1beta1.ContainerAnalysisV1Beta1Settings;
import com.google.cloud.devtools.containeranalysis.v1beta1.stub.ContainerAnalysisV1Beta1Stub;
import com.google.cloud.devtools.containeranalysis.v1beta1.stub.ContainerAnalysisV1Beta1StubSettings;
import com.google.containeranalysis.v1beta1.ExportSBOMRequest;
import com.google.containeranalysis.v1beta1.ExportSBOMResponse;
import com.google.containeranalysis.v1beta1.GeneratePackagesSummaryRequest;
import com.google.containeranalysis.v1beta1.PackagesSummaryResponse;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class ContainerAnalysisV1Beta1Client
implements BackgroundResource {
    private final ContainerAnalysisV1Beta1Settings settings;
    private final ContainerAnalysisV1Beta1Stub stub;

    public static final ContainerAnalysisV1Beta1Client create() throws IOException {
        return ContainerAnalysisV1Beta1Client.create(ContainerAnalysisV1Beta1Settings.newBuilder().build());
    }

    public static final ContainerAnalysisV1Beta1Client create(ContainerAnalysisV1Beta1Settings settings) throws IOException {
        return new ContainerAnalysisV1Beta1Client(settings);
    }

    public static final ContainerAnalysisV1Beta1Client create(ContainerAnalysisV1Beta1Stub stub) {
        return new ContainerAnalysisV1Beta1Client(stub);
    }

    protected ContainerAnalysisV1Beta1Client(ContainerAnalysisV1Beta1Settings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ContainerAnalysisV1Beta1StubSettings)settings.getStubSettings()).createStub();
    }

    protected ContainerAnalysisV1Beta1Client(ContainerAnalysisV1Beta1Stub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ContainerAnalysisV1Beta1Settings getSettings() {
        return this.settings;
    }

    public ContainerAnalysisV1Beta1Stub getStub() {
        return this.stub;
    }

    public final Policy setIamPolicy(ResourceName resource, Policy policy) {
        SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(resource == null ? null : resource.toString()).setPolicy(policy).build();
        return this.setIamPolicy(request);
    }

    public final Policy setIamPolicy(String resource, Policy policy) {
        SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(resource).setPolicy(policy).build();
        return this.setIamPolicy(request);
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final Policy getIamPolicy(ResourceName resource) {
        GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(resource == null ? null : resource.toString()).build();
        return this.getIamPolicy(request);
    }

    public final Policy getIamPolicy(String resource) {
        GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(resource).build();
        return this.getIamPolicy(request);
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(ResourceName resource, List<String> permissions) {
        TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(resource == null ? null : resource.toString()).addAllPermissions(permissions).build();
        return this.testIamPermissions(request);
    }

    public final TestIamPermissionsResponse testIamPermissions(String resource, List<String> permissions) {
        TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(resource).addAllPermissions(permissions).build();
        return this.testIamPermissions(request);
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final PackagesSummaryResponse generatePackagesSummary(GeneratePackagesSummaryRequest request) {
        return (PackagesSummaryResponse)this.generatePackagesSummaryCallable().call((Object)request);
    }

    public final UnaryCallable<GeneratePackagesSummaryRequest, PackagesSummaryResponse> generatePackagesSummaryCallable() {
        return this.stub.generatePackagesSummaryCallable();
    }

    public final ExportSBOMResponse exportSBOM(ExportSBOMRequest request) {
        return (ExportSBOMResponse)this.exportSBOMCallable().call((Object)request);
    }

    public final UnaryCallable<ExportSBOMRequest, ExportSBOMResponse> exportSBOMCallable() {
        return this.stub.exportSBOMCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

