/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.httpjson.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListFutureReservationsRequest;
import com.google.cloud.compute.v1.CancelFutureReservationRequest;
import com.google.cloud.compute.v1.DeleteFutureReservationRequest;
import com.google.cloud.compute.v1.FutureReservation;
import com.google.cloud.compute.v1.FutureReservationsAggregatedListResponse;
import com.google.cloud.compute.v1.FutureReservationsClient;
import com.google.cloud.compute.v1.FutureReservationsListResponse;
import com.google.cloud.compute.v1.FutureReservationsScopedList;
import com.google.cloud.compute.v1.GetFutureReservationRequest;
import com.google.cloud.compute.v1.InsertFutureReservationRequest;
import com.google.cloud.compute.v1.ListFutureReservationsRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.UpdateFutureReservationRequest;
import com.google.cloud.compute.v1.stub.FutureReservationsStub;
import com.google.cloud.compute.v1.stub.HttpJsonFutureReservationsStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FutureReservationsStubSettings
extends StubSettings<FutureReservationsStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<AggregatedListFutureReservationsRequest, FutureReservationsAggregatedListResponse, FutureReservationsClient.AggregatedListPagedResponse> aggregatedListSettings;
    private final UnaryCallSettings<CancelFutureReservationRequest, Operation> cancelSettings;
    private final OperationCallSettings<CancelFutureReservationRequest, Operation, Operation> cancelOperationSettings;
    private final UnaryCallSettings<DeleteFutureReservationRequest, Operation> deleteSettings;
    private final OperationCallSettings<DeleteFutureReservationRequest, Operation, Operation> deleteOperationSettings;
    private final UnaryCallSettings<GetFutureReservationRequest, FutureReservation> getSettings;
    private final UnaryCallSettings<InsertFutureReservationRequest, Operation> insertSettings;
    private final OperationCallSettings<InsertFutureReservationRequest, Operation, Operation> insertOperationSettings;
    private final PagedCallSettings<ListFutureReservationsRequest, FutureReservationsListResponse, FutureReservationsClient.ListPagedResponse> listSettings;
    private final UnaryCallSettings<UpdateFutureReservationRequest, Operation> updateSettings;
    private final OperationCallSettings<UpdateFutureReservationRequest, Operation, Operation> updateOperationSettings;
    private static final PagedListDescriptor<AggregatedListFutureReservationsRequest, FutureReservationsAggregatedListResponse, Map.Entry<String, FutureReservationsScopedList>> AGGREGATED_LIST_PAGE_STR_DESC = new PagedListDescriptor<AggregatedListFutureReservationsRequest, FutureReservationsAggregatedListResponse, Map.Entry<String, FutureReservationsScopedList>>(){

        public String emptyToken() {
            return "";
        }

        public AggregatedListFutureReservationsRequest injectToken(AggregatedListFutureReservationsRequest payload, String token) {
            return AggregatedListFutureReservationsRequest.newBuilder((AggregatedListFutureReservationsRequest)payload).setPageToken(token).build();
        }

        public AggregatedListFutureReservationsRequest injectPageSize(AggregatedListFutureReservationsRequest payload, int pageSize) {
            return AggregatedListFutureReservationsRequest.newBuilder((AggregatedListFutureReservationsRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(AggregatedListFutureReservationsRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(FutureReservationsAggregatedListResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Map.Entry<String, FutureReservationsScopedList>> extractResources(FutureReservationsAggregatedListResponse payload) {
            return payload.getItemsMap().entrySet();
        }
    };
    private static final PagedListDescriptor<ListFutureReservationsRequest, FutureReservationsListResponse, FutureReservation> LIST_PAGE_STR_DESC = new PagedListDescriptor<ListFutureReservationsRequest, FutureReservationsListResponse, FutureReservation>(){

        public String emptyToken() {
            return "";
        }

        public ListFutureReservationsRequest injectToken(ListFutureReservationsRequest payload, String token) {
            return ListFutureReservationsRequest.newBuilder((ListFutureReservationsRequest)payload).setPageToken(token).build();
        }

        public ListFutureReservationsRequest injectPageSize(ListFutureReservationsRequest payload, int pageSize) {
            return ListFutureReservationsRequest.newBuilder((ListFutureReservationsRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListFutureReservationsRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(FutureReservationsListResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<FutureReservation> extractResources(FutureReservationsListResponse payload) {
            return payload.getItemsList();
        }
    };
    private static final PagedListResponseFactory<AggregatedListFutureReservationsRequest, FutureReservationsAggregatedListResponse, FutureReservationsClient.AggregatedListPagedResponse> AGGREGATED_LIST_PAGE_STR_FACT = new PagedListResponseFactory<AggregatedListFutureReservationsRequest, FutureReservationsAggregatedListResponse, FutureReservationsClient.AggregatedListPagedResponse>(){

        public ApiFuture<FutureReservationsClient.AggregatedListPagedResponse> getFuturePagedResponse(UnaryCallable<AggregatedListFutureReservationsRequest, FutureReservationsAggregatedListResponse> callable, AggregatedListFutureReservationsRequest request, ApiCallContext context, ApiFuture<FutureReservationsAggregatedListResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)AGGREGATED_LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return FutureReservationsClient.AggregatedListPagedResponse.createAsync((PageContext<AggregatedListFutureReservationsRequest, FutureReservationsAggregatedListResponse, Map.Entry<String, FutureReservationsScopedList>>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListFutureReservationsRequest, FutureReservationsListResponse, FutureReservationsClient.ListPagedResponse> LIST_PAGE_STR_FACT = new PagedListResponseFactory<ListFutureReservationsRequest, FutureReservationsListResponse, FutureReservationsClient.ListPagedResponse>(){

        public ApiFuture<FutureReservationsClient.ListPagedResponse> getFuturePagedResponse(UnaryCallable<ListFutureReservationsRequest, FutureReservationsListResponse> callable, ListFutureReservationsRequest request, ApiCallContext context, ApiFuture<FutureReservationsListResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return FutureReservationsClient.ListPagedResponse.createAsync((PageContext<ListFutureReservationsRequest, FutureReservationsListResponse, FutureReservation>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<AggregatedListFutureReservationsRequest, FutureReservationsAggregatedListResponse, FutureReservationsClient.AggregatedListPagedResponse> aggregatedListSettings() {
        return this.aggregatedListSettings;
    }

    public UnaryCallSettings<CancelFutureReservationRequest, Operation> cancelSettings() {
        return this.cancelSettings;
    }

    public OperationCallSettings<CancelFutureReservationRequest, Operation, Operation> cancelOperationSettings() {
        return this.cancelOperationSettings;
    }

    public UnaryCallSettings<DeleteFutureReservationRequest, Operation> deleteSettings() {
        return this.deleteSettings;
    }

    public OperationCallSettings<DeleteFutureReservationRequest, Operation, Operation> deleteOperationSettings() {
        return this.deleteOperationSettings;
    }

    public UnaryCallSettings<GetFutureReservationRequest, FutureReservation> getSettings() {
        return this.getSettings;
    }

    public UnaryCallSettings<InsertFutureReservationRequest, Operation> insertSettings() {
        return this.insertSettings;
    }

    public OperationCallSettings<InsertFutureReservationRequest, Operation, Operation> insertOperationSettings() {
        return this.insertOperationSettings;
    }

    public PagedCallSettings<ListFutureReservationsRequest, FutureReservationsListResponse, FutureReservationsClient.ListPagedResponse> listSettings() {
        return this.listSettings;
    }

    public UnaryCallSettings<UpdateFutureReservationRequest, Operation> updateSettings() {
        return this.updateSettings;
    }

    public OperationCallSettings<UpdateFutureReservationRequest, Operation, Operation> updateOperationSettings() {
        return this.updateOperationSettings;
    }

    public FutureReservationsStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonFutureReservationsStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "compute";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "compute.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "compute.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return FutureReservationsStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(FutureReservationsStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected FutureReservationsStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.aggregatedListSettings = settingsBuilder.aggregatedListSettings().build();
        this.cancelSettings = settingsBuilder.cancelSettings().build();
        this.cancelOperationSettings = settingsBuilder.cancelOperationSettings().build();
        this.deleteSettings = settingsBuilder.deleteSettings().build();
        this.deleteOperationSettings = settingsBuilder.deleteOperationSettings().build();
        this.getSettings = settingsBuilder.getSettings().build();
        this.insertSettings = settingsBuilder.insertSettings().build();
        this.insertOperationSettings = settingsBuilder.insertOperationSettings().build();
        this.listSettings = settingsBuilder.listSettings().build();
        this.updateSettings = settingsBuilder.updateSettings().build();
        this.updateOperationSettings = settingsBuilder.updateOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<FutureReservationsStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<AggregatedListFutureReservationsRequest, FutureReservationsAggregatedListResponse, FutureReservationsClient.AggregatedListPagedResponse> aggregatedListSettings;
        private final UnaryCallSettings.Builder<CancelFutureReservationRequest, Operation> cancelSettings;
        private final OperationCallSettings.Builder<CancelFutureReservationRequest, Operation, Operation> cancelOperationSettings;
        private final UnaryCallSettings.Builder<DeleteFutureReservationRequest, Operation> deleteSettings;
        private final OperationCallSettings.Builder<DeleteFutureReservationRequest, Operation, Operation> deleteOperationSettings;
        private final UnaryCallSettings.Builder<GetFutureReservationRequest, FutureReservation> getSettings;
        private final UnaryCallSettings.Builder<InsertFutureReservationRequest, Operation> insertSettings;
        private final OperationCallSettings.Builder<InsertFutureReservationRequest, Operation, Operation> insertOperationSettings;
        private final PagedCallSettings.Builder<ListFutureReservationsRequest, FutureReservationsListResponse, FutureReservationsClient.ListPagedResponse> listSettings;
        private final UnaryCallSettings.Builder<UpdateFutureReservationRequest, Operation> updateSettings;
        private final OperationCallSettings.Builder<UpdateFutureReservationRequest, Operation, Operation> updateOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.aggregatedListSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)AGGREGATED_LIST_PAGE_STR_FACT);
            this.cancelSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.cancelOperationSettings = OperationCallSettings.newBuilder();
            this.deleteSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteOperationSettings = OperationCallSettings.newBuilder();
            this.getSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertOperationSettings = OperationCallSettings.newBuilder();
            this.listSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PAGE_STR_FACT);
            this.updateSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListSettings, this.cancelSettings, this.deleteSettings, this.getSettings, this.insertSettings, this.listSettings, this.updateSettings);
            Builder.initDefaults(this);
        }

        protected Builder(FutureReservationsStubSettings settings) {
            super((StubSettings)settings);
            this.aggregatedListSettings = settings.aggregatedListSettings.toBuilder();
            this.cancelSettings = settings.cancelSettings.toBuilder();
            this.cancelOperationSettings = settings.cancelOperationSettings.toBuilder();
            this.deleteSettings = settings.deleteSettings.toBuilder();
            this.deleteOperationSettings = settings.deleteOperationSettings.toBuilder();
            this.getSettings = settings.getSettings.toBuilder();
            this.insertSettings = settings.insertSettings.toBuilder();
            this.insertOperationSettings = settings.insertOperationSettings.toBuilder();
            this.listSettings = settings.listSettings.toBuilder();
            this.updateSettings = settings.updateSettings.toBuilder();
            this.updateOperationSettings = settings.updateOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListSettings, this.cancelSettings, this.deleteSettings, this.getSettings, this.insertSettings, this.listSettings, this.updateSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(FutureReservationsStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)FutureReservationsStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)FutureReservationsStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(FutureReservationsStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.aggregatedListSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.cancelSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.insertSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.cancelOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(20000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(600000L)).build()));
            builder.deleteOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(20000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(600000L)).build()));
            builder.insertOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(20000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(600000L)).build()));
            builder.updateOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(20000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(600000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<AggregatedListFutureReservationsRequest, FutureReservationsAggregatedListResponse, FutureReservationsClient.AggregatedListPagedResponse> aggregatedListSettings() {
            return this.aggregatedListSettings;
        }

        public UnaryCallSettings.Builder<CancelFutureReservationRequest, Operation> cancelSettings() {
            return this.cancelSettings;
        }

        public OperationCallSettings.Builder<CancelFutureReservationRequest, Operation, Operation> cancelOperationSettings() {
            return this.cancelOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteFutureReservationRequest, Operation> deleteSettings() {
            return this.deleteSettings;
        }

        public OperationCallSettings.Builder<DeleteFutureReservationRequest, Operation, Operation> deleteOperationSettings() {
            return this.deleteOperationSettings;
        }

        public UnaryCallSettings.Builder<GetFutureReservationRequest, FutureReservation> getSettings() {
            return this.getSettings;
        }

        public UnaryCallSettings.Builder<InsertFutureReservationRequest, Operation> insertSettings() {
            return this.insertSettings;
        }

        public OperationCallSettings.Builder<InsertFutureReservationRequest, Operation, Operation> insertOperationSettings() {
            return this.insertOperationSettings;
        }

        public PagedCallSettings.Builder<ListFutureReservationsRequest, FutureReservationsListResponse, FutureReservationsClient.ListPagedResponse> listSettings() {
            return this.listSettings;
        }

        public UnaryCallSettings.Builder<UpdateFutureReservationRequest, Operation> updateSettings() {
            return this.updateSettings;
        }

        public OperationCallSettings.Builder<UpdateFutureReservationRequest, Operation, Operation> updateOperationSettings() {
            return this.updateOperationSettings;
        }

        public FutureReservationsStubSettings build() throws IOException {
            return new FutureReservationsStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(60000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(600000L)).setTotalTimeoutDuration(Duration.ofMillis(600000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeoutDuration(Duration.ofMillis(600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(600000L)).setTotalTimeoutDuration(Duration.ofMillis(600000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

