/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.CrossSiteNetwork;
import com.google.cloud.compute.v1.CrossSiteNetworkList;
import com.google.cloud.compute.v1.CrossSiteNetworksSettings;
import com.google.cloud.compute.v1.DeleteCrossSiteNetworkRequest;
import com.google.cloud.compute.v1.GetCrossSiteNetworkRequest;
import com.google.cloud.compute.v1.InsertCrossSiteNetworkRequest;
import com.google.cloud.compute.v1.ListCrossSiteNetworksRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchCrossSiteNetworkRequest;
import com.google.cloud.compute.v1.stub.CrossSiteNetworksStub;
import com.google.cloud.compute.v1.stub.CrossSiteNetworksStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class CrossSiteNetworksClient
implements BackgroundResource {
    private final CrossSiteNetworksSettings settings;
    private final CrossSiteNetworksStub stub;

    public static final CrossSiteNetworksClient create() throws IOException {
        return CrossSiteNetworksClient.create(CrossSiteNetworksSettings.newBuilder().build());
    }

    public static final CrossSiteNetworksClient create(CrossSiteNetworksSettings settings) throws IOException {
        return new CrossSiteNetworksClient(settings);
    }

    public static final CrossSiteNetworksClient create(CrossSiteNetworksStub stub) {
        return new CrossSiteNetworksClient(stub);
    }

    protected CrossSiteNetworksClient(CrossSiteNetworksSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((CrossSiteNetworksStubSettings)settings.getStubSettings()).createStub();
    }

    protected CrossSiteNetworksClient(CrossSiteNetworksStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final CrossSiteNetworksSettings getSettings() {
        return this.settings;
    }

    public CrossSiteNetworksStub getStub() {
        return this.stub;
    }

    public final OperationFuture<Operation, Operation> deleteAsync(String project, String crossSiteNetwork) {
        DeleteCrossSiteNetworkRequest request = DeleteCrossSiteNetworkRequest.newBuilder().setProject(project).setCrossSiteNetwork(crossSiteNetwork).build();
        return this.deleteAsync(request);
    }

    public final OperationFuture<Operation, Operation> deleteAsync(DeleteCrossSiteNetworkRequest request) {
        return this.deleteOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteCrossSiteNetworkRequest, Operation, Operation> deleteOperationCallable() {
        return this.stub.deleteOperationCallable();
    }

    public final UnaryCallable<DeleteCrossSiteNetworkRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final CrossSiteNetwork get(String project, String crossSiteNetwork) {
        GetCrossSiteNetworkRequest request = GetCrossSiteNetworkRequest.newBuilder().setProject(project).setCrossSiteNetwork(crossSiteNetwork).build();
        return this.get(request);
    }

    public final CrossSiteNetwork get(GetCrossSiteNetworkRequest request) {
        return (CrossSiteNetwork)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetCrossSiteNetworkRequest, CrossSiteNetwork> getCallable() {
        return this.stub.getCallable();
    }

    public final OperationFuture<Operation, Operation> insertAsync(String project, CrossSiteNetwork crossSiteNetworkResource) {
        InsertCrossSiteNetworkRequest request = InsertCrossSiteNetworkRequest.newBuilder().setProject(project).setCrossSiteNetworkResource(crossSiteNetworkResource).build();
        return this.insertAsync(request);
    }

    public final OperationFuture<Operation, Operation> insertAsync(InsertCrossSiteNetworkRequest request) {
        return this.insertOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<InsertCrossSiteNetworkRequest, Operation, Operation> insertOperationCallable() {
        return this.stub.insertOperationCallable();
    }

    public final UnaryCallable<InsertCrossSiteNetworkRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list(String project) {
        ListCrossSiteNetworksRequest request = ListCrossSiteNetworksRequest.newBuilder().setProject(project).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListCrossSiteNetworksRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListCrossSiteNetworksRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListCrossSiteNetworksRequest, CrossSiteNetworkList> listCallable() {
        return this.stub.listCallable();
    }

    public final OperationFuture<Operation, Operation> patchAsync(String project, String crossSiteNetwork, CrossSiteNetwork crossSiteNetworkResource) {
        PatchCrossSiteNetworkRequest request = PatchCrossSiteNetworkRequest.newBuilder().setProject(project).setCrossSiteNetwork(crossSiteNetwork).setCrossSiteNetworkResource(crossSiteNetworkResource).build();
        return this.patchAsync(request);
    }

    public final OperationFuture<Operation, Operation> patchAsync(PatchCrossSiteNetworkRequest request) {
        return this.patchOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<PatchCrossSiteNetworkRequest, Operation, Operation> patchOperationCallable() {
        return this.stub.patchOperationCallable();
    }

    public final UnaryCallable<PatchCrossSiteNetworkRequest, Operation> patchCallable() {
        return this.stub.patchCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListCrossSiteNetworksRequest, CrossSiteNetworkList, CrossSiteNetwork, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListCrossSiteNetworksRequest, CrossSiteNetworkList, CrossSiteNetwork, ListPage> {
        private ListPage(PageContext<ListCrossSiteNetworksRequest, CrossSiteNetworkList, CrossSiteNetwork> context, CrossSiteNetworkList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListCrossSiteNetworksRequest, CrossSiteNetworkList, CrossSiteNetwork> context, CrossSiteNetworkList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListCrossSiteNetworksRequest, CrossSiteNetworkList, CrossSiteNetwork> context, ApiFuture<CrossSiteNetworkList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListCrossSiteNetworksRequest, CrossSiteNetworkList, CrossSiteNetwork, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListCrossSiteNetworksRequest, CrossSiteNetworkList, CrossSiteNetwork> context, ApiFuture<CrossSiteNetworkList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPagedResponse((ListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }
}

