/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AdviceSettings;
import com.google.cloud.compute.v1.CalendarModeAdviceRequest;
import com.google.cloud.compute.v1.CalendarModeAdviceResponse;
import com.google.cloud.compute.v1.CalendarModeAdviceRpcRequest;
import com.google.cloud.compute.v1.stub.AdviceStub;
import com.google.cloud.compute.v1.stub.AdviceStubSettings;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class AdviceClient
implements BackgroundResource {
    private final AdviceSettings settings;
    private final AdviceStub stub;

    public static final AdviceClient create() throws IOException {
        return AdviceClient.create(AdviceSettings.newBuilder().build());
    }

    public static final AdviceClient create(AdviceSettings settings) throws IOException {
        return new AdviceClient(settings);
    }

    public static final AdviceClient create(AdviceStub stub) {
        return new AdviceClient(stub);
    }

    protected AdviceClient(AdviceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((AdviceStubSettings)settings.getStubSettings()).createStub();
    }

    protected AdviceClient(AdviceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final AdviceSettings getSettings() {
        return this.settings;
    }

    public AdviceStub getStub() {
        return this.stub;
    }

    public final CalendarModeAdviceResponse calendarMode(String project, String region, CalendarModeAdviceRequest calendarModeAdviceRequestResource) {
        CalendarModeAdviceRpcRequest request = CalendarModeAdviceRpcRequest.newBuilder().setProject(project).setRegion(region).setCalendarModeAdviceRequestResource(calendarModeAdviceRequestResource).build();
        return this.calendarMode(request);
    }

    public final CalendarModeAdviceResponse calendarMode(CalendarModeAdviceRpcRequest request) {
        return (CalendarModeAdviceResponse)this.calendarModeCallable().call((Object)request);
    }

    public final UnaryCallable<CalendarModeAdviceRpcRequest, CalendarModeAdviceResponse> calendarModeCallable() {
        return this.stub.calendarModeCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

