/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListStoragePoolsRequest;
import com.google.cloud.compute.v1.DeleteStoragePoolRequest;
import com.google.cloud.compute.v1.GetIamPolicyStoragePoolRequest;
import com.google.cloud.compute.v1.GetStoragePoolRequest;
import com.google.cloud.compute.v1.InsertStoragePoolRequest;
import com.google.cloud.compute.v1.ListDisksStoragePoolsRequest;
import com.google.cloud.compute.v1.ListStoragePoolsRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.Policy;
import com.google.cloud.compute.v1.SetIamPolicyStoragePoolRequest;
import com.google.cloud.compute.v1.StoragePool;
import com.google.cloud.compute.v1.StoragePoolAggregatedList;
import com.google.cloud.compute.v1.StoragePoolDisk;
import com.google.cloud.compute.v1.StoragePoolList;
import com.google.cloud.compute.v1.StoragePoolListDisks;
import com.google.cloud.compute.v1.StoragePoolsScopedList;
import com.google.cloud.compute.v1.StoragePoolsSettings;
import com.google.cloud.compute.v1.TestIamPermissionsStoragePoolRequest;
import com.google.cloud.compute.v1.TestPermissionsRequest;
import com.google.cloud.compute.v1.TestPermissionsResponse;
import com.google.cloud.compute.v1.UpdateStoragePoolRequest;
import com.google.cloud.compute.v1.ZoneSetPolicyRequest;
import com.google.cloud.compute.v1.stub.StoragePoolsStub;
import com.google.cloud.compute.v1.stub.StoragePoolsStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class StoragePoolsClient
implements BackgroundResource {
    private final StoragePoolsSettings settings;
    private final StoragePoolsStub stub;

    public static final StoragePoolsClient create() throws IOException {
        return StoragePoolsClient.create(StoragePoolsSettings.newBuilder().build());
    }

    public static final StoragePoolsClient create(StoragePoolsSettings settings) throws IOException {
        return new StoragePoolsClient(settings);
    }

    public static final StoragePoolsClient create(StoragePoolsStub stub) {
        return new StoragePoolsClient(stub);
    }

    protected StoragePoolsClient(StoragePoolsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((StoragePoolsStubSettings)settings.getStubSettings()).createStub();
    }

    protected StoragePoolsClient(StoragePoolsStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final StoragePoolsSettings getSettings() {
        return this.settings;
    }

    public StoragePoolsStub getStub() {
        return this.stub;
    }

    public final AggregatedListPagedResponse aggregatedList(String project) {
        AggregatedListStoragePoolsRequest request = AggregatedListStoragePoolsRequest.newBuilder().setProject(project).build();
        return this.aggregatedList(request);
    }

    public final AggregatedListPagedResponse aggregatedList(AggregatedListStoragePoolsRequest request) {
        return (AggregatedListPagedResponse)((Object)this.aggregatedListPagedCallable().call((Object)request));
    }

    public final UnaryCallable<AggregatedListStoragePoolsRequest, AggregatedListPagedResponse> aggregatedListPagedCallable() {
        return this.stub.aggregatedListPagedCallable();
    }

    public final UnaryCallable<AggregatedListStoragePoolsRequest, StoragePoolAggregatedList> aggregatedListCallable() {
        return this.stub.aggregatedListCallable();
    }

    public final OperationFuture<Operation, Operation> deleteAsync(String project, String zone, String storagePool) {
        DeleteStoragePoolRequest request = DeleteStoragePoolRequest.newBuilder().setProject(project).setZone(zone).setStoragePool(storagePool).build();
        return this.deleteAsync(request);
    }

    public final OperationFuture<Operation, Operation> deleteAsync(DeleteStoragePoolRequest request) {
        return this.deleteOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteStoragePoolRequest, Operation, Operation> deleteOperationCallable() {
        return this.stub.deleteOperationCallable();
    }

    public final UnaryCallable<DeleteStoragePoolRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final StoragePool get(String project, String zone, String storagePool) {
        GetStoragePoolRequest request = GetStoragePoolRequest.newBuilder().setProject(project).setZone(zone).setStoragePool(storagePool).build();
        return this.get(request);
    }

    public final StoragePool get(GetStoragePoolRequest request) {
        return (StoragePool)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetStoragePoolRequest, StoragePool> getCallable() {
        return this.stub.getCallable();
    }

    public final Policy getIamPolicy(String project, String zone, String resource) {
        GetIamPolicyStoragePoolRequest request = GetIamPolicyStoragePoolRequest.newBuilder().setProject(project).setZone(zone).setResource(resource).build();
        return this.getIamPolicy(request);
    }

    public final Policy getIamPolicy(GetIamPolicyStoragePoolRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyStoragePoolRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final OperationFuture<Operation, Operation> insertAsync(String project, String zone, StoragePool storagePoolResource) {
        InsertStoragePoolRequest request = InsertStoragePoolRequest.newBuilder().setProject(project).setZone(zone).setStoragePoolResource(storagePoolResource).build();
        return this.insertAsync(request);
    }

    public final OperationFuture<Operation, Operation> insertAsync(InsertStoragePoolRequest request) {
        return this.insertOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<InsertStoragePoolRequest, Operation, Operation> insertOperationCallable() {
        return this.stub.insertOperationCallable();
    }

    public final UnaryCallable<InsertStoragePoolRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list(String project, String zone) {
        ListStoragePoolsRequest request = ListStoragePoolsRequest.newBuilder().setProject(project).setZone(zone).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListStoragePoolsRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListStoragePoolsRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListStoragePoolsRequest, StoragePoolList> listCallable() {
        return this.stub.listCallable();
    }

    public final ListDisksPagedResponse listDisks(String project, String zone, String storagePool) {
        ListDisksStoragePoolsRequest request = ListDisksStoragePoolsRequest.newBuilder().setProject(project).setZone(zone).setStoragePool(storagePool).build();
        return this.listDisks(request);
    }

    public final ListDisksPagedResponse listDisks(ListDisksStoragePoolsRequest request) {
        return (ListDisksPagedResponse)((Object)this.listDisksPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListDisksStoragePoolsRequest, ListDisksPagedResponse> listDisksPagedCallable() {
        return this.stub.listDisksPagedCallable();
    }

    public final UnaryCallable<ListDisksStoragePoolsRequest, StoragePoolListDisks> listDisksCallable() {
        return this.stub.listDisksCallable();
    }

    public final Policy setIamPolicy(String project, String zone, String resource, ZoneSetPolicyRequest zoneSetPolicyRequestResource) {
        SetIamPolicyStoragePoolRequest request = SetIamPolicyStoragePoolRequest.newBuilder().setProject(project).setZone(zone).setResource(resource).setZoneSetPolicyRequestResource(zoneSetPolicyRequestResource).build();
        return this.setIamPolicy(request);
    }

    public final Policy setIamPolicy(SetIamPolicyStoragePoolRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyStoragePoolRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final TestPermissionsResponse testIamPermissions(String project, String zone, String resource, TestPermissionsRequest testPermissionsRequestResource) {
        TestIamPermissionsStoragePoolRequest request = TestIamPermissionsStoragePoolRequest.newBuilder().setProject(project).setZone(zone).setResource(resource).setTestPermissionsRequestResource(testPermissionsRequestResource).build();
        return this.testIamPermissions(request);
    }

    public final TestPermissionsResponse testIamPermissions(TestIamPermissionsStoragePoolRequest request) {
        return (TestPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsStoragePoolRequest, TestPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final OperationFuture<Operation, Operation> updateAsync(String project, String zone, String storagePool, StoragePool storagePoolResource) {
        UpdateStoragePoolRequest request = UpdateStoragePoolRequest.newBuilder().setProject(project).setZone(zone).setStoragePool(storagePool).setStoragePoolResource(storagePoolResource).build();
        return this.updateAsync(request);
    }

    public final OperationFuture<Operation, Operation> updateAsync(UpdateStoragePoolRequest request) {
        return this.updateOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateStoragePoolRequest, Operation, Operation> updateOperationCallable() {
        return this.stub.updateOperationCallable();
    }

    public final UnaryCallable<UpdateStoragePoolRequest, Operation> updateCallable() {
        return this.stub.updateCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListDisksFixedSizeCollection
    extends AbstractFixedSizeCollection<ListDisksStoragePoolsRequest, StoragePoolListDisks, StoragePoolDisk, ListDisksPage, ListDisksFixedSizeCollection> {
        private ListDisksFixedSizeCollection(List<ListDisksPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListDisksFixedSizeCollection createEmptyCollection() {
            return new ListDisksFixedSizeCollection(null, 0);
        }

        protected ListDisksFixedSizeCollection createCollection(List<ListDisksPage> pages, int collectionSize) {
            return new ListDisksFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListDisksPage
    extends AbstractPage<ListDisksStoragePoolsRequest, StoragePoolListDisks, StoragePoolDisk, ListDisksPage> {
        private ListDisksPage(PageContext<ListDisksStoragePoolsRequest, StoragePoolListDisks, StoragePoolDisk> context, StoragePoolListDisks response) {
            super(context, (Object)response);
        }

        private static ListDisksPage createEmptyPage() {
            return new ListDisksPage(null, null);
        }

        protected ListDisksPage createPage(PageContext<ListDisksStoragePoolsRequest, StoragePoolListDisks, StoragePoolDisk> context, StoragePoolListDisks response) {
            return new ListDisksPage(context, response);
        }

        public ApiFuture<ListDisksPage> createPageAsync(PageContext<ListDisksStoragePoolsRequest, StoragePoolListDisks, StoragePoolDisk> context, ApiFuture<StoragePoolListDisks> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListDisksPagedResponse
    extends AbstractPagedListResponse<ListDisksStoragePoolsRequest, StoragePoolListDisks, StoragePoolDisk, ListDisksPage, ListDisksFixedSizeCollection> {
        public static ApiFuture<ListDisksPagedResponse> createAsync(PageContext<ListDisksStoragePoolsRequest, StoragePoolListDisks, StoragePoolDisk> context, ApiFuture<StoragePoolListDisks> futureResponse) {
            ApiFuture<ListDisksPage> futurePage = ListDisksPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListDisksPagedResponse((ListDisksPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListDisksPagedResponse(ListDisksPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListDisksFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListStoragePoolsRequest, StoragePoolList, StoragePool, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListStoragePoolsRequest, StoragePoolList, StoragePool, ListPage> {
        private ListPage(PageContext<ListStoragePoolsRequest, StoragePoolList, StoragePool> context, StoragePoolList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListStoragePoolsRequest, StoragePoolList, StoragePool> context, StoragePoolList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListStoragePoolsRequest, StoragePoolList, StoragePool> context, ApiFuture<StoragePoolList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListStoragePoolsRequest, StoragePoolList, StoragePool, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListStoragePoolsRequest, StoragePoolList, StoragePool> context, ApiFuture<StoragePoolList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPagedResponse((ListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class AggregatedListFixedSizeCollection
    extends AbstractFixedSizeCollection<AggregatedListStoragePoolsRequest, StoragePoolAggregatedList, Map.Entry<String, StoragePoolsScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        private AggregatedListFixedSizeCollection(List<AggregatedListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static AggregatedListFixedSizeCollection createEmptyCollection() {
            return new AggregatedListFixedSizeCollection(null, 0);
        }

        protected AggregatedListFixedSizeCollection createCollection(List<AggregatedListPage> pages, int collectionSize) {
            return new AggregatedListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class AggregatedListPage
    extends AbstractPage<AggregatedListStoragePoolsRequest, StoragePoolAggregatedList, Map.Entry<String, StoragePoolsScopedList>, AggregatedListPage> {
        private AggregatedListPage(PageContext<AggregatedListStoragePoolsRequest, StoragePoolAggregatedList, Map.Entry<String, StoragePoolsScopedList>> context, StoragePoolAggregatedList response) {
            super(context, (Object)response);
        }

        private static AggregatedListPage createEmptyPage() {
            return new AggregatedListPage(null, null);
        }

        protected AggregatedListPage createPage(PageContext<AggregatedListStoragePoolsRequest, StoragePoolAggregatedList, Map.Entry<String, StoragePoolsScopedList>> context, StoragePoolAggregatedList response) {
            return new AggregatedListPage(context, response);
        }

        public ApiFuture<AggregatedListPage> createPageAsync(PageContext<AggregatedListStoragePoolsRequest, StoragePoolAggregatedList, Map.Entry<String, StoragePoolsScopedList>> context, ApiFuture<StoragePoolAggregatedList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class AggregatedListPagedResponse
    extends AbstractPagedListResponse<AggregatedListStoragePoolsRequest, StoragePoolAggregatedList, Map.Entry<String, StoragePoolsScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        public static ApiFuture<AggregatedListPagedResponse> createAsync(PageContext<AggregatedListStoragePoolsRequest, StoragePoolAggregatedList, Map.Entry<String, StoragePoolsScopedList>> context, ApiFuture<StoragePoolAggregatedList> futureResponse) {
            ApiFuture<AggregatedListPage> futurePage = AggregatedListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new AggregatedListPagedResponse((AggregatedListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private AggregatedListPagedResponse(AggregatedListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)AggregatedListFixedSizeCollection.createEmptyCollection());
        }
    }
}

