/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListInterconnectAttachmentsRequest;
import com.google.cloud.compute.v1.DeleteInterconnectAttachmentRequest;
import com.google.cloud.compute.v1.GetInterconnectAttachmentRequest;
import com.google.cloud.compute.v1.InsertInterconnectAttachmentRequest;
import com.google.cloud.compute.v1.InterconnectAttachment;
import com.google.cloud.compute.v1.InterconnectAttachmentAggregatedList;
import com.google.cloud.compute.v1.InterconnectAttachmentList;
import com.google.cloud.compute.v1.InterconnectAttachmentsScopedList;
import com.google.cloud.compute.v1.InterconnectAttachmentsSettings;
import com.google.cloud.compute.v1.ListInterconnectAttachmentsRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchInterconnectAttachmentRequest;
import com.google.cloud.compute.v1.stub.InterconnectAttachmentsStub;
import com.google.cloud.compute.v1.stub.InterconnectAttachmentsStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class InterconnectAttachmentsClient
implements BackgroundResource {
    private final InterconnectAttachmentsSettings settings;
    private final InterconnectAttachmentsStub stub;

    public static final InterconnectAttachmentsClient create() throws IOException {
        return InterconnectAttachmentsClient.create(InterconnectAttachmentsSettings.newBuilder().build());
    }

    public static final InterconnectAttachmentsClient create(InterconnectAttachmentsSettings settings) throws IOException {
        return new InterconnectAttachmentsClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final InterconnectAttachmentsClient create(InterconnectAttachmentsStub stub) {
        return new InterconnectAttachmentsClient(stub);
    }

    protected InterconnectAttachmentsClient(InterconnectAttachmentsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((InterconnectAttachmentsStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected InterconnectAttachmentsClient(InterconnectAttachmentsStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final InterconnectAttachmentsSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public InterconnectAttachmentsStub getStub() {
        return this.stub;
    }

    public final AggregatedListPagedResponse aggregatedList(String project) {
        AggregatedListInterconnectAttachmentsRequest request = AggregatedListInterconnectAttachmentsRequest.newBuilder().setProject(project).build();
        return this.aggregatedList(request);
    }

    public final AggregatedListPagedResponse aggregatedList(AggregatedListInterconnectAttachmentsRequest request) {
        return (AggregatedListPagedResponse)((Object)this.aggregatedListPagedCallable().call((Object)request));
    }

    public final UnaryCallable<AggregatedListInterconnectAttachmentsRequest, AggregatedListPagedResponse> aggregatedListPagedCallable() {
        return this.stub.aggregatedListPagedCallable();
    }

    public final UnaryCallable<AggregatedListInterconnectAttachmentsRequest, InterconnectAttachmentAggregatedList> aggregatedListCallable() {
        return this.stub.aggregatedListCallable();
    }

    public final OperationFuture<Operation, Operation> deleteAsync(String project, String region, String interconnectAttachment) {
        DeleteInterconnectAttachmentRequest request = DeleteInterconnectAttachmentRequest.newBuilder().setProject(project).setRegion(region).setInterconnectAttachment(interconnectAttachment).build();
        return this.deleteAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> deleteAsync(DeleteInterconnectAttachmentRequest request) {
        return this.deleteOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteInterconnectAttachmentRequest, Operation, Operation> deleteOperationCallable() {
        return this.stub.deleteOperationCallable();
    }

    public final UnaryCallable<DeleteInterconnectAttachmentRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final InterconnectAttachment get(String project, String region, String interconnectAttachment) {
        GetInterconnectAttachmentRequest request = GetInterconnectAttachmentRequest.newBuilder().setProject(project).setRegion(region).setInterconnectAttachment(interconnectAttachment).build();
        return this.get(request);
    }

    public final InterconnectAttachment get(GetInterconnectAttachmentRequest request) {
        return (InterconnectAttachment)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetInterconnectAttachmentRequest, InterconnectAttachment> getCallable() {
        return this.stub.getCallable();
    }

    public final OperationFuture<Operation, Operation> insertAsync(String project, String region, InterconnectAttachment interconnectAttachmentResource) {
        InsertInterconnectAttachmentRequest request = InsertInterconnectAttachmentRequest.newBuilder().setProject(project).setRegion(region).setInterconnectAttachmentResource(interconnectAttachmentResource).build();
        return this.insertAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> insertAsync(InsertInterconnectAttachmentRequest request) {
        return this.insertOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<InsertInterconnectAttachmentRequest, Operation, Operation> insertOperationCallable() {
        return this.stub.insertOperationCallable();
    }

    public final UnaryCallable<InsertInterconnectAttachmentRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list(String project, String region) {
        ListInterconnectAttachmentsRequest request = ListInterconnectAttachmentsRequest.newBuilder().setProject(project).setRegion(region).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListInterconnectAttachmentsRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListInterconnectAttachmentsRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListInterconnectAttachmentsRequest, InterconnectAttachmentList> listCallable() {
        return this.stub.listCallable();
    }

    public final OperationFuture<Operation, Operation> patchAsync(String project, String region, String interconnectAttachment, InterconnectAttachment interconnectAttachmentResource) {
        PatchInterconnectAttachmentRequest request = PatchInterconnectAttachmentRequest.newBuilder().setProject(project).setRegion(region).setInterconnectAttachment(interconnectAttachment).setInterconnectAttachmentResource(interconnectAttachmentResource).build();
        return this.patchAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> patchAsync(PatchInterconnectAttachmentRequest request) {
        return this.patchOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<PatchInterconnectAttachmentRequest, Operation, Operation> patchOperationCallable() {
        return this.stub.patchOperationCallable();
    }

    public final UnaryCallable<PatchInterconnectAttachmentRequest, Operation> patchCallable() {
        return this.stub.patchCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListInterconnectAttachmentsRequest, InterconnectAttachmentList, InterconnectAttachment, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListInterconnectAttachmentsRequest, InterconnectAttachmentList, InterconnectAttachment, ListPage> {
        private ListPage(PageContext<ListInterconnectAttachmentsRequest, InterconnectAttachmentList, InterconnectAttachment> context, InterconnectAttachmentList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListInterconnectAttachmentsRequest, InterconnectAttachmentList, InterconnectAttachment> context, InterconnectAttachmentList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListInterconnectAttachmentsRequest, InterconnectAttachmentList, InterconnectAttachment> context, ApiFuture<InterconnectAttachmentList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListInterconnectAttachmentsRequest, InterconnectAttachmentList, InterconnectAttachment, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListInterconnectAttachmentsRequest, InterconnectAttachmentList, InterconnectAttachment> context, ApiFuture<InterconnectAttachmentList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPagedResponse((ListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class AggregatedListFixedSizeCollection
    extends AbstractFixedSizeCollection<AggregatedListInterconnectAttachmentsRequest, InterconnectAttachmentAggregatedList, Map.Entry<String, InterconnectAttachmentsScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        private AggregatedListFixedSizeCollection(List<AggregatedListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static AggregatedListFixedSizeCollection createEmptyCollection() {
            return new AggregatedListFixedSizeCollection(null, 0);
        }

        protected AggregatedListFixedSizeCollection createCollection(List<AggregatedListPage> pages, int collectionSize) {
            return new AggregatedListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class AggregatedListPage
    extends AbstractPage<AggregatedListInterconnectAttachmentsRequest, InterconnectAttachmentAggregatedList, Map.Entry<String, InterconnectAttachmentsScopedList>, AggregatedListPage> {
        private AggregatedListPage(PageContext<AggregatedListInterconnectAttachmentsRequest, InterconnectAttachmentAggregatedList, Map.Entry<String, InterconnectAttachmentsScopedList>> context, InterconnectAttachmentAggregatedList response) {
            super(context, (Object)response);
        }

        private static AggregatedListPage createEmptyPage() {
            return new AggregatedListPage(null, null);
        }

        protected AggregatedListPage createPage(PageContext<AggregatedListInterconnectAttachmentsRequest, InterconnectAttachmentAggregatedList, Map.Entry<String, InterconnectAttachmentsScopedList>> context, InterconnectAttachmentAggregatedList response) {
            return new AggregatedListPage(context, response);
        }

        public ApiFuture<AggregatedListPage> createPageAsync(PageContext<AggregatedListInterconnectAttachmentsRequest, InterconnectAttachmentAggregatedList, Map.Entry<String, InterconnectAttachmentsScopedList>> context, ApiFuture<InterconnectAttachmentAggregatedList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class AggregatedListPagedResponse
    extends AbstractPagedListResponse<AggregatedListInterconnectAttachmentsRequest, InterconnectAttachmentAggregatedList, Map.Entry<String, InterconnectAttachmentsScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        public static ApiFuture<AggregatedListPagedResponse> createAsync(PageContext<AggregatedListInterconnectAttachmentsRequest, InterconnectAttachmentAggregatedList, Map.Entry<String, InterconnectAttachmentsScopedList>> context, ApiFuture<InterconnectAttachmentAggregatedList> futureResponse) {
            ApiFuture<AggregatedListPage> futurePage = AggregatedListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new AggregatedListPagedResponse((AggregatedListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private AggregatedListPagedResponse(AggregatedListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)AggregatedListFixedSizeCollection.createEmptyCollection());
        }
    }
}

