/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.httpjson.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AddAssociationRegionNetworkFirewallPolicyRequest;
import com.google.cloud.compute.v1.AddRuleRegionNetworkFirewallPolicyRequest;
import com.google.cloud.compute.v1.CloneRulesRegionNetworkFirewallPolicyRequest;
import com.google.cloud.compute.v1.DeleteRegionNetworkFirewallPolicyRequest;
import com.google.cloud.compute.v1.FirewallPolicy;
import com.google.cloud.compute.v1.FirewallPolicyAssociation;
import com.google.cloud.compute.v1.FirewallPolicyList;
import com.google.cloud.compute.v1.FirewallPolicyRule;
import com.google.cloud.compute.v1.GetAssociationRegionNetworkFirewallPolicyRequest;
import com.google.cloud.compute.v1.GetEffectiveFirewallsRegionNetworkFirewallPolicyRequest;
import com.google.cloud.compute.v1.GetIamPolicyRegionNetworkFirewallPolicyRequest;
import com.google.cloud.compute.v1.GetRegionNetworkFirewallPolicyRequest;
import com.google.cloud.compute.v1.GetRuleRegionNetworkFirewallPolicyRequest;
import com.google.cloud.compute.v1.InsertRegionNetworkFirewallPolicyRequest;
import com.google.cloud.compute.v1.ListRegionNetworkFirewallPoliciesRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchRegionNetworkFirewallPolicyRequest;
import com.google.cloud.compute.v1.PatchRuleRegionNetworkFirewallPolicyRequest;
import com.google.cloud.compute.v1.Policy;
import com.google.cloud.compute.v1.RegionNetworkFirewallPoliciesClient;
import com.google.cloud.compute.v1.RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponse;
import com.google.cloud.compute.v1.RemoveAssociationRegionNetworkFirewallPolicyRequest;
import com.google.cloud.compute.v1.RemoveRuleRegionNetworkFirewallPolicyRequest;
import com.google.cloud.compute.v1.SetIamPolicyRegionNetworkFirewallPolicyRequest;
import com.google.cloud.compute.v1.TestIamPermissionsRegionNetworkFirewallPolicyRequest;
import com.google.cloud.compute.v1.TestPermissionsResponse;
import com.google.cloud.compute.v1.stub.HttpJsonRegionNetworkFirewallPoliciesStub;
import com.google.cloud.compute.v1.stub.RegionNetworkFirewallPoliciesStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class RegionNetworkFirewallPoliciesStubSettings
extends StubSettings<RegionNetworkFirewallPoliciesStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<AddAssociationRegionNetworkFirewallPolicyRequest, Operation> addAssociationSettings;
    private final OperationCallSettings<AddAssociationRegionNetworkFirewallPolicyRequest, Operation, Operation> addAssociationOperationSettings;
    private final UnaryCallSettings<AddRuleRegionNetworkFirewallPolicyRequest, Operation> addRuleSettings;
    private final OperationCallSettings<AddRuleRegionNetworkFirewallPolicyRequest, Operation, Operation> addRuleOperationSettings;
    private final UnaryCallSettings<CloneRulesRegionNetworkFirewallPolicyRequest, Operation> cloneRulesSettings;
    private final OperationCallSettings<CloneRulesRegionNetworkFirewallPolicyRequest, Operation, Operation> cloneRulesOperationSettings;
    private final UnaryCallSettings<DeleteRegionNetworkFirewallPolicyRequest, Operation> deleteSettings;
    private final OperationCallSettings<DeleteRegionNetworkFirewallPolicyRequest, Operation, Operation> deleteOperationSettings;
    private final UnaryCallSettings<GetRegionNetworkFirewallPolicyRequest, FirewallPolicy> getSettings;
    private final UnaryCallSettings<GetAssociationRegionNetworkFirewallPolicyRequest, FirewallPolicyAssociation> getAssociationSettings;
    private final UnaryCallSettings<GetEffectiveFirewallsRegionNetworkFirewallPolicyRequest, RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponse> getEffectiveFirewallsSettings;
    private final UnaryCallSettings<GetIamPolicyRegionNetworkFirewallPolicyRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<GetRuleRegionNetworkFirewallPolicyRequest, FirewallPolicyRule> getRuleSettings;
    private final UnaryCallSettings<InsertRegionNetworkFirewallPolicyRequest, Operation> insertSettings;
    private final OperationCallSettings<InsertRegionNetworkFirewallPolicyRequest, Operation, Operation> insertOperationSettings;
    private final PagedCallSettings<ListRegionNetworkFirewallPoliciesRequest, FirewallPolicyList, RegionNetworkFirewallPoliciesClient.ListPagedResponse> listSettings;
    private final UnaryCallSettings<PatchRegionNetworkFirewallPolicyRequest, Operation> patchSettings;
    private final OperationCallSettings<PatchRegionNetworkFirewallPolicyRequest, Operation, Operation> patchOperationSettings;
    private final UnaryCallSettings<PatchRuleRegionNetworkFirewallPolicyRequest, Operation> patchRuleSettings;
    private final OperationCallSettings<PatchRuleRegionNetworkFirewallPolicyRequest, Operation, Operation> patchRuleOperationSettings;
    private final UnaryCallSettings<RemoveAssociationRegionNetworkFirewallPolicyRequest, Operation> removeAssociationSettings;
    private final OperationCallSettings<RemoveAssociationRegionNetworkFirewallPolicyRequest, Operation, Operation> removeAssociationOperationSettings;
    private final UnaryCallSettings<RemoveRuleRegionNetworkFirewallPolicyRequest, Operation> removeRuleSettings;
    private final OperationCallSettings<RemoveRuleRegionNetworkFirewallPolicyRequest, Operation, Operation> removeRuleOperationSettings;
    private final UnaryCallSettings<SetIamPolicyRegionNetworkFirewallPolicyRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsRegionNetworkFirewallPolicyRequest, TestPermissionsResponse> testIamPermissionsSettings;
    private static final PagedListDescriptor<ListRegionNetworkFirewallPoliciesRequest, FirewallPolicyList, FirewallPolicy> LIST_PAGE_STR_DESC = new PagedListDescriptor<ListRegionNetworkFirewallPoliciesRequest, FirewallPolicyList, FirewallPolicy>(){

        public String emptyToken() {
            return "";
        }

        public ListRegionNetworkFirewallPoliciesRequest injectToken(ListRegionNetworkFirewallPoliciesRequest payload, String token) {
            return ListRegionNetworkFirewallPoliciesRequest.newBuilder((ListRegionNetworkFirewallPoliciesRequest)payload).setPageToken(token).build();
        }

        public ListRegionNetworkFirewallPoliciesRequest injectPageSize(ListRegionNetworkFirewallPoliciesRequest payload, int pageSize) {
            return ListRegionNetworkFirewallPoliciesRequest.newBuilder((ListRegionNetworkFirewallPoliciesRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListRegionNetworkFirewallPoliciesRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(FirewallPolicyList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<FirewallPolicy> extractResources(FirewallPolicyList payload) {
            return payload.getItemsList() == null ? ImmutableList.of() : payload.getItemsList();
        }
    };
    private static final PagedListResponseFactory<ListRegionNetworkFirewallPoliciesRequest, FirewallPolicyList, RegionNetworkFirewallPoliciesClient.ListPagedResponse> LIST_PAGE_STR_FACT = new PagedListResponseFactory<ListRegionNetworkFirewallPoliciesRequest, FirewallPolicyList, RegionNetworkFirewallPoliciesClient.ListPagedResponse>(){

        public ApiFuture<RegionNetworkFirewallPoliciesClient.ListPagedResponse> getFuturePagedResponse(UnaryCallable<ListRegionNetworkFirewallPoliciesRequest, FirewallPolicyList> callable, ListRegionNetworkFirewallPoliciesRequest request, ApiCallContext context, ApiFuture<FirewallPolicyList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return RegionNetworkFirewallPoliciesClient.ListPagedResponse.createAsync((PageContext<ListRegionNetworkFirewallPoliciesRequest, FirewallPolicyList, FirewallPolicy>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<AddAssociationRegionNetworkFirewallPolicyRequest, Operation> addAssociationSettings() {
        return this.addAssociationSettings;
    }

    public OperationCallSettings<AddAssociationRegionNetworkFirewallPolicyRequest, Operation, Operation> addAssociationOperationSettings() {
        return this.addAssociationOperationSettings;
    }

    public UnaryCallSettings<AddRuleRegionNetworkFirewallPolicyRequest, Operation> addRuleSettings() {
        return this.addRuleSettings;
    }

    public OperationCallSettings<AddRuleRegionNetworkFirewallPolicyRequest, Operation, Operation> addRuleOperationSettings() {
        return this.addRuleOperationSettings;
    }

    public UnaryCallSettings<CloneRulesRegionNetworkFirewallPolicyRequest, Operation> cloneRulesSettings() {
        return this.cloneRulesSettings;
    }

    public OperationCallSettings<CloneRulesRegionNetworkFirewallPolicyRequest, Operation, Operation> cloneRulesOperationSettings() {
        return this.cloneRulesOperationSettings;
    }

    public UnaryCallSettings<DeleteRegionNetworkFirewallPolicyRequest, Operation> deleteSettings() {
        return this.deleteSettings;
    }

    public OperationCallSettings<DeleteRegionNetworkFirewallPolicyRequest, Operation, Operation> deleteOperationSettings() {
        return this.deleteOperationSettings;
    }

    public UnaryCallSettings<GetRegionNetworkFirewallPolicyRequest, FirewallPolicy> getSettings() {
        return this.getSettings;
    }

    public UnaryCallSettings<GetAssociationRegionNetworkFirewallPolicyRequest, FirewallPolicyAssociation> getAssociationSettings() {
        return this.getAssociationSettings;
    }

    public UnaryCallSettings<GetEffectiveFirewallsRegionNetworkFirewallPolicyRequest, RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponse> getEffectiveFirewallsSettings() {
        return this.getEffectiveFirewallsSettings;
    }

    public UnaryCallSettings<GetIamPolicyRegionNetworkFirewallPolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<GetRuleRegionNetworkFirewallPolicyRequest, FirewallPolicyRule> getRuleSettings() {
        return this.getRuleSettings;
    }

    public UnaryCallSettings<InsertRegionNetworkFirewallPolicyRequest, Operation> insertSettings() {
        return this.insertSettings;
    }

    public OperationCallSettings<InsertRegionNetworkFirewallPolicyRequest, Operation, Operation> insertOperationSettings() {
        return this.insertOperationSettings;
    }

    public PagedCallSettings<ListRegionNetworkFirewallPoliciesRequest, FirewallPolicyList, RegionNetworkFirewallPoliciesClient.ListPagedResponse> listSettings() {
        return this.listSettings;
    }

    public UnaryCallSettings<PatchRegionNetworkFirewallPolicyRequest, Operation> patchSettings() {
        return this.patchSettings;
    }

    public OperationCallSettings<PatchRegionNetworkFirewallPolicyRequest, Operation, Operation> patchOperationSettings() {
        return this.patchOperationSettings;
    }

    public UnaryCallSettings<PatchRuleRegionNetworkFirewallPolicyRequest, Operation> patchRuleSettings() {
        return this.patchRuleSettings;
    }

    public OperationCallSettings<PatchRuleRegionNetworkFirewallPolicyRequest, Operation, Operation> patchRuleOperationSettings() {
        return this.patchRuleOperationSettings;
    }

    public UnaryCallSettings<RemoveAssociationRegionNetworkFirewallPolicyRequest, Operation> removeAssociationSettings() {
        return this.removeAssociationSettings;
    }

    public OperationCallSettings<RemoveAssociationRegionNetworkFirewallPolicyRequest, Operation, Operation> removeAssociationOperationSettings() {
        return this.removeAssociationOperationSettings;
    }

    public UnaryCallSettings<RemoveRuleRegionNetworkFirewallPolicyRequest, Operation> removeRuleSettings() {
        return this.removeRuleSettings;
    }

    public OperationCallSettings<RemoveRuleRegionNetworkFirewallPolicyRequest, Operation, Operation> removeRuleOperationSettings() {
        return this.removeRuleOperationSettings;
    }

    public UnaryCallSettings<SetIamPolicyRegionNetworkFirewallPolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsRegionNetworkFirewallPolicyRequest, TestPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public RegionNetworkFirewallPoliciesStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonRegionNetworkFirewallPoliciesStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "compute";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "compute.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "compute.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return RegionNetworkFirewallPoliciesStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(RegionNetworkFirewallPoliciesStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected RegionNetworkFirewallPoliciesStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.addAssociationSettings = settingsBuilder.addAssociationSettings().build();
        this.addAssociationOperationSettings = settingsBuilder.addAssociationOperationSettings().build();
        this.addRuleSettings = settingsBuilder.addRuleSettings().build();
        this.addRuleOperationSettings = settingsBuilder.addRuleOperationSettings().build();
        this.cloneRulesSettings = settingsBuilder.cloneRulesSettings().build();
        this.cloneRulesOperationSettings = settingsBuilder.cloneRulesOperationSettings().build();
        this.deleteSettings = settingsBuilder.deleteSettings().build();
        this.deleteOperationSettings = settingsBuilder.deleteOperationSettings().build();
        this.getSettings = settingsBuilder.getSettings().build();
        this.getAssociationSettings = settingsBuilder.getAssociationSettings().build();
        this.getEffectiveFirewallsSettings = settingsBuilder.getEffectiveFirewallsSettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.getRuleSettings = settingsBuilder.getRuleSettings().build();
        this.insertSettings = settingsBuilder.insertSettings().build();
        this.insertOperationSettings = settingsBuilder.insertOperationSettings().build();
        this.listSettings = settingsBuilder.listSettings().build();
        this.patchSettings = settingsBuilder.patchSettings().build();
        this.patchOperationSettings = settingsBuilder.patchOperationSettings().build();
        this.patchRuleSettings = settingsBuilder.patchRuleSettings().build();
        this.patchRuleOperationSettings = settingsBuilder.patchRuleOperationSettings().build();
        this.removeAssociationSettings = settingsBuilder.removeAssociationSettings().build();
        this.removeAssociationOperationSettings = settingsBuilder.removeAssociationOperationSettings().build();
        this.removeRuleSettings = settingsBuilder.removeRuleSettings().build();
        this.removeRuleOperationSettings = settingsBuilder.removeRuleOperationSettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<RegionNetworkFirewallPoliciesStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<AddAssociationRegionNetworkFirewallPolicyRequest, Operation> addAssociationSettings;
        private final OperationCallSettings.Builder<AddAssociationRegionNetworkFirewallPolicyRequest, Operation, Operation> addAssociationOperationSettings;
        private final UnaryCallSettings.Builder<AddRuleRegionNetworkFirewallPolicyRequest, Operation> addRuleSettings;
        private final OperationCallSettings.Builder<AddRuleRegionNetworkFirewallPolicyRequest, Operation, Operation> addRuleOperationSettings;
        private final UnaryCallSettings.Builder<CloneRulesRegionNetworkFirewallPolicyRequest, Operation> cloneRulesSettings;
        private final OperationCallSettings.Builder<CloneRulesRegionNetworkFirewallPolicyRequest, Operation, Operation> cloneRulesOperationSettings;
        private final UnaryCallSettings.Builder<DeleteRegionNetworkFirewallPolicyRequest, Operation> deleteSettings;
        private final OperationCallSettings.Builder<DeleteRegionNetworkFirewallPolicyRequest, Operation, Operation> deleteOperationSettings;
        private final UnaryCallSettings.Builder<GetRegionNetworkFirewallPolicyRequest, FirewallPolicy> getSettings;
        private final UnaryCallSettings.Builder<GetAssociationRegionNetworkFirewallPolicyRequest, FirewallPolicyAssociation> getAssociationSettings;
        private final UnaryCallSettings.Builder<GetEffectiveFirewallsRegionNetworkFirewallPolicyRequest, RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponse> getEffectiveFirewallsSettings;
        private final UnaryCallSettings.Builder<GetIamPolicyRegionNetworkFirewallPolicyRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<GetRuleRegionNetworkFirewallPolicyRequest, FirewallPolicyRule> getRuleSettings;
        private final UnaryCallSettings.Builder<InsertRegionNetworkFirewallPolicyRequest, Operation> insertSettings;
        private final OperationCallSettings.Builder<InsertRegionNetworkFirewallPolicyRequest, Operation, Operation> insertOperationSettings;
        private final PagedCallSettings.Builder<ListRegionNetworkFirewallPoliciesRequest, FirewallPolicyList, RegionNetworkFirewallPoliciesClient.ListPagedResponse> listSettings;
        private final UnaryCallSettings.Builder<PatchRegionNetworkFirewallPolicyRequest, Operation> patchSettings;
        private final OperationCallSettings.Builder<PatchRegionNetworkFirewallPolicyRequest, Operation, Operation> patchOperationSettings;
        private final UnaryCallSettings.Builder<PatchRuleRegionNetworkFirewallPolicyRequest, Operation> patchRuleSettings;
        private final OperationCallSettings.Builder<PatchRuleRegionNetworkFirewallPolicyRequest, Operation, Operation> patchRuleOperationSettings;
        private final UnaryCallSettings.Builder<RemoveAssociationRegionNetworkFirewallPolicyRequest, Operation> removeAssociationSettings;
        private final OperationCallSettings.Builder<RemoveAssociationRegionNetworkFirewallPolicyRequest, Operation, Operation> removeAssociationOperationSettings;
        private final UnaryCallSettings.Builder<RemoveRuleRegionNetworkFirewallPolicyRequest, Operation> removeRuleSettings;
        private final OperationCallSettings.Builder<RemoveRuleRegionNetworkFirewallPolicyRequest, Operation, Operation> removeRuleOperationSettings;
        private final UnaryCallSettings.Builder<SetIamPolicyRegionNetworkFirewallPolicyRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsRegionNetworkFirewallPolicyRequest, TestPermissionsResponse> testIamPermissionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.addAssociationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.addAssociationOperationSettings = OperationCallSettings.newBuilder();
            this.addRuleSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.addRuleOperationSettings = OperationCallSettings.newBuilder();
            this.cloneRulesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.cloneRulesOperationSettings = OperationCallSettings.newBuilder();
            this.deleteSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteOperationSettings = OperationCallSettings.newBuilder();
            this.getSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getAssociationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getEffectiveFirewallsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getRuleSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertOperationSettings = OperationCallSettings.newBuilder();
            this.listSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PAGE_STR_FACT);
            this.patchSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.patchOperationSettings = OperationCallSettings.newBuilder();
            this.patchRuleSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.patchRuleOperationSettings = OperationCallSettings.newBuilder();
            this.removeAssociationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.removeAssociationOperationSettings = OperationCallSettings.newBuilder();
            this.removeRuleSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.removeRuleOperationSettings = OperationCallSettings.newBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.addAssociationSettings, this.addRuleSettings, this.cloneRulesSettings, this.deleteSettings, this.getSettings, this.getAssociationSettings, this.getEffectiveFirewallsSettings, this.getIamPolicySettings, this.getRuleSettings, this.insertSettings, this.listSettings, this.patchSettings, (Object[])new UnaryCallSettings.Builder[]{this.patchRuleSettings, this.removeAssociationSettings, this.removeRuleSettings, this.setIamPolicySettings, this.testIamPermissionsSettings});
            Builder.initDefaults(this);
        }

        protected Builder(RegionNetworkFirewallPoliciesStubSettings settings) {
            super((StubSettings)settings);
            this.addAssociationSettings = settings.addAssociationSettings.toBuilder();
            this.addAssociationOperationSettings = settings.addAssociationOperationSettings.toBuilder();
            this.addRuleSettings = settings.addRuleSettings.toBuilder();
            this.addRuleOperationSettings = settings.addRuleOperationSettings.toBuilder();
            this.cloneRulesSettings = settings.cloneRulesSettings.toBuilder();
            this.cloneRulesOperationSettings = settings.cloneRulesOperationSettings.toBuilder();
            this.deleteSettings = settings.deleteSettings.toBuilder();
            this.deleteOperationSettings = settings.deleteOperationSettings.toBuilder();
            this.getSettings = settings.getSettings.toBuilder();
            this.getAssociationSettings = settings.getAssociationSettings.toBuilder();
            this.getEffectiveFirewallsSettings = settings.getEffectiveFirewallsSettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.getRuleSettings = settings.getRuleSettings.toBuilder();
            this.insertSettings = settings.insertSettings.toBuilder();
            this.insertOperationSettings = settings.insertOperationSettings.toBuilder();
            this.listSettings = settings.listSettings.toBuilder();
            this.patchSettings = settings.patchSettings.toBuilder();
            this.patchOperationSettings = settings.patchOperationSettings.toBuilder();
            this.patchRuleSettings = settings.patchRuleSettings.toBuilder();
            this.patchRuleOperationSettings = settings.patchRuleOperationSettings.toBuilder();
            this.removeAssociationSettings = settings.removeAssociationSettings.toBuilder();
            this.removeAssociationOperationSettings = settings.removeAssociationOperationSettings.toBuilder();
            this.removeRuleSettings = settings.removeRuleSettings.toBuilder();
            this.removeRuleOperationSettings = settings.removeRuleOperationSettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.addAssociationSettings, this.addRuleSettings, this.cloneRulesSettings, this.deleteSettings, this.getSettings, this.getAssociationSettings, this.getEffectiveFirewallsSettings, this.getIamPolicySettings, this.getRuleSettings, this.insertSettings, this.listSettings, this.patchSettings, (Object[])new UnaryCallSettings.Builder[]{this.patchRuleSettings, this.removeAssociationSettings, this.removeRuleSettings, this.setIamPolicySettings, this.testIamPermissionsSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(RegionNetworkFirewallPoliciesStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)RegionNetworkFirewallPoliciesStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)RegionNetworkFirewallPoliciesStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(RegionNetworkFirewallPoliciesStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.addAssociationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.addRuleSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.cloneRulesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getAssociationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getEffectiveFirewallsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getRuleSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.insertSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.patchSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.patchRuleSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.removeAssociationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.removeRuleSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.addAssociationOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.addRuleOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.cloneRulesOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.deleteOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.insertOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.patchOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.patchRuleOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.removeAssociationOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.removeRuleOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<AddAssociationRegionNetworkFirewallPolicyRequest, Operation> addAssociationSettings() {
            return this.addAssociationSettings;
        }

        public OperationCallSettings.Builder<AddAssociationRegionNetworkFirewallPolicyRequest, Operation, Operation> addAssociationOperationSettings() {
            return this.addAssociationOperationSettings;
        }

        public UnaryCallSettings.Builder<AddRuleRegionNetworkFirewallPolicyRequest, Operation> addRuleSettings() {
            return this.addRuleSettings;
        }

        public OperationCallSettings.Builder<AddRuleRegionNetworkFirewallPolicyRequest, Operation, Operation> addRuleOperationSettings() {
            return this.addRuleOperationSettings;
        }

        public UnaryCallSettings.Builder<CloneRulesRegionNetworkFirewallPolicyRequest, Operation> cloneRulesSettings() {
            return this.cloneRulesSettings;
        }

        public OperationCallSettings.Builder<CloneRulesRegionNetworkFirewallPolicyRequest, Operation, Operation> cloneRulesOperationSettings() {
            return this.cloneRulesOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteRegionNetworkFirewallPolicyRequest, Operation> deleteSettings() {
            return this.deleteSettings;
        }

        public OperationCallSettings.Builder<DeleteRegionNetworkFirewallPolicyRequest, Operation, Operation> deleteOperationSettings() {
            return this.deleteOperationSettings;
        }

        public UnaryCallSettings.Builder<GetRegionNetworkFirewallPolicyRequest, FirewallPolicy> getSettings() {
            return this.getSettings;
        }

        public UnaryCallSettings.Builder<GetAssociationRegionNetworkFirewallPolicyRequest, FirewallPolicyAssociation> getAssociationSettings() {
            return this.getAssociationSettings;
        }

        public UnaryCallSettings.Builder<GetEffectiveFirewallsRegionNetworkFirewallPolicyRequest, RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponse> getEffectiveFirewallsSettings() {
            return this.getEffectiveFirewallsSettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyRegionNetworkFirewallPolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<GetRuleRegionNetworkFirewallPolicyRequest, FirewallPolicyRule> getRuleSettings() {
            return this.getRuleSettings;
        }

        public UnaryCallSettings.Builder<InsertRegionNetworkFirewallPolicyRequest, Operation> insertSettings() {
            return this.insertSettings;
        }

        public OperationCallSettings.Builder<InsertRegionNetworkFirewallPolicyRequest, Operation, Operation> insertOperationSettings() {
            return this.insertOperationSettings;
        }

        public PagedCallSettings.Builder<ListRegionNetworkFirewallPoliciesRequest, FirewallPolicyList, RegionNetworkFirewallPoliciesClient.ListPagedResponse> listSettings() {
            return this.listSettings;
        }

        public UnaryCallSettings.Builder<PatchRegionNetworkFirewallPolicyRequest, Operation> patchSettings() {
            return this.patchSettings;
        }

        public OperationCallSettings.Builder<PatchRegionNetworkFirewallPolicyRequest, Operation, Operation> patchOperationSettings() {
            return this.patchOperationSettings;
        }

        public UnaryCallSettings.Builder<PatchRuleRegionNetworkFirewallPolicyRequest, Operation> patchRuleSettings() {
            return this.patchRuleSettings;
        }

        public OperationCallSettings.Builder<PatchRuleRegionNetworkFirewallPolicyRequest, Operation, Operation> patchRuleOperationSettings() {
            return this.patchRuleOperationSettings;
        }

        public UnaryCallSettings.Builder<RemoveAssociationRegionNetworkFirewallPolicyRequest, Operation> removeAssociationSettings() {
            return this.removeAssociationSettings;
        }

        public OperationCallSettings.Builder<RemoveAssociationRegionNetworkFirewallPolicyRequest, Operation, Operation> removeAssociationOperationSettings() {
            return this.removeAssociationOperationSettings;
        }

        public UnaryCallSettings.Builder<RemoveRuleRegionNetworkFirewallPolicyRequest, Operation> removeRuleSettings() {
            return this.removeRuleSettings;
        }

        public OperationCallSettings.Builder<RemoveRuleRegionNetworkFirewallPolicyRequest, Operation, Operation> removeRuleOperationSettings() {
            return this.removeRuleOperationSettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyRegionNetworkFirewallPolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsRegionNetworkFirewallPolicyRequest, TestPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public RegionNetworkFirewallPoliciesStubSettings build() throws IOException {
            return new RegionNetworkFirewallPoliciesStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

