/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AcceleratorType;
import com.google.cloud.compute.v1.AcceleratorTypeAggregatedList;
import com.google.cloud.compute.v1.AcceleratorTypeList;
import com.google.cloud.compute.v1.AcceleratorTypesClient;
import com.google.cloud.compute.v1.AcceleratorTypesScopedList;
import com.google.cloud.compute.v1.AggregatedListAcceleratorTypesRequest;
import com.google.cloud.compute.v1.GetAcceleratorTypeRequest;
import com.google.cloud.compute.v1.ListAcceleratorTypesRequest;
import com.google.cloud.compute.v1.stub.AcceleratorTypesStub;
import com.google.cloud.compute.v1.stub.HttpJsonAcceleratorTypesStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.threeten.bp.Duration;

public class AcceleratorTypesStubSettings
extends StubSettings<AcceleratorTypesStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/compute.readonly").add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<AggregatedListAcceleratorTypesRequest, AcceleratorTypeAggregatedList, AcceleratorTypesClient.AggregatedListPagedResponse> aggregatedListSettings;
    private final UnaryCallSettings<GetAcceleratorTypeRequest, AcceleratorType> getSettings;
    private final PagedCallSettings<ListAcceleratorTypesRequest, AcceleratorTypeList, AcceleratorTypesClient.ListPagedResponse> listSettings;
    private static final PagedListDescriptor<AggregatedListAcceleratorTypesRequest, AcceleratorTypeAggregatedList, Map.Entry<String, AcceleratorTypesScopedList>> AGGREGATED_LIST_PAGE_STR_DESC = new PagedListDescriptor<AggregatedListAcceleratorTypesRequest, AcceleratorTypeAggregatedList, Map.Entry<String, AcceleratorTypesScopedList>>(){

        public String emptyToken() {
            return "";
        }

        public AggregatedListAcceleratorTypesRequest injectToken(AggregatedListAcceleratorTypesRequest payload, String token) {
            return AggregatedListAcceleratorTypesRequest.newBuilder((AggregatedListAcceleratorTypesRequest)payload).setPageToken(token).build();
        }

        public AggregatedListAcceleratorTypesRequest injectPageSize(AggregatedListAcceleratorTypesRequest payload, int pageSize) {
            return AggregatedListAcceleratorTypesRequest.newBuilder((AggregatedListAcceleratorTypesRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(AggregatedListAcceleratorTypesRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(AcceleratorTypeAggregatedList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Map.Entry<String, AcceleratorTypesScopedList>> extractResources(AcceleratorTypeAggregatedList payload) {
            return payload.getItemsMap() == null ? Collections.emptySet() : payload.getItemsMap().entrySet();
        }
    };
    private static final PagedListDescriptor<ListAcceleratorTypesRequest, AcceleratorTypeList, AcceleratorType> LIST_PAGE_STR_DESC = new PagedListDescriptor<ListAcceleratorTypesRequest, AcceleratorTypeList, AcceleratorType>(){

        public String emptyToken() {
            return "";
        }

        public ListAcceleratorTypesRequest injectToken(ListAcceleratorTypesRequest payload, String token) {
            return ListAcceleratorTypesRequest.newBuilder((ListAcceleratorTypesRequest)payload).setPageToken(token).build();
        }

        public ListAcceleratorTypesRequest injectPageSize(ListAcceleratorTypesRequest payload, int pageSize) {
            return ListAcceleratorTypesRequest.newBuilder((ListAcceleratorTypesRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListAcceleratorTypesRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(AcceleratorTypeList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<AcceleratorType> extractResources(AcceleratorTypeList payload) {
            return payload.getItemsList() == null ? ImmutableList.of() : payload.getItemsList();
        }
    };
    private static final PagedListResponseFactory<AggregatedListAcceleratorTypesRequest, AcceleratorTypeAggregatedList, AcceleratorTypesClient.AggregatedListPagedResponse> AGGREGATED_LIST_PAGE_STR_FACT = new PagedListResponseFactory<AggregatedListAcceleratorTypesRequest, AcceleratorTypeAggregatedList, AcceleratorTypesClient.AggregatedListPagedResponse>(){

        public ApiFuture<AcceleratorTypesClient.AggregatedListPagedResponse> getFuturePagedResponse(UnaryCallable<AggregatedListAcceleratorTypesRequest, AcceleratorTypeAggregatedList> callable, AggregatedListAcceleratorTypesRequest request, ApiCallContext context, ApiFuture<AcceleratorTypeAggregatedList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)AGGREGATED_LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AcceleratorTypesClient.AggregatedListPagedResponse.createAsync((PageContext<AggregatedListAcceleratorTypesRequest, AcceleratorTypeAggregatedList, Map.Entry<String, AcceleratorTypesScopedList>>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListAcceleratorTypesRequest, AcceleratorTypeList, AcceleratorTypesClient.ListPagedResponse> LIST_PAGE_STR_FACT = new PagedListResponseFactory<ListAcceleratorTypesRequest, AcceleratorTypeList, AcceleratorTypesClient.ListPagedResponse>(){

        public ApiFuture<AcceleratorTypesClient.ListPagedResponse> getFuturePagedResponse(UnaryCallable<ListAcceleratorTypesRequest, AcceleratorTypeList> callable, ListAcceleratorTypesRequest request, ApiCallContext context, ApiFuture<AcceleratorTypeList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AcceleratorTypesClient.ListPagedResponse.createAsync((PageContext<ListAcceleratorTypesRequest, AcceleratorTypeList, AcceleratorType>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<AggregatedListAcceleratorTypesRequest, AcceleratorTypeAggregatedList, AcceleratorTypesClient.AggregatedListPagedResponse> aggregatedListSettings() {
        return this.aggregatedListSettings;
    }

    public UnaryCallSettings<GetAcceleratorTypeRequest, AcceleratorType> getSettings() {
        return this.getSettings;
    }

    public PagedCallSettings<ListAcceleratorTypesRequest, AcceleratorTypeList, AcceleratorTypesClient.ListPagedResponse> listSettings() {
        return this.listSettings;
    }

    public AcceleratorTypesStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonAcceleratorTypesStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "compute";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "compute.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "compute.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return AcceleratorTypesStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(AcceleratorTypesStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected AcceleratorTypesStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.aggregatedListSettings = settingsBuilder.aggregatedListSettings().build();
        this.getSettings = settingsBuilder.getSettings().build();
        this.listSettings = settingsBuilder.listSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<AcceleratorTypesStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<AggregatedListAcceleratorTypesRequest, AcceleratorTypeAggregatedList, AcceleratorTypesClient.AggregatedListPagedResponse> aggregatedListSettings;
        private final UnaryCallSettings.Builder<GetAcceleratorTypeRequest, AcceleratorType> getSettings;
        private final PagedCallSettings.Builder<ListAcceleratorTypesRequest, AcceleratorTypeList, AcceleratorTypesClient.ListPagedResponse> listSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.aggregatedListSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)AGGREGATED_LIST_PAGE_STR_FACT);
            this.getSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListSettings, this.getSettings, this.listSettings);
            Builder.initDefaults(this);
        }

        protected Builder(AcceleratorTypesStubSettings settings) {
            super((StubSettings)settings);
            this.aggregatedListSettings = settings.aggregatedListSettings.toBuilder();
            this.getSettings = settings.getSettings.toBuilder();
            this.listSettings = settings.listSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListSettings, this.getSettings, this.listSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(AcceleratorTypesStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)AcceleratorTypesStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)AcceleratorTypesStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(AcceleratorTypesStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.aggregatedListSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<AggregatedListAcceleratorTypesRequest, AcceleratorTypeAggregatedList, AcceleratorTypesClient.AggregatedListPagedResponse> aggregatedListSettings() {
            return this.aggregatedListSettings;
        }

        public UnaryCallSettings.Builder<GetAcceleratorTypeRequest, AcceleratorType> getSettings() {
            return this.getSettings;
        }

        public PagedCallSettings.Builder<ListAcceleratorTypesRequest, AcceleratorTypeList, AcceleratorTypesClient.ListPagedResponse> listSettings() {
            return this.listSettings;
        }

        public AcceleratorTypesStubSettings build() throws IOException {
            return new AcceleratorTypesStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

