/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AddRuleRegionSecurityPolicyRequest;
import com.google.cloud.compute.v1.DeleteRegionSecurityPolicyRequest;
import com.google.cloud.compute.v1.GetRegionSecurityPolicyRequest;
import com.google.cloud.compute.v1.GetRuleRegionSecurityPolicyRequest;
import com.google.cloud.compute.v1.InsertRegionSecurityPolicyRequest;
import com.google.cloud.compute.v1.ListRegionSecurityPoliciesRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchRegionSecurityPolicyRequest;
import com.google.cloud.compute.v1.PatchRuleRegionSecurityPolicyRequest;
import com.google.cloud.compute.v1.RegionSecurityPoliciesSettings;
import com.google.cloud.compute.v1.RemoveRuleRegionSecurityPolicyRequest;
import com.google.cloud.compute.v1.SecurityPolicy;
import com.google.cloud.compute.v1.SecurityPolicyList;
import com.google.cloud.compute.v1.SecurityPolicyRule;
import com.google.cloud.compute.v1.stub.RegionSecurityPoliciesStub;
import com.google.cloud.compute.v1.stub.RegionSecurityPoliciesStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class RegionSecurityPoliciesClient
implements BackgroundResource {
    private final RegionSecurityPoliciesSettings settings;
    private final RegionSecurityPoliciesStub stub;

    public static final RegionSecurityPoliciesClient create() throws IOException {
        return RegionSecurityPoliciesClient.create(RegionSecurityPoliciesSettings.newBuilder().build());
    }

    public static final RegionSecurityPoliciesClient create(RegionSecurityPoliciesSettings settings) throws IOException {
        return new RegionSecurityPoliciesClient(settings);
    }

    public static final RegionSecurityPoliciesClient create(RegionSecurityPoliciesStub stub) {
        return new RegionSecurityPoliciesClient(stub);
    }

    protected RegionSecurityPoliciesClient(RegionSecurityPoliciesSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((RegionSecurityPoliciesStubSettings)settings.getStubSettings()).createStub();
    }

    protected RegionSecurityPoliciesClient(RegionSecurityPoliciesStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final RegionSecurityPoliciesSettings getSettings() {
        return this.settings;
    }

    public RegionSecurityPoliciesStub getStub() {
        return this.stub;
    }

    public final OperationFuture<Operation, Operation> addRuleAsync(String project, String region, String securityPolicy, SecurityPolicyRule securityPolicyRuleResource) {
        AddRuleRegionSecurityPolicyRequest request = AddRuleRegionSecurityPolicyRequest.newBuilder().setProject(project).setRegion(region).setSecurityPolicy(securityPolicy).setSecurityPolicyRuleResource(securityPolicyRuleResource).build();
        return this.addRuleAsync(request);
    }

    public final OperationFuture<Operation, Operation> addRuleAsync(AddRuleRegionSecurityPolicyRequest request) {
        return this.addRuleOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<AddRuleRegionSecurityPolicyRequest, Operation, Operation> addRuleOperationCallable() {
        return this.stub.addRuleOperationCallable();
    }

    public final UnaryCallable<AddRuleRegionSecurityPolicyRequest, Operation> addRuleCallable() {
        return this.stub.addRuleCallable();
    }

    public final OperationFuture<Operation, Operation> deleteAsync(String project, String region, String securityPolicy) {
        DeleteRegionSecurityPolicyRequest request = DeleteRegionSecurityPolicyRequest.newBuilder().setProject(project).setRegion(region).setSecurityPolicy(securityPolicy).build();
        return this.deleteAsync(request);
    }

    public final OperationFuture<Operation, Operation> deleteAsync(DeleteRegionSecurityPolicyRequest request) {
        return this.deleteOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteRegionSecurityPolicyRequest, Operation, Operation> deleteOperationCallable() {
        return this.stub.deleteOperationCallable();
    }

    public final UnaryCallable<DeleteRegionSecurityPolicyRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final SecurityPolicy get(String project, String region, String securityPolicy) {
        GetRegionSecurityPolicyRequest request = GetRegionSecurityPolicyRequest.newBuilder().setProject(project).setRegion(region).setSecurityPolicy(securityPolicy).build();
        return this.get(request);
    }

    public final SecurityPolicy get(GetRegionSecurityPolicyRequest request) {
        return (SecurityPolicy)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetRegionSecurityPolicyRequest, SecurityPolicy> getCallable() {
        return this.stub.getCallable();
    }

    public final SecurityPolicyRule getRule(String project, String region, String securityPolicy) {
        GetRuleRegionSecurityPolicyRequest request = GetRuleRegionSecurityPolicyRequest.newBuilder().setProject(project).setRegion(region).setSecurityPolicy(securityPolicy).build();
        return this.getRule(request);
    }

    public final SecurityPolicyRule getRule(GetRuleRegionSecurityPolicyRequest request) {
        return (SecurityPolicyRule)this.getRuleCallable().call((Object)request);
    }

    public final UnaryCallable<GetRuleRegionSecurityPolicyRequest, SecurityPolicyRule> getRuleCallable() {
        return this.stub.getRuleCallable();
    }

    public final OperationFuture<Operation, Operation> insertAsync(String project, String region, SecurityPolicy securityPolicyResource) {
        InsertRegionSecurityPolicyRequest request = InsertRegionSecurityPolicyRequest.newBuilder().setProject(project).setRegion(region).setSecurityPolicyResource(securityPolicyResource).build();
        return this.insertAsync(request);
    }

    public final OperationFuture<Operation, Operation> insertAsync(InsertRegionSecurityPolicyRequest request) {
        return this.insertOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<InsertRegionSecurityPolicyRequest, Operation, Operation> insertOperationCallable() {
        return this.stub.insertOperationCallable();
    }

    public final UnaryCallable<InsertRegionSecurityPolicyRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list(String project, String region) {
        ListRegionSecurityPoliciesRequest request = ListRegionSecurityPoliciesRequest.newBuilder().setProject(project).setRegion(region).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListRegionSecurityPoliciesRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListRegionSecurityPoliciesRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListRegionSecurityPoliciesRequest, SecurityPolicyList> listCallable() {
        return this.stub.listCallable();
    }

    public final OperationFuture<Operation, Operation> patchAsync(String project, String region, String securityPolicy, SecurityPolicy securityPolicyResource) {
        PatchRegionSecurityPolicyRequest request = PatchRegionSecurityPolicyRequest.newBuilder().setProject(project).setRegion(region).setSecurityPolicy(securityPolicy).setSecurityPolicyResource(securityPolicyResource).build();
        return this.patchAsync(request);
    }

    public final OperationFuture<Operation, Operation> patchAsync(PatchRegionSecurityPolicyRequest request) {
        return this.patchOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<PatchRegionSecurityPolicyRequest, Operation, Operation> patchOperationCallable() {
        return this.stub.patchOperationCallable();
    }

    public final UnaryCallable<PatchRegionSecurityPolicyRequest, Operation> patchCallable() {
        return this.stub.patchCallable();
    }

    public final OperationFuture<Operation, Operation> patchRuleAsync(String project, String region, String securityPolicy, SecurityPolicyRule securityPolicyRuleResource) {
        PatchRuleRegionSecurityPolicyRequest request = PatchRuleRegionSecurityPolicyRequest.newBuilder().setProject(project).setRegion(region).setSecurityPolicy(securityPolicy).setSecurityPolicyRuleResource(securityPolicyRuleResource).build();
        return this.patchRuleAsync(request);
    }

    public final OperationFuture<Operation, Operation> patchRuleAsync(PatchRuleRegionSecurityPolicyRequest request) {
        return this.patchRuleOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<PatchRuleRegionSecurityPolicyRequest, Operation, Operation> patchRuleOperationCallable() {
        return this.stub.patchRuleOperationCallable();
    }

    public final UnaryCallable<PatchRuleRegionSecurityPolicyRequest, Operation> patchRuleCallable() {
        return this.stub.patchRuleCallable();
    }

    public final OperationFuture<Operation, Operation> removeRuleAsync(String project, String region, String securityPolicy) {
        RemoveRuleRegionSecurityPolicyRequest request = RemoveRuleRegionSecurityPolicyRequest.newBuilder().setProject(project).setRegion(region).setSecurityPolicy(securityPolicy).build();
        return this.removeRuleAsync(request);
    }

    public final OperationFuture<Operation, Operation> removeRuleAsync(RemoveRuleRegionSecurityPolicyRequest request) {
        return this.removeRuleOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<RemoveRuleRegionSecurityPolicyRequest, Operation, Operation> removeRuleOperationCallable() {
        return this.stub.removeRuleOperationCallable();
    }

    public final UnaryCallable<RemoveRuleRegionSecurityPolicyRequest, Operation> removeRuleCallable() {
        return this.stub.removeRuleCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRegionSecurityPoliciesRequest, SecurityPolicyList, SecurityPolicy, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListRegionSecurityPoliciesRequest, SecurityPolicyList, SecurityPolicy, ListPage> {
        private ListPage(PageContext<ListRegionSecurityPoliciesRequest, SecurityPolicyList, SecurityPolicy> context, SecurityPolicyList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListRegionSecurityPoliciesRequest, SecurityPolicyList, SecurityPolicy> context, SecurityPolicyList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListRegionSecurityPoliciesRequest, SecurityPolicyList, SecurityPolicy> context, ApiFuture<SecurityPolicyList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListRegionSecurityPoliciesRequest, SecurityPolicyList, SecurityPolicy, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListRegionSecurityPoliciesRequest, SecurityPolicyList, SecurityPolicy> context, ApiFuture<SecurityPolicyList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPagedResponse((ListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }
}

