/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListNodeTypesRequest;
import com.google.cloud.compute.v1.GetNodeTypeRequest;
import com.google.cloud.compute.v1.ListNodeTypesRequest;
import com.google.cloud.compute.v1.NodeType;
import com.google.cloud.compute.v1.NodeTypeAggregatedList;
import com.google.cloud.compute.v1.NodeTypeList;
import com.google.cloud.compute.v1.NodeTypesClient;
import com.google.cloud.compute.v1.NodeTypesScopedList;
import com.google.cloud.compute.v1.stub.HttpJsonNodeTypesStub;
import com.google.cloud.compute.v1.stub.NodeTypesStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.threeten.bp.Duration;

public class NodeTypesStubSettings
extends StubSettings<NodeTypesStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/compute.readonly").add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<AggregatedListNodeTypesRequest, NodeTypeAggregatedList, NodeTypesClient.AggregatedListPagedResponse> aggregatedListSettings;
    private final UnaryCallSettings<GetNodeTypeRequest, NodeType> getSettings;
    private final PagedCallSettings<ListNodeTypesRequest, NodeTypeList, NodeTypesClient.ListPagedResponse> listSettings;
    private static final PagedListDescriptor<AggregatedListNodeTypesRequest, NodeTypeAggregatedList, Map.Entry<String, NodeTypesScopedList>> AGGREGATED_LIST_PAGE_STR_DESC = new PagedListDescriptor<AggregatedListNodeTypesRequest, NodeTypeAggregatedList, Map.Entry<String, NodeTypesScopedList>>(){

        public String emptyToken() {
            return "";
        }

        public AggregatedListNodeTypesRequest injectToken(AggregatedListNodeTypesRequest payload, String token) {
            return AggregatedListNodeTypesRequest.newBuilder((AggregatedListNodeTypesRequest)payload).setPageToken(token).build();
        }

        public AggregatedListNodeTypesRequest injectPageSize(AggregatedListNodeTypesRequest payload, int pageSize) {
            return AggregatedListNodeTypesRequest.newBuilder((AggregatedListNodeTypesRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(AggregatedListNodeTypesRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(NodeTypeAggregatedList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Map.Entry<String, NodeTypesScopedList>> extractResources(NodeTypeAggregatedList payload) {
            return payload.getItemsMap() == null ? Collections.emptySet() : payload.getItemsMap().entrySet();
        }
    };
    private static final PagedListDescriptor<ListNodeTypesRequest, NodeTypeList, NodeType> LIST_PAGE_STR_DESC = new PagedListDescriptor<ListNodeTypesRequest, NodeTypeList, NodeType>(){

        public String emptyToken() {
            return "";
        }

        public ListNodeTypesRequest injectToken(ListNodeTypesRequest payload, String token) {
            return ListNodeTypesRequest.newBuilder((ListNodeTypesRequest)payload).setPageToken(token).build();
        }

        public ListNodeTypesRequest injectPageSize(ListNodeTypesRequest payload, int pageSize) {
            return ListNodeTypesRequest.newBuilder((ListNodeTypesRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListNodeTypesRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(NodeTypeList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<NodeType> extractResources(NodeTypeList payload) {
            return payload.getItemsList() == null ? ImmutableList.of() : payload.getItemsList();
        }
    };
    private static final PagedListResponseFactory<AggregatedListNodeTypesRequest, NodeTypeAggregatedList, NodeTypesClient.AggregatedListPagedResponse> AGGREGATED_LIST_PAGE_STR_FACT = new PagedListResponseFactory<AggregatedListNodeTypesRequest, NodeTypeAggregatedList, NodeTypesClient.AggregatedListPagedResponse>(){

        public ApiFuture<NodeTypesClient.AggregatedListPagedResponse> getFuturePagedResponse(UnaryCallable<AggregatedListNodeTypesRequest, NodeTypeAggregatedList> callable, AggregatedListNodeTypesRequest request, ApiCallContext context, ApiFuture<NodeTypeAggregatedList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)AGGREGATED_LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return NodeTypesClient.AggregatedListPagedResponse.createAsync((PageContext<AggregatedListNodeTypesRequest, NodeTypeAggregatedList, Map.Entry<String, NodeTypesScopedList>>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListNodeTypesRequest, NodeTypeList, NodeTypesClient.ListPagedResponse> LIST_PAGE_STR_FACT = new PagedListResponseFactory<ListNodeTypesRequest, NodeTypeList, NodeTypesClient.ListPagedResponse>(){

        public ApiFuture<NodeTypesClient.ListPagedResponse> getFuturePagedResponse(UnaryCallable<ListNodeTypesRequest, NodeTypeList> callable, ListNodeTypesRequest request, ApiCallContext context, ApiFuture<NodeTypeList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return NodeTypesClient.ListPagedResponse.createAsync((PageContext<ListNodeTypesRequest, NodeTypeList, NodeType>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<AggregatedListNodeTypesRequest, NodeTypeAggregatedList, NodeTypesClient.AggregatedListPagedResponse> aggregatedListSettings() {
        return this.aggregatedListSettings;
    }

    public UnaryCallSettings<GetNodeTypeRequest, NodeType> getSettings() {
        return this.getSettings;
    }

    public PagedCallSettings<ListNodeTypesRequest, NodeTypeList, NodeTypesClient.ListPagedResponse> listSettings() {
        return this.listSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public NodeTypesStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonNodeTypesStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "compute.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "compute.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return NodeTypesStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(NodeTypesStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected NodeTypesStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.aggregatedListSettings = settingsBuilder.aggregatedListSettings().build();
        this.getSettings = settingsBuilder.getSettings().build();
        this.listSettings = settingsBuilder.listSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<NodeTypesStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<AggregatedListNodeTypesRequest, NodeTypeAggregatedList, NodeTypesClient.AggregatedListPagedResponse> aggregatedListSettings;
        private final UnaryCallSettings.Builder<GetNodeTypeRequest, NodeType> getSettings;
        private final PagedCallSettings.Builder<ListNodeTypesRequest, NodeTypeList, NodeTypesClient.ListPagedResponse> listSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.aggregatedListSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)AGGREGATED_LIST_PAGE_STR_FACT);
            this.getSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListSettings, this.getSettings, this.listSettings);
            Builder.initDefaults(this);
        }

        protected Builder(NodeTypesStubSettings settings) {
            super((StubSettings)settings);
            this.aggregatedListSettings = settings.aggregatedListSettings.toBuilder();
            this.getSettings = settings.getSettings.toBuilder();
            this.listSettings = settings.listSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListSettings, this.getSettings, this.listSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(NodeTypesStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)NodeTypesStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)NodeTypesStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(NodeTypesStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(NodeTypesStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.aggregatedListSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<AggregatedListNodeTypesRequest, NodeTypeAggregatedList, NodeTypesClient.AggregatedListPagedResponse> aggregatedListSettings() {
            return this.aggregatedListSettings;
        }

        public UnaryCallSettings.Builder<GetNodeTypeRequest, NodeType> getSettings() {
            return this.getSettings;
        }

        public PagedCallSettings.Builder<ListNodeTypesRequest, NodeTypeList, NodeTypesClient.ListPagedResponse> listSettings() {
            return this.listSettings;
        }

        public NodeTypesStubSettings build() throws IOException {
            return new NodeTypesStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

