/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListNetworkEndpointGroupsRequest;
import com.google.cloud.compute.v1.AttachNetworkEndpointsNetworkEndpointGroupRequest;
import com.google.cloud.compute.v1.DeleteNetworkEndpointGroupRequest;
import com.google.cloud.compute.v1.DetachNetworkEndpointsNetworkEndpointGroupRequest;
import com.google.cloud.compute.v1.GetNetworkEndpointGroupRequest;
import com.google.cloud.compute.v1.InsertNetworkEndpointGroupRequest;
import com.google.cloud.compute.v1.ListNetworkEndpointGroupsRequest;
import com.google.cloud.compute.v1.ListNetworkEndpointsNetworkEndpointGroupsRequest;
import com.google.cloud.compute.v1.NetworkEndpointGroup;
import com.google.cloud.compute.v1.NetworkEndpointGroupAggregatedList;
import com.google.cloud.compute.v1.NetworkEndpointGroupList;
import com.google.cloud.compute.v1.NetworkEndpointGroupsClient;
import com.google.cloud.compute.v1.NetworkEndpointGroupsListNetworkEndpoints;
import com.google.cloud.compute.v1.NetworkEndpointGroupsScopedList;
import com.google.cloud.compute.v1.NetworkEndpointWithHealthStatus;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.TestIamPermissionsNetworkEndpointGroupRequest;
import com.google.cloud.compute.v1.TestPermissionsResponse;
import com.google.cloud.compute.v1.stub.HttpJsonNetworkEndpointGroupsStub;
import com.google.cloud.compute.v1.stub.NetworkEndpointGroupsStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.threeten.bp.Duration;

public class NetworkEndpointGroupsStubSettings
extends StubSettings<NetworkEndpointGroupsStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<AggregatedListNetworkEndpointGroupsRequest, NetworkEndpointGroupAggregatedList, NetworkEndpointGroupsClient.AggregatedListPagedResponse> aggregatedListSettings;
    private final UnaryCallSettings<AttachNetworkEndpointsNetworkEndpointGroupRequest, Operation> attachNetworkEndpointsSettings;
    private final UnaryCallSettings<DeleteNetworkEndpointGroupRequest, Operation> deleteSettings;
    private final UnaryCallSettings<DetachNetworkEndpointsNetworkEndpointGroupRequest, Operation> detachNetworkEndpointsSettings;
    private final UnaryCallSettings<GetNetworkEndpointGroupRequest, NetworkEndpointGroup> getSettings;
    private final UnaryCallSettings<InsertNetworkEndpointGroupRequest, Operation> insertSettings;
    private final PagedCallSettings<ListNetworkEndpointGroupsRequest, NetworkEndpointGroupList, NetworkEndpointGroupsClient.ListPagedResponse> listSettings;
    private final PagedCallSettings<ListNetworkEndpointsNetworkEndpointGroupsRequest, NetworkEndpointGroupsListNetworkEndpoints, NetworkEndpointGroupsClient.ListNetworkEndpointsPagedResponse> listNetworkEndpointsSettings;
    private final UnaryCallSettings<TestIamPermissionsNetworkEndpointGroupRequest, TestPermissionsResponse> testIamPermissionsSettings;
    private static final PagedListDescriptor<AggregatedListNetworkEndpointGroupsRequest, NetworkEndpointGroupAggregatedList, Map.Entry<String, NetworkEndpointGroupsScopedList>> AGGREGATED_LIST_PAGE_STR_DESC = new PagedListDescriptor<AggregatedListNetworkEndpointGroupsRequest, NetworkEndpointGroupAggregatedList, Map.Entry<String, NetworkEndpointGroupsScopedList>>(){

        public String emptyToken() {
            return "";
        }

        public AggregatedListNetworkEndpointGroupsRequest injectToken(AggregatedListNetworkEndpointGroupsRequest payload, String token) {
            return AggregatedListNetworkEndpointGroupsRequest.newBuilder((AggregatedListNetworkEndpointGroupsRequest)payload).setPageToken(token).build();
        }

        public AggregatedListNetworkEndpointGroupsRequest injectPageSize(AggregatedListNetworkEndpointGroupsRequest payload, int pageSize) {
            return AggregatedListNetworkEndpointGroupsRequest.newBuilder((AggregatedListNetworkEndpointGroupsRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(AggregatedListNetworkEndpointGroupsRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(NetworkEndpointGroupAggregatedList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Map.Entry<String, NetworkEndpointGroupsScopedList>> extractResources(NetworkEndpointGroupAggregatedList payload) {
            return payload.getItemsMap() == null ? Collections.emptySet() : payload.getItemsMap().entrySet();
        }
    };
    private static final PagedListDescriptor<ListNetworkEndpointGroupsRequest, NetworkEndpointGroupList, NetworkEndpointGroup> LIST_PAGE_STR_DESC = new PagedListDescriptor<ListNetworkEndpointGroupsRequest, NetworkEndpointGroupList, NetworkEndpointGroup>(){

        public String emptyToken() {
            return "";
        }

        public ListNetworkEndpointGroupsRequest injectToken(ListNetworkEndpointGroupsRequest payload, String token) {
            return ListNetworkEndpointGroupsRequest.newBuilder((ListNetworkEndpointGroupsRequest)payload).setPageToken(token).build();
        }

        public ListNetworkEndpointGroupsRequest injectPageSize(ListNetworkEndpointGroupsRequest payload, int pageSize) {
            return ListNetworkEndpointGroupsRequest.newBuilder((ListNetworkEndpointGroupsRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListNetworkEndpointGroupsRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(NetworkEndpointGroupList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<NetworkEndpointGroup> extractResources(NetworkEndpointGroupList payload) {
            return payload.getItemsList() == null ? ImmutableList.of() : payload.getItemsList();
        }
    };
    private static final PagedListDescriptor<ListNetworkEndpointsNetworkEndpointGroupsRequest, NetworkEndpointGroupsListNetworkEndpoints, NetworkEndpointWithHealthStatus> LIST_NETWORK_ENDPOINTS_PAGE_STR_DESC = new PagedListDescriptor<ListNetworkEndpointsNetworkEndpointGroupsRequest, NetworkEndpointGroupsListNetworkEndpoints, NetworkEndpointWithHealthStatus>(){

        public String emptyToken() {
            return "";
        }

        public ListNetworkEndpointsNetworkEndpointGroupsRequest injectToken(ListNetworkEndpointsNetworkEndpointGroupsRequest payload, String token) {
            return ListNetworkEndpointsNetworkEndpointGroupsRequest.newBuilder((ListNetworkEndpointsNetworkEndpointGroupsRequest)payload).setPageToken(token).build();
        }

        public ListNetworkEndpointsNetworkEndpointGroupsRequest injectPageSize(ListNetworkEndpointsNetworkEndpointGroupsRequest payload, int pageSize) {
            return ListNetworkEndpointsNetworkEndpointGroupsRequest.newBuilder((ListNetworkEndpointsNetworkEndpointGroupsRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListNetworkEndpointsNetworkEndpointGroupsRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(NetworkEndpointGroupsListNetworkEndpoints payload) {
            return payload.getNextPageToken();
        }

        public Iterable<NetworkEndpointWithHealthStatus> extractResources(NetworkEndpointGroupsListNetworkEndpoints payload) {
            return payload.getItemsList() == null ? ImmutableList.of() : payload.getItemsList();
        }
    };
    private static final PagedListResponseFactory<AggregatedListNetworkEndpointGroupsRequest, NetworkEndpointGroupAggregatedList, NetworkEndpointGroupsClient.AggregatedListPagedResponse> AGGREGATED_LIST_PAGE_STR_FACT = new PagedListResponseFactory<AggregatedListNetworkEndpointGroupsRequest, NetworkEndpointGroupAggregatedList, NetworkEndpointGroupsClient.AggregatedListPagedResponse>(){

        public ApiFuture<NetworkEndpointGroupsClient.AggregatedListPagedResponse> getFuturePagedResponse(UnaryCallable<AggregatedListNetworkEndpointGroupsRequest, NetworkEndpointGroupAggregatedList> callable, AggregatedListNetworkEndpointGroupsRequest request, ApiCallContext context, ApiFuture<NetworkEndpointGroupAggregatedList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)AGGREGATED_LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return NetworkEndpointGroupsClient.AggregatedListPagedResponse.createAsync((PageContext<AggregatedListNetworkEndpointGroupsRequest, NetworkEndpointGroupAggregatedList, Map.Entry<String, NetworkEndpointGroupsScopedList>>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListNetworkEndpointGroupsRequest, NetworkEndpointGroupList, NetworkEndpointGroupsClient.ListPagedResponse> LIST_PAGE_STR_FACT = new PagedListResponseFactory<ListNetworkEndpointGroupsRequest, NetworkEndpointGroupList, NetworkEndpointGroupsClient.ListPagedResponse>(){

        public ApiFuture<NetworkEndpointGroupsClient.ListPagedResponse> getFuturePagedResponse(UnaryCallable<ListNetworkEndpointGroupsRequest, NetworkEndpointGroupList> callable, ListNetworkEndpointGroupsRequest request, ApiCallContext context, ApiFuture<NetworkEndpointGroupList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return NetworkEndpointGroupsClient.ListPagedResponse.createAsync((PageContext<ListNetworkEndpointGroupsRequest, NetworkEndpointGroupList, NetworkEndpointGroup>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListNetworkEndpointsNetworkEndpointGroupsRequest, NetworkEndpointGroupsListNetworkEndpoints, NetworkEndpointGroupsClient.ListNetworkEndpointsPagedResponse> LIST_NETWORK_ENDPOINTS_PAGE_STR_FACT = new PagedListResponseFactory<ListNetworkEndpointsNetworkEndpointGroupsRequest, NetworkEndpointGroupsListNetworkEndpoints, NetworkEndpointGroupsClient.ListNetworkEndpointsPagedResponse>(){

        public ApiFuture<NetworkEndpointGroupsClient.ListNetworkEndpointsPagedResponse> getFuturePagedResponse(UnaryCallable<ListNetworkEndpointsNetworkEndpointGroupsRequest, NetworkEndpointGroupsListNetworkEndpoints> callable, ListNetworkEndpointsNetworkEndpointGroupsRequest request, ApiCallContext context, ApiFuture<NetworkEndpointGroupsListNetworkEndpoints> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_NETWORK_ENDPOINTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return NetworkEndpointGroupsClient.ListNetworkEndpointsPagedResponse.createAsync((PageContext<ListNetworkEndpointsNetworkEndpointGroupsRequest, NetworkEndpointGroupsListNetworkEndpoints, NetworkEndpointWithHealthStatus>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<AggregatedListNetworkEndpointGroupsRequest, NetworkEndpointGroupAggregatedList, NetworkEndpointGroupsClient.AggregatedListPagedResponse> aggregatedListSettings() {
        return this.aggregatedListSettings;
    }

    public UnaryCallSettings<AttachNetworkEndpointsNetworkEndpointGroupRequest, Operation> attachNetworkEndpointsSettings() {
        return this.attachNetworkEndpointsSettings;
    }

    public UnaryCallSettings<DeleteNetworkEndpointGroupRequest, Operation> deleteSettings() {
        return this.deleteSettings;
    }

    public UnaryCallSettings<DetachNetworkEndpointsNetworkEndpointGroupRequest, Operation> detachNetworkEndpointsSettings() {
        return this.detachNetworkEndpointsSettings;
    }

    public UnaryCallSettings<GetNetworkEndpointGroupRequest, NetworkEndpointGroup> getSettings() {
        return this.getSettings;
    }

    public UnaryCallSettings<InsertNetworkEndpointGroupRequest, Operation> insertSettings() {
        return this.insertSettings;
    }

    public PagedCallSettings<ListNetworkEndpointGroupsRequest, NetworkEndpointGroupList, NetworkEndpointGroupsClient.ListPagedResponse> listSettings() {
        return this.listSettings;
    }

    public PagedCallSettings<ListNetworkEndpointsNetworkEndpointGroupsRequest, NetworkEndpointGroupsListNetworkEndpoints, NetworkEndpointGroupsClient.ListNetworkEndpointsPagedResponse> listNetworkEndpointsSettings() {
        return this.listNetworkEndpointsSettings;
    }

    public UnaryCallSettings<TestIamPermissionsNetworkEndpointGroupRequest, TestPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public NetworkEndpointGroupsStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonNetworkEndpointGroupsStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "compute.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "compute.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return NetworkEndpointGroupsStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(NetworkEndpointGroupsStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected NetworkEndpointGroupsStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.aggregatedListSettings = settingsBuilder.aggregatedListSettings().build();
        this.attachNetworkEndpointsSettings = settingsBuilder.attachNetworkEndpointsSettings().build();
        this.deleteSettings = settingsBuilder.deleteSettings().build();
        this.detachNetworkEndpointsSettings = settingsBuilder.detachNetworkEndpointsSettings().build();
        this.getSettings = settingsBuilder.getSettings().build();
        this.insertSettings = settingsBuilder.insertSettings().build();
        this.listSettings = settingsBuilder.listSettings().build();
        this.listNetworkEndpointsSettings = settingsBuilder.listNetworkEndpointsSettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<NetworkEndpointGroupsStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<AggregatedListNetworkEndpointGroupsRequest, NetworkEndpointGroupAggregatedList, NetworkEndpointGroupsClient.AggregatedListPagedResponse> aggregatedListSettings;
        private final UnaryCallSettings.Builder<AttachNetworkEndpointsNetworkEndpointGroupRequest, Operation> attachNetworkEndpointsSettings;
        private final UnaryCallSettings.Builder<DeleteNetworkEndpointGroupRequest, Operation> deleteSettings;
        private final UnaryCallSettings.Builder<DetachNetworkEndpointsNetworkEndpointGroupRequest, Operation> detachNetworkEndpointsSettings;
        private final UnaryCallSettings.Builder<GetNetworkEndpointGroupRequest, NetworkEndpointGroup> getSettings;
        private final UnaryCallSettings.Builder<InsertNetworkEndpointGroupRequest, Operation> insertSettings;
        private final PagedCallSettings.Builder<ListNetworkEndpointGroupsRequest, NetworkEndpointGroupList, NetworkEndpointGroupsClient.ListPagedResponse> listSettings;
        private final PagedCallSettings.Builder<ListNetworkEndpointsNetworkEndpointGroupsRequest, NetworkEndpointGroupsListNetworkEndpoints, NetworkEndpointGroupsClient.ListNetworkEndpointsPagedResponse> listNetworkEndpointsSettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsNetworkEndpointGroupRequest, TestPermissionsResponse> testIamPermissionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.aggregatedListSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)AGGREGATED_LIST_PAGE_STR_FACT);
            this.attachNetworkEndpointsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.detachNetworkEndpointsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PAGE_STR_FACT);
            this.listNetworkEndpointsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_NETWORK_ENDPOINTS_PAGE_STR_FACT);
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListSettings, this.attachNetworkEndpointsSettings, this.deleteSettings, this.detachNetworkEndpointsSettings, this.getSettings, this.insertSettings, this.listSettings, this.listNetworkEndpointsSettings, this.testIamPermissionsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(NetworkEndpointGroupsStubSettings settings) {
            super((StubSettings)settings);
            this.aggregatedListSettings = settings.aggregatedListSettings.toBuilder();
            this.attachNetworkEndpointsSettings = settings.attachNetworkEndpointsSettings.toBuilder();
            this.deleteSettings = settings.deleteSettings.toBuilder();
            this.detachNetworkEndpointsSettings = settings.detachNetworkEndpointsSettings.toBuilder();
            this.getSettings = settings.getSettings.toBuilder();
            this.insertSettings = settings.insertSettings.toBuilder();
            this.listSettings = settings.listSettings.toBuilder();
            this.listNetworkEndpointsSettings = settings.listNetworkEndpointsSettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListSettings, this.attachNetworkEndpointsSettings, this.deleteSettings, this.detachNetworkEndpointsSettings, this.getSettings, this.insertSettings, this.listSettings, this.listNetworkEndpointsSettings, this.testIamPermissionsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(NetworkEndpointGroupsStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)NetworkEndpointGroupsStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)NetworkEndpointGroupsStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(NetworkEndpointGroupsStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(NetworkEndpointGroupsStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.aggregatedListSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.attachNetworkEndpointsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.detachNetworkEndpointsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.insertSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listNetworkEndpointsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<AggregatedListNetworkEndpointGroupsRequest, NetworkEndpointGroupAggregatedList, NetworkEndpointGroupsClient.AggregatedListPagedResponse> aggregatedListSettings() {
            return this.aggregatedListSettings;
        }

        public UnaryCallSettings.Builder<AttachNetworkEndpointsNetworkEndpointGroupRequest, Operation> attachNetworkEndpointsSettings() {
            return this.attachNetworkEndpointsSettings;
        }

        public UnaryCallSettings.Builder<DeleteNetworkEndpointGroupRequest, Operation> deleteSettings() {
            return this.deleteSettings;
        }

        public UnaryCallSettings.Builder<DetachNetworkEndpointsNetworkEndpointGroupRequest, Operation> detachNetworkEndpointsSettings() {
            return this.detachNetworkEndpointsSettings;
        }

        public UnaryCallSettings.Builder<GetNetworkEndpointGroupRequest, NetworkEndpointGroup> getSettings() {
            return this.getSettings;
        }

        public UnaryCallSettings.Builder<InsertNetworkEndpointGroupRequest, Operation> insertSettings() {
            return this.insertSettings;
        }

        public PagedCallSettings.Builder<ListNetworkEndpointGroupsRequest, NetworkEndpointGroupList, NetworkEndpointGroupsClient.ListPagedResponse> listSettings() {
            return this.listSettings;
        }

        public PagedCallSettings.Builder<ListNetworkEndpointsNetworkEndpointGroupsRequest, NetworkEndpointGroupsListNetworkEndpoints, NetworkEndpointGroupsClient.ListNetworkEndpointsPagedResponse> listNetworkEndpointsSettings() {
            return this.listNetworkEndpointsSettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsNetworkEndpointGroupRequest, TestPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public NetworkEndpointGroupsStubSettings build() throws IOException {
            return new NetworkEndpointGroupsStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

