/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteTargetSslProxyRequest;
import com.google.cloud.compute.v1.GetTargetSslProxyRequest;
import com.google.cloud.compute.v1.InsertTargetSslProxyRequest;
import com.google.cloud.compute.v1.ListTargetSslProxiesRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.SetBackendServiceTargetSslProxyRequest;
import com.google.cloud.compute.v1.SetProxyHeaderTargetSslProxyRequest;
import com.google.cloud.compute.v1.SetSslCertificatesTargetSslProxyRequest;
import com.google.cloud.compute.v1.SetSslPolicyTargetSslProxyRequest;
import com.google.cloud.compute.v1.SslPolicyReference;
import com.google.cloud.compute.v1.TargetSslProxiesSetBackendServiceRequest;
import com.google.cloud.compute.v1.TargetSslProxiesSetProxyHeaderRequest;
import com.google.cloud.compute.v1.TargetSslProxiesSetSslCertificatesRequest;
import com.google.cloud.compute.v1.TargetSslProxiesSettings;
import com.google.cloud.compute.v1.TargetSslProxy;
import com.google.cloud.compute.v1.TargetSslProxyList;
import com.google.cloud.compute.v1.stub.TargetSslProxiesStub;
import com.google.cloud.compute.v1.stub.TargetSslProxiesStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class TargetSslProxiesClient
implements BackgroundResource {
    private final TargetSslProxiesSettings settings;
    private final TargetSslProxiesStub stub;

    public static final TargetSslProxiesClient create() throws IOException {
        return TargetSslProxiesClient.create(TargetSslProxiesSettings.newBuilder().build());
    }

    public static final TargetSslProxiesClient create(TargetSslProxiesSettings settings) throws IOException {
        return new TargetSslProxiesClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final TargetSslProxiesClient create(TargetSslProxiesStub stub) {
        return new TargetSslProxiesClient(stub);
    }

    protected TargetSslProxiesClient(TargetSslProxiesSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((TargetSslProxiesStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected TargetSslProxiesClient(TargetSslProxiesStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final TargetSslProxiesSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public TargetSslProxiesStub getStub() {
        return this.stub;
    }

    public final Operation delete(String project, String targetSslProxy) {
        DeleteTargetSslProxyRequest request = DeleteTargetSslProxyRequest.newBuilder().setProject(project).setTargetSslProxy(targetSslProxy).build();
        return this.delete(request);
    }

    public final Operation delete(DeleteTargetSslProxyRequest request) {
        return (Operation)this.deleteCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteTargetSslProxyRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final TargetSslProxy get(String project, String targetSslProxy) {
        GetTargetSslProxyRequest request = GetTargetSslProxyRequest.newBuilder().setProject(project).setTargetSslProxy(targetSslProxy).build();
        return this.get(request);
    }

    public final TargetSslProxy get(GetTargetSslProxyRequest request) {
        return (TargetSslProxy)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetTargetSslProxyRequest, TargetSslProxy> getCallable() {
        return this.stub.getCallable();
    }

    public final Operation insert(String project, TargetSslProxy targetSslProxyResource) {
        InsertTargetSslProxyRequest request = InsertTargetSslProxyRequest.newBuilder().setProject(project).setTargetSslProxyResource(targetSslProxyResource).build();
        return this.insert(request);
    }

    public final Operation insert(InsertTargetSslProxyRequest request) {
        return (Operation)this.insertCallable().call((Object)request);
    }

    public final UnaryCallable<InsertTargetSslProxyRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list(String project) {
        ListTargetSslProxiesRequest request = ListTargetSslProxiesRequest.newBuilder().setProject(project).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListTargetSslProxiesRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListTargetSslProxiesRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListTargetSslProxiesRequest, TargetSslProxyList> listCallable() {
        return this.stub.listCallable();
    }

    public final Operation setBackendService(String project, String targetSslProxy, TargetSslProxiesSetBackendServiceRequest targetSslProxiesSetBackendServiceRequestResource) {
        SetBackendServiceTargetSslProxyRequest request = SetBackendServiceTargetSslProxyRequest.newBuilder().setProject(project).setTargetSslProxy(targetSslProxy).setTargetSslProxiesSetBackendServiceRequestResource(targetSslProxiesSetBackendServiceRequestResource).build();
        return this.setBackendService(request);
    }

    public final Operation setBackendService(SetBackendServiceTargetSslProxyRequest request) {
        return (Operation)this.setBackendServiceCallable().call((Object)request);
    }

    public final UnaryCallable<SetBackendServiceTargetSslProxyRequest, Operation> setBackendServiceCallable() {
        return this.stub.setBackendServiceCallable();
    }

    public final Operation setProxyHeader(String project, String targetSslProxy, TargetSslProxiesSetProxyHeaderRequest targetSslProxiesSetProxyHeaderRequestResource) {
        SetProxyHeaderTargetSslProxyRequest request = SetProxyHeaderTargetSslProxyRequest.newBuilder().setProject(project).setTargetSslProxy(targetSslProxy).setTargetSslProxiesSetProxyHeaderRequestResource(targetSslProxiesSetProxyHeaderRequestResource).build();
        return this.setProxyHeader(request);
    }

    public final Operation setProxyHeader(SetProxyHeaderTargetSslProxyRequest request) {
        return (Operation)this.setProxyHeaderCallable().call((Object)request);
    }

    public final UnaryCallable<SetProxyHeaderTargetSslProxyRequest, Operation> setProxyHeaderCallable() {
        return this.stub.setProxyHeaderCallable();
    }

    public final Operation setSslCertificates(String project, String targetSslProxy, TargetSslProxiesSetSslCertificatesRequest targetSslProxiesSetSslCertificatesRequestResource) {
        SetSslCertificatesTargetSslProxyRequest request = SetSslCertificatesTargetSslProxyRequest.newBuilder().setProject(project).setTargetSslProxy(targetSslProxy).setTargetSslProxiesSetSslCertificatesRequestResource(targetSslProxiesSetSslCertificatesRequestResource).build();
        return this.setSslCertificates(request);
    }

    public final Operation setSslCertificates(SetSslCertificatesTargetSslProxyRequest request) {
        return (Operation)this.setSslCertificatesCallable().call((Object)request);
    }

    public final UnaryCallable<SetSslCertificatesTargetSslProxyRequest, Operation> setSslCertificatesCallable() {
        return this.stub.setSslCertificatesCallable();
    }

    public final Operation setSslPolicy(String project, String targetSslProxy, SslPolicyReference sslPolicyReferenceResource) {
        SetSslPolicyTargetSslProxyRequest request = SetSslPolicyTargetSslProxyRequest.newBuilder().setProject(project).setTargetSslProxy(targetSslProxy).setSslPolicyReferenceResource(sslPolicyReferenceResource).build();
        return this.setSslPolicy(request);
    }

    public final Operation setSslPolicy(SetSslPolicyTargetSslProxyRequest request) {
        return (Operation)this.setSslPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetSslPolicyTargetSslProxyRequest, Operation> setSslPolicyCallable() {
        return this.stub.setSslPolicyCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListTargetSslProxiesRequest, TargetSslProxyList, TargetSslProxy, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListTargetSslProxiesRequest, TargetSslProxyList, TargetSslProxy, ListPage> {
        private ListPage(PageContext<ListTargetSslProxiesRequest, TargetSslProxyList, TargetSslProxy> context, TargetSslProxyList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListTargetSslProxiesRequest, TargetSslProxyList, TargetSslProxy> context, TargetSslProxyList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListTargetSslProxiesRequest, TargetSslProxyList, TargetSslProxy> context, ApiFuture<TargetSslProxyList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListTargetSslProxiesRequest, TargetSslProxyList, TargetSslProxy, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListTargetSslProxiesRequest, TargetSslProxyList, TargetSslProxy> context, ApiFuture<TargetSslProxyList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPagedResponse((ListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }
}

