/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AbandonInstancesInstanceGroupManagerRequest;
import com.google.cloud.compute.v1.AggregatedListInstanceGroupManagersRequest;
import com.google.cloud.compute.v1.ApplyUpdatesToInstancesInstanceGroupManagerRequest;
import com.google.cloud.compute.v1.CreateInstancesInstanceGroupManagerRequest;
import com.google.cloud.compute.v1.DeleteInstanceGroupManagerRequest;
import com.google.cloud.compute.v1.DeleteInstancesInstanceGroupManagerRequest;
import com.google.cloud.compute.v1.DeletePerInstanceConfigsInstanceGroupManagerRequest;
import com.google.cloud.compute.v1.GetInstanceGroupManagerRequest;
import com.google.cloud.compute.v1.InsertInstanceGroupManagerRequest;
import com.google.cloud.compute.v1.InstanceGroupManager;
import com.google.cloud.compute.v1.InstanceGroupManagerAggregatedList;
import com.google.cloud.compute.v1.InstanceGroupManagerList;
import com.google.cloud.compute.v1.InstanceGroupManagersAbandonInstancesRequest;
import com.google.cloud.compute.v1.InstanceGroupManagersApplyUpdatesRequest;
import com.google.cloud.compute.v1.InstanceGroupManagersCreateInstancesRequest;
import com.google.cloud.compute.v1.InstanceGroupManagersDeleteInstancesRequest;
import com.google.cloud.compute.v1.InstanceGroupManagersDeletePerInstanceConfigsReq;
import com.google.cloud.compute.v1.InstanceGroupManagersListErrorsResponse;
import com.google.cloud.compute.v1.InstanceGroupManagersListManagedInstancesResponse;
import com.google.cloud.compute.v1.InstanceGroupManagersListPerInstanceConfigsResp;
import com.google.cloud.compute.v1.InstanceGroupManagersPatchPerInstanceConfigsReq;
import com.google.cloud.compute.v1.InstanceGroupManagersRecreateInstancesRequest;
import com.google.cloud.compute.v1.InstanceGroupManagersScopedList;
import com.google.cloud.compute.v1.InstanceGroupManagersSetInstanceTemplateRequest;
import com.google.cloud.compute.v1.InstanceGroupManagersSetTargetPoolsRequest;
import com.google.cloud.compute.v1.InstanceGroupManagersSettings;
import com.google.cloud.compute.v1.InstanceGroupManagersUpdatePerInstanceConfigsReq;
import com.google.cloud.compute.v1.InstanceManagedByIgmError;
import com.google.cloud.compute.v1.ListErrorsInstanceGroupManagersRequest;
import com.google.cloud.compute.v1.ListInstanceGroupManagersRequest;
import com.google.cloud.compute.v1.ListManagedInstancesInstanceGroupManagersRequest;
import com.google.cloud.compute.v1.ListPerInstanceConfigsInstanceGroupManagersRequest;
import com.google.cloud.compute.v1.ManagedInstance;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchInstanceGroupManagerRequest;
import com.google.cloud.compute.v1.PatchPerInstanceConfigsInstanceGroupManagerRequest;
import com.google.cloud.compute.v1.PerInstanceConfig;
import com.google.cloud.compute.v1.RecreateInstancesInstanceGroupManagerRequest;
import com.google.cloud.compute.v1.ResizeInstanceGroupManagerRequest;
import com.google.cloud.compute.v1.SetInstanceTemplateInstanceGroupManagerRequest;
import com.google.cloud.compute.v1.SetTargetPoolsInstanceGroupManagerRequest;
import com.google.cloud.compute.v1.UpdatePerInstanceConfigsInstanceGroupManagerRequest;
import com.google.cloud.compute.v1.stub.InstanceGroupManagersStub;
import com.google.cloud.compute.v1.stub.InstanceGroupManagersStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class InstanceGroupManagersClient
implements BackgroundResource {
    private final InstanceGroupManagersSettings settings;
    private final InstanceGroupManagersStub stub;

    public static final InstanceGroupManagersClient create() throws IOException {
        return InstanceGroupManagersClient.create(InstanceGroupManagersSettings.newBuilder().build());
    }

    public static final InstanceGroupManagersClient create(InstanceGroupManagersSettings settings) throws IOException {
        return new InstanceGroupManagersClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final InstanceGroupManagersClient create(InstanceGroupManagersStub stub) {
        return new InstanceGroupManagersClient(stub);
    }

    protected InstanceGroupManagersClient(InstanceGroupManagersSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((InstanceGroupManagersStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected InstanceGroupManagersClient(InstanceGroupManagersStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final InstanceGroupManagersSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public InstanceGroupManagersStub getStub() {
        return this.stub;
    }

    public final Operation abandonInstances(String project, String zone, String instanceGroupManager, InstanceGroupManagersAbandonInstancesRequest instanceGroupManagersAbandonInstancesRequestResource) {
        AbandonInstancesInstanceGroupManagerRequest request = AbandonInstancesInstanceGroupManagerRequest.newBuilder().setProject(project).setZone(zone).setInstanceGroupManager(instanceGroupManager).setInstanceGroupManagersAbandonInstancesRequestResource(instanceGroupManagersAbandonInstancesRequestResource).build();
        return this.abandonInstances(request);
    }

    public final Operation abandonInstances(AbandonInstancesInstanceGroupManagerRequest request) {
        return (Operation)this.abandonInstancesCallable().call((Object)request);
    }

    public final UnaryCallable<AbandonInstancesInstanceGroupManagerRequest, Operation> abandonInstancesCallable() {
        return this.stub.abandonInstancesCallable();
    }

    public final AggregatedListPagedResponse aggregatedList(String project) {
        AggregatedListInstanceGroupManagersRequest request = AggregatedListInstanceGroupManagersRequest.newBuilder().setProject(project).build();
        return this.aggregatedList(request);
    }

    public final AggregatedListPagedResponse aggregatedList(AggregatedListInstanceGroupManagersRequest request) {
        return (AggregatedListPagedResponse)((Object)this.aggregatedListPagedCallable().call((Object)request));
    }

    public final UnaryCallable<AggregatedListInstanceGroupManagersRequest, AggregatedListPagedResponse> aggregatedListPagedCallable() {
        return this.stub.aggregatedListPagedCallable();
    }

    public final UnaryCallable<AggregatedListInstanceGroupManagersRequest, InstanceGroupManagerAggregatedList> aggregatedListCallable() {
        return this.stub.aggregatedListCallable();
    }

    public final Operation applyUpdatesToInstances(String project, String zone, String instanceGroupManager, InstanceGroupManagersApplyUpdatesRequest instanceGroupManagersApplyUpdatesRequestResource) {
        ApplyUpdatesToInstancesInstanceGroupManagerRequest request = ApplyUpdatesToInstancesInstanceGroupManagerRequest.newBuilder().setProject(project).setZone(zone).setInstanceGroupManager(instanceGroupManager).setInstanceGroupManagersApplyUpdatesRequestResource(instanceGroupManagersApplyUpdatesRequestResource).build();
        return this.applyUpdatesToInstances(request);
    }

    public final Operation applyUpdatesToInstances(ApplyUpdatesToInstancesInstanceGroupManagerRequest request) {
        return (Operation)this.applyUpdatesToInstancesCallable().call((Object)request);
    }

    public final UnaryCallable<ApplyUpdatesToInstancesInstanceGroupManagerRequest, Operation> applyUpdatesToInstancesCallable() {
        return this.stub.applyUpdatesToInstancesCallable();
    }

    public final Operation createInstances(String project, String zone, String instanceGroupManager, InstanceGroupManagersCreateInstancesRequest instanceGroupManagersCreateInstancesRequestResource) {
        CreateInstancesInstanceGroupManagerRequest request = CreateInstancesInstanceGroupManagerRequest.newBuilder().setProject(project).setZone(zone).setInstanceGroupManager(instanceGroupManager).setInstanceGroupManagersCreateInstancesRequestResource(instanceGroupManagersCreateInstancesRequestResource).build();
        return this.createInstances(request);
    }

    public final Operation createInstances(CreateInstancesInstanceGroupManagerRequest request) {
        return (Operation)this.createInstancesCallable().call((Object)request);
    }

    public final UnaryCallable<CreateInstancesInstanceGroupManagerRequest, Operation> createInstancesCallable() {
        return this.stub.createInstancesCallable();
    }

    public final Operation delete(String project, String zone, String instanceGroupManager) {
        DeleteInstanceGroupManagerRequest request = DeleteInstanceGroupManagerRequest.newBuilder().setProject(project).setZone(zone).setInstanceGroupManager(instanceGroupManager).build();
        return this.delete(request);
    }

    public final Operation delete(DeleteInstanceGroupManagerRequest request) {
        return (Operation)this.deleteCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteInstanceGroupManagerRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final Operation deleteInstances(String project, String zone, String instanceGroupManager, InstanceGroupManagersDeleteInstancesRequest instanceGroupManagersDeleteInstancesRequestResource) {
        DeleteInstancesInstanceGroupManagerRequest request = DeleteInstancesInstanceGroupManagerRequest.newBuilder().setProject(project).setZone(zone).setInstanceGroupManager(instanceGroupManager).setInstanceGroupManagersDeleteInstancesRequestResource(instanceGroupManagersDeleteInstancesRequestResource).build();
        return this.deleteInstances(request);
    }

    public final Operation deleteInstances(DeleteInstancesInstanceGroupManagerRequest request) {
        return (Operation)this.deleteInstancesCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteInstancesInstanceGroupManagerRequest, Operation> deleteInstancesCallable() {
        return this.stub.deleteInstancesCallable();
    }

    public final Operation deletePerInstanceConfigs(String project, String zone, String instanceGroupManager, InstanceGroupManagersDeletePerInstanceConfigsReq instanceGroupManagersDeletePerInstanceConfigsReqResource) {
        DeletePerInstanceConfigsInstanceGroupManagerRequest request = DeletePerInstanceConfigsInstanceGroupManagerRequest.newBuilder().setProject(project).setZone(zone).setInstanceGroupManager(instanceGroupManager).setInstanceGroupManagersDeletePerInstanceConfigsReqResource(instanceGroupManagersDeletePerInstanceConfigsReqResource).build();
        return this.deletePerInstanceConfigs(request);
    }

    public final Operation deletePerInstanceConfigs(DeletePerInstanceConfigsInstanceGroupManagerRequest request) {
        return (Operation)this.deletePerInstanceConfigsCallable().call((Object)request);
    }

    public final UnaryCallable<DeletePerInstanceConfigsInstanceGroupManagerRequest, Operation> deletePerInstanceConfigsCallable() {
        return this.stub.deletePerInstanceConfigsCallable();
    }

    public final InstanceGroupManager get(String project, String zone, String instanceGroupManager) {
        GetInstanceGroupManagerRequest request = GetInstanceGroupManagerRequest.newBuilder().setProject(project).setZone(zone).setInstanceGroupManager(instanceGroupManager).build();
        return this.get(request);
    }

    public final InstanceGroupManager get(GetInstanceGroupManagerRequest request) {
        return (InstanceGroupManager)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetInstanceGroupManagerRequest, InstanceGroupManager> getCallable() {
        return this.stub.getCallable();
    }

    public final Operation insert(String project, String zone, InstanceGroupManager instanceGroupManagerResource) {
        InsertInstanceGroupManagerRequest request = InsertInstanceGroupManagerRequest.newBuilder().setProject(project).setZone(zone).setInstanceGroupManagerResource(instanceGroupManagerResource).build();
        return this.insert(request);
    }

    public final Operation insert(InsertInstanceGroupManagerRequest request) {
        return (Operation)this.insertCallable().call((Object)request);
    }

    public final UnaryCallable<InsertInstanceGroupManagerRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list(String project, String zone) {
        ListInstanceGroupManagersRequest request = ListInstanceGroupManagersRequest.newBuilder().setProject(project).setZone(zone).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListInstanceGroupManagersRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListInstanceGroupManagersRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListInstanceGroupManagersRequest, InstanceGroupManagerList> listCallable() {
        return this.stub.listCallable();
    }

    public final ListErrorsPagedResponse listErrors(String project, String zone, String instanceGroupManager) {
        ListErrorsInstanceGroupManagersRequest request = ListErrorsInstanceGroupManagersRequest.newBuilder().setProject(project).setZone(zone).setInstanceGroupManager(instanceGroupManager).build();
        return this.listErrors(request);
    }

    public final ListErrorsPagedResponse listErrors(ListErrorsInstanceGroupManagersRequest request) {
        return (ListErrorsPagedResponse)((Object)this.listErrorsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListErrorsInstanceGroupManagersRequest, ListErrorsPagedResponse> listErrorsPagedCallable() {
        return this.stub.listErrorsPagedCallable();
    }

    public final UnaryCallable<ListErrorsInstanceGroupManagersRequest, InstanceGroupManagersListErrorsResponse> listErrorsCallable() {
        return this.stub.listErrorsCallable();
    }

    public final ListManagedInstancesPagedResponse listManagedInstances(String project, String zone, String instanceGroupManager) {
        ListManagedInstancesInstanceGroupManagersRequest request = ListManagedInstancesInstanceGroupManagersRequest.newBuilder().setProject(project).setZone(zone).setInstanceGroupManager(instanceGroupManager).build();
        return this.listManagedInstances(request);
    }

    public final ListManagedInstancesPagedResponse listManagedInstances(ListManagedInstancesInstanceGroupManagersRequest request) {
        return (ListManagedInstancesPagedResponse)((Object)this.listManagedInstancesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListManagedInstancesInstanceGroupManagersRequest, ListManagedInstancesPagedResponse> listManagedInstancesPagedCallable() {
        return this.stub.listManagedInstancesPagedCallable();
    }

    public final UnaryCallable<ListManagedInstancesInstanceGroupManagersRequest, InstanceGroupManagersListManagedInstancesResponse> listManagedInstancesCallable() {
        return this.stub.listManagedInstancesCallable();
    }

    public final ListPerInstanceConfigsPagedResponse listPerInstanceConfigs(String project, String zone, String instanceGroupManager) {
        ListPerInstanceConfigsInstanceGroupManagersRequest request = ListPerInstanceConfigsInstanceGroupManagersRequest.newBuilder().setProject(project).setZone(zone).setInstanceGroupManager(instanceGroupManager).build();
        return this.listPerInstanceConfigs(request);
    }

    public final ListPerInstanceConfigsPagedResponse listPerInstanceConfigs(ListPerInstanceConfigsInstanceGroupManagersRequest request) {
        return (ListPerInstanceConfigsPagedResponse)((Object)this.listPerInstanceConfigsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListPerInstanceConfigsInstanceGroupManagersRequest, ListPerInstanceConfigsPagedResponse> listPerInstanceConfigsPagedCallable() {
        return this.stub.listPerInstanceConfigsPagedCallable();
    }

    public final UnaryCallable<ListPerInstanceConfigsInstanceGroupManagersRequest, InstanceGroupManagersListPerInstanceConfigsResp> listPerInstanceConfigsCallable() {
        return this.stub.listPerInstanceConfigsCallable();
    }

    public final Operation patch(String project, String zone, String instanceGroupManager, InstanceGroupManager instanceGroupManagerResource) {
        PatchInstanceGroupManagerRequest request = PatchInstanceGroupManagerRequest.newBuilder().setProject(project).setZone(zone).setInstanceGroupManager(instanceGroupManager).setInstanceGroupManagerResource(instanceGroupManagerResource).build();
        return this.patch(request);
    }

    public final Operation patch(PatchInstanceGroupManagerRequest request) {
        return (Operation)this.patchCallable().call((Object)request);
    }

    public final UnaryCallable<PatchInstanceGroupManagerRequest, Operation> patchCallable() {
        return this.stub.patchCallable();
    }

    public final Operation patchPerInstanceConfigs(String project, String zone, String instanceGroupManager, InstanceGroupManagersPatchPerInstanceConfigsReq instanceGroupManagersPatchPerInstanceConfigsReqResource) {
        PatchPerInstanceConfigsInstanceGroupManagerRequest request = PatchPerInstanceConfigsInstanceGroupManagerRequest.newBuilder().setProject(project).setZone(zone).setInstanceGroupManager(instanceGroupManager).setInstanceGroupManagersPatchPerInstanceConfigsReqResource(instanceGroupManagersPatchPerInstanceConfigsReqResource).build();
        return this.patchPerInstanceConfigs(request);
    }

    public final Operation patchPerInstanceConfigs(PatchPerInstanceConfigsInstanceGroupManagerRequest request) {
        return (Operation)this.patchPerInstanceConfigsCallable().call((Object)request);
    }

    public final UnaryCallable<PatchPerInstanceConfigsInstanceGroupManagerRequest, Operation> patchPerInstanceConfigsCallable() {
        return this.stub.patchPerInstanceConfigsCallable();
    }

    public final Operation recreateInstances(String project, String zone, String instanceGroupManager, InstanceGroupManagersRecreateInstancesRequest instanceGroupManagersRecreateInstancesRequestResource) {
        RecreateInstancesInstanceGroupManagerRequest request = RecreateInstancesInstanceGroupManagerRequest.newBuilder().setProject(project).setZone(zone).setInstanceGroupManager(instanceGroupManager).setInstanceGroupManagersRecreateInstancesRequestResource(instanceGroupManagersRecreateInstancesRequestResource).build();
        return this.recreateInstances(request);
    }

    public final Operation recreateInstances(RecreateInstancesInstanceGroupManagerRequest request) {
        return (Operation)this.recreateInstancesCallable().call((Object)request);
    }

    public final UnaryCallable<RecreateInstancesInstanceGroupManagerRequest, Operation> recreateInstancesCallable() {
        return this.stub.recreateInstancesCallable();
    }

    public final Operation resize(String project, String zone, String instanceGroupManager, int size) {
        ResizeInstanceGroupManagerRequest request = ResizeInstanceGroupManagerRequest.newBuilder().setProject(project).setZone(zone).setInstanceGroupManager(instanceGroupManager).setSize(size).build();
        return this.resize(request);
    }

    public final Operation resize(ResizeInstanceGroupManagerRequest request) {
        return (Operation)this.resizeCallable().call((Object)request);
    }

    public final UnaryCallable<ResizeInstanceGroupManagerRequest, Operation> resizeCallable() {
        return this.stub.resizeCallable();
    }

    public final Operation setInstanceTemplate(String project, String zone, String instanceGroupManager, InstanceGroupManagersSetInstanceTemplateRequest instanceGroupManagersSetInstanceTemplateRequestResource) {
        SetInstanceTemplateInstanceGroupManagerRequest request = SetInstanceTemplateInstanceGroupManagerRequest.newBuilder().setProject(project).setZone(zone).setInstanceGroupManager(instanceGroupManager).setInstanceGroupManagersSetInstanceTemplateRequestResource(instanceGroupManagersSetInstanceTemplateRequestResource).build();
        return this.setInstanceTemplate(request);
    }

    public final Operation setInstanceTemplate(SetInstanceTemplateInstanceGroupManagerRequest request) {
        return (Operation)this.setInstanceTemplateCallable().call((Object)request);
    }

    public final UnaryCallable<SetInstanceTemplateInstanceGroupManagerRequest, Operation> setInstanceTemplateCallable() {
        return this.stub.setInstanceTemplateCallable();
    }

    public final Operation setTargetPools(String project, String zone, String instanceGroupManager, InstanceGroupManagersSetTargetPoolsRequest instanceGroupManagersSetTargetPoolsRequestResource) {
        SetTargetPoolsInstanceGroupManagerRequest request = SetTargetPoolsInstanceGroupManagerRequest.newBuilder().setProject(project).setZone(zone).setInstanceGroupManager(instanceGroupManager).setInstanceGroupManagersSetTargetPoolsRequestResource(instanceGroupManagersSetTargetPoolsRequestResource).build();
        return this.setTargetPools(request);
    }

    public final Operation setTargetPools(SetTargetPoolsInstanceGroupManagerRequest request) {
        return (Operation)this.setTargetPoolsCallable().call((Object)request);
    }

    public final UnaryCallable<SetTargetPoolsInstanceGroupManagerRequest, Operation> setTargetPoolsCallable() {
        return this.stub.setTargetPoolsCallable();
    }

    public final Operation updatePerInstanceConfigs(String project, String zone, String instanceGroupManager, InstanceGroupManagersUpdatePerInstanceConfigsReq instanceGroupManagersUpdatePerInstanceConfigsReqResource) {
        UpdatePerInstanceConfigsInstanceGroupManagerRequest request = UpdatePerInstanceConfigsInstanceGroupManagerRequest.newBuilder().setProject(project).setZone(zone).setInstanceGroupManager(instanceGroupManager).setInstanceGroupManagersUpdatePerInstanceConfigsReqResource(instanceGroupManagersUpdatePerInstanceConfigsReqResource).build();
        return this.updatePerInstanceConfigs(request);
    }

    public final Operation updatePerInstanceConfigs(UpdatePerInstanceConfigsInstanceGroupManagerRequest request) {
        return (Operation)this.updatePerInstanceConfigsCallable().call((Object)request);
    }

    public final UnaryCallable<UpdatePerInstanceConfigsInstanceGroupManagerRequest, Operation> updatePerInstanceConfigsCallable() {
        return this.stub.updatePerInstanceConfigsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListPerInstanceConfigsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListPerInstanceConfigsInstanceGroupManagersRequest, InstanceGroupManagersListPerInstanceConfigsResp, PerInstanceConfig, ListPerInstanceConfigsPage, ListPerInstanceConfigsFixedSizeCollection> {
        private ListPerInstanceConfigsFixedSizeCollection(List<ListPerInstanceConfigsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListPerInstanceConfigsFixedSizeCollection createEmptyCollection() {
            return new ListPerInstanceConfigsFixedSizeCollection(null, 0);
        }

        protected ListPerInstanceConfigsFixedSizeCollection createCollection(List<ListPerInstanceConfigsPage> pages, int collectionSize) {
            return new ListPerInstanceConfigsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPerInstanceConfigsPage
    extends AbstractPage<ListPerInstanceConfigsInstanceGroupManagersRequest, InstanceGroupManagersListPerInstanceConfigsResp, PerInstanceConfig, ListPerInstanceConfigsPage> {
        private ListPerInstanceConfigsPage(PageContext<ListPerInstanceConfigsInstanceGroupManagersRequest, InstanceGroupManagersListPerInstanceConfigsResp, PerInstanceConfig> context, InstanceGroupManagersListPerInstanceConfigsResp response) {
            super(context, (Object)response);
        }

        private static ListPerInstanceConfigsPage createEmptyPage() {
            return new ListPerInstanceConfigsPage(null, null);
        }

        protected ListPerInstanceConfigsPage createPage(PageContext<ListPerInstanceConfigsInstanceGroupManagersRequest, InstanceGroupManagersListPerInstanceConfigsResp, PerInstanceConfig> context, InstanceGroupManagersListPerInstanceConfigsResp response) {
            return new ListPerInstanceConfigsPage(context, response);
        }

        public ApiFuture<ListPerInstanceConfigsPage> createPageAsync(PageContext<ListPerInstanceConfigsInstanceGroupManagersRequest, InstanceGroupManagersListPerInstanceConfigsResp, PerInstanceConfig> context, ApiFuture<InstanceGroupManagersListPerInstanceConfigsResp> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPerInstanceConfigsPagedResponse
    extends AbstractPagedListResponse<ListPerInstanceConfigsInstanceGroupManagersRequest, InstanceGroupManagersListPerInstanceConfigsResp, PerInstanceConfig, ListPerInstanceConfigsPage, ListPerInstanceConfigsFixedSizeCollection> {
        public static ApiFuture<ListPerInstanceConfigsPagedResponse> createAsync(PageContext<ListPerInstanceConfigsInstanceGroupManagersRequest, InstanceGroupManagersListPerInstanceConfigsResp, PerInstanceConfig> context, ApiFuture<InstanceGroupManagersListPerInstanceConfigsResp> futureResponse) {
            ApiFuture<ListPerInstanceConfigsPage> futurePage = ListPerInstanceConfigsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPerInstanceConfigsPagedResponse((ListPerInstanceConfigsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPerInstanceConfigsPagedResponse(ListPerInstanceConfigsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListPerInstanceConfigsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListManagedInstancesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListManagedInstancesInstanceGroupManagersRequest, InstanceGroupManagersListManagedInstancesResponse, ManagedInstance, ListManagedInstancesPage, ListManagedInstancesFixedSizeCollection> {
        private ListManagedInstancesFixedSizeCollection(List<ListManagedInstancesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListManagedInstancesFixedSizeCollection createEmptyCollection() {
            return new ListManagedInstancesFixedSizeCollection(null, 0);
        }

        protected ListManagedInstancesFixedSizeCollection createCollection(List<ListManagedInstancesPage> pages, int collectionSize) {
            return new ListManagedInstancesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListManagedInstancesPage
    extends AbstractPage<ListManagedInstancesInstanceGroupManagersRequest, InstanceGroupManagersListManagedInstancesResponse, ManagedInstance, ListManagedInstancesPage> {
        private ListManagedInstancesPage(PageContext<ListManagedInstancesInstanceGroupManagersRequest, InstanceGroupManagersListManagedInstancesResponse, ManagedInstance> context, InstanceGroupManagersListManagedInstancesResponse response) {
            super(context, (Object)response);
        }

        private static ListManagedInstancesPage createEmptyPage() {
            return new ListManagedInstancesPage(null, null);
        }

        protected ListManagedInstancesPage createPage(PageContext<ListManagedInstancesInstanceGroupManagersRequest, InstanceGroupManagersListManagedInstancesResponse, ManagedInstance> context, InstanceGroupManagersListManagedInstancesResponse response) {
            return new ListManagedInstancesPage(context, response);
        }

        public ApiFuture<ListManagedInstancesPage> createPageAsync(PageContext<ListManagedInstancesInstanceGroupManagersRequest, InstanceGroupManagersListManagedInstancesResponse, ManagedInstance> context, ApiFuture<InstanceGroupManagersListManagedInstancesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListManagedInstancesPagedResponse
    extends AbstractPagedListResponse<ListManagedInstancesInstanceGroupManagersRequest, InstanceGroupManagersListManagedInstancesResponse, ManagedInstance, ListManagedInstancesPage, ListManagedInstancesFixedSizeCollection> {
        public static ApiFuture<ListManagedInstancesPagedResponse> createAsync(PageContext<ListManagedInstancesInstanceGroupManagersRequest, InstanceGroupManagersListManagedInstancesResponse, ManagedInstance> context, ApiFuture<InstanceGroupManagersListManagedInstancesResponse> futureResponse) {
            ApiFuture<ListManagedInstancesPage> futurePage = ListManagedInstancesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListManagedInstancesPagedResponse((ListManagedInstancesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListManagedInstancesPagedResponse(ListManagedInstancesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListManagedInstancesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListErrorsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListErrorsInstanceGroupManagersRequest, InstanceGroupManagersListErrorsResponse, InstanceManagedByIgmError, ListErrorsPage, ListErrorsFixedSizeCollection> {
        private ListErrorsFixedSizeCollection(List<ListErrorsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListErrorsFixedSizeCollection createEmptyCollection() {
            return new ListErrorsFixedSizeCollection(null, 0);
        }

        protected ListErrorsFixedSizeCollection createCollection(List<ListErrorsPage> pages, int collectionSize) {
            return new ListErrorsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListErrorsPage
    extends AbstractPage<ListErrorsInstanceGroupManagersRequest, InstanceGroupManagersListErrorsResponse, InstanceManagedByIgmError, ListErrorsPage> {
        private ListErrorsPage(PageContext<ListErrorsInstanceGroupManagersRequest, InstanceGroupManagersListErrorsResponse, InstanceManagedByIgmError> context, InstanceGroupManagersListErrorsResponse response) {
            super(context, (Object)response);
        }

        private static ListErrorsPage createEmptyPage() {
            return new ListErrorsPage(null, null);
        }

        protected ListErrorsPage createPage(PageContext<ListErrorsInstanceGroupManagersRequest, InstanceGroupManagersListErrorsResponse, InstanceManagedByIgmError> context, InstanceGroupManagersListErrorsResponse response) {
            return new ListErrorsPage(context, response);
        }

        public ApiFuture<ListErrorsPage> createPageAsync(PageContext<ListErrorsInstanceGroupManagersRequest, InstanceGroupManagersListErrorsResponse, InstanceManagedByIgmError> context, ApiFuture<InstanceGroupManagersListErrorsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListErrorsPagedResponse
    extends AbstractPagedListResponse<ListErrorsInstanceGroupManagersRequest, InstanceGroupManagersListErrorsResponse, InstanceManagedByIgmError, ListErrorsPage, ListErrorsFixedSizeCollection> {
        public static ApiFuture<ListErrorsPagedResponse> createAsync(PageContext<ListErrorsInstanceGroupManagersRequest, InstanceGroupManagersListErrorsResponse, InstanceManagedByIgmError> context, ApiFuture<InstanceGroupManagersListErrorsResponse> futureResponse) {
            ApiFuture<ListErrorsPage> futurePage = ListErrorsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListErrorsPagedResponse((ListErrorsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListErrorsPagedResponse(ListErrorsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListErrorsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListInstanceGroupManagersRequest, InstanceGroupManagerList, InstanceGroupManager, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListInstanceGroupManagersRequest, InstanceGroupManagerList, InstanceGroupManager, ListPage> {
        private ListPage(PageContext<ListInstanceGroupManagersRequest, InstanceGroupManagerList, InstanceGroupManager> context, InstanceGroupManagerList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListInstanceGroupManagersRequest, InstanceGroupManagerList, InstanceGroupManager> context, InstanceGroupManagerList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListInstanceGroupManagersRequest, InstanceGroupManagerList, InstanceGroupManager> context, ApiFuture<InstanceGroupManagerList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListInstanceGroupManagersRequest, InstanceGroupManagerList, InstanceGroupManager, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListInstanceGroupManagersRequest, InstanceGroupManagerList, InstanceGroupManager> context, ApiFuture<InstanceGroupManagerList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPagedResponse((ListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class AggregatedListFixedSizeCollection
    extends AbstractFixedSizeCollection<AggregatedListInstanceGroupManagersRequest, InstanceGroupManagerAggregatedList, Map.Entry<String, InstanceGroupManagersScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        private AggregatedListFixedSizeCollection(List<AggregatedListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static AggregatedListFixedSizeCollection createEmptyCollection() {
            return new AggregatedListFixedSizeCollection(null, 0);
        }

        protected AggregatedListFixedSizeCollection createCollection(List<AggregatedListPage> pages, int collectionSize) {
            return new AggregatedListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class AggregatedListPage
    extends AbstractPage<AggregatedListInstanceGroupManagersRequest, InstanceGroupManagerAggregatedList, Map.Entry<String, InstanceGroupManagersScopedList>, AggregatedListPage> {
        private AggregatedListPage(PageContext<AggregatedListInstanceGroupManagersRequest, InstanceGroupManagerAggregatedList, Map.Entry<String, InstanceGroupManagersScopedList>> context, InstanceGroupManagerAggregatedList response) {
            super(context, (Object)response);
        }

        private static AggregatedListPage createEmptyPage() {
            return new AggregatedListPage(null, null);
        }

        protected AggregatedListPage createPage(PageContext<AggregatedListInstanceGroupManagersRequest, InstanceGroupManagerAggregatedList, Map.Entry<String, InstanceGroupManagersScopedList>> context, InstanceGroupManagerAggregatedList response) {
            return new AggregatedListPage(context, response);
        }

        public ApiFuture<AggregatedListPage> createPageAsync(PageContext<AggregatedListInstanceGroupManagersRequest, InstanceGroupManagerAggregatedList, Map.Entry<String, InstanceGroupManagersScopedList>> context, ApiFuture<InstanceGroupManagerAggregatedList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class AggregatedListPagedResponse
    extends AbstractPagedListResponse<AggregatedListInstanceGroupManagersRequest, InstanceGroupManagerAggregatedList, Map.Entry<String, InstanceGroupManagersScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        public static ApiFuture<AggregatedListPagedResponse> createAsync(PageContext<AggregatedListInstanceGroupManagersRequest, InstanceGroupManagerAggregatedList, Map.Entry<String, InstanceGroupManagersScopedList>> context, ApiFuture<InstanceGroupManagerAggregatedList> futureResponse) {
            ApiFuture<AggregatedListPage> futurePage = AggregatedListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new AggregatedListPagedResponse((AggregatedListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private AggregatedListPagedResponse(AggregatedListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)AggregatedListFixedSizeCollection.createEmptyCollection());
        }
    }
}

