/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AddSignedUrlKeyBackendServiceRequest;
import com.google.cloud.compute.v1.AggregatedListBackendServicesRequest;
import com.google.cloud.compute.v1.BackendService;
import com.google.cloud.compute.v1.BackendServiceAggregatedList;
import com.google.cloud.compute.v1.BackendServiceGroupHealth;
import com.google.cloud.compute.v1.BackendServiceList;
import com.google.cloud.compute.v1.BackendServicesScopedList;
import com.google.cloud.compute.v1.BackendServicesSettings;
import com.google.cloud.compute.v1.DeleteBackendServiceRequest;
import com.google.cloud.compute.v1.DeleteSignedUrlKeyBackendServiceRequest;
import com.google.cloud.compute.v1.GetBackendServiceRequest;
import com.google.cloud.compute.v1.GetHealthBackendServiceRequest;
import com.google.cloud.compute.v1.InsertBackendServiceRequest;
import com.google.cloud.compute.v1.ListBackendServicesRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchBackendServiceRequest;
import com.google.cloud.compute.v1.ResourceGroupReference;
import com.google.cloud.compute.v1.SecurityPolicyReference;
import com.google.cloud.compute.v1.SetSecurityPolicyBackendServiceRequest;
import com.google.cloud.compute.v1.SignedUrlKey;
import com.google.cloud.compute.v1.UpdateBackendServiceRequest;
import com.google.cloud.compute.v1.stub.BackendServicesStub;
import com.google.cloud.compute.v1.stub.BackendServicesStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class BackendServicesClient
implements BackgroundResource {
    private final BackendServicesSettings settings;
    private final BackendServicesStub stub;

    public static final BackendServicesClient create() throws IOException {
        return BackendServicesClient.create(BackendServicesSettings.newBuilder().build());
    }

    public static final BackendServicesClient create(BackendServicesSettings settings) throws IOException {
        return new BackendServicesClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final BackendServicesClient create(BackendServicesStub stub) {
        return new BackendServicesClient(stub);
    }

    protected BackendServicesClient(BackendServicesSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((BackendServicesStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected BackendServicesClient(BackendServicesStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final BackendServicesSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public BackendServicesStub getStub() {
        return this.stub;
    }

    public final Operation addSignedUrlKey(String project, String backendService, SignedUrlKey signedUrlKeyResource) {
        AddSignedUrlKeyBackendServiceRequest request = AddSignedUrlKeyBackendServiceRequest.newBuilder().setProject(project).setBackendService(backendService).setSignedUrlKeyResource(signedUrlKeyResource).build();
        return this.addSignedUrlKey(request);
    }

    public final Operation addSignedUrlKey(AddSignedUrlKeyBackendServiceRequest request) {
        return (Operation)this.addSignedUrlKeyCallable().call((Object)request);
    }

    public final UnaryCallable<AddSignedUrlKeyBackendServiceRequest, Operation> addSignedUrlKeyCallable() {
        return this.stub.addSignedUrlKeyCallable();
    }

    public final AggregatedListPagedResponse aggregatedList(String project) {
        AggregatedListBackendServicesRequest request = AggregatedListBackendServicesRequest.newBuilder().setProject(project).build();
        return this.aggregatedList(request);
    }

    public final AggregatedListPagedResponse aggregatedList(AggregatedListBackendServicesRequest request) {
        return (AggregatedListPagedResponse)((Object)this.aggregatedListPagedCallable().call((Object)request));
    }

    public final UnaryCallable<AggregatedListBackendServicesRequest, AggregatedListPagedResponse> aggregatedListPagedCallable() {
        return this.stub.aggregatedListPagedCallable();
    }

    public final UnaryCallable<AggregatedListBackendServicesRequest, BackendServiceAggregatedList> aggregatedListCallable() {
        return this.stub.aggregatedListCallable();
    }

    public final Operation delete(String project, String backendService) {
        DeleteBackendServiceRequest request = DeleteBackendServiceRequest.newBuilder().setProject(project).setBackendService(backendService).build();
        return this.delete(request);
    }

    public final Operation delete(DeleteBackendServiceRequest request) {
        return (Operation)this.deleteCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteBackendServiceRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final Operation deleteSignedUrlKey(String project, String backendService, String keyName) {
        DeleteSignedUrlKeyBackendServiceRequest request = DeleteSignedUrlKeyBackendServiceRequest.newBuilder().setProject(project).setBackendService(backendService).setKeyName(keyName).build();
        return this.deleteSignedUrlKey(request);
    }

    public final Operation deleteSignedUrlKey(DeleteSignedUrlKeyBackendServiceRequest request) {
        return (Operation)this.deleteSignedUrlKeyCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteSignedUrlKeyBackendServiceRequest, Operation> deleteSignedUrlKeyCallable() {
        return this.stub.deleteSignedUrlKeyCallable();
    }

    public final BackendService get(String project, String backendService) {
        GetBackendServiceRequest request = GetBackendServiceRequest.newBuilder().setProject(project).setBackendService(backendService).build();
        return this.get(request);
    }

    public final BackendService get(GetBackendServiceRequest request) {
        return (BackendService)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetBackendServiceRequest, BackendService> getCallable() {
        return this.stub.getCallable();
    }

    public final BackendServiceGroupHealth getHealth(String project, String backendService, ResourceGroupReference resourceGroupReferenceResource) {
        GetHealthBackendServiceRequest request = GetHealthBackendServiceRequest.newBuilder().setProject(project).setBackendService(backendService).setResourceGroupReferenceResource(resourceGroupReferenceResource).build();
        return this.getHealth(request);
    }

    public final BackendServiceGroupHealth getHealth(GetHealthBackendServiceRequest request) {
        return (BackendServiceGroupHealth)this.getHealthCallable().call((Object)request);
    }

    public final UnaryCallable<GetHealthBackendServiceRequest, BackendServiceGroupHealth> getHealthCallable() {
        return this.stub.getHealthCallable();
    }

    public final Operation insert(String project, BackendService backendServiceResource) {
        InsertBackendServiceRequest request = InsertBackendServiceRequest.newBuilder().setProject(project).setBackendServiceResource(backendServiceResource).build();
        return this.insert(request);
    }

    public final Operation insert(InsertBackendServiceRequest request) {
        return (Operation)this.insertCallable().call((Object)request);
    }

    public final UnaryCallable<InsertBackendServiceRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list(String project) {
        ListBackendServicesRequest request = ListBackendServicesRequest.newBuilder().setProject(project).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListBackendServicesRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListBackendServicesRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListBackendServicesRequest, BackendServiceList> listCallable() {
        return this.stub.listCallable();
    }

    public final Operation patch(String project, String backendService, BackendService backendServiceResource) {
        PatchBackendServiceRequest request = PatchBackendServiceRequest.newBuilder().setProject(project).setBackendService(backendService).setBackendServiceResource(backendServiceResource).build();
        return this.patch(request);
    }

    public final Operation patch(PatchBackendServiceRequest request) {
        return (Operation)this.patchCallable().call((Object)request);
    }

    public final UnaryCallable<PatchBackendServiceRequest, Operation> patchCallable() {
        return this.stub.patchCallable();
    }

    public final Operation setSecurityPolicy(String project, String backendService, SecurityPolicyReference securityPolicyReferenceResource) {
        SetSecurityPolicyBackendServiceRequest request = SetSecurityPolicyBackendServiceRequest.newBuilder().setProject(project).setBackendService(backendService).setSecurityPolicyReferenceResource(securityPolicyReferenceResource).build();
        return this.setSecurityPolicy(request);
    }

    public final Operation setSecurityPolicy(SetSecurityPolicyBackendServiceRequest request) {
        return (Operation)this.setSecurityPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetSecurityPolicyBackendServiceRequest, Operation> setSecurityPolicyCallable() {
        return this.stub.setSecurityPolicyCallable();
    }

    public final Operation update(String project, String backendService, BackendService backendServiceResource) {
        UpdateBackendServiceRequest request = UpdateBackendServiceRequest.newBuilder().setProject(project).setBackendService(backendService).setBackendServiceResource(backendServiceResource).build();
        return this.update(request);
    }

    public final Operation update(UpdateBackendServiceRequest request) {
        return (Operation)this.updateCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateBackendServiceRequest, Operation> updateCallable() {
        return this.stub.updateCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListBackendServicesRequest, BackendServiceList, BackendService, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListBackendServicesRequest, BackendServiceList, BackendService, ListPage> {
        private ListPage(PageContext<ListBackendServicesRequest, BackendServiceList, BackendService> context, BackendServiceList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListBackendServicesRequest, BackendServiceList, BackendService> context, BackendServiceList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListBackendServicesRequest, BackendServiceList, BackendService> context, ApiFuture<BackendServiceList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListBackendServicesRequest, BackendServiceList, BackendService, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListBackendServicesRequest, BackendServiceList, BackendService> context, ApiFuture<BackendServiceList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPagedResponse((ListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class AggregatedListFixedSizeCollection
    extends AbstractFixedSizeCollection<AggregatedListBackendServicesRequest, BackendServiceAggregatedList, Map.Entry<String, BackendServicesScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        private AggregatedListFixedSizeCollection(List<AggregatedListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static AggregatedListFixedSizeCollection createEmptyCollection() {
            return new AggregatedListFixedSizeCollection(null, 0);
        }

        protected AggregatedListFixedSizeCollection createCollection(List<AggregatedListPage> pages, int collectionSize) {
            return new AggregatedListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class AggregatedListPage
    extends AbstractPage<AggregatedListBackendServicesRequest, BackendServiceAggregatedList, Map.Entry<String, BackendServicesScopedList>, AggregatedListPage> {
        private AggregatedListPage(PageContext<AggregatedListBackendServicesRequest, BackendServiceAggregatedList, Map.Entry<String, BackendServicesScopedList>> context, BackendServiceAggregatedList response) {
            super(context, (Object)response);
        }

        private static AggregatedListPage createEmptyPage() {
            return new AggregatedListPage(null, null);
        }

        protected AggregatedListPage createPage(PageContext<AggregatedListBackendServicesRequest, BackendServiceAggregatedList, Map.Entry<String, BackendServicesScopedList>> context, BackendServiceAggregatedList response) {
            return new AggregatedListPage(context, response);
        }

        public ApiFuture<AggregatedListPage> createPageAsync(PageContext<AggregatedListBackendServicesRequest, BackendServiceAggregatedList, Map.Entry<String, BackendServicesScopedList>> context, ApiFuture<BackendServiceAggregatedList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class AggregatedListPagedResponse
    extends AbstractPagedListResponse<AggregatedListBackendServicesRequest, BackendServiceAggregatedList, Map.Entry<String, BackendServicesScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        public static ApiFuture<AggregatedListPagedResponse> createAsync(PageContext<AggregatedListBackendServicesRequest, BackendServiceAggregatedList, Map.Entry<String, BackendServicesScopedList>> context, ApiFuture<BackendServiceAggregatedList> futureResponse) {
            ApiFuture<AggregatedListPage> futurePage = AggregatedListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new AggregatedListPagedResponse((AggregatedListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private AggregatedListPagedResponse(AggregatedListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)AggregatedListFixedSizeCollection.createEmptyCollection());
        }
    }
}

