/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListTargetVpnGatewaysRequest;
import com.google.cloud.compute.v1.DeleteTargetVpnGatewayRequest;
import com.google.cloud.compute.v1.GetTargetVpnGatewayRequest;
import com.google.cloud.compute.v1.InsertTargetVpnGatewayRequest;
import com.google.cloud.compute.v1.ListTargetVpnGatewaysRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.TargetVpnGateway;
import com.google.cloud.compute.v1.TargetVpnGatewayAggregatedList;
import com.google.cloud.compute.v1.TargetVpnGatewayList;
import com.google.cloud.compute.v1.TargetVpnGatewaysScopedList;
import com.google.cloud.compute.v1.TargetVpnGatewaysSettings;
import com.google.cloud.compute.v1.stub.TargetVpnGatewaysStub;
import com.google.cloud.compute.v1.stub.TargetVpnGatewaysStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class TargetVpnGatewaysClient
implements BackgroundResource {
    private final TargetVpnGatewaysSettings settings;
    private final TargetVpnGatewaysStub stub;

    public static final TargetVpnGatewaysClient create() throws IOException {
        return TargetVpnGatewaysClient.create(TargetVpnGatewaysSettings.newBuilder().build());
    }

    public static final TargetVpnGatewaysClient create(TargetVpnGatewaysSettings settings) throws IOException {
        return new TargetVpnGatewaysClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final TargetVpnGatewaysClient create(TargetVpnGatewaysStub stub) {
        return new TargetVpnGatewaysClient(stub);
    }

    protected TargetVpnGatewaysClient(TargetVpnGatewaysSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((TargetVpnGatewaysStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected TargetVpnGatewaysClient(TargetVpnGatewaysStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final TargetVpnGatewaysSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public TargetVpnGatewaysStub getStub() {
        return this.stub;
    }

    public final AggregatedListPagedResponse aggregatedList(String project) {
        AggregatedListTargetVpnGatewaysRequest request = AggregatedListTargetVpnGatewaysRequest.newBuilder().setProject(project).build();
        return this.aggregatedList(request);
    }

    public final AggregatedListPagedResponse aggregatedList(AggregatedListTargetVpnGatewaysRequest request) {
        return (AggregatedListPagedResponse)((Object)this.aggregatedListPagedCallable().call((Object)request));
    }

    public final UnaryCallable<AggregatedListTargetVpnGatewaysRequest, AggregatedListPagedResponse> aggregatedListPagedCallable() {
        return this.stub.aggregatedListPagedCallable();
    }

    public final UnaryCallable<AggregatedListTargetVpnGatewaysRequest, TargetVpnGatewayAggregatedList> aggregatedListCallable() {
        return this.stub.aggregatedListCallable();
    }

    public final Operation delete(String project, String region, String targetVpnGateway) {
        DeleteTargetVpnGatewayRequest request = DeleteTargetVpnGatewayRequest.newBuilder().setProject(project).setRegion(region).setTargetVpnGateway(targetVpnGateway).build();
        return this.delete(request);
    }

    public final Operation delete(DeleteTargetVpnGatewayRequest request) {
        return (Operation)this.deleteCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteTargetVpnGatewayRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final TargetVpnGateway get(String project, String region, String targetVpnGateway) {
        GetTargetVpnGatewayRequest request = GetTargetVpnGatewayRequest.newBuilder().setProject(project).setRegion(region).setTargetVpnGateway(targetVpnGateway).build();
        return this.get(request);
    }

    public final TargetVpnGateway get(GetTargetVpnGatewayRequest request) {
        return (TargetVpnGateway)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetTargetVpnGatewayRequest, TargetVpnGateway> getCallable() {
        return this.stub.getCallable();
    }

    public final Operation insert(String project, String region, TargetVpnGateway targetVpnGatewayResource) {
        InsertTargetVpnGatewayRequest request = InsertTargetVpnGatewayRequest.newBuilder().setProject(project).setRegion(region).setTargetVpnGatewayResource(targetVpnGatewayResource).build();
        return this.insert(request);
    }

    public final Operation insert(InsertTargetVpnGatewayRequest request) {
        return (Operation)this.insertCallable().call((Object)request);
    }

    public final UnaryCallable<InsertTargetVpnGatewayRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list(String project, String region) {
        ListTargetVpnGatewaysRequest request = ListTargetVpnGatewaysRequest.newBuilder().setProject(project).setRegion(region).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListTargetVpnGatewaysRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListTargetVpnGatewaysRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListTargetVpnGatewaysRequest, TargetVpnGatewayList> listCallable() {
        return this.stub.listCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListTargetVpnGatewaysRequest, TargetVpnGatewayList, TargetVpnGateway, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListTargetVpnGatewaysRequest, TargetVpnGatewayList, TargetVpnGateway, ListPage> {
        private ListPage(PageContext<ListTargetVpnGatewaysRequest, TargetVpnGatewayList, TargetVpnGateway> context, TargetVpnGatewayList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListTargetVpnGatewaysRequest, TargetVpnGatewayList, TargetVpnGateway> context, TargetVpnGatewayList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListTargetVpnGatewaysRequest, TargetVpnGatewayList, TargetVpnGateway> context, ApiFuture<TargetVpnGatewayList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListTargetVpnGatewaysRequest, TargetVpnGatewayList, TargetVpnGateway, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListTargetVpnGatewaysRequest, TargetVpnGatewayList, TargetVpnGateway> context, ApiFuture<TargetVpnGatewayList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListPage, ListPagedResponse>(){

                public ListPagedResponse apply(ListPage input) {
                    return new ListPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class AggregatedListFixedSizeCollection
    extends AbstractFixedSizeCollection<AggregatedListTargetVpnGatewaysRequest, TargetVpnGatewayAggregatedList, Map.Entry<String, TargetVpnGatewaysScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        private AggregatedListFixedSizeCollection(List<AggregatedListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static AggregatedListFixedSizeCollection createEmptyCollection() {
            return new AggregatedListFixedSizeCollection(null, 0);
        }

        protected AggregatedListFixedSizeCollection createCollection(List<AggregatedListPage> pages, int collectionSize) {
            return new AggregatedListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class AggregatedListPage
    extends AbstractPage<AggregatedListTargetVpnGatewaysRequest, TargetVpnGatewayAggregatedList, Map.Entry<String, TargetVpnGatewaysScopedList>, AggregatedListPage> {
        private AggregatedListPage(PageContext<AggregatedListTargetVpnGatewaysRequest, TargetVpnGatewayAggregatedList, Map.Entry<String, TargetVpnGatewaysScopedList>> context, TargetVpnGatewayAggregatedList response) {
            super(context, (Object)response);
        }

        private static AggregatedListPage createEmptyPage() {
            return new AggregatedListPage(null, null);
        }

        protected AggregatedListPage createPage(PageContext<AggregatedListTargetVpnGatewaysRequest, TargetVpnGatewayAggregatedList, Map.Entry<String, TargetVpnGatewaysScopedList>> context, TargetVpnGatewayAggregatedList response) {
            return new AggregatedListPage(context, response);
        }

        public ApiFuture<AggregatedListPage> createPageAsync(PageContext<AggregatedListTargetVpnGatewaysRequest, TargetVpnGatewayAggregatedList, Map.Entry<String, TargetVpnGatewaysScopedList>> context, ApiFuture<TargetVpnGatewayAggregatedList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class AggregatedListPagedResponse
    extends AbstractPagedListResponse<AggregatedListTargetVpnGatewaysRequest, TargetVpnGatewayAggregatedList, Map.Entry<String, TargetVpnGatewaysScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        public static ApiFuture<AggregatedListPagedResponse> createAsync(PageContext<AggregatedListTargetVpnGatewaysRequest, TargetVpnGatewayAggregatedList, Map.Entry<String, TargetVpnGatewaysScopedList>> context, ApiFuture<TargetVpnGatewayAggregatedList> futureResponse) {
            ApiFuture<AggregatedListPage> futurePage = AggregatedListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<AggregatedListPage, AggregatedListPagedResponse>(){

                public AggregatedListPagedResponse apply(AggregatedListPage input) {
                    return new AggregatedListPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private AggregatedListPagedResponse(AggregatedListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)AggregatedListFixedSizeCollection.createEmptyCollection());
        }
    }
}

