/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteRegionTargetHttpsProxyRequest;
import com.google.cloud.compute.v1.GetRegionTargetHttpsProxyRequest;
import com.google.cloud.compute.v1.InsertRegionTargetHttpsProxyRequest;
import com.google.cloud.compute.v1.ListRegionTargetHttpsProxiesRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.RegionTargetHttpsProxiesSetSslCertificatesRequest;
import com.google.cloud.compute.v1.RegionTargetHttpsProxiesSettings;
import com.google.cloud.compute.v1.SetSslCertificatesRegionTargetHttpsProxyRequest;
import com.google.cloud.compute.v1.SetUrlMapRegionTargetHttpsProxyRequest;
import com.google.cloud.compute.v1.TargetHttpsProxy;
import com.google.cloud.compute.v1.TargetHttpsProxyList;
import com.google.cloud.compute.v1.UrlMapReference;
import com.google.cloud.compute.v1.stub.RegionTargetHttpsProxiesStub;
import com.google.cloud.compute.v1.stub.RegionTargetHttpsProxiesStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class RegionTargetHttpsProxiesClient
implements BackgroundResource {
    private final RegionTargetHttpsProxiesSettings settings;
    private final RegionTargetHttpsProxiesStub stub;

    public static final RegionTargetHttpsProxiesClient create() throws IOException {
        return RegionTargetHttpsProxiesClient.create(RegionTargetHttpsProxiesSettings.newBuilder().build());
    }

    public static final RegionTargetHttpsProxiesClient create(RegionTargetHttpsProxiesSettings settings) throws IOException {
        return new RegionTargetHttpsProxiesClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final RegionTargetHttpsProxiesClient create(RegionTargetHttpsProxiesStub stub) {
        return new RegionTargetHttpsProxiesClient(stub);
    }

    protected RegionTargetHttpsProxiesClient(RegionTargetHttpsProxiesSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((RegionTargetHttpsProxiesStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected RegionTargetHttpsProxiesClient(RegionTargetHttpsProxiesStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final RegionTargetHttpsProxiesSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public RegionTargetHttpsProxiesStub getStub() {
        return this.stub;
    }

    public final Operation delete(String project, String region, String targetHttpsProxy) {
        DeleteRegionTargetHttpsProxyRequest request = DeleteRegionTargetHttpsProxyRequest.newBuilder().setProject(project).setRegion(region).setTargetHttpsProxy(targetHttpsProxy).build();
        return this.delete(request);
    }

    public final Operation delete(DeleteRegionTargetHttpsProxyRequest request) {
        return (Operation)this.deleteCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteRegionTargetHttpsProxyRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final TargetHttpsProxy get(String project, String region, String targetHttpsProxy) {
        GetRegionTargetHttpsProxyRequest request = GetRegionTargetHttpsProxyRequest.newBuilder().setProject(project).setRegion(region).setTargetHttpsProxy(targetHttpsProxy).build();
        return this.get(request);
    }

    public final TargetHttpsProxy get(GetRegionTargetHttpsProxyRequest request) {
        return (TargetHttpsProxy)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetRegionTargetHttpsProxyRequest, TargetHttpsProxy> getCallable() {
        return this.stub.getCallable();
    }

    public final Operation insert(String project, String region, TargetHttpsProxy targetHttpsProxyResource) {
        InsertRegionTargetHttpsProxyRequest request = InsertRegionTargetHttpsProxyRequest.newBuilder().setProject(project).setRegion(region).setTargetHttpsProxyResource(targetHttpsProxyResource).build();
        return this.insert(request);
    }

    public final Operation insert(InsertRegionTargetHttpsProxyRequest request) {
        return (Operation)this.insertCallable().call((Object)request);
    }

    public final UnaryCallable<InsertRegionTargetHttpsProxyRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list(String project, String region) {
        ListRegionTargetHttpsProxiesRequest request = ListRegionTargetHttpsProxiesRequest.newBuilder().setProject(project).setRegion(region).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListRegionTargetHttpsProxiesRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListRegionTargetHttpsProxiesRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListRegionTargetHttpsProxiesRequest, TargetHttpsProxyList> listCallable() {
        return this.stub.listCallable();
    }

    public final Operation setSslCertificates(String project, String region, String targetHttpsProxy, RegionTargetHttpsProxiesSetSslCertificatesRequest regionTargetHttpsProxiesSetSslCertificatesRequestResource) {
        SetSslCertificatesRegionTargetHttpsProxyRequest request = SetSslCertificatesRegionTargetHttpsProxyRequest.newBuilder().setProject(project).setRegion(region).setTargetHttpsProxy(targetHttpsProxy).setRegionTargetHttpsProxiesSetSslCertificatesRequestResource(regionTargetHttpsProxiesSetSslCertificatesRequestResource).build();
        return this.setSslCertificates(request);
    }

    public final Operation setSslCertificates(SetSslCertificatesRegionTargetHttpsProxyRequest request) {
        return (Operation)this.setSslCertificatesCallable().call((Object)request);
    }

    public final UnaryCallable<SetSslCertificatesRegionTargetHttpsProxyRequest, Operation> setSslCertificatesCallable() {
        return this.stub.setSslCertificatesCallable();
    }

    public final Operation setUrlMap(String project, String region, String targetHttpsProxy, UrlMapReference urlMapReferenceResource) {
        SetUrlMapRegionTargetHttpsProxyRequest request = SetUrlMapRegionTargetHttpsProxyRequest.newBuilder().setProject(project).setRegion(region).setTargetHttpsProxy(targetHttpsProxy).setUrlMapReferenceResource(urlMapReferenceResource).build();
        return this.setUrlMap(request);
    }

    public final Operation setUrlMap(SetUrlMapRegionTargetHttpsProxyRequest request) {
        return (Operation)this.setUrlMapCallable().call((Object)request);
    }

    public final UnaryCallable<SetUrlMapRegionTargetHttpsProxyRequest, Operation> setUrlMapCallable() {
        return this.stub.setUrlMapCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRegionTargetHttpsProxiesRequest, TargetHttpsProxyList, TargetHttpsProxy, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListRegionTargetHttpsProxiesRequest, TargetHttpsProxyList, TargetHttpsProxy, ListPage> {
        private ListPage(PageContext<ListRegionTargetHttpsProxiesRequest, TargetHttpsProxyList, TargetHttpsProxy> context, TargetHttpsProxyList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListRegionTargetHttpsProxiesRequest, TargetHttpsProxyList, TargetHttpsProxy> context, TargetHttpsProxyList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListRegionTargetHttpsProxiesRequest, TargetHttpsProxyList, TargetHttpsProxy> context, ApiFuture<TargetHttpsProxyList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListRegionTargetHttpsProxiesRequest, TargetHttpsProxyList, TargetHttpsProxy, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListRegionTargetHttpsProxiesRequest, TargetHttpsProxyList, TargetHttpsProxy> context, ApiFuture<TargetHttpsProxyList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListPage, ListPagedResponse>(){

                public ListPagedResponse apply(ListPage input) {
                    return new ListPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }
}

