/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteExternalVpnGatewayRequest;
import com.google.cloud.compute.v1.ExternalVpnGateway;
import com.google.cloud.compute.v1.ExternalVpnGatewayList;
import com.google.cloud.compute.v1.ExternalVpnGatewaysSettings;
import com.google.cloud.compute.v1.GetExternalVpnGatewayRequest;
import com.google.cloud.compute.v1.GlobalSetLabelsRequest;
import com.google.cloud.compute.v1.InsertExternalVpnGatewayRequest;
import com.google.cloud.compute.v1.ListExternalVpnGatewaysRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.SetLabelsExternalVpnGatewayRequest;
import com.google.cloud.compute.v1.TestIamPermissionsExternalVpnGatewayRequest;
import com.google.cloud.compute.v1.TestPermissionsRequest;
import com.google.cloud.compute.v1.TestPermissionsResponse;
import com.google.cloud.compute.v1.stub.ExternalVpnGatewaysStub;
import com.google.cloud.compute.v1.stub.ExternalVpnGatewaysStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class ExternalVpnGatewaysClient
implements BackgroundResource {
    private final ExternalVpnGatewaysSettings settings;
    private final ExternalVpnGatewaysStub stub;

    public static final ExternalVpnGatewaysClient create() throws IOException {
        return ExternalVpnGatewaysClient.create(ExternalVpnGatewaysSettings.newBuilder().build());
    }

    public static final ExternalVpnGatewaysClient create(ExternalVpnGatewaysSettings settings) throws IOException {
        return new ExternalVpnGatewaysClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final ExternalVpnGatewaysClient create(ExternalVpnGatewaysStub stub) {
        return new ExternalVpnGatewaysClient(stub);
    }

    protected ExternalVpnGatewaysClient(ExternalVpnGatewaysSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ExternalVpnGatewaysStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected ExternalVpnGatewaysClient(ExternalVpnGatewaysStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ExternalVpnGatewaysSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public ExternalVpnGatewaysStub getStub() {
        return this.stub;
    }

    public final Operation delete(String project, String externalVpnGateway) {
        DeleteExternalVpnGatewayRequest request = DeleteExternalVpnGatewayRequest.newBuilder().setProject(project).setExternalVpnGateway(externalVpnGateway).build();
        return this.delete(request);
    }

    public final Operation delete(DeleteExternalVpnGatewayRequest request) {
        return (Operation)this.deleteCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteExternalVpnGatewayRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final ExternalVpnGateway get(String project, String externalVpnGateway) {
        GetExternalVpnGatewayRequest request = GetExternalVpnGatewayRequest.newBuilder().setProject(project).setExternalVpnGateway(externalVpnGateway).build();
        return this.get(request);
    }

    public final ExternalVpnGateway get(GetExternalVpnGatewayRequest request) {
        return (ExternalVpnGateway)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetExternalVpnGatewayRequest, ExternalVpnGateway> getCallable() {
        return this.stub.getCallable();
    }

    public final Operation insert(String project, ExternalVpnGateway externalVpnGatewayResource) {
        InsertExternalVpnGatewayRequest request = InsertExternalVpnGatewayRequest.newBuilder().setProject(project).setExternalVpnGatewayResource(externalVpnGatewayResource).build();
        return this.insert(request);
    }

    public final Operation insert(InsertExternalVpnGatewayRequest request) {
        return (Operation)this.insertCallable().call((Object)request);
    }

    public final UnaryCallable<InsertExternalVpnGatewayRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list(String project) {
        ListExternalVpnGatewaysRequest request = ListExternalVpnGatewaysRequest.newBuilder().setProject(project).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListExternalVpnGatewaysRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListExternalVpnGatewaysRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListExternalVpnGatewaysRequest, ExternalVpnGatewayList> listCallable() {
        return this.stub.listCallable();
    }

    public final Operation setLabels(String project, String resource, GlobalSetLabelsRequest globalSetLabelsRequestResource) {
        SetLabelsExternalVpnGatewayRequest request = SetLabelsExternalVpnGatewayRequest.newBuilder().setProject(project).setResource(resource).setGlobalSetLabelsRequestResource(globalSetLabelsRequestResource).build();
        return this.setLabels(request);
    }

    public final Operation setLabels(SetLabelsExternalVpnGatewayRequest request) {
        return (Operation)this.setLabelsCallable().call((Object)request);
    }

    public final UnaryCallable<SetLabelsExternalVpnGatewayRequest, Operation> setLabelsCallable() {
        return this.stub.setLabelsCallable();
    }

    public final TestPermissionsResponse testIamPermissions(String project, String resource, TestPermissionsRequest testPermissionsRequestResource) {
        TestIamPermissionsExternalVpnGatewayRequest request = TestIamPermissionsExternalVpnGatewayRequest.newBuilder().setProject(project).setResource(resource).setTestPermissionsRequestResource(testPermissionsRequestResource).build();
        return this.testIamPermissions(request);
    }

    public final TestPermissionsResponse testIamPermissions(TestIamPermissionsExternalVpnGatewayRequest request) {
        return (TestPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsExternalVpnGatewayRequest, TestPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListExternalVpnGatewaysRequest, ExternalVpnGatewayList, ExternalVpnGateway, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListExternalVpnGatewaysRequest, ExternalVpnGatewayList, ExternalVpnGateway, ListPage> {
        private ListPage(PageContext<ListExternalVpnGatewaysRequest, ExternalVpnGatewayList, ExternalVpnGateway> context, ExternalVpnGatewayList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListExternalVpnGatewaysRequest, ExternalVpnGatewayList, ExternalVpnGateway> context, ExternalVpnGatewayList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListExternalVpnGatewaysRequest, ExternalVpnGatewayList, ExternalVpnGateway> context, ApiFuture<ExternalVpnGatewayList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListExternalVpnGatewaysRequest, ExternalVpnGatewayList, ExternalVpnGateway, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListExternalVpnGatewaysRequest, ExternalVpnGatewayList, ExternalVpnGateway> context, ApiFuture<ExternalVpnGatewayList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListPage, ListPagedResponse>(){

                public ListPagedResponse apply(ListPage input) {
                    return new ListPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }
}

