/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteRouteRequest;
import com.google.cloud.compute.v1.GetRouteRequest;
import com.google.cloud.compute.v1.InsertRouteRequest;
import com.google.cloud.compute.v1.ListRoutesRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.Route;
import com.google.cloud.compute.v1.RouteList;
import com.google.cloud.compute.v1.RoutesSettings;
import com.google.cloud.compute.v1.stub.RoutesStub;
import com.google.cloud.compute.v1.stub.RoutesStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class RoutesClient
implements BackgroundResource {
    private final RoutesSettings settings;
    private final RoutesStub stub;

    public static final RoutesClient create() throws IOException {
        return RoutesClient.create(RoutesSettings.newBuilder().build());
    }

    public static final RoutesClient create(RoutesSettings settings) throws IOException {
        return new RoutesClient(settings);
    }

    public static final RoutesClient create(RoutesStub stub) {
        return new RoutesClient(stub);
    }

    protected RoutesClient(RoutesSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((RoutesStubSettings)settings.getStubSettings()).createStub();
    }

    protected RoutesClient(RoutesStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final RoutesSettings getSettings() {
        return this.settings;
    }

    public RoutesStub getStub() {
        return this.stub;
    }

    public final OperationFuture<Operation, Operation> deleteAsync(String project, String route) {
        DeleteRouteRequest request = DeleteRouteRequest.newBuilder().setProject(project).setRoute(route).build();
        return this.deleteAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> deleteAsync(DeleteRouteRequest request) {
        return this.deleteOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteRouteRequest, Operation, Operation> deleteOperationCallable() {
        return this.stub.deleteOperationCallable();
    }

    public final UnaryCallable<DeleteRouteRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final Route get(String project, String route) {
        GetRouteRequest request = GetRouteRequest.newBuilder().setProject(project).setRoute(route).build();
        return this.get(request);
    }

    public final Route get(GetRouteRequest request) {
        return (Route)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetRouteRequest, Route> getCallable() {
        return this.stub.getCallable();
    }

    public final OperationFuture<Operation, Operation> insertAsync(String project, Route routeResource) {
        InsertRouteRequest request = InsertRouteRequest.newBuilder().setProject(project).setRouteResource(routeResource).build();
        return this.insertAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> insertAsync(InsertRouteRequest request) {
        return this.insertOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<InsertRouteRequest, Operation, Operation> insertOperationCallable() {
        return this.stub.insertOperationCallable();
    }

    public final UnaryCallable<InsertRouteRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list(String project) {
        ListRoutesRequest request = ListRoutesRequest.newBuilder().setProject(project).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListRoutesRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListRoutesRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListRoutesRequest, RouteList> listCallable() {
        return this.stub.listCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRoutesRequest, RouteList, Route, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListRoutesRequest, RouteList, Route, ListPage> {
        private ListPage(PageContext<ListRoutesRequest, RouteList, Route> context, RouteList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListRoutesRequest, RouteList, Route> context, RouteList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListRoutesRequest, RouteList, Route> context, ApiFuture<RouteList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListRoutesRequest, RouteList, Route, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListRoutesRequest, RouteList, Route> context, ApiFuture<RouteList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPagedResponse((ListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }
}

