/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AddPeeringNetworkRequest;
import com.google.cloud.compute.v1.DeleteNetworkRequest;
import com.google.cloud.compute.v1.ExchangedPeeringRoute;
import com.google.cloud.compute.v1.ExchangedPeeringRoutesList;
import com.google.cloud.compute.v1.GetEffectiveFirewallsNetworkRequest;
import com.google.cloud.compute.v1.GetNetworkRequest;
import com.google.cloud.compute.v1.InsertNetworkRequest;
import com.google.cloud.compute.v1.ListNetworksRequest;
import com.google.cloud.compute.v1.ListPeeringRoutesNetworksRequest;
import com.google.cloud.compute.v1.Network;
import com.google.cloud.compute.v1.NetworkList;
import com.google.cloud.compute.v1.NetworksClient;
import com.google.cloud.compute.v1.NetworksGetEffectiveFirewallsResponse;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchNetworkRequest;
import com.google.cloud.compute.v1.RemovePeeringNetworkRequest;
import com.google.cloud.compute.v1.SwitchToCustomModeNetworkRequest;
import com.google.cloud.compute.v1.UpdatePeeringNetworkRequest;
import com.google.cloud.compute.v1.stub.HttpJsonNetworksStub;
import com.google.cloud.compute.v1.stub.NetworksStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class NetworksStubSettings
extends StubSettings<NetworksStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/compute.readonly").build();
    private final UnaryCallSettings<AddPeeringNetworkRequest, Operation> addPeeringSettings;
    private final UnaryCallSettings<DeleteNetworkRequest, Operation> deleteSettings;
    private final UnaryCallSettings<GetNetworkRequest, Network> getSettings;
    private final UnaryCallSettings<GetEffectiveFirewallsNetworkRequest, NetworksGetEffectiveFirewallsResponse> getEffectiveFirewallsSettings;
    private final UnaryCallSettings<InsertNetworkRequest, Operation> insertSettings;
    private final PagedCallSettings<ListNetworksRequest, NetworkList, NetworksClient.ListPagedResponse> listSettings;
    private final PagedCallSettings<ListPeeringRoutesNetworksRequest, ExchangedPeeringRoutesList, NetworksClient.ListPeeringRoutesPagedResponse> listPeeringRoutesSettings;
    private final UnaryCallSettings<PatchNetworkRequest, Operation> patchSettings;
    private final UnaryCallSettings<RemovePeeringNetworkRequest, Operation> removePeeringSettings;
    private final UnaryCallSettings<SwitchToCustomModeNetworkRequest, Operation> switchToCustomModeSettings;
    private final UnaryCallSettings<UpdatePeeringNetworkRequest, Operation> updatePeeringSettings;
    private static final PagedListDescriptor<ListNetworksRequest, NetworkList, Network> LIST_PAGE_STR_DESC = new PagedListDescriptor<ListNetworksRequest, NetworkList, Network>(){

        public String emptyToken() {
            return "";
        }

        public ListNetworksRequest injectToken(ListNetworksRequest payload, String token) {
            return ListNetworksRequest.newBuilder((ListNetworksRequest)payload).setPageToken(token).build();
        }

        public ListNetworksRequest injectPageSize(ListNetworksRequest payload, int pageSize) {
            return ListNetworksRequest.newBuilder((ListNetworksRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListNetworksRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(NetworkList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Network> extractResources(NetworkList payload) {
            return payload.getItemsList() != null ? payload.getItemsList() : ImmutableList.of();
        }
    };
    private static final PagedListDescriptor<ListPeeringRoutesNetworksRequest, ExchangedPeeringRoutesList, ExchangedPeeringRoute> LIST_PEERING_ROUTES_PAGE_STR_DESC = new PagedListDescriptor<ListPeeringRoutesNetworksRequest, ExchangedPeeringRoutesList, ExchangedPeeringRoute>(){

        public String emptyToken() {
            return "";
        }

        public ListPeeringRoutesNetworksRequest injectToken(ListPeeringRoutesNetworksRequest payload, String token) {
            return ListPeeringRoutesNetworksRequest.newBuilder((ListPeeringRoutesNetworksRequest)payload).setPageToken(token).build();
        }

        public ListPeeringRoutesNetworksRequest injectPageSize(ListPeeringRoutesNetworksRequest payload, int pageSize) {
            return ListPeeringRoutesNetworksRequest.newBuilder((ListPeeringRoutesNetworksRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListPeeringRoutesNetworksRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(ExchangedPeeringRoutesList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<ExchangedPeeringRoute> extractResources(ExchangedPeeringRoutesList payload) {
            return payload.getItemsList() != null ? payload.getItemsList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<ListNetworksRequest, NetworkList, NetworksClient.ListPagedResponse> LIST_PAGE_STR_FACT = new PagedListResponseFactory<ListNetworksRequest, NetworkList, NetworksClient.ListPagedResponse>(){

        public ApiFuture<NetworksClient.ListPagedResponse> getFuturePagedResponse(UnaryCallable<ListNetworksRequest, NetworkList> callable, ListNetworksRequest request, ApiCallContext context, ApiFuture<NetworkList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return NetworksClient.ListPagedResponse.createAsync((PageContext<ListNetworksRequest, NetworkList, Network>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListPeeringRoutesNetworksRequest, ExchangedPeeringRoutesList, NetworksClient.ListPeeringRoutesPagedResponse> LIST_PEERING_ROUTES_PAGE_STR_FACT = new PagedListResponseFactory<ListPeeringRoutesNetworksRequest, ExchangedPeeringRoutesList, NetworksClient.ListPeeringRoutesPagedResponse>(){

        public ApiFuture<NetworksClient.ListPeeringRoutesPagedResponse> getFuturePagedResponse(UnaryCallable<ListPeeringRoutesNetworksRequest, ExchangedPeeringRoutesList> callable, ListPeeringRoutesNetworksRequest request, ApiCallContext context, ApiFuture<ExchangedPeeringRoutesList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PEERING_ROUTES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return NetworksClient.ListPeeringRoutesPagedResponse.createAsync((PageContext<ListPeeringRoutesNetworksRequest, ExchangedPeeringRoutesList, ExchangedPeeringRoute>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<AddPeeringNetworkRequest, Operation> addPeeringSettings() {
        return this.addPeeringSettings;
    }

    public UnaryCallSettings<DeleteNetworkRequest, Operation> deleteSettings() {
        return this.deleteSettings;
    }

    public UnaryCallSettings<GetNetworkRequest, Network> getSettings() {
        return this.getSettings;
    }

    public UnaryCallSettings<GetEffectiveFirewallsNetworkRequest, NetworksGetEffectiveFirewallsResponse> getEffectiveFirewallsSettings() {
        return this.getEffectiveFirewallsSettings;
    }

    public UnaryCallSettings<InsertNetworkRequest, Operation> insertSettings() {
        return this.insertSettings;
    }

    public PagedCallSettings<ListNetworksRequest, NetworkList, NetworksClient.ListPagedResponse> listSettings() {
        return this.listSettings;
    }

    public PagedCallSettings<ListPeeringRoutesNetworksRequest, ExchangedPeeringRoutesList, NetworksClient.ListPeeringRoutesPagedResponse> listPeeringRoutesSettings() {
        return this.listPeeringRoutesSettings;
    }

    public UnaryCallSettings<PatchNetworkRequest, Operation> patchSettings() {
        return this.patchSettings;
    }

    public UnaryCallSettings<RemovePeeringNetworkRequest, Operation> removePeeringSettings() {
        return this.removePeeringSettings;
    }

    public UnaryCallSettings<SwitchToCustomModeNetworkRequest, Operation> switchToCustomModeSettings() {
        return this.switchToCustomModeSettings;
    }

    public UnaryCallSettings<UpdatePeeringNetworkRequest, Operation> updatePeeringSettings() {
        return this.updatePeeringSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public NetworksStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonNetworksStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "compute.googleapis.com";
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return NetworksStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(NetworksStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected NetworksStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.addPeeringSettings = settingsBuilder.addPeeringSettings().build();
        this.deleteSettings = settingsBuilder.deleteSettings().build();
        this.getSettings = settingsBuilder.getSettings().build();
        this.getEffectiveFirewallsSettings = settingsBuilder.getEffectiveFirewallsSettings().build();
        this.insertSettings = settingsBuilder.insertSettings().build();
        this.listSettings = settingsBuilder.listSettings().build();
        this.listPeeringRoutesSettings = settingsBuilder.listPeeringRoutesSettings().build();
        this.patchSettings = settingsBuilder.patchSettings().build();
        this.removePeeringSettings = settingsBuilder.removePeeringSettings().build();
        this.switchToCustomModeSettings = settingsBuilder.switchToCustomModeSettings().build();
        this.updatePeeringSettings = settingsBuilder.updatePeeringSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<NetworksStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<AddPeeringNetworkRequest, Operation> addPeeringSettings;
        private final UnaryCallSettings.Builder<DeleteNetworkRequest, Operation> deleteSettings;
        private final UnaryCallSettings.Builder<GetNetworkRequest, Network> getSettings;
        private final UnaryCallSettings.Builder<GetEffectiveFirewallsNetworkRequest, NetworksGetEffectiveFirewallsResponse> getEffectiveFirewallsSettings;
        private final UnaryCallSettings.Builder<InsertNetworkRequest, Operation> insertSettings;
        private final PagedCallSettings.Builder<ListNetworksRequest, NetworkList, NetworksClient.ListPagedResponse> listSettings;
        private final PagedCallSettings.Builder<ListPeeringRoutesNetworksRequest, ExchangedPeeringRoutesList, NetworksClient.ListPeeringRoutesPagedResponse> listPeeringRoutesSettings;
        private final UnaryCallSettings.Builder<PatchNetworkRequest, Operation> patchSettings;
        private final UnaryCallSettings.Builder<RemovePeeringNetworkRequest, Operation> removePeeringSettings;
        private final UnaryCallSettings.Builder<SwitchToCustomModeNetworkRequest, Operation> switchToCustomModeSettings;
        private final UnaryCallSettings.Builder<UpdatePeeringNetworkRequest, Operation> updatePeeringSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.addPeeringSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getEffectiveFirewallsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PAGE_STR_FACT);
            this.listPeeringRoutesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PEERING_ROUTES_PAGE_STR_FACT);
            this.patchSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.removePeeringSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.switchToCustomModeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updatePeeringSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.addPeeringSettings, this.deleteSettings, this.getSettings, this.getEffectiveFirewallsSettings, this.insertSettings, this.listSettings, this.listPeeringRoutesSettings, this.patchSettings, this.removePeeringSettings, this.switchToCustomModeSettings, this.updatePeeringSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(NetworksStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)NetworksStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)NetworksStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(NetworksStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.addPeeringSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.deleteSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getEffectiveFirewallsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.insertSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listPeeringRoutesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.patchSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.removePeeringSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.switchToCustomModeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.updatePeeringSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(NetworksStubSettings settings) {
            super((StubSettings)settings);
            this.addPeeringSettings = settings.addPeeringSettings.toBuilder();
            this.deleteSettings = settings.deleteSettings.toBuilder();
            this.getSettings = settings.getSettings.toBuilder();
            this.getEffectiveFirewallsSettings = settings.getEffectiveFirewallsSettings.toBuilder();
            this.insertSettings = settings.insertSettings.toBuilder();
            this.listSettings = settings.listSettings.toBuilder();
            this.listPeeringRoutesSettings = settings.listPeeringRoutesSettings.toBuilder();
            this.patchSettings = settings.patchSettings.toBuilder();
            this.removePeeringSettings = settings.removePeeringSettings.toBuilder();
            this.switchToCustomModeSettings = settings.switchToCustomModeSettings.toBuilder();
            this.updatePeeringSettings = settings.updatePeeringSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.addPeeringSettings, this.deleteSettings, this.getSettings, this.getEffectiveFirewallsSettings, this.insertSettings, this.listSettings, this.listPeeringRoutesSettings, this.patchSettings, this.removePeeringSettings, this.switchToCustomModeSettings, this.updatePeeringSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<AddPeeringNetworkRequest, Operation> addPeeringSettings() {
            return this.addPeeringSettings;
        }

        public UnaryCallSettings.Builder<DeleteNetworkRequest, Operation> deleteSettings() {
            return this.deleteSettings;
        }

        public UnaryCallSettings.Builder<GetNetworkRequest, Network> getSettings() {
            return this.getSettings;
        }

        public UnaryCallSettings.Builder<GetEffectiveFirewallsNetworkRequest, NetworksGetEffectiveFirewallsResponse> getEffectiveFirewallsSettings() {
            return this.getEffectiveFirewallsSettings;
        }

        public UnaryCallSettings.Builder<InsertNetworkRequest, Operation> insertSettings() {
            return this.insertSettings;
        }

        public PagedCallSettings.Builder<ListNetworksRequest, NetworkList, NetworksClient.ListPagedResponse> listSettings() {
            return this.listSettings;
        }

        public PagedCallSettings.Builder<ListPeeringRoutesNetworksRequest, ExchangedPeeringRoutesList, NetworksClient.ListPeeringRoutesPagedResponse> listPeeringRoutesSettings() {
            return this.listPeeringRoutesSettings;
        }

        public UnaryCallSettings.Builder<PatchNetworkRequest, Operation> patchSettings() {
            return this.patchSettings;
        }

        public UnaryCallSettings.Builder<RemovePeeringNetworkRequest, Operation> removePeeringSettings() {
            return this.removePeeringSettings;
        }

        public UnaryCallSettings.Builder<SwitchToCustomModeNetworkRequest, Operation> switchToCustomModeSettings() {
            return this.switchToCustomModeSettings;
        }

        public UnaryCallSettings.Builder<UpdatePeeringNetworkRequest, Operation> updatePeeringSettings() {
            return this.updatePeeringSettings;
        }

        public NetworksStubSettings build() throws IOException {
            return new NetworksStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

